CREATE TABLE IF NOT EXISTS `xwlpv_commentmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `xwlpv_comments` (
  `comment_ID` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

REPLACE INTO `xwlpv_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
(1, 1, 'A WordPress Commenter', 'wapuu@wordpress.example', 'https://wordpress.org/', '', '2016-09-11 12:57:37', '2016-09-11 12:57:37', 'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href="https://gravatar.com">Gravatar</a>.', 0, '1', '', '', 0, 0),
(2, 155, 'Anon', 'anon@example.com', '', '59.167.157.3', '2007-09-04 10:49:28', '2007-09-04 00:49:28', 'Anonymous comment.', 0, '1', '', '', 0, 0),
(3, 155, 'tellyworthtest2', 'tellyworth+test2@gmail.com', '', '59.167.157.3', '2007-09-04 10:49:03', '2007-09-04 00:49:03', 'Contributor comment.', 0, '1', '', '', 0, 0),
(4, 155, 'John Doe', 'example@example.org', 'http://example.org', '59.167.157.3', '2007-09-04 10:48:51', '2007-09-04 17:48:51', 'Author comment.', 0, '1', '', '', 0, 0),
(5, 1148, 'John Doe', 'example@example.org', 'http://example.org/', '59.167.157.3', '2012-09-03 10:18:04', '2012-09-03 17:18:04', '<h2>Headings</h2>\n<h1>Header one</h1>\n<h2>Header two</h2>\n<h3>Header three</h3>\n<h4>Header four</h4>\n<h5>Header five</h5>\n<h6>Header six</h6>\n<h2>Blockquotes</h2>\nSingle line blockquote:\n<blockquote>Stay hungry. Stay foolish.</blockquote>\nMulti line blockquote with a cite reference:\n<blockquote>People think focus means saying yes to the thing you\'ve got to focus on. But that\'s not what it means at all. It means saying no to the hundred other good ideas that there are. You have to pick carefully. I\'m actually as proud of the things we haven\'t done as the things I have done. Innovation is saying no to 1,000 things. <cite>Steve Jobs - Apple Worldwide Developers\' Conference, 1997</cite></blockquote>\n<h2>Tables</h2>\n<table>\n<tbody>\n<tr>\n<th>Employee</th>\n<th class="views">Salary</th>\n<th></th>\n</tr>\n<tr class="odd">\n<td><a href="http://example.org/" rel="nofollow">John Saddington</a></td>\n<td>$1</td>\n<td>Because that\'s all Steve Job\' needed for a salary.</td>\n</tr>\n<tr class="even">\n<td><a href="http://example.org/" rel="nofollow">Tom McFarlin</a></td>\n<td>$100K</td>\n<td>For all the blogging he does.</td>\n</tr>\n<tr class="odd">\n<td><a href="http://example.org/" rel="nofollow">Jared Erickson</a></td>\n<td>$100M</td>\n<td>Pictures are worth a thousand words, right? So Tom x 1,000.</td>\n</tr>\n<tr class="even">\n<td><a href="http://example.org/" rel="nofollow">Chris Ames</a></td>\n<td>$100B</td>\n<td>With hair like that?! Enough said...</td>\n</tr>\n</tbody>\n</table>\n<h2>Definition Lists</h2>\n<dl><dt>Definition List Title</dt><dd>Definition list division.</dd><dt>Startup</dt><dd>A startup company or startup is a company or temporary organization designed to search for a repeatable and scalable business model.</dd><dt>#dowork</dt><dd>Coined by Rob Dyrdek and his personal body guard Christopher "Big Black" Boykins, "Do Work" works as a self motivator, to motivating your friends.</dd><dt>Do It Live</dt><dd>I\'ll let Bill O\'Reilly will <a title="We\'ll Do It Live" href="https://www.youtube.com/watch?v=O_HyZ5aW76c" rel="nofollow">explain</a> this one.</dd></dl>\n<h2>Unordered Lists (Nested)</h2>\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n<h2>Ordered List (Nested)</h2>\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n<h2>HTML Tags</h2>\nThese supported tags come from the WordPress.com code <a title="Code" href="http://en.support.wordpress.com/code/" rel="nofollow">FAQ</a>.\n\n<strong>Address Tag</strong>\n\n<address>1 Infinite Loop\nCupertino, CA 95014\nUnited States</address><strong>Anchor Tag (aka. Link)</strong>\n\nThis is an example of a <a title="Apple" href="http://apple.com" rel="nofollow">link</a>.\n\n<strong>Abbreviation Tag</strong>\n\nThe abbreviation <abbr title="Seriously">srsly</abbr> stands for "seriously".\n\n<strong>Acronym Tag</strong>\n\nThe acronym <acronym title="For The Win">ftw</acronym> stands for "for the win".\n\n<strong>Big Tag</strong>\n\nThese tests are a <big>big</big> deal, but this tag is no longer supported in HTML5.\n\n<strong>Cite Tag</strong>\n\n"Code is poetry." --<cite>Automattic</cite>\n\n<strong>Code Tag</strong>\n\nYou will learn later on in these tests that <code>word-wrap: break-word;</code> will be your best friend.\n\n<strong>Delete Tag</strong>\n\nThis tag will let you <del>strikeout text</del>, but this tag is no longer supported in HTML5 (use the <code>&lt;strike&gt;</code> instead).\n\n<strong>Emphasize Tag</strong>\n\nThe emphasize tag should <em>italicize</em> text.\n\n<strong>Insert Tag</strong>\n\nThis tag should denote <ins>inserted</ins> text.\n\n<strong>Keyboard Tag</strong>\n\nThis scarcely known tag emulates <kbd>keyboard text</kbd>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Preformatted Tag</strong>\n\nThis tag styles large blocks of code.\n<pre>.post-title {\n  margin: 0 0 5px;\n  font-weight: bold;\n  font-size: 38px;\n  line-height: 1.2;\n}</pre>\n\n<strong>Quote Tag</strong>\n\n<q>Developers, developers, developers...</q> --Steve Ballmer\n\n<strong>Strong Tag</strong>\n\nThis tag shows <strong>bold<strong> text.</strong></strong>\n\n<strong>Subscript Tag</strong>\n\nGetting our science styling on with H<sub>2</sub>O, which should push the "2" down.\n\n<strong>Superscript Tag</strong>\n\nStill sticking with science and Isaac Newton\'s E = MC<sup>2</sup>, which should lift the 2 up.\n\n<strong>Teletype Tag</strong>\n\nThis rarely used tag emulates <tt>teletype text</tt>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Variable Tag</strong>\n\nThis allows you to denote <var>variables</var>.', 0, '1', '', '', 0, 0),
(6, 1148, 'Anonymous User', 'fake@email.com', '', '67.3.69.40', '2013-03-11 23:45:54', '2013-03-12 04:45:54', 'This user it trying to be anonymous.\n\n\n    They used a fake email, so there should be no <a href="http://gravatar.com/" title="Gravatar" rel="nofollow">Gravatar</a> associated with it.\n    They did not speify a website, so there should be no link to it in the comment.\n', 0, '1', '', '', 0, 0),
(7, 1148, 'Jane Doe', 'example@example.org', 'http://example.org/', '204.54.106.1', '2013-03-12 13:17:35', '2013-03-12 20:17:35', 'Comments? I love comments!', 0, '1', '', '', 0, 0),
(8, 1148, 'John Doe', 'example@example.org', 'http://example.org', '24.126.245.62', '2013-03-14 07:53:26', '2013-03-14 14:53:26', 'These tests are amazing!', 0, '1', '', '', 0, 0),
(9, 1148, 'John Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 07:56:46', '2013-03-14 14:56:46', 'Author Comment.', 0, '1', '', '', 0, 0),
(10, 1148, 'John Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 07:57:01', '2013-03-14 14:57:01', 'Comment Depth 01', 0, '1', '', '', 0, 0),
(11, 1148, 'Jane Bloggs', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:01:21', '2013-03-14 15:01:21', 'Comment Depth 02', 0, '1', '', '', 10, 0),
(12, 1148, 'Fred Bloggs', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:02:06', '2013-03-14 15:02:06', 'Comment Depth 03', 0, '1', '', '', 11, 0),
(13, 1148, 'Fred Bloggs', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:03:22', '2013-03-14 15:03:22', 'Comment Depth 04', 0, '1', '', '', 12, 0),
(14, 1148, 'Joe Bloggs', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:10:29', '2013-03-14 15:10:29', 'Comment Depth 05\n\nAlso an author comment.', 0, '1', '', '', 13, 0),
(15, 1148, 'Jane Bloggs', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:12:16', '2013-03-14 15:12:16', 'Comment Depth 06', 0, '1', '', '', 14, 0),
(16, 1148, 'Joe Bloggs', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:12:58', '2013-03-14 15:12:58', 'Comment Depth 07', 0, '1', '', '', 15, 0),
(17, 1148, 'Jane Bloggs', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:13:42', '2013-03-14 15:13:42', 'Comment Depth 08', 0, '1', '', '', 16, 0),
(18, 1148, 'Joe Bloggs', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:14:13', '2013-03-14 15:14:13', 'Comment Depth 09', 0, '1', '', '', 17, 0),
(19, 1148, 'John Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 08:14:47', '2013-03-14 15:14:47', 'Comment Depth 10\n\nAlso an author comment.', 0, '1', '', '', 18, 0),
(20, 1148, 'Jane Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 09:56:43', '2013-03-14 16:56:43', 'Image comment.\n\n', 0, '1', '', '', 0, 0),
(21, 1148, 'John Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 11:23:24', '2013-03-14 18:23:24', 'We are totally going to blog about these tests!', 0, '1', '', '', 0, 0),
(22, 1148, 'John Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 11:27:54', '2013-03-14 18:27:54', 'We use these tests all the time! Killer stuff!', 0, '1', '', '', 0, 0),
(23, 1148, 'Jane Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 11:30:33', '2013-03-14 18:30:33', 'Thanks for all the comments, everyone!', 0, '1', '', '', 0, 0),
(24, 1149, 'Ping 1 &laquo; What&#8217;s a tellyworth?', '', 'http://tellyworth.wordpress.com/2007/11/21/ping-1/', '72.232.101.12', '2007-11-21 11:31:12', '2007-11-21 01:31:12', '[...] Trackback test. [...]', 0, '1', '', 'pingback', 0, 0),
(25, 1149, 'Ping 2 with a much longer title than the previous ping, which was called Ping 1 &laquo; What&#8217;s a tellyworth?', '', 'http://tellyworth.wordpress.com/2007/11/21/ping-2-with-a-much-longer-title-than-the-previous-ping-which-was-called-ping-1/', '72.232.101.12', '2007-11-21 11:35:47', '2007-11-21 01:35:47', '[...] Another trackback test.  Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec hendrerit gravida nisi. Praesent libero odio, tincidunt nec, fringilla et, mollis ut, ipsum. Proin a lacus quis nisi pulvinar bibendum. Donec massa justo, dapibus at, imperdiet vestibulum, dapibus in, leo. Donec pretium tellus in dui. Phasellus tristique aliquet justo. Donec sodales. Nulla urna mi, molestie ac, malesuada sit amet, sagittis id, lacus. Mauris auctor leo ac justo. Proin convallis. Nulla eleifend dictum mi. Donec at lectus. Integer augue sapien, ornare vitae, rhoncus quis, rhoncus sed, sapien. Nunc mattis diam sodales diam.Etiam porttitor, ante sed varius semper, ante arcu rutrum tortor, at luctus nunc urna id nibh. Fusce sodales. Integer sed ligula. Donec posuere, nibh aliquet auctor congue, augue est porttitor odio, imperdiet facilisis tortor urna vel mauris. Pellentesque pretium, lorem non pellentesque varius, elit diam ultrices mi, sed posuere sapien lectus sed mi. Donec vestibulum urna. Donec gravida elit et enim. Ut dignissim neque ut erat. Morbi tincidunt nunc vitae lorem. Morbi rhoncus mi. Praesent facilisis tincidunt enim. Ut pulvinar. Suspendisse potenti. Vivamus turpis odio, porta at, malesuada in, iaculis eget, odio. Aenean faucibus, urna quis congue dignissim, orci tellus ornare leo, eget viverra ante ipsum sit amet magna. Suspendisse mattis nunc at justo. Nullam malesuada lobortis lorem. Morbi ultricies. Nam risus erat, sagittis ut, tristique rhoncus, luctus id, ante. Maecenas ac dui. [...]', 0, '1', '', 'pingback', 0, 0),
(26, 1149, 'Ping 4 &laquo; What&#8217;s a tellyworth?', '', 'http://tellyworth.wordpress.com/2007/11/21/ping-4/', '72.232.101.12', '2007-11-21 11:39:25', '2007-11-21 01:39:25', '[...] Another short one. [...]', 0, '1', '', 'pingback', 0, 0),
(27, 1149, 'Ping 3 &laquo; What&#8217;s a tellyworth?', '', 'http://tellyworth.wordpress.com/2007/11/21/ping-3/', '72.232.101.12', '2007-11-21 11:38:22', '2007-11-21 01:38:22', '[...] Just a short one. [...]', 0, '1', '', 'pingback', 0, 0),
(28, 1149, 'John Doe', 'example@example.org', 'http://example.org/', '146.214.103.251', '2010-06-11 15:27:04', '2010-06-11 22:27:04', 'This is a comment amongst pingbacks and trackbacks.', 0, '1', '', '', 0, 0),
(29, 1168, 'Jane Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 11:56:08', '2013-03-14 18:56:08', 'This comment should not be visible until the password is entered.', 0, '1', '', '', 0, 0),
(30, 1170, 'John Doe', 'example@example.org', 'http://example.org/', '24.126.245.62', '2013-03-14 12:35:07', '2013-03-14 19:35:07', 'Having no content in the post should have no adverse effects on the layout or functionality.', 0, '1', '', '', 0, 0);

CREATE TABLE IF NOT EXISTS `xwlpv_links` (
  `link_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) UNSIGNED NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `xwlpv_options` (
  `option_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=4213 DEFAULT CHARSET=utf8;

REPLACE INTO `xwlpv_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(22, 'posts_per_page', '3', 'yes'),
(23, 'date_format', 'F j, Y', 'yes'),
(24, 'time_format', 'g:i a', 'yes'),
(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
(26, 'comment_moderation', '0', 'yes'),
(27, 'moderation_notify', '1', 'yes'),
(28, 'permalink_structure', '/%year%/%monthnum%/%day%/%postname%/', 'yes'),
(30, 'hack_file', '0', 'yes'),
(31, 'blog_charset', 'UTF-8', 'yes'),
(32, 'moderation_keys', '', 'no'),
(34, 'category_base', '', 'yes'),
(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(36, 'comment_max_links', '2', 'yes'),
(37, 'gmt_offset', '0', 'yes'),
(38, 'default_email_category', '1', 'yes'),
(40, 'template', 'goarch', 'yes'),
(41, 'stylesheet', 'goarch', 'yes'),
(42, 'comment_whitelist', '1', 'yes'),
(43, 'blacklist_keys', '', 'no'),
(44, 'comment_registration', '0', 'yes'),
(45, 'html_type', 'text/html', 'yes'),
(46, 'use_trackback', '0', 'yes'),
(47, 'default_role', 'subscriber', 'yes'),
(48, 'db_version', '38590', 'yes'),
(49, 'uploads_use_yearmonth_folders', '1', 'yes'),
(50, 'upload_path', '', 'yes'),
(51, 'blog_public', '1', 'yes'),
(52, 'default_link_category', '2', 'yes'),
(53, 'show_on_front', 'page', 'yes'),
(54, 'tag_base', '', 'yes'),
(55, 'show_avatars', '1', 'yes'),
(56, 'avatar_rating', 'G', 'yes'),
(57, 'upload_url_path', '', 'yes'),
(58, 'thumbnail_size_w', '150', 'yes'),
(59, 'thumbnail_size_h', '150', 'yes'),
(60, 'thumbnail_crop', '1', 'yes'),
(61, 'medium_size_w', '300', 'yes'),
(62, 'medium_size_h', '300', 'yes'),
(63, 'avatar_default', 'mystery', 'yes'),
(64, 'large_size_w', '1024', 'yes'),
(65, 'large_size_h', '1024', 'yes'),
(66, 'image_default_link_type', 'none', 'yes'),
(67, 'image_default_size', '', 'yes'),
(68, 'image_default_align', '', 'yes'),
(69, 'close_comments_for_old_posts', '0', 'yes'),
(70, 'close_comments_days_old', '14', 'yes'),
(71, 'thread_comments', '1', 'yes'),
(72, 'thread_comments_depth', '5', 'yes'),
(73, 'page_comments', '0', 'yes'),
(74, 'comments_per_page', '50', 'yes'),
(75, 'default_comments_page', 'newest', 'yes'),
(76, 'comment_order', 'asc', 'yes'),
(79, 'widget_text', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(81, 'uninstall_plugins', 'a:0:{}', 'no'),
(82, 'timezone_string', '', 'yes'),
(83, 'page_for_posts', '0', 'yes'),
(85, 'default_post_format', '0', 'yes'),
(86, 'link_manager_enabled', '0', 'yes'),
(87, 'finished_splitting_shared_terms', '1', 'yes'),
(89, 'medium_large_size_w', '768', 'yes'),
(90, 'medium_large_size_h', '0', 'yes'),
(91, 'initial_db_version', '37965', 'yes'),
(3, 'blogname', 'Go.arch  &#8211; Architecture  WordPress Template', 'yes'),
(93, 'widget_search', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(94, 'widget_recent-posts', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(95, 'widget_recent-comments', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(96, 'widget_archives', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(78, 'widget_categories', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(97, 'widget_meta', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(98, 'sidebars_widgets', 'a:3:{s:19:"wp_inactive_widgets";a:0:{}s:14:"goarch_sidebar";a:3:{i:0;s:9:"monster-2";i:1;s:21:"goarch_recent_posts-2";i:2;s:18:"widget-tag-cloud-2";}s:13:"array_version";i:3;}', 'yes'),
(99, 'widget_pages', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(100, 'widget_calendar', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(101, 'widget_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(102, 'widget_nav_menu', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(4207, 'revslider-valid-notice', 'false', 'yes'),
(4204, '_site_transient_timeout_theme_roots', '1481808461', 'no'),
(4205, '_site_transient_theme_roots', 'a:4:{s:6:"goarch";s:7:"/themes";s:13:"twentyfifteen";s:7:"/themes";s:14:"twentyfourteen";s:7:"/themes";s:13:"twentysixteen";s:7:"/themes";}', 'no'),
(4119, '_site_transient_browser_3a179042b5d9d18726343f8efdf53113', 'a:9:{s:8:"platform";s:7:"Windows";s:4:"name";s:6:"Chrome";s:7:"version";s:12:"54.0.2840.99";s:10:"update_url";s:28:"http://www.google.com/chrome";s:7:"img_src";s:49:"http://s.wordpress.org/images/browsers/chrome.png";s:11:"img_src_ssl";s:48:"https://wordpress.org/images/browsers/chrome.png";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;}', 'no'),
(4192, '_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1481803383', 'no'),
(4190, '_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1481846583', 'no'),
(4191, '_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1481846583', 'no'),
(4195, '_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9', '1481803385', 'no'),
(4193, '_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9', '1481846585', 'no'),
(4194, '_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9', '1481846585', 'no'),
(4198, '_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109', '1481846586', 'no'),
(4199, '_transient_feed_mod_b9388c83948825c1edaef0d856b7b109', '1481803386', 'no'),
(4200, '_transient_timeout_dash_88ae138922fe95674369b1cb3d215a2b', '1481846586', 'no'),
(4201, '_transient_dash_88ae138922fe95674369b1cb3d215a2b', '<div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2016/12/vaughan/\'>WordPress 4.7 “Vaughan”</a> <span class="rss-date">December 6, 2016</span><div class="rssSummary">Version 4.7 of WordPress, named “Vaughan” in honor of legendary jazz vocalist Sarah &quot;Sassy&quot; Vaughan, is available for download or update in your WordPress dashboard. New features in 4.7 help you get your site set up the way you want it.</div></li></ul></div><div class="rss-widget"><ul><li><a class=\'rsswidget\' href=\'https://ma.tt/2016/12/another-dongle/\'>Matt: Another Dongle</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/matt-mullenweg-proposes-wordpress-growth-council\'>WPTavern: Matt Mullenweg Proposes WordPress Growth Council</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/updraftplus-acquires-wp-optimize-will-be-integrated-into-updraftcentral\'>WPTavern: UpdraftPlus Acquires WP-Optimize, Will Be Integrated Into UpdraftCentral</a></li></ul></div><div class="rss-widget"><ul><li class="dashboard-news-plugin"><span>Popular Plugin:</span> SiteOrigin Widgets Bundle&nbsp;<a href="plugin-install.php?tab=plugin-information&amp;plugin=so-widgets-bundle&amp;_wpnonce=3eeba12c4a&amp;TB_iframe=true&amp;width=600&amp;height=800" class="thickbox open-plugin-details-modal" aria-label="Install SiteOrigin Widgets Bundle">(Install)</a></li></ul></div>', 'no'),
(4196, '_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109', '1481846586', 'no');
REPLACE INTO `xwlpv_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(4197, '_transient_feed_b9388c83948825c1edaef0d856b7b109', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n	\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:117:"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:34:"WordPress Plugins » View: Popular";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"https://wordpress.org/plugins/browse/popular/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:34:"WordPress Plugins » View: Popular";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 15 Dec 2016 11:30:26 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:25:"http://bbpress.org/?v=1.1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"item";a:30:{i:0;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"W3 Total Cache";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wordpress.org/plugins/w3-total-cache/#post-12073";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 29 Jul 2009 18:46:31 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"12073@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:144:"Search Engine (SEO) &#38; Performance Optimization (WPO) via caching. Integrated caching: CDN, Minify, Page, Object, Fragment, Database support.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Frederick Townes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Contact Form 7";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"https://wordpress.org/plugins/contact-form-7/#post-2141";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 02 Aug 2007 12:45:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"2141@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:54:"Just another contact form plugin. Simple but flexible.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Takayuki Miyoshi";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"All in One SEO Pack";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 30 Mar 2007 20:08:18 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"753@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:150:"One of the most downloaded WordPress plugins (over 30 million downloads since 2007). Use All in One SEO Pack to optimize your site for Search Engines.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:8:"uberdose";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:11:"WP-PageNavi";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"https://wordpress.org/plugins/wp-pagenavi/#post-363";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 23:17:57 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"363@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:49:"Adds a more advanced paging navigation interface.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Lester Chan";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"Really Simple CAPTCHA";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:62:"https://wordpress.org/plugins/really-simple-captcha/#post-9542";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 09 Mar 2009 02:17:35 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"9542@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:138:"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Takayuki Miyoshi";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"WP Super Cache";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"https://wordpress.org/plugins/wp-super-cache/#post-2572";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 05 Nov 2007 11:40:04 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"2572@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:73:"A very fast caching engine for WordPress that produces static html files.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Donncha O Caoimh";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:11:"Hello Dolly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wordpress.org/plugins/hello-dolly/#post-5790";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 May 2008 22:11:34 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"5790@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:150:"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt Mullenweg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"WordPress Importer";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://wordpress.org/plugins/wordpress-importer/#post-18101";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 May 2010 17:42:45 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"18101@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:101:"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Brian Colinger";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:19:"Google XML Sitemaps";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:64:"https://wordpress.org/plugins/google-sitemap-generator/#post-132";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:31:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:34:"132@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:105:"This plugin will generate a special XML sitemap which will help search engines to better index your blog.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Arne Brachhold";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"Duplicate Post";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"https://wordpress.org/plugins/duplicate-post/#post-2646";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 05 Dec 2007 17:40:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"2646@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:22:"Clone posts and pages.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:4:"Lopo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:10;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"TinyMCE Advanced";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:57:"https://wordpress.org/plugins/tinymce-advanced/#post-2082";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 27 Jun 2007 15:00:26 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"2082@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:58:"Extends and enhances TinyMCE, the WordPress Visual Editor.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Andrew Ozz";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:11;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:24:"Jetpack by WordPress.com";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:49:"https://wordpress.org/plugins/jetpack/#post-23862";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 20 Jan 2011 02:21:38 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"23862@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:107:"Increase your traffic, view your stats, speed up your site, and protect yourself from hackers with Jetpack.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Automattic";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:12;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:26:"Page Builder by SiteOrigin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wordpress.org/plugins/siteorigin-panels/#post-51888";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 11 Apr 2013 10:36:42 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"51888@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:111:"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Greg Priday";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:13;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:42:"NextGEN Gallery - WordPress Gallery Plugin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wordpress.org/plugins/nextgen-gallery/#post-1169";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 23 Apr 2007 20:08:06 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"1169@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:121:"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 16 million downloads.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Alex Rabe";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:14;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"Wordfence Security";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"https://wordpress.org/plugins/wordfence/#post-29832";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 04 Sep 2011 03:13:51 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"29832@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:149:"Secure your website with the most comprehensive WordPress security plugin. Firewall, malware scan, blocking, live traffic, login security &#38; more.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Wordfence";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:15;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:9:"Yoast SEO";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:54:"https://wordpress.org/plugins/wordpress-seo/#post-8321";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 01 Jan 2009 20:34:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"8321@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:118:"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the Yoast SEO plugin.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Joost de Valk";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:16;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:35:"Google Analytics by MonsterInsights";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 14 Sep 2007 12:15:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"2316@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:113:"Connect Google Analytics with WordPress by adding your Google Analytics tracking code. Get the stats that matter.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Syed Balkhi";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:17;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:7:"Akismet";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:46:"https://wordpress.org/plugins/akismet/#post-15";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Mar 2007 22:11:30 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:33:"15@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:98:"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"Matt Mullenweg";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:18;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:22:"Advanced Custom Fields";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:64:"https://wordpress.org/plugins/advanced-custom-fields/#post-25254";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 17 Mar 2011 04:07:30 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"25254@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:68:"Customise WordPress with powerful, professional and intuitive fields";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"elliotcondon";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:19;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:11:"WooCommerce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wordpress.org/plugins/woocommerce/#post-29860";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 05 Sep 2011 08:13:36 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"29860@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:97:"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"WooThemes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:20;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:21:"Regenerate Thumbnails";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:62:"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 23 Aug 2008 14:38:58 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"6743@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:76:"Allows you to regenerate your thumbnails after changing the thumbnail sizes.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:25:"Alex Mills (Viper007Bond)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:21;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"Clef Two-Factor Authentication";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wordpress.org/plugins/wpclef/#post-47509";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 27 Dec 2012 01:25:57 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"47509@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:139:"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical login experience.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Dave Ross";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:22;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:35:"UpdraftPlus WordPress Backup Plugin";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wordpress.org/plugins/updraftplus/#post-38058";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 21 May 2012 15:14:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"38058@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:148:"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:14:"David Anderson";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:23;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"Google Analytics Dashboard for WP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:75:"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sun, 10 Mar 2013 17:07:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"50539@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:127:"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Alin Marcu";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:24;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:16:"Disable Comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:58:"https://wordpress.org/plugins/disable-comments/#post-26907";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 27 May 2011 04:42:58 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"26907@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:150:"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly. Provides tool t";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Samir Shah";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:25;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:18:"WP Multibyte Patch";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 14 Jul 2011 12:22:53 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"28395@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:71:"Multibyte functionality enhancement for the WordPress Japanese package.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"plugin-master";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:26;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:10:"Duplicator";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wordpress.org/plugins/duplicator/#post-26607";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 16 May 2011 12:15:41 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"26607@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:88:"Duplicate, clone, backup, move and transfer an entire site from one location to another.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:10:"Cory Lamle";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:27;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:27:"Black Studio TinyMCE Widget";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:69:"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 10 Nov 2011 15:06:14 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"31973@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:39:"The visual editor widget for Wordpress.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"Marco Chiesi";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:28;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:46:"iThemes Security (formerly Better WP Security)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://wordpress.org/plugins/better-wp-security/#post-21738";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 22 Oct 2010 22:06:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"21738@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:146:"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"iThemes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:29;a:6:{s:4:"data";s:30:"\n			\n			\n			\n			\n			\n			\n					";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:2:{s:0:"";a:5:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:25:"SiteOrigin Widgets Bundle";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://wordpress.org/plugins/so-widgets-bundle/#post-67824";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 24 May 2014 14:27:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:36:"67824@https://wordpress.org/plugins/";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:128:"A collection of all widgets, neatly bundled into a single plugin. It&#039;s also a framework to code your own widgets on top of.";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Greg Priday";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:46:"https://wordpress.org/plugins/rss/view/popular";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:"\0*\0data";a:12:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Thu, 15 Dec 2016 12:03:06 GMT";s:12:"content-type";s:23:"text/xml; charset=UTF-8";s:4:"vary";s:15:"Accept-Encoding";s:25:"strict-transport-security";s:11:"max-age=360";s:7:"expires";s:29:"Thu, 15 Dec 2016 12:05:26 GMT";s:13:"cache-control";s:0:"";s:6:"pragma";s:0:"";s:13:"last-modified";s:31:"Thu, 15 Dec 2016 11:30:26 +0000";s:15:"x-frame-options";s:10:"SAMEORIGIN";s:4:"x-nc";s:11:"HIT lax 250";s:16:"content-encoding";s:4:"gzip";}}s:5:"build";s:14:"20161207170813";}', 'no'),
(4182, '_transient_plugin_slugs', 'a:13:{i:0;s:19:"akismet/akismet.php";i:1;s:43:"change-table-prefix/change-table-prefix.php";i:2;s:53:"customizer-export-import/customizer-export-import.php";i:3;s:23:"debug-bar/debug-bar.php";i:4;s:23:"goarch_plugin/index.php";i:5;s:9:"hello.php";i:6;s:33:"monster-widget/monster-widget.php";i:7;s:25:"option-tree/ot-loader.php";i:8;s:47:"regenerate-thumbnails/regenerate-thumbnails.php";i:9;s:23:"revslider/revslider.php";i:10;s:27:"theme-check/theme-check.php";i:11;s:41:"wordpress-importer/wordpress-importer.php";i:12;s:27:"js_composer/js_composer.php";}', 'no'),
(4181, '_transient_timeout_plugin_slugs', '1481889809', 'no'),
(137, 'theme_mods_twentysixteen', 'a:1:{s:16:"sidebars_widgets";a:2:{s:4:"time";i:1473613157;s:4:"data";a:2:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}}}}', 'yes'),
(140, 'theme_switched', '', 'yes'),
(138, 'current_theme', 'goarch', 'yes');
REPLACE INTO `xwlpv_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(29, 'rewrite_rules', 'a:131:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:11:"projects/?$";s:28:"index.php?post_type=projects";s:41:"projects/feed/(feed|rdf|rss|rss2|atom)/?$";s:45:"index.php?post_type=projects&feed=$matches[1]";s:36:"projects/(feed|rdf|rss|rss2|atom)/?$";s:45:"index.php?post_type=projects&feed=$matches[1]";s:28:"projects/page/([0-9]{1,})/?$";s:46:"index.php?post_type=projects&paged=$matches[1]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:36:"projects/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:46:"projects/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:66:"projects/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:61:"projects/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:61:"projects/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:42:"projects/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:25:"projects/([^/]+)/embed/?$";s:52:"index.php?projects_categories=$matches[1]&embed=true";s:29:"projects/([^/]+)/trackback/?$";s:35:"index.php?projects=$matches[1]&tb=1";s:49:"projects/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:58:"index.php?projects_categories=$matches[1]&feed=$matches[2]";s:44:"projects/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:58:"index.php?projects_categories=$matches[1]&feed=$matches[2]";s:37:"projects/([^/]+)/page/?([0-9]{1,})/?$";s:59:"index.php?projects_categories=$matches[1]&paged=$matches[2]";s:44:"projects/([^/]+)/comment-page-([0-9]{1,})/?$";s:48:"index.php?projects=$matches[1]&cpage=$matches[2]";s:33:"projects/([^/]+)(?:/([0-9]+))?/?$";s:47:"index.php?projects=$matches[1]&page=$matches[2]";s:25:"projects/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:35:"projects/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:55:"projects/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:50:"projects/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:50:"projects/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:31:"projects/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:19:"projects/([^/]+)/?$";s:41:"index.php?projects_categories=$matches[1]";s:40:"vc_grid_item/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:50:"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:70:"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:65:"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:65:"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:46:"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:29:"vc_grid_item/([^/]+)/embed/?$";s:45:"index.php?vc_grid_item=$matches[1]&embed=true";s:33:"vc_grid_item/([^/]+)/trackback/?$";s:39:"index.php?vc_grid_item=$matches[1]&tb=1";s:41:"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$";s:52:"index.php?vc_grid_item=$matches[1]&paged=$matches[2]";s:48:"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$";s:52:"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]";s:37:"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$";s:51:"index.php?vc_grid_item=$matches[1]&page=$matches[2]";s:29:"vc_grid_item/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:39:"vc_grid_item/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:59:"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:54:"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:54:"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:35:"vc_grid_item/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:40:"index.php?&page_id=701&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:58:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:68:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:88:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:64:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:53:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$";s:91:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$";s:85:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1";s:77:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:65:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]";s:61:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]";s:47:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:57:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:77:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:53:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]";s:51:"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]";s:38:"([0-9]{4})/comment-page-([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&cpage=$matches[2]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";}', 'yes'),
(39, 'recently_edited', 'a:5:{i:0;s:105:"/home/m/murren/murren.ru/public_html/templates/WP/go-arch/go-arch-demo/wp-content/themes/goarch/style.css";i:1;s:126:"/home/m/murren/murren.ru/public_html/templates/WP/go-arch/go-arch-demo/wp-content/themes/goarch/partials/header-navigation.php";i:2;s:105:"/home/m/murren/murren.ru/public_html/templates/WP/go-arch/go-arch-demo/wp-content/themes/goarch/index.php";i:4;s:119:"/home/m/murren/murren.ru/public_html/templates/WP/go-arch/go-arch-demo/wp-content/plugins/goarch_plugin/shortcodes2.php";i:5;s:113:"/home/m/murren/murren.ru/public_html/templates/WP/go-arch/go-arch-demo/wp-content/plugins/goarch_plugin/index.php";}', 'no'),
(77, 'sticky_posts', 'a:1:{i:0;i:1241;}', 'yes'),
(80, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(84, 'page_on_front', '701', 'yes'),
(88, 'site_icon', '1983', 'yes'),
(103, 'cron', 'a:5:{i:1481807289;a:1:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1481821314;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1481849857;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1577880018;a:1:{s:19:"publish_future_post";a:1:{s:32:"53e45760b4285163a94322f2b432f7d3";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;i:1153;}}}}s:7:"version";i:2;}', 'yes'),
(152, 'wpb_js_composer_license_activation_notified', 'yes', 'yes'),
(150, 'vc_version', '5.0.1', 'yes'),
(141, 'widget_goarch_recent_posts', 'a:2:{i:2;a:2:{s:5:"title";s:12:"Recent posts";s:4:"text";s:1:"3";}s:12:"_multiwidget";i:1;}', 'yes'),
(142, 'widget_widget-tag-cloud', 'a:2:{i:2;a:3:{s:5:"title";s:0:"";s:6:"number";i:20;s:8:"type_tag";s:1:"0";}s:12:"_multiwidget";i:1;}', 'yes'),
(143, 'option_tree_settings', 'a:3:{s:15:"contextual_help";a:1:{s:7:"sidebar";s:0:"";}s:8:"sections";a:14:{i:0;a:2:{s:2:"id";s:7:"general";s:5:"title";s:14:"General Config";}i:1;a:2:{s:2:"id";s:3:"css";s:5:"title";s:19:"Custom CSS &amp; JS";}i:2;a:2:{s:2:"id";s:4:"mask";s:5:"title";s:10:"Image mask";}i:3;a:2:{s:2:"id";s:12:"google_fonts";s:5:"title";s:12:"Google Fonts";}i:4;a:2:{s:2:"id";s:10:"typography";s:5:"title";s:10:"Typography";}i:5;a:2:{s:2:"id";s:10:"navigation";s:5:"title";s:10:"Navigation";}i:6;a:2:{s:2:"id";s:17:"sidebars_settings";s:5:"title";s:28:"Theme Sidebars Color Options";}i:7;a:2:{s:2:"id";s:17:"frontheader_color";s:5:"title";s:22:"Frontage Color Options";}i:8;a:2:{s:2:"id";s:6:"header";s:5:"title";s:24:"blog/Page Header Options";}i:9;a:2:{s:2:"id";s:12:"header_color";s:5:"title";s:30:"blog/Page Header Color Options";}i:10;a:2:{s:2:"id";s:13:"single_header";s:5:"title";s:26:"Single Page Header Options";}i:11;a:2:{s:2:"id";s:12:"archive_page";s:5:"title";s:27:"Archive Page Header Options";}i:12;a:2:{s:2:"id";s:10:"error_page";s:5:"title";s:23:"404 Page Header Options";}i:13;a:2:{s:2:"id";s:11:"search_page";s:5:"title";s:26:"Search Page Header Options";}}s:8:"settings";a:55:{i:0;a:10:{s:2:"id";s:13:"additionalcss";s:5:"label";s:14:"additional css";s:4:"desc";s:27:"You can add additional css ";s:3:"std";s:0:"";s:4:"type";s:3:"css";s:7:"section";s:3:"css";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";}i:1;a:10:{s:2:"id";s:12:"additionaljs";s:5:"label";s:21:"additional javascript";s:4:"desc";s:34:"You can add additional javascript ";s:3:"std";s:0:"";s:4:"type";s:3:"css";s:7:"section";s:3:"css";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";}i:2;a:7:{s:2:"id";s:11:"goarch_mask";s:5:"label";s:21:"Background Black mask";s:4:"desc";s:64:"Background Image Black mask <code>on</code> or <code>off</code>.";s:3:"std";s:2:"on";s:4:"type";s:6:"on-off";s:7:"section";s:4:"mask";s:8:"operator";s:3:"and";}i:3;a:6:{s:2:"id";s:10:"goarch_m_c";s:5:"label";s:10:"Mask color";s:4:"desc";s:32:"Please select color with opacity";s:4:"type";s:19:"colorpicker-opacity";s:3:"std";s:0:"";s:7:"section";s:4:"mask";}i:4;a:6:{s:2:"id";s:36:"goarch_frontpage_header_slogan_color";s:5:"label";s:26:"Frontpage paragraph  color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"frontheader_color";}i:5;a:6:{s:2:"id";s:38:"goarch_frontpage_header_buttonbg_color";s:5:"label";s:33:"Frontpage button background color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"frontheader_color";}i:6;a:6:{s:2:"id";s:44:"goarch_frontpage_header_buttonbg_hover_color";s:5:"label";s:39:"Frontpage button background hover color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"frontheader_color";}i:7;a:12:{s:2:"id";s:16:"goarch_logowidth";s:5:"label";s:18:"Logo  header width";s:4:"desc";s:10:"Logo width";s:3:"std";s:2:"39";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:7:"general";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:8;a:12:{s:2:"id";s:17:"goarch_logoheight";s:5:"label";s:18:"Logo header height";s:4:"desc";s:18:"Logo header height";s:3:"std";s:2:"40";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:7:"general";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:9;a:13:{s:2:"id";s:17:"body_google_fonts";s:5:"label";s:12:"Google Fonts";s:4:"desc";s:117:"Add Google Font and after the save settings follow these steps Dashbogoarch > Appearance > Theme Options > Typography";s:3:"std";s:0:"";s:4:"type";s:12:"google-fonts";s:7:"section";s:12:"google_fonts";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:10;a:13:{s:2:"id";s:15:"goarch_tipigrof";s:5:"label";s:10:"Typography";s:4:"desc";s:72:"The Typography option type is for adding typography styles to your site.";s:3:"std";s:0:"";s:4:"type";s:10:"typography";s:7:"section";s:10:"typography";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:11;a:13:{s:2:"id";s:16:"goarch_tipigrof1";s:5:"label";s:13:"Typography h1";s:4:"desc";s:72:"The Typography option type is for adding typography styles to your site.";s:3:"std";s:0:"";s:4:"type";s:10:"typography";s:7:"section";s:10:"typography";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:12;a:13:{s:2:"id";s:16:"goarch_tipigrof2";s:5:"label";s:13:"Typography h2";s:4:"desc";s:72:"The Typography option type is for adding typography styles to your site.";s:3:"std";s:0:"";s:4:"type";s:10:"typography";s:7:"section";s:10:"typography";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:13;a:13:{s:2:"id";s:16:"goarch_tipigrof3";s:5:"label";s:13:"Typography h3";s:4:"desc";s:72:"The Typography option type is for adding typography styles to your site.";s:3:"std";s:0:"";s:4:"type";s:10:"typography";s:7:"section";s:10:"typography";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:14;a:13:{s:2:"id";s:16:"goarch_tipigrof4";s:5:"label";s:13:"Typography h4";s:4:"desc";s:72:"The Typography option type is for adding typography styles to your site.";s:3:"std";s:0:"";s:4:"type";s:10:"typography";s:7:"section";s:10:"typography";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:15;a:13:{s:2:"id";s:16:"goarch_tipigrof5";s:5:"label";s:13:"Typography h5";s:4:"desc";s:72:"The Typography option type is for adding typography styles to your site.";s:3:"std";s:0:"";s:4:"type";s:10:"typography";s:7:"section";s:10:"typography";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:16;a:13:{s:2:"id";s:16:"goarch_tipigrof6";s:5:"label";s:13:"Typography h6";s:4:"desc";s:72:"The Typography option type is for adding typography styles to your site.";s:3:"std";s:0:"";s:4:"type";s:10:"typography";s:7:"section";s:10:"typography";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:17;a:6:{s:2:"id";s:19:"goarch_navigationbg";s:5:"label";s:34:"Theme navigation background color ";s:4:"desc";s:32:"Please select color with opacity";s:4:"type";s:19:"colorpicker-opacity";s:3:"std";s:0:"";s:7:"section";s:10:"navigation";}i:18;a:6:{s:2:"id";s:14:"goarch_navitem";s:5:"label";s:32:"Theme navigation menu item color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:10:"navigation";}i:19;a:6:{s:2:"id";s:20:"goarch_navitem_affix";s:5:"label";s:38:"Theme navigation menu item color affix";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:10:"navigation";}i:20;a:6:{s:2:"id";s:19:"goarch_navitemhover";s:5:"label";s:38:"Theme navigation menu item hover color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:10:"navigation";}i:21;a:6:{s:2:"id";s:32:"goarch_sidebarwidgetgeneralcolor";s:5:"label";s:34:"Theme Sidebar widget general color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"sidebars_settings";}i:22;a:6:{s:2:"id";s:30:"goarch_sidebarwidgettitlecolor";s:5:"label";s:32:"Theme Sidebar widget title color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"sidebars_settings";}i:23;a:6:{s:2:"id";s:23:"goarch_sidebarlinkcolor";s:5:"label";s:30:"Theme Sidebar link title color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"sidebars_settings";}i:24;a:6:{s:2:"id";s:28:"goarch_sidebarlinkhovercolor";s:5:"label";s:36:"Theme Sidebar link title hover color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"sidebars_settings";}i:25;a:6:{s:2:"id";s:35:"goarch_sidebarsearchsubmittextcolor";s:5:"label";s:38:"Theme Sidebar search submit text color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"sidebars_settings";}i:26;a:6:{s:2:"id";s:33:"goarch_sidebarsearchsubmitbgcolor";s:5:"label";s:33:"Theme Sidebar search submit color";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:17:"sidebars_settings";}i:27;a:13:{s:2:"id";s:25:"goarch_mask_c_page_header";s:5:"label";s:40:"Pages header background image visibility";s:4:"desc";s:55:"Heading visibility <code>on</code> or <code>off</code>.";s:3:"std";s:2:"on";s:4:"type";s:6:"on-off";s:7:"section";s:6:"header";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:28;a:6:{s:2:"id";s:24:"goarch_blogheaderbgcolor";s:5:"label";s:43:"blog Pages Header Section background color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:19:"colorpicker-opacity";s:3:"std";s:0:"";s:7:"section";s:6:"header";}i:29;a:6:{s:2:"id";s:29:"goarch_blogheaderbgcolor_mask";s:5:"label";s:48:"blog Pages Header Section background mask color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:19:"colorpicker-opacity";s:3:"std";s:0:"";s:7:"section";s:6:"header";}i:30;a:12:{s:2:"id";s:27:"goarch_blogheaderpaddingtop";s:5:"label";s:18:"Header padding top";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"33";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:6:"header";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:31;a:12:{s:2:"id";s:30:"goarch_blogheaderpaddingbottom";s:5:"label";s:21:"Header padding bottom";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"17";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:6:"header";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:32;a:12:{s:2:"id";s:29:"goarch_singleheaderpaddingtop";s:5:"label";s:18:"Header padding top";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"33";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:13:"single_header";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:33;a:12:{s:2:"id";s:32:"goarch_singleheaderpaddingbottom";s:5:"label";s:21:"Header padding bottom";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"17";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:13:"single_header";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:34;a:6:{s:2:"id";s:25:"goarch_singleheadingcolor";s:5:"label";s:27:"Single Pages Heading color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:13:"single_header";}i:35;a:6:{s:2:"id";s:33:"goarch_singleheaderparagraphcolor";s:5:"label";s:30:"Single Pages title post color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:13:"single_header";}i:36;a:12:{s:2:"id";s:30:"goarch_archiveheaderpaddingtop";s:5:"label";s:18:"Header padding top";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"33";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:12:"archive_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:37;a:12:{s:2:"id";s:33:"goarch_archiveheaderpaddingbottom";s:5:"label";s:21:"Header padding bottom";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"17";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,500";s:7:"section";s:12:"archive_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:38;a:6:{s:2:"id";s:26:"goarch_archiveheadingcolor";s:5:"label";s:28:"Archive Pages Heading color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:10:"typography";s:3:"std";s:0:"";s:7:"section";s:12:"archive_page";}i:39;a:11:{s:2:"id";s:22:"goarch_errorpageheadbg";s:5:"label";s:35:"404 Header Section background image";s:4:"desc";s:45:"You can upload your image for parallax header";s:3:"std";s:0:"";s:4:"type";s:6:"upload";s:7:"section";s:10:"error_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:40;a:6:{s:2:"id";s:25:"goarch_errorheaderbgcolor";s:5:"label";s:42:"404 Pages Header Section background color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:10:"error_page";}i:41;a:12:{s:2:"id";s:28:"goarch_errorheaderpaddingtop";s:5:"label";s:18:"Header padding top";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"33";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:10:"error_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:42;a:12:{s:2:"id";s:31:"goarch_errorheaderpaddingbottom";s:5:"label";s:21:"Header padding bottom";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"17";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:10:"error_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:43;a:10:{s:2:"id";s:20:"goarch_error_heading";s:5:"label";s:16:"404 Page Heading";s:4:"desc";s:19:"Enter Error Heading";s:3:"std";s:8:"404 Page";s:4:"type";s:4:"text";s:7:"section";s:10:"error_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";}i:44;a:6:{s:2:"id";s:24:"goarch_errorheadingcolor";s:5:"label";s:24:"404 Pages Heading color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:10:"typography";s:3:"std";s:0:"";s:7:"section";s:10:"error_page";}i:45;a:13:{s:2:"id";s:30:"goarch_error_slogan_visibility";s:5:"label";s:26:"404 Page slogan visibility";s:4:"desc";s:63:"404 Page slogan visibility <code>on</code> or <code>off</code>.";s:3:"std";s:2:"on";s:4:"type";s:6:"on-off";s:7:"section";s:10:"error_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:12:"min_max_step";s:0:"";s:5:"class";s:0:"";s:9:"condition";s:0:"";s:8:"operator";s:3:"and";}i:46;a:10:{s:2:"id";s:19:"goarch_error_slogan";s:5:"label";s:15:"404 Page Slogan";s:4:"desc";s:21:"Enter 404 Page Slogan";s:3:"std";s:33:"Oops! That page can’t be found.";s:4:"type";s:4:"text";s:7:"section";s:10:"error_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";}i:47;a:6:{s:2:"id";s:32:"goarch_errorheaderparagraphcolor";s:5:"label";s:33:"404 Pages paragraph/slogan color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:10:"typography";s:3:"std";s:0:"";s:7:"section";s:10:"error_page";}i:48;a:11:{s:2:"id";s:23:"goarch_searchpageheadbg";s:5:"label";s:38:"Search Header Section background image";s:4:"desc";s:45:"You can upload your image for parallax header";s:3:"std";s:0:"";s:4:"type";s:6:"upload";s:7:"section";s:11:"search_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:49;a:6:{s:2:"id";s:26:"goarch_searchheaderbgcolor";s:5:"label";s:27:"Search Pages Heading color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:10:"typography";s:3:"std";s:0:"";s:7:"section";s:11:"search_page";}i:50;a:12:{s:2:"id";s:29:"goarch_searchheaderpaddingtop";s:5:"label";s:18:"Header padding top";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"33";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:11:"search_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:51;a:12:{s:2:"id";s:32:"goarch_searchheaderpaddingbottom";s:5:"label";s:21:"Header padding bottom";s:4:"desc";s:55:"You can use this option for heading text vertical align";s:3:"std";s:2:"17";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:11:"search_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:52;a:12:{s:2:"id";s:30:"goarch_search_heading_fontsize";s:5:"label";s:29:"Search Page Heading font size";s:4:"desc";s:35:"Enter Search Page Heading font size";s:3:"std";s:0:"";s:4:"type";s:14:"numeric-slider";s:12:"min_max_step";s:5:"0,100";s:7:"section";s:11:"search_page";s:4:"rows";s:0:"";s:9:"post_type";s:0:"";s:8:"taxonomy";s:0:"";s:5:"class";s:0:"";s:8:"operator";s:3:"and";}i:53;a:6:{s:2:"id";s:23:"goarch_blogheadingcolor";s:5:"label";s:25:"blog Pages Heading color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:12:"header_color";}i:54;a:6:{s:2:"id";s:24:"goarch_blogsubtitlecolor";s:5:"label";s:36:"blog Pages  post / page title color ";s:4:"desc";s:19:"Please select color";s:4:"type";s:11:"colorpicker";s:3:"std";s:0:"";s:7:"section";s:12:"header_color";}}}', 'yes'),
(3838, 'option_tree', 'a:60:{s:13:"additionalcss";s:0:"";s:12:"additionaljs";s:0:"";s:11:"goarch_mask";s:2:"on";s:10:"goarch_m_c";s:0:"";s:36:"goarch_frontpage_header_slogan_color";s:0:"";s:38:"goarch_frontpage_header_buttonbg_color";s:0:"";s:44:"goarch_frontpage_header_buttonbg_hover_color";s:0:"";s:16:"goarch_logowidth";s:2:"39";s:17:"goarch_logoheight";s:2:"40";s:17:"body_google_fonts";s:0:"";s:15:"goarch_tipigrof";s:0:"";s:16:"goarch_tipigrof1";s:0:"";s:16:"goarch_tipigrof2";s:0:"";s:16:"goarch_tipigrof3";s:0:"";s:16:"goarch_tipigrof4";s:0:"";s:16:"goarch_tipigrof5";s:0:"";s:16:"goarch_tipigrof6";s:0:"";s:19:"goarch_navigationbg";s:0:"";s:14:"goarch_navitem";s:0:"";s:20:"goarch_navitem_affix";s:0:"";s:19:"goarch_navitemhover";s:0:"";s:32:"goarch_sidebarwidgetgeneralcolor";s:0:"";s:30:"goarch_sidebarwidgettitlecolor";s:0:"";s:23:"goarch_sidebarlinkcolor";s:0:"";s:28:"goarch_sidebarlinkhovercolor";s:0:"";s:35:"goarch_sidebarsearchsubmittextcolor";s:0:"";s:33:"goarch_sidebarsearchsubmitbgcolor";s:0:"";s:25:"goarch_mask_c_page_header";s:2:"on";s:24:"goarch_blogheaderbgcolor";s:0:"";s:29:"goarch_blogheaderbgcolor_mask";s:0:"";s:27:"goarch_blogheaderpaddingtop";s:2:"33";s:30:"goarch_blogheaderpaddingbottom";s:2:"17";s:29:"goarch_singleheaderpaddingtop";s:2:"33";s:32:"goarch_singleheaderpaddingbottom";s:2:"17";s:25:"goarch_singleheadingcolor";s:0:"";s:33:"goarch_singleheaderparagraphcolor";s:0:"";s:30:"goarch_archiveheaderpaddingtop";s:2:"33";s:33:"goarch_archiveheaderpaddingbottom";s:2:"17";s:26:"goarch_archiveheadingcolor";s:0:"";s:22:"goarch_errorpageheadbg";s:0:"";s:25:"goarch_errorheaderbgcolor";s:0:"";s:28:"goarch_errorheaderpaddingtop";s:2:"33";s:31:"goarch_errorheaderpaddingbottom";s:2:"17";s:20:"goarch_error_heading";s:8:"404 Page";s:24:"goarch_errorheadingcolor";s:0:"";s:30:"goarch_error_slogan_visibility";s:2:"on";s:19:"goarch_error_slogan";s:33:"Oops! That page can’t be found.";s:32:"goarch_errorheaderparagraphcolor";s:0:"";s:23:"goarch_searchpageheadbg";s:0:"";s:26:"goarch_searchheaderbgcolor";s:0:"";s:29:"goarch_searchheaderpaddingtop";s:2:"33";s:32:"goarch_searchheaderpaddingbottom";s:2:"17";s:30:"goarch_search_heading_fontsize";s:0:"";s:25:"goarch_searchheadingcolor";s:0:"";s:23:"goarch_blogheadingcolor";s:0:"";s:24:"goarch_blogsubtitlecolor";s:0:"";s:27:"goarch_blogbreadcrubmscolor";s:0:"";s:32:"goarch_blogbreadcrubmshovercolor";s:0:"";s:34:"goarch_blogbreadcrubmscurrentcolor";s:0:"";s:30:"goarch_blogbreadcrubmsfontsize";s:2:"15";}', 'yes'),
(145, 'ot_media_post_ID', '5', 'yes'),
(146, 'recently_activated', 'a:2:{s:53:"customizer-export-import/customizer-export-import.php";i:1481803408;s:23:"revslider/revslider.php";i:1481300902;}', 'yes'),
(4127, '_site_transient_update_plugins', 'O:8:"stdClass":4:{s:12:"last_checked";i:1481806687;s:8:"response";a:0:{}s:12:"translations";a:0:{}s:9:"no_update";a:10:{s:19:"akismet/akismet.php";O:8:"stdClass":6:{s:2:"id";s:2:"15";s:4:"slug";s:7:"akismet";s:6:"plugin";s:19:"akismet/akismet.php";s:11:"new_version";s:3:"3.2";s:3:"url";s:38:"https://wordpress.org/plugins/akismet/";s:7:"package";s:54:"https://downloads.wordpress.org/plugin/akismet.3.2.zip";}s:43:"change-table-prefix/change-table-prefix.php";O:8:"stdClass":6:{s:2:"id";s:5:"34206";s:4:"slug";s:19:"change-table-prefix";s:6:"plugin";s:43:"change-table-prefix/change-table-prefix.php";s:11:"new_version";s:3:"1.4";s:3:"url";s:50:"https://wordpress.org/plugins/change-table-prefix/";s:7:"package";s:62:"https://downloads.wordpress.org/plugin/change-table-prefix.zip";}s:53:"customizer-export-import/customizer-export-import.php";O:8:"stdClass":6:{s:2:"id";s:5:"56213";s:4:"slug";s:24:"customizer-export-import";s:6:"plugin";s:53:"customizer-export-import/customizer-export-import.php";s:11:"new_version";s:3:"0.4";s:3:"url";s:55:"https://wordpress.org/plugins/customizer-export-import/";s:7:"package";s:67:"https://downloads.wordpress.org/plugin/customizer-export-import.zip";}s:23:"debug-bar/debug-bar.php";O:8:"stdClass":7:{s:2:"id";s:5:"18561";s:4:"slug";s:9:"debug-bar";s:6:"plugin";s:23:"debug-bar/debug-bar.php";s:11:"new_version";s:5:"0.8.4";s:3:"url";s:40:"https://wordpress.org/plugins/debug-bar/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/debug-bar.0.8.4.zip";s:14:"upgrade_notice";s:56:"Updated to avoid incompatibilities with some extensions.";}s:9:"hello.php";O:8:"stdClass":6:{s:2:"id";s:4:"3564";s:4:"slug";s:11:"hello-dolly";s:6:"plugin";s:9:"hello.php";s:11:"new_version";s:3:"1.6";s:3:"url";s:42:"https://wordpress.org/plugins/hello-dolly/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip";}s:33:"monster-widget/monster-widget.php";O:8:"stdClass":6:{s:2:"id";s:5:"31537";s:4:"slug";s:14:"monster-widget";s:6:"plugin";s:33:"monster-widget/monster-widget.php";s:11:"new_version";s:3:"0.3";s:3:"url";s:45:"https://wordpress.org/plugins/monster-widget/";s:7:"package";s:57:"https://downloads.wordpress.org/plugin/monster-widget.zip";}s:25:"option-tree/ot-loader.php";O:8:"stdClass":6:{s:2:"id";s:5:"13921";s:4:"slug";s:11:"option-tree";s:6:"plugin";s:25:"option-tree/ot-loader.php";s:11:"new_version";s:5:"2.6.0";s:3:"url";s:42:"https://wordpress.org/plugins/option-tree/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/option-tree.2.6.0.zip";}s:47:"regenerate-thumbnails/regenerate-thumbnails.php";O:8:"stdClass":6:{s:2:"id";s:4:"4437";s:4:"slug";s:21:"regenerate-thumbnails";s:6:"plugin";s:47:"regenerate-thumbnails/regenerate-thumbnails.php";s:11:"new_version";s:5:"2.2.6";s:3:"url";s:52:"https://wordpress.org/plugins/regenerate-thumbnails/";s:7:"package";s:64:"https://downloads.wordpress.org/plugin/regenerate-thumbnails.zip";}s:27:"theme-check/theme-check.php";O:8:"stdClass":6:{s:2:"id";s:5:"18487";s:4:"slug";s:11:"theme-check";s:6:"plugin";s:27:"theme-check/theme-check.php";s:11:"new_version";s:10:"20160523.1";s:3:"url";s:42:"https://wordpress.org/plugins/theme-check/";s:7:"package";s:65:"https://downloads.wordpress.org/plugin/theme-check.20160523.1.zip";}s:41:"wordpress-importer/wordpress-importer.php";O:8:"stdClass":6:{s:2:"id";s:5:"14975";s:4:"slug";s:18:"wordpress-importer";s:6:"plugin";s:41:"wordpress-importer/wordpress-importer.php";s:11:"new_version";s:5:"0.6.3";s:3:"url";s:49:"https://wordpress.org/plugins/wordpress-importer/";s:7:"package";s:67:"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.3.zip";}}}', 'no'),
(2789, 'category_children', 'a:6:{i:2;a:1:{i:0;i:46;}i:35;a:1:{i:0;i:57;}i:57;a:1:{i:0;i:58;}i:36;a:5:{i:0;i:59;i:1;i:60;i:2;i:61;i:3;i:62;i:4;i:63;}i:24;a:1:{i:0;i:64;}i:61;a:1:{i:0;i:65;}}', 'yes'),
(185, 'goarcha_taxonomy_image181', '', 'yes'),
(3814, '_transient_timeout_feed_c338a64000c51ebf6963bece9325ec30', '1480621102', 'no'),
(304, 'widget_monster', 'a:2:{i:2;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(224, 'theme_mods_twentyfifteen', 'a:2:{i:0;b:0;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1474394629;s:4:"data";a:2:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}}}}', 'yes'),
(244, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}', 'yes'),
(4211, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:57:"https://downloads.wordpress.org/release/wordpress-4.7.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:57:"https://downloads.wordpress.org/release/wordpress-4.7.zip";s:10:"no_content";s:68:"https://downloads.wordpress.org/release/wordpress-4.7-no-content.zip";s:11:"new_bundled";s:69:"https://downloads.wordpress.org/release/wordpress-4.7-new-bundled.zip";s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:3:"4.7";s:7:"version";s:3:"4.7";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.7";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1481806691;s:15:"version_checked";s:3:"4.7";s:12:"translations";a:0:{}}', 'no'),
(2833, 'widget_vanessa_twiter', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(3252, 'revslider-update-check-short', '1481731303', 'yes'),
(2924, 'projects_categories_children', 'a:0:{}', 'yes'),
(3385, 'revslider-connection', '1', 'yes'),
(3386, 'revslider-latest-version', '5.3.1.5', 'yes'),
(3387, 'revslider-stable-version', '4.2', 'yes'),
(3388, 'revslider-notices', 'a:4:{i:0;O:8:"stdClass":7:{s:7:"version";s:5:"5.0.9";s:4:"text";s:230:"<a href="http://revolution.themepunch.com/direct-customer-benefits/" target="_blank"><img src="http://updates.themepunch.tools/banners/updatenow51_banner.jpg" style="min-width: 50%; max-width:100%" alt="revslider 5.1 is out" ></a>";s:4:"code";s:9:"TPRS51-01";s:5:"color";s:5:"green";s:7:"disable";b:0;s:9:"is_global";b:0;s:10:"additional";a:0:{}}i:1;O:8:"stdClass":7:{s:7:"version";s:5:"5.1.4";s:4:"text";s:242:"<a href="http://revolution.themepunch.com/direct-customer-benefits/?ref=515b" target="_blank"><img src="http://updates.themepunch.tools/banners/updatenow_banner515.jpg" style="min-width: 50%; max-width:100%" alt="revslider 5.1.5 is out" ></a>";s:4:"code";s:10:"TPRS515-01";s:5:"color";s:5:"green";s:7:"disable";b:0;s:9:"is_global";b:0;s:10:"additional";a:0:{}}i:2;O:8:"stdClass":7:{s:7:"version";s:5:"5.1.6";s:4:"text";s:240:"<a href="http://revolution.themepunch.com/direct-customer-benefits/?ref=52b" target="_blank"><img src="http://updates.themepunch.tools/banners/updatenow_banner52.jpg" style="min-width: 50%; max-width:100%" alt="revslider 5.1.5 is out" ></a>";s:4:"code";s:10:"TPRS515-01";s:5:"color";s:5:"green";s:7:"disable";b:0;s:9:"is_global";b:0;s:10:"additional";a:0:{}}i:3;O:8:"stdClass":7:{s:7:"version";s:5:"5.2.9";s:4:"text";s:249:"<a href="http://revolution.themepunch.com/direct-customer-benefits/?ref=530b" target="_blank"><img src="http://updates.themepunch.tools/banners/updatenow_banner_large_5.3.jpg" style="min-width: 50%; max-width:100%" alt="revslider 5.3.0 is out" ></a>";s:4:"code";s:10:"TPRS530-01";s:5:"color";s:5:"green";s:7:"disable";b:0;s:9:"is_global";b:0;s:10:"additional";a:0:{}}}', 'yes'),
(4209, 'db_upgraded', '', 'yes'),
(3253, 'revslider-templates-check', '1481536490', 'yes'),
(2788, 'goarch_taxonomy_image2', '', 'yes'),
(3947, 'revslider-library-check', '1480769397', 'yes');
REPLACE INTO `xwlpv_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(3948, 'rs-library', 'a:2:{s:7:"objects";a:169:{i:198;a:11:{s:2:"id";s:3:"198";s:4:"type";s:1:"1";s:6:"handle";s:16:"object_dvd_1.png";s:4:"name";s:3:"DVD";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:43:17";s:6:"active";s:1:"1";}i:197;a:11:{s:2:"id";s:3:"197";s:4:"type";s:1:"2";s:6:"handle";s:17:"relax_hammock.jpg";s:4:"name";s:13:"Relax Hammock";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"24";s:6:"handle";s:6:"People";s:4:"name";s:6:"People";}i:1;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:196;a:11:{s:2:"id";s:3:"196";s:4:"type";s:1:"2";s:6:"handle";s:16:"beach_houses.jpg";s:4:"name";s:12:"Beach Houses";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:195;a:11:{s:2:"id";s:3:"195";s:4:"type";s:1:"2";s:6:"handle";s:17:"forest_road_2.jpg";s:4:"name";s:13:"Forest Road 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:194;a:11:{s:2:"id";s:3:"194";s:4:"type";s:1:"2";s:6:"handle";s:14:"clean_desk.jpg";s:4:"name";s:10:"Clean Desk";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:193;a:11:{s:2:"id";s:3:"193";s:4:"type";s:1:"2";s:6:"handle";s:19:"mountain_view_6.jpg";s:4:"name";s:15:"Mountain View 6";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"23";s:6:"handle";s:5:"Night";s:4:"name";s:5:"Night";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1249";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:192;a:11:{s:2:"id";s:3:"192";s:4:"type";s:1:"2";s:6:"handle";s:14:"corn_field.jpg";s:4:"name";s:10:"Corn Field";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1320";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:191;a:11:{s:2:"id";s:3:"191";s:4:"type";s:1:"2";s:6:"handle";s:21:"stylish_apartment.jpg";s:4:"name";s:17:"Stylish Apartment";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1281";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:190;a:11:{s:2:"id";s:3:"190";s:4:"type";s:1:"2";s:6:"handle";s:24:"hipster_coffee_house.jpg";s:4:"name";s:20:"Hipster Coffee House";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1080";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:189;a:11:{s:2:"id";s:3:"189";s:4:"type";s:1:"2";s:6:"handle";s:16:"blurry_beach.jpg";s:4:"name";s:12:"Blurry Beach";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1080";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-10-17 12:41:12";s:6:"active";s:1:"1";}i:188;a:11:{s:2:"id";s:3:"188";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_plant_1.png";s:4:"name";s:7:"Plant 1";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-12 16:25:27";s:6:"active";s:1:"1";}i:187;a:11:{s:2:"id";s:3:"187";s:4:"type";s:1:"1";s:6:"handle";s:16:"object_pen_1.png";s:4:"name";s:5:"Pen 1";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-12 16:25:27";s:6:"active";s:1:"1";}i:186;a:11:{s:2:"id";s:3:"186";s:4:"type";s:1:"2";s:6:"handle";s:17:"greens_street.jpg";s:4:"name";s:13:"Greens Street";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1277";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:185;a:11:{s:2:"id";s:3:"185";s:4:"type";s:1:"2";s:6:"handle";s:10:"desert.jpg";s:4:"name";s:6:"Desert";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:184;a:11:{s:2:"id";s:3:"184";s:4:"type";s:1:"2";s:6:"handle";s:19:"mountain_view_5.jpg";s:4:"name";s:15:"Mountain View 5";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1080";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:183;a:11:{s:2:"id";s:3:"183";s:4:"type";s:1:"2";s:6:"handle";s:10:"laptop.jpg";s:4:"name";s:6:"Laptop";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1391";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:182;a:11:{s:2:"id";s:3:"182";s:4:"type";s:1:"2";s:6:"handle";s:16:"grand_canyon.jpg";s:4:"name";s:12:"Grand Canyon";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1287";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:181;a:11:{s:2:"id";s:3:"181";s:4:"type";s:1:"2";s:6:"handle";s:20:"landscape_clouds.jpg";s:4:"name";s:16:"Landscape Clouds";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1272";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:180;a:11:{s:2:"id";s:3:"180";s:4:"type";s:1:"2";s:6:"handle";s:17:"highway_night.jpg";s:4:"name";s:13:"Highway Night";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"23";s:6:"handle";s:5:"Night";s:4:"name";s:5:"Night";}i:1;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1440";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:179;a:11:{s:2:"id";s:3:"179";s:4:"type";s:1:"2";s:6:"handle";s:15:"beach_water.jpg";s:4:"name";s:11:"Beach Water";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:177;a:11:{s:2:"id";s:3:"177";s:4:"type";s:1:"2";s:6:"handle";s:15:"woman_beach.jpg";s:4:"name";s:11:"Woman Beach";s:4:"tags";a:4:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:2;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}i:3;a:3:{s:2:"id";s:2:"24";s:6:"handle";s:6:"People";s:4:"name";s:6:"People";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:175;a:11:{s:2:"id";s:3:"175";s:4:"type";s:1:"2";s:6:"handle";s:12:"cool_guy.jpg";s:4:"name";s:8:"Cool Guy";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"24";s:6:"handle";s:6:"People";s:4:"name";s:6:"People";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:174;a:11:{s:2:"id";s:3:"174";s:4:"type";s:1:"2";s:6:"handle";s:13:"beach_sea.jpg";s:4:"name";s:9:"Beach Sea";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:2;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:173;a:11:{s:2:"id";s:3:"173";s:4:"type";s:1:"2";s:6:"handle";s:17:"bridge_clouds.jpg";s:4:"name";s:13:"Bridge Clouds";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}i:2;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1281";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-09-05 15:29:22";s:6:"active";s:1:"1";}i:172;a:11:{s:2:"id";s:3:"172";s:4:"type";s:1:"1";s:6:"handle";s:16:"object_egg_1.png";s:4:"name";s:3:"Egg";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"600";s:6:"height";s:3:"600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:171;a:11:{s:2:"id";s:3:"171";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_guitar_1.png";s:4:"name";s:6:"Guitar";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:170;a:11:{s:2:"id";s:3:"170";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_envelope_1.png";s:4:"name";s:15:"Closed Envelope";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:169;a:11:{s:2:"id";s:3:"169";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_postit_2.png";s:4:"name";s:18:"Postit Label White";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"900";s:6:"height";s:3:"900";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:168;a:11:{s:2:"id";s:3:"168";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_envelope_2.png";s:4:"name";s:13:"Open Envelope";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:167;a:11:{s:2:"id";s:3:"167";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_eggs_1.png";s:4:"name";s:10:"Egg Carton";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:166;a:11:{s:2:"id";s:3:"166";s:4:"type";s:1:"1";s:6:"handle";s:25:"object_bottleopener_1.png";s:4:"name";s:13:"Bottle Opener";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}i:1;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"800";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:165;a:11:{s:2:"id";s:3:"165";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_blueprints_1.png";s:4:"name";s:10:"Blueprints";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:164;a:11:{s:2:"id";s:3:"164";s:4:"type";s:1:"1";s:6:"handle";s:22:"object_holepunch_1.png";s:4:"name";s:10:"Hole-punch";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:163;a:11:{s:2:"id";s:3:"163";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_speaker_1.png";s:4:"name";s:13:"Black Speaker";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:162;a:11:{s:2:"id";s:3:"162";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_eraser_1.png";s:4:"name";s:6:"Eraser";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"500";s:6:"height";s:3:"500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:161;a:11:{s:2:"id";s:3:"161";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_vinylcover_1.png";s:4:"name";s:11:"Vinyl Cover";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:160;a:11:{s:2:"id";s:3:"160";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_booklet_1.png";s:4:"name";s:9:"Booklet 1";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:159;a:11:{s:2:"id";s:3:"159";s:4:"type";s:1:"1";s:6:"handle";s:22:"object_earphones_2.png";s:4:"name";s:11:"Earphones 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:158;a:11:{s:2:"id";s:3:"158";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_vinyl_1.png";s:4:"name";s:5:"Vinyl";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:157;a:11:{s:2:"id";s:3:"157";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_postit_1.png";s:4:"name";s:17:"Postit Label Pink";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"900";s:6:"height";s:3:"900";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:156;a:11:{s:2:"id";s:3:"156";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_mechpencil_1.png";s:4:"name";s:17:"Mechanical Pencil";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:155;a:11:{s:2:"id";s:3:"155";s:4:"type";s:1:"1";s:6:"handle";s:22:"object_turntable_1.png";s:4:"name";s:9:"Turntable";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:154;a:11:{s:2:"id";s:3:"154";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_folder_2.png";s:4:"name";s:19:"Closed Folder Black";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:153;a:11:{s:2:"id";s:3:"153";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_postit_4.png";s:4:"name";s:18:"Postit Label Green";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"900";s:6:"height";s:3:"900";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:152;a:11:{s:2:"id";s:3:"152";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_folder_1.png";s:4:"name";s:12:"Blank Folder";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:151;a:11:{s:2:"id";s:3:"151";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_pencup_1.png";s:4:"name";s:7:"Pen Cup";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:150;a:11:{s:2:"id";s:3:"150";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_winebottle_1.png";s:4:"name";s:15:"Red Wine Bottle";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:149;a:11:{s:2:"id";s:3:"149";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_headphones_1.png";s:4:"name";s:10:"Headphones";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:148;a:11:{s:2:"id";s:3:"148";s:4:"type";s:1:"1";s:6:"handle";s:22:"object_earphones_1.png";s:4:"name";s:9:"Earphones";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:147;a:11:{s:2:"id";s:3:"147";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_postit_3.png";s:4:"name";s:19:"Postit Label Yellow";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"900";s:6:"height";s:3:"900";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:146;a:11:{s:2:"id";s:3:"146";s:4:"type";s:1:"1";s:6:"handle";s:22:"object_corkscrew_1.png";s:4:"name";s:23:"Corkscrew Bottle Opener";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}i:1;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1300";s:6:"height";s:4:"1300";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-18 15:34:49";s:6:"active";s:1:"1";}i:145;a:11:{s:2:"id";s:3:"145";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_muffin_1.png";s:4:"name";s:16:"Chocolate Muffin";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"900";s:6:"height";s:3:"900";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:144;a:11:{s:2:"id";s:3:"144";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_chair_2.png";s:4:"name";s:12:"Yellow Chair";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:143;a:11:{s:2:"id";s:3:"143";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_knife_2.png";s:4:"name";s:7:"Knife 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:142;a:11:{s:2:"id";s:3:"142";s:4:"type";s:1:"1";s:6:"handle";s:26:"object_choppingboard_2.png";s:4:"name";s:16:"Chopping Board 3";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:141;a:11:{s:2:"id";s:3:"141";s:4:"type";s:1:"1";s:6:"handle";s:26:"object_choppingboard_3.png";s:4:"name";s:16:"Chopping Board 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:140;a:11:{s:2:"id";s:3:"140";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_coffee_2.png";s:4:"name";s:12:"Coffee Cup 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1200";s:6:"height";s:4:"1200";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:139;a:11:{s:2:"id";s:3:"139";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_bread_1.png";s:4:"name";s:15:"Croissant Bread";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:138;a:11:{s:2:"id";s:3:"138";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_spoon_2.png";s:4:"name";s:12:"Wodden Spoon";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:137;a:11:{s:2:"id";s:3:"137";s:4:"type";s:1:"1";s:6:"handle";s:26:"object_choppingboard_1.png";s:4:"name";s:16:"Chopping Board 1";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:136;a:11:{s:2:"id";s:3:"136";s:4:"type";s:1:"1";s:6:"handle";s:16:"object_cup_2.png";s:4:"name";s:11:"Empty Cup 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1400";s:6:"height";s:4:"1400";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:135;a:11:{s:2:"id";s:3:"135";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_knife_1.png";s:4:"name";s:5:"Knife";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:134;a:11:{s:2:"id";s:3:"134";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_spoon_1.png";s:4:"name";s:5:"Spoon";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:133;a:11:{s:2:"id";s:3:"133";s:4:"type";s:1:"1";s:6:"handle";s:16:"object_cup_1.png";s:4:"name";s:9:"Empty Cup";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1400";s:6:"height";s:4:"1400";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:132;a:11:{s:2:"id";s:3:"132";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_chair_3.png";s:4:"name";s:11:"White Chair";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:131;a:11:{s:2:"id";s:3:"131";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_coffee_1.png";s:4:"name";s:10:"Coffee Cup";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:130;a:11:{s:2:"id";s:3:"130";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_frypan_2.png";s:4:"name";s:9:"Fry Pan 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:129;a:11:{s:2:"id";s:3:"129";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_frypan_1.png";s:4:"name";s:9:"Fry Pan 1";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:128;a:11:{s:2:"id";s:3:"128";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_fork_1.png";s:4:"name";s:4:"Fork";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:127;a:11:{s:2:"id";s:3:"127";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_dishrag_1.png";s:4:"name";s:13:"Dishrag Cloth";s:4:"tags";a:0:{}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-17 13:48:44";s:6:"active";s:1:"1";}i:126;a:11:{s:2:"id";s:3:"126";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_wacom_pen.png";s:4:"name";s:17:"Wacom Drawing Pen";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}i:2;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1060";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:125;a:11:{s:2:"id";s:3:"125";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_occulus_vr.png";s:4:"name";s:23:"Occulus Virtual Reality";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:124;a:11:{s:2:"id";s:3:"124";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_antenna.png";s:4:"name";s:13:"Antenna Radar";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:123;a:11:{s:2:"id";s:3:"123";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_solarpanel.png";s:4:"name";s:11:"Solar Panel";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:122;a:11:{s:2:"id";s:3:"122";s:4:"type";s:1:"1";s:6:"handle";s:16:"object_wacom.png";s:4:"name";s:20:"Wacom Drawing Tablet";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}i:2;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:121;a:11:{s:2:"id";s:3:"121";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_earth_2.png";s:4:"name";s:20:"Earth Globe Planet 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:120;a:11:{s:2:"id";s:3:"120";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_chair_1.png";s:4:"name";s:12:"Office Chair";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:119;a:11:{s:2:"id";s:3:"119";s:4:"type";s:1:"1";s:6:"handle";s:24:"object_windturbine_2.png";s:4:"name";s:14:"Wind Turbine 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:118;a:11:{s:2:"id";s:3:"118";s:4:"type";s:1:"1";s:6:"handle";s:22:"object_windturbine.png";s:4:"name";s:12:"Wind Turbine";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:117;a:11:{s:2:"id";s:3:"117";s:4:"type";s:1:"1";s:6:"handle";s:16:"object_earth.png";s:4:"name";s:18:"Earth Globe Planet";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 16:50:55";s:6:"active";s:1:"1";}i:116;a:11:{s:2:"id";s:3:"116";s:4:"type";s:1:"2";s:6:"handle";s:19:"mountain_view_2.jpg";s:4:"name";s:15:"Mountain View 2";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1275";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:115;a:11:{s:2:"id";s:3:"115";s:4:"type";s:1:"2";s:6:"handle";s:16:"desert_trees.jpg";s:4:"name";s:12:"Desert Trees";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1275";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:114;a:11:{s:2:"id";s:3:"114";s:4:"type";s:1:"2";s:6:"handle";s:20:"explore_moutains.jpg";s:4:"name";s:17:"Explore Mountains";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1080";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:113;a:11:{s:2:"id";s:3:"113";s:4:"type";s:1:"2";s:6:"handle";s:19:"night_skyline_2.jpg";s:4:"name";s:15:"Night Skyline 2";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"23";s:6:"handle";s:5:"Night";s:4:"name";s:5:"Night";}i:1;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:112;a:11:{s:2:"id";s:3:"112";s:4:"type";s:1:"2";s:6:"handle";s:15:"cliff_ocean.jpg";s:4:"name";s:11:"Cliff Ocean";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:111;a:11:{s:2:"id";s:3:"111";s:4:"type";s:1:"2";s:6:"handle";s:14:"city_smoke.jpg";s:4:"name";s:10:"City Smoke";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"24";s:6:"handle";s:6:"People";s:4:"name";s:6:"People";}i:1;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:110;a:11:{s:2:"id";s:3:"110";s:4:"type";s:1:"2";s:6:"handle";s:16:"surfer_beach.jpg";s:4:"name";s:12:"Surfer Beach";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:2;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1278";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:109;a:11:{s:2:"id";s:3:"109";s:4:"type";s:1:"2";s:6:"handle";s:13:"sky_night.jpg";s:4:"name";s:9:"Sky Night";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}i:2;a:3:{s:2:"id";s:2:"23";s:6:"handle";s:5:"Night";s:4:"name";s:5:"Night";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1282";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:108;a:11:{s:2:"id";s:3:"108";s:4:"type";s:1:"2";s:6:"handle";s:15:"palm_sunset.jpg";s:4:"name";s:11:"Palm Sunset";s:4:"tags";a:4:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}i:2;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}i:3;a:3:{s:2:"id";s:2:"23";s:6:"handle";s:5:"Night";s:4:"name";s:5:"Night";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1372";s:6:"height";s:4:"1920";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:107;a:11:{s:2:"id";s:3:"107";s:4:"type";s:1:"2";s:6:"handle";s:18:"concert_people.jpg";s:4:"name";s:14:"Concert People";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"24";s:6:"handle";s:6:"People";s:4:"name";s:6:"People";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1277";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:106;a:11:{s:2:"id";s:3:"106";s:4:"type";s:1:"2";s:6:"handle";s:15:"forest_road.jpg";s:4:"name";s:11:"Forest Road";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1282";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:105;a:11:{s:2:"id";s:3:"105";s:4:"type";s:1:"2";s:6:"handle";s:15:"beach_ocean.jpg";s:4:"name";s:11:"Beach Ocean";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:2;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:104;a:11:{s:2:"id";s:3:"104";s:4:"type";s:1:"2";s:6:"handle";s:18:"mountain_night.jpg";s:4:"name";s:14:"Mountain Night";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}i:2;a:3:{s:2:"id";s:2:"23";s:6:"handle";s:5:"Night";s:4:"name";s:5:"Night";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1277";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:103;a:11:{s:2:"id";s:3:"103";s:4:"type";s:1:"2";s:6:"handle";s:19:"ocean_mountains.jpg";s:4:"name";s:15:"Ocean Mountains";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1282";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:102;a:11:{s:2:"id";s:3:"102";s:4:"type";s:1:"2";s:6:"handle";s:10:"forest.jpg";s:4:"name";s:6:"Forest";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:101;a:11:{s:2:"id";s:3:"101";s:4:"type";s:1:"2";s:6:"handle";s:16:"ocean_stones.jpg";s:4:"name";s:12:"Ocean Stones";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:2;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:100;a:11:{s:2:"id";s:3:"100";s:4:"type";s:1:"2";s:6:"handle";s:16:"country_road.jpg";s:4:"name";s:12:"Country Road";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}i:2;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:99;a:11:{s:2:"id";s:2:"99";s:4:"type";s:1:"2";s:6:"handle";s:9:"beach.jpg";s:4:"name";s:5:"Beach";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:98;a:11:{s:2:"id";s:2:"98";s:4:"type";s:1:"2";s:6:"handle";s:16:"city_skyline.jpg";s:4:"name";s:12:"City Skyline";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:97;a:11:{s:2:"id";s:2:"97";s:4:"type";s:1:"2";s:6:"handle";s:17:"night_skyline.jpg";s:4:"name";s:13:"Night Skyline";s:4:"tags";a:3:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}i:2;a:3:{s:2:"id";s:2:"23";s:6:"handle";s:5:"Night";s:4:"name";s:5:"Night";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:96;a:11:{s:2:"id";s:2:"96";s:4:"type";s:1:"2";s:6:"handle";s:14:"city_river.jpg";s:4:"name";s:10:"City River";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:95;a:11:{s:2:"id";s:2:"95";s:4:"type";s:1:"2";s:6:"handle";s:19:"mountain_view_3.jpg";s:4:"name";s:15:"Mountain View 3";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1281";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:94;a:11:{s:2:"id";s:2:"94";s:4:"type";s:1:"2";s:6:"handle";s:14:"misty_farm.jpg";s:4:"name";s:10:"Misty Farm";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:93;a:11:{s:2:"id";s:2:"93";s:4:"type";s:1:"2";s:6:"handle";s:17:"mountain_path.jpg";s:4:"name";s:13:"Mountain Path";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1280";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:92;a:11:{s:2:"id";s:2:"92";s:4:"type";s:1:"2";s:6:"handle";s:19:"night_skyline_3.jpg";s:4:"name";s:15:"Night Skyline 3";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1080";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:91;a:11:{s:2:"id";s:2:"91";s:4:"type";s:1:"2";s:6:"handle";s:17:"mountain_view.jpg";s:4:"name";s:13:"Mountain View";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1160";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:90;a:11:{s:2:"id";s:2:"90";s:4:"type";s:1:"2";s:6:"handle";s:19:"rocky_landscape.jpg";s:4:"name";s:15:"Rocky Landscape";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1080";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:89;a:11:{s:2:"id";s:2:"89";s:4:"type";s:1:"2";s:6:"handle";s:19:"mountain_view_4.jpg";s:4:"name";s:15:"Mountain View 4";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}i:1;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1920";s:6:"height";s:4:"1203";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-15 14:29:46";s:6:"active";s:1:"1";}i:88;a:11:{s:2:"id";s:2:"88";s:4:"type";s:1:"1";s:6:"handle";s:24:"object_eiffeltower_2.png";s:4:"name";s:13:"Eiffeltower 2";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}i:1;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"700";s:6:"height";s:3:"700";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:87;a:11:{s:2:"id";s:2:"87";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_notebook_1.png";s:4:"name";s:11:"Notebook PC";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"2000";s:6:"height";s:4:"2000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:86;a:11:{s:2:"id";s:2:"86";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_macbook_1.png";s:4:"name";s:20:"Apple Macbook Silver";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"2000";s:6:"height";s:4:"2000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:85;a:11:{s:2:"id";s:2:"85";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_canon_2.png";s:4:"name";s:21:"Canon Camera DSLR Top";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:84;a:11:{s:2:"id";s:2:"84";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_iphone_3.png";s:4:"name";s:25:"Apple iPhone Silver White";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:83;a:11:{s:2:"id";s:2:"83";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_candy_2.png";s:4:"name";s:15:"Candy Colored 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"800";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:82;a:11:{s:2:"id";s:2:"82";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_macmouse_1.png";s:4:"name";s:15:"Apple Mac Mouse";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:81;a:11:{s:2:"id";s:2:"81";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_iphone_1.png";s:4:"name";s:18:"Apple iPhone Black";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:80;a:11:{s:2:"id";s:2:"80";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_deco_1.png";s:4:"name";s:17:"White Deco Object";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}i:1;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"800";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:79;a:11:{s:2:"id";s:2:"79";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_applewatch_1.png";s:4:"name";s:24:"Apple Watch White Silver";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"800";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:78;a:11:{s:2:"id";s:2:"78";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_swissknife_1.png";s:4:"name";s:11:"Swiss Knife";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}i:1;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"800";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:77;a:11:{s:2:"id";s:2:"77";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_applewatch_2.png";s:4:"name";s:17:"Apple Watch Black";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"800";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:76;a:11:{s:2:"id";s:2:"76";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_candy_1.png";s:4:"name";s:13:"Candy Colored";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"800";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:75;a:11:{s:2:"id";s:2:"75";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_ipad_1.png";s:4:"name";s:16:"Apple iPad Black";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"2000";s:6:"height";s:4:"2000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:74;a:11:{s:2:"id";s:2:"74";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_lamp_2.png";s:4:"name";s:15:"Black Desk Lamp";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:73;a:11:{s:2:"id";s:2:"73";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_canon_1.png";s:4:"name";s:17:"Canon Camera DLSR";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:72;a:11:{s:2:"id";s:2:"72";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_blackberry_2.png";s:4:"name";s:12:"Blackberry 3";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:71;a:11:{s:2:"id";s:2:"71";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_iphone_2.png";s:4:"name";s:19:"Apple iPhone Silver";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:70;a:11:{s:2:"id";s:2:"70";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_ipad_2.png";s:4:"name";s:15:"Apple iPad Gold";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"2000";s:6:"height";s:4:"2000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:69;a:11:{s:2:"id";s:2:"69";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_printer_1.png";s:4:"name";s:7:"Printer";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:68;a:11:{s:2:"id";s:2:"68";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_pcmouse_1.png";s:4:"name";s:14:"Black PC Mouse";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:67;a:11:{s:2:"id";s:2:"67";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_ipad_3.png";s:4:"name";s:17:"Apple iPad Silver";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"2000";s:6:"height";s:4:"2000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:66;a:11:{s:2:"id";s:2:"66";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_lamp_1.png";s:4:"name";s:13:"Desk Lamp Top";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:65;a:11:{s:2:"id";s:2:"65";s:4:"type";s:1:"1";s:6:"handle";s:22:"object_macscreen_1.png";s:4:"name";s:16:"Apple Mac Screen";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"2000";s:6:"height";s:4:"2000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:64;a:11:{s:2:"id";s:2:"64";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_blackberry_3.png";s:4:"name";s:12:"Blackberry 2";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:63;a:11:{s:2:"id";s:2:"63";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_applewatch_3.png";s:4:"name";s:16:"Apple Watch Gold";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"800";s:6:"height";s:3:"800";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:62;a:11:{s:2:"id";s:2:"62";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_blackberry_1.png";s:4:"name";s:10:"Blackberry";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 16:51:11";s:6:"active";s:1:"1";}i:49;a:11:{s:2:"id";s:2:"49";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_bottle_1.png";s:4:"name";s:18:"Brown Glass Bottle";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}i:1;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:48;a:11:{s:2:"id";s:2:"48";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_glasses_1.png";s:4:"name";s:19:"Hipster Glasses Top";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:47;a:11:{s:2:"id";s:2:"47";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_magazine_1.png";s:4:"name";s:14:"Blank Magazine";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:46;a:11:{s:2:"id";s:2:"46";s:4:"type";s:1:"1";s:6:"handle";s:28:"object_leatherdocument_2.png";s:4:"name";s:24:"Black Leather Document 2";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}i:1;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:45;a:11:{s:2:"id";s:2:"45";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_purse_2.png";s:4:"name";s:13:"Black Purse 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:44;a:11:{s:2:"id";s:2:"44";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_typewriter_1.png";s:4:"name";s:18:"Retro Typewriter 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:43;a:11:{s:2:"id";s:2:"43";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_book_5.png";s:4:"name";s:9:"Old Books";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:42;a:11:{s:2:"id";s:2:"42";s:4:"type";s:1:"1";s:6:"handle";s:28:"object_leatherdocument_1.png";s:4:"name";s:29:"Black Leather Document Closed";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:41;a:11:{s:2:"id";s:2:"41";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_book_4.png";s:4:"name";s:8:"Old Book";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:40;a:11:{s:2:"id";s:2:"40";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_wallet_2.png";s:4:"name";s:22:"Black Leather Document";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:39;a:11:{s:2:"id";s:2:"39";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_quill_2.png";s:4:"name";s:15:"Quill Feather 2";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:38;a:11:{s:2:"id";s:2:"38";s:4:"type";s:1:"1";s:6:"handle";s:24:"object_eiffeltower_1.png";s:4:"name";s:11:"Eiffeltower";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:37;a:11:{s:2:"id";s:2:"37";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_magazine_2.png";s:4:"name";s:11:"Open Book 3";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1333";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:36;a:11:{s:2:"id";s:2:"36";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_book_1.png";s:4:"name";s:10:"Blank Book";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:35;a:11:{s:2:"id";s:2:"35";s:4:"type";s:1:"1";s:6:"handle";s:20:"object_glasses_2.png";s:4:"name";s:15:"Hipster Glasses";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:34;a:11:{s:2:"id";s:2:"34";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_book_2.png";s:4:"name";s:11:"Open Book 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:33;a:11:{s:2:"id";s:2:"33";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_gloves_1.png";s:4:"name";s:12:"Black Gloves";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:32;a:11:{s:2:"id";s:2:"32";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_typewriter_2.png";s:4:"name";s:16:"Retro Typewriter";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:31;a:11:{s:2:"id";s:2:"31";s:4:"type";s:1:"1";s:6:"handle";s:17:"object_book_3.png";s:4:"name";s:9:"Open Book";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:30;a:11:{s:2:"id";s:2:"30";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_wallet_1.png";s:4:"name";s:12:"Black Wallet";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1500";s:6:"height";s:4:"1500";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:29;a:11:{s:2:"id";s:2:"29";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_purse_1.png";s:4:"name";s:11:"Black Purse";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:28;a:11:{s:2:"id";s:2:"28";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_quill_1.png";s:4:"name";s:13:"Quill Feather";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 12:57:32";s:6:"active";s:1:"1";}i:27;a:11:{s:2:"id";s:2:"27";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_artbox_2.png";s:4:"name";s:16:"Art Box Colors 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 10:59:23";s:6:"active";s:1:"1";}i:26;a:11:{s:2:"id";s:2:"26";s:4:"type";s:1:"1";s:6:"handle";s:18:"object_cloth_1.png";s:4:"name";s:17:"Cloth Paint Color";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1400";s:6:"height";s:4:"1400";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 10:59:23";s:6:"active";s:1:"1";}i:25;a:11:{s:2:"id";s:2:"25";s:4:"type";s:1:"1";s:6:"handle";s:21:"object_brushpot_1.png";s:4:"name";s:9:"Brush Pot";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"984";s:6:"height";s:3:"984";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 10:59:23";s:6:"active";s:1:"1";}i:24;a:11:{s:2:"id";s:2:"24";s:4:"type";s:1:"1";s:6:"handle";s:24:"object_paintbucket_1.png";s:4:"name";s:12:"Paint Bucket";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1400";s:6:"height";s:4:"1400";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 10:59:23";s:6:"active";s:1:"1";}i:23;a:11:{s:2:"id";s:2:"23";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_paintbrush_2.png";s:4:"name";s:12:"Paintbrush 3";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}}s:11:"description";s:8:"New File";s:5:"width";s:3:"700";s:6:"height";s:3:"700";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 10:59:23";s:6:"active";s:1:"1";}i:22;a:11:{s:2:"id";s:2:"22";s:4:"type";s:1:"1";s:6:"handle";s:19:"object_artbox_1.png";s:4:"name";s:14:"Art Box Colors";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 10:59:23";s:6:"active";s:1:"1";}i:21;a:11:{s:2:"id";s:2:"21";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_paintbrush_3.png";s:4:"name";s:12:"Paintbrush 2";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1100";s:6:"height";s:4:"1100";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 10:59:23";s:6:"active";s:1:"1";}i:20;a:11:{s:2:"id";s:2:"20";s:4:"type";s:1:"1";s:6:"handle";s:23:"object_paintbrush_1.png";s:4:"name";s:12:"Paintbrush 1";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1000";s:6:"height";s:4:"1000";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-12 10:59:23";s:6:"active";s:1:"1";}i:11;a:11:{s:2:"id";s:2:"11";s:4:"type";s:1:"1";s:6:"handle";s:21:"table_radio_right.png";s:4:"name";s:18:"Radio Speaker Wood";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-11 13:37:51";s:6:"active";s:1:"1";}i:10;a:11:{s:2:"id";s:2:"10";s:4:"type";s:1:"1";s:6:"handle";s:18:"keyboard_apple.png";s:4:"name";s:14:"Apple Keyboard";s:4:"tags";a:1:{i:0;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-11 13:37:51";s:6:"active";s:1:"1";}i:9;a:11:{s:2:"id";s:1:"9";s:4:"type";s:1:"1";s:6:"handle";s:20:"macbook_top_gold.png";s:4:"name";s:18:"Apple Macbook Gold";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1600";s:6:"height";s:4:"1600";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-11 13:37:51";s:6:"active";s:1:"1";}i:8;a:11:{s:2:"id";s:1:"8";s:4:"type";s:1:"1";s:6:"handle";s:21:"nexus6_front_blue.png";s:4:"name";s:19:"Google Nexus 6 Blue";s:4:"tags";a:2:{i:0;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:1;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}}s:11:"description";s:8:"New File";s:5:"width";s:4:"1100";s:6:"height";s:4:"1100";s:7:"version";s:3:"1.0";s:5:"added";s:19:"2016-08-11 13:37:51";s:6:"active";s:1:"1";}}s:4:"tags";a:13:{i:1;a:3:{s:2:"id";s:1:"1";s:6:"handle";s:11:"accessories";s:4:"name";s:11:"Accessories";}i:5;a:3:{s:2:"id";s:1:"5";s:6:"handle";s:3:"art";s:4:"name";s:3:"Art";}i:20;a:3:{s:2:"id";s:2:"20";s:6:"handle";s:5:"Beach";s:4:"name";s:5:"Beach";}i:21;a:3:{s:2:"id";s:2:"21";s:6:"handle";s:4:"City";s:4:"name";s:4:"City";}i:2;a:3:{s:2:"id";s:1:"2";s:6:"handle";s:6:"device";s:4:"name";s:6:"Device";}i:16;a:3:{s:2:"id";s:2:"16";s:6:"handle";s:4:"food";s:4:"name";s:4:"Food";}i:18;a:3:{s:2:"id";s:2:"18";s:6:"handle";s:4:"misc";s:4:"name";s:4:"Misc";}i:4;a:3:{s:2:"id";s:1:"4";s:6:"handle";s:5:"music";s:4:"name";s:5:"Music";}i:19;a:3:{s:2:"id";s:2:"19";s:6:"handle";s:6:"nature";s:4:"name";s:6:"Nature";}i:23;a:3:{s:2:"id";s:2:"23";s:6:"handle";s:5:"Night";s:4:"name";s:5:"Night";}i:3;a:3:{s:2:"id";s:1:"3";s:6:"handle";s:6:"office";s:4:"name";s:6:"Office";}i:24;a:3:{s:2:"id";s:2:"24";s:6:"handle";s:6:"People";s:4:"name";s:6:"People";}i:22;a:3:{s:2:"id";s:2:"22";s:6:"handle";s:3:"Sky";s:4:"name";s:3:"Sky";}}}', 'no');
REPLACE INTO `xwlpv_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(4206, '_site_transient_update_themes', 'O:8:"stdClass":4:{s:12:"last_checked";i:1481806690;s:7:"checked";a:4:{s:6:"goarch";s:5:"1.0.3";s:13:"twentyfifteen";s:3:"1.6";s:14:"twentyfourteen";s:3:"1.8";s:13:"twentysixteen";s:3:"1.3";}s:8:"response";a:2:{s:13:"twentyfifteen";a:4:{s:5:"theme";s:13:"twentyfifteen";s:11:"new_version";s:3:"1.7";s:3:"url";s:43:"https://wordpress.org/themes/twentyfifteen/";s:7:"package";s:59:"https://downloads.wordpress.org/theme/twentyfifteen.1.7.zip";}s:14:"twentyfourteen";a:4:{s:5:"theme";s:14:"twentyfourteen";s:11:"new_version";s:3:"1.9";s:3:"url";s:44:"https://wordpress.org/themes/twentyfourteen/";s:7:"package";s:60:"https://downloads.wordpress.org/theme/twentyfourteen.1.9.zip";}}s:12:"translations";a:0:{}}', 'no'),
(3950, 'rs_tables_created', '1', 'yes'),
(4123, 'revslider_table_version', '1.0.6', 'yes'),
(4212, 'can_compress_scripts', '1', 'no'),
(3953, 'rs_obj_favorites', 'a:12:{i:0;s:128:"http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/plugins/revslider/public/assets/assets/svg/action/ic_lock_24px.svg";i:1;s:135:"http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/plugins/revslider/public/assets/assets/svg/action/ic_description_24px.svg";i:2;s:134:"http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/plugins/revslider/public/assets/assets/svg/action/ic_group_work_24px.svg";i:3;s:16:"object_dvd_1.png";i:4;s:17:"relax_hammock.jpg";i:5;s:16:"beach_houses.jpg";i:6;s:17:"forest_road_2.jpg";i:7;s:18:"object_plant_1.png";i:8;s:16:"object_pen_1.png";i:9;s:13:"fa-icon-glass";i:10;s:13:"fa-icon-music";i:11;s:14:"fa-icon-search";}', 'yes'),
(4118, '_site_transient_timeout_browser_3a179042b5d9d18726343f8efdf53113', '1481905678', 'no'),
(3441, 'widget_goarch_twiter', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(3260, 'revslider-global-settings', 'a:17:{s:4:"role";s:5:"admin";s:17:"includes_globally";s:2:"on";s:18:"pages_for_includes";s:0:"";s:12:"js_to_footer";s:3:"off";s:8:"js_defer";s:3:"off";s:19:"load_all_javascript";s:3:"off";s:15:"show_dev_export";s:2:"on";s:19:"change_font_loading";s:0:"";s:5:"width";s:4:"2048";s:14:"width_notebook";s:4:"1750";s:12:"width_tablet";s:4:"1192";s:12:"width_mobile";s:0:"";s:18:"enable_newschannel";s:2:"on";s:11:"enable_logs";s:3:"off";s:20:"force_activation_box";s:3:"off";s:18:"pack_page_creation";s:2:"on";s:20:"single_page_creation";s:3:"off";}', 'yes'),
(3262, 'revslider_update_version', '5.2.5.5', 'yes'),
(3263, 'widget_rev-slider-widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(3389, 'revslider-dashboard', 'O:8:"stdClass":1:{s:11:"test-handle";O:8:"stdClass":5:{s:12:"version_from";s:5:"5.0.0";s:10:"version_to";s:5:"5.0.0";s:5:"order";i:5;s:7:"content";s:181:"<div class="rs-dash-widget"><div class="rs-dash-title-wrap"><div class="rs-dash-title">your version is: {{current_version}}</div></div><div class="rs-dash-widget-inner"></div></div>";s:4:"code";s:0:"";}}', 'yes'),
(3390, 'revslider-addons', 'O:8:"stdClass":8:{s:26:"revslider-whiteboard-addon";O:8:"stdClass":9:{s:4:"slug";s:26:"revslider-whiteboard-addon";s:12:"version_from";s:5:"5.2.0";s:10:"version_to";s:5:"9.9.9";s:5:"title";s:107:"<img style="margin-top:6px;" src="http://updates.themepunch.tools/addons/images/whiteboard_small_logo.png">";s:6:"line_1";s:31:"Create Hand-Drawn Presentations";s:6:"line_2";s:45:"that are understandable, memorable & engaging";s:9:"available";s:5:"1.0.5";s:10:"background";s:70:"http://updates.themepunch.tools/addons/images/whiteboard_widget_bg.jpg";s:6:"button";s:11:"How to use?";}s:22:"revslider-backup-addon";O:8:"stdClass":9:{s:4:"slug";s:22:"revslider-backup-addon";s:12:"version_from";s:5:"5.2.0";s:10:"version_to";s:5:"9.9.9";s:5:"title";s:6:"Backup";s:6:"line_1";s:12:"Make Backups";s:6:"line_2";s:25:"Revisions for your safety";s:9:"available";s:5:"1.0.1";s:10:"background";s:0:"";s:6:"button";s:11:"How to use?";}s:23:"revslider-gallery-addon";O:8:"stdClass":9:{s:4:"slug";s:23:"revslider-gallery-addon";s:12:"version_from";s:5:"5.2.0";s:10:"version_to";s:5:"9.9.9";s:5:"title";s:17:"WordPress Gallery";s:6:"line_1";s:31:"Replace the standard WP Gallery";s:6:"line_2";s:31:"with the Sliders of your choice";s:9:"available";s:5:"1.0.1";s:10:"background";s:0:"";s:6:"button";s:9:"Configure";}s:25:"revslider-rel-posts-addon";O:8:"stdClass":9:{s:4:"slug";s:25:"revslider-rel-posts-addon";s:12:"version_from";s:7:"5.2.4.1";s:10:"version_to";s:5:"9.9.9";s:5:"title";s:13:"Related Posts";s:6:"line_1";s:25:"Add related Posts Sliders";s:6:"line_2";s:31:"at the end of your post content";s:9:"available";s:5:"1.0.0";s:10:"background";s:0:"";s:6:"button";s:9:"Configure";}s:26:"revslider-typewriter-addon";O:8:"stdClass":9:{s:4:"slug";s:26:"revslider-typewriter-addon";s:12:"version_from";s:5:"5.3.0";s:10:"version_to";s:5:"9.9.9";s:5:"title";s:17:"Typewriter Effect";s:6:"line_1";s:26:"Enhance your slider\'s text";s:6:"line_2";s:23:"with typewriter effects";s:9:"available";s:5:"1.0.1";s:10:"background";s:0:"";s:6:"button";s:9:"Configure";}s:23:"revslider-sharing-addon";O:8:"stdClass":9:{s:4:"slug";s:23:"revslider-sharing-addon";s:12:"version_from";s:5:"5.3.1";s:10:"version_to";s:5:"9.9.9";s:5:"title";s:14:"Social Sharing";s:6:"line_1";s:17:"Share your slides";s:6:"line_2";s:50:"with RevSlider "actions" because sharing is caring";s:9:"available";s:5:"1.1.0";s:10:"background";s:0:"";s:6:"button";s:11:"How to use?";}s:27:"revslider-maintenance-addon";O:8:"stdClass":9:{s:4:"slug";s:27:"revslider-maintenance-addon";s:12:"version_from";s:5:"5.3.1";s:10:"version_to";s:5:"9.9.9";s:5:"title";s:15:"Coming & Maint.";s:6:"line_1";s:37:"Simple Coming Soon & Maintenance Page";s:6:"line_2";s:42:"Let your visitors know what\'s up and when!";s:9:"available";s:5:"1.0.2";s:10:"background";s:0:"";s:6:"button";s:9:"Configure";}s:20:"revslider-snow-addon";O:8:"stdClass":9:{s:4:"slug";s:20:"revslider-snow-addon";s:12:"version_from";s:5:"5.3.0";s:10:"version_to";s:5:"9.9.9";s:5:"title";s:12:"Holiday Snow";s:6:"line_1";s:12:"Let it snow!";s:6:"line_2";s:31:"Add animated snow to any Slider";s:9:"available";s:5:"1.0.1";s:10:"background";s:0:"";s:6:"button";s:11:"How to use?";}}', 'yes');
REPLACE INTO `xwlpv_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(4139, 'rs-templates', 'a:2:{s:6:"slider";a:136:{i:0;a:20:{s:2:"id";s:1:"1";s:5:"title";s:16:"Classic Carousel";s:5:"alias";s:16:"classic-carousel";s:3:"zip";s:20:"classic-carousel.zip";s:3:"uid";s:32:"146a01dd380c0cdee85c4456ee68cd84";s:3:"img";s:27:"classic-carousel/slider.jpg";s:7:"preview";s:56:"http://revolution.themepunch.com/carousel-slider-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:141:"<span class="ttm_content">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:310:"<span class="ttm_content">This is a "Default" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:8:"carousel";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-22 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:1;a:20:{s:2:"id";s:1:"2";s:5:"title";s:14:"Classic Slider";s:5:"alias";s:13:"classicslider";s:3:"zip";s:17:"classicslider.zip";s:3:"uid";s:32:"a0d6a9248c9066b404ba0f1cdadc5cf2";s:3:"img";s:24:"classicslider/slider.jpg";s:7:"preview";s:61:"http://revolution.themepunch.com/wordpress-slideshow-gallery/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:136:" <span class="ttm_content">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:2;a:20:{s:2:"id";s:1:"3";s:5:"title";s:12:"Content Tabs";s:5:"alias";s:11:"contenttabs";s:3:"zip";s:15:"contenttabs.zip";s:3:"uid";s:32:"e02e91604b690123a3d07a65582c4fd0";s:3:"img";s:22:"contenttabs/slider.jpg";s:7:"preview";s:63:"http://revolution.themepunch.com/wordpress-content-tabs-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"600";s:11:"description";s:170:" <span class="ttm_content">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:3;a:20:{s:2:"id";s:1:"4";s:5:"title";s:13:"Facebook Feed";s:5:"alias";s:13:"facebook-feed";s:3:"zip";s:17:"facebook-feed.zip";s:3:"uid";s:32:"5506431d5b1babcb25dcf52c508d42e3";s:3:"img";s:24:"facebook-feed/slider.jpg";s:7:"preview";s:57:"http://revolution.themepunch.com/wordpress-facebook-feed/";s:7:"version";s:5:"1.0.1";s:8:"required";s:5:"5.0.5";s:5:"width";s:3:"800";s:6:"height";s:3:"600";s:11:"description";s:174:"<span class="ttm_content"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:439:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"Facebook Stream"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:11:"socialmedia";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:4;a:20:{s:2:"id";s:1:"5";s:5:"title";s:7:"Fashion";s:5:"alias";s:7:"fashion";s:3:"zip";s:11:"fashion.zip";s:3:"uid";s:32:"4f4b914d6db35e19101ff003c4e7ea3a";s:3:"img";s:18:"fashion/slider.jpg";s:7:"preview";s:65:"http://revolution.themepunch.com/wordpress-one-page-slider-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:183:"  <span class="ttm_content">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:449:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:5;a:20:{s:2:"id";s:1:"6";s:5:"title";s:14:"Flickr Gallery";s:5:"alias";s:14:"flickr-gallery";s:3:"zip";s:18:"flickr-gallery.zip";s:3:"uid";s:32:"ad85cfac7acfa678e6a1b8febfee51ed";s:3:"img";s:25:"flickr-gallery/slider.jpg";s:7:"preview";s:57:"http://revolution.themepunch.com/wordpress-flickr-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:3:"800";s:6:"height";s:3:"640";s:11:"description";s:173:" <span class="ttm_content"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:437:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"Flickr Stream"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:11:"socialmedia";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:6;a:20:{s:2:"id";s:1:"7";s:5:"title";s:3:"Gym";s:5:"alias";s:3:"gym";s:3:"zip";s:7:"gym.zip";s:3:"uid";s:32:"e4d81f13f96fb9bc905f4ad89615032b";s:3:"img";s:14:"gym/slider.jpg";s:7:"preview";s:59:"http://revolution.themepunch.com/one-page-wordpress-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:189:"<span class="ttm_content">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:617:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Instructions for <a href="https://www.themepunch.com/faq/modify-burger-menu/" target="_blank">changing the menu</a>.</span><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:7;a:20:{s:2:"id";s:1:"8";s:5:"title";s:18:"Highlight Carousel";s:5:"alias";s:18:"highlight-carousel";s:3:"zip";s:22:"highlight-carousel.zip";s:3:"uid";s:32:"ada52163f723a942f782351fa0396b3d";s:3:"img";s:29:"highlight-carousel/slider.jpg";s:7:"preview";s:56:"http://revolution.themepunch.com/wordpress-swipe-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:3:"800";s:6:"height";s:3:"720";s:11:"description";s:138:"  <span class="ttm_content">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class="ttm_space"></span>\r\n";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:8:"carousel";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:8;a:20:{s:2:"id";s:1:"9";s:5:"title";s:18:"Highlight Showcase";s:5:"alias";s:18:"highlight-showcase";s:3:"zip";s:22:"highlight-showcase.zip";s:3:"uid";s:32:"2bfe0bd410fb48fec9d942eab1e21530";s:3:"img";s:29:"highlight-showcase/slider.jpg";s:7:"preview";s:62:"http://revolution.themepunch.com/wordpress-parallax-slideshow/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1230";s:6:"height";s:3:"720";s:11:"description";s:157:"<span class="ttm_content">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:9;a:20:{s:2:"id";s:2:"10";s:5:"title";s:10:"Image Hero";s:5:"alias";s:10:"image-hero";s:3:"zip";s:13:"imagehero.zip";s:3:"uid";s:32:"7db18781d44f2adc28c962440894aac1";s:3:"img";s:20:"imagehero/slider.jpg";s:7:"preview";s:54:"http://revolution.themepunch.com/wordpress-hero-image/";s:7:"version";s:5:"1.0.2";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:121:"<span class="ttm_content">A commonly used full-width image hero block with texts.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:10;a:20:{s:2:"id";s:2:"11";s:5:"title";s:17:"Instagram Gallery";s:5:"alias";s:13:"insta-gallery";s:3:"zip";s:17:"insta-gallery.zip";s:3:"uid";s:32:"711732b0d42ec2b57818a2b9b1d86cba";s:3:"img";s:24:"insta-gallery/slider.jpg";s:7:"preview";s:61:"http://revolution.themepunch.com/wordpress-instagram-gallery/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:3:"640";s:6:"height";s:3:"640";s:11:"description";s:174:"<span class="ttm_content">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:440:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"Instagram Stream"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:11:"socialmedia";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:11;a:20:{s:2:"id";s:2:"12";s:5:"title";s:21:"Levano Restaurant Bar";s:5:"alias";s:19:"levanorestaurantbar";s:3:"zip";s:23:"levanorestaurantbar.zip";s:3:"uid";s:32:"4178f837db67d1b2eb6cb5840bbd0b42";s:3:"img";s:30:"levanorestaurantbar/slider.jpg";s:7:"preview";s:63:"http://revolution.themepunch.com/wordpress-front-page-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:181:"<span class="ttm_content">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:617:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Instructions for <a href="https://www.themepunch.com/faq/modify-burger-menu/" target="_blank">changing the menu</a>.</span><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:12;a:20:{s:2:"id";s:2:"13";s:5:"title";s:19:"Main Feature Slider";s:5:"alias";s:11:"mainfeature";s:3:"zip";s:15:"mainfeature.zip";s:3:"uid";s:32:"1e002a3230ab00095bedc6f60393ee7f";s:3:"img";s:22:"mainfeature/slider.jpg";s:7:"preview";s:33:"http://revolution.themepunch.com/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1230";s:6:"height";s:3:"750";s:11:"description";s:127:" <span class="ttm_content">A slightly stripped down version of the main preview slider.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:13;a:20:{s:2:"id";s:2:"14";s:5:"title";s:17:"Media Gallery Two";s:5:"alias";s:17:"media-gallery-two";s:3:"zip";s:21:"media-gallery-two.zip";s:3:"uid";s:32:"d002f1b1b55805f9322c264c5504ba5a";s:3:"img";s:28:"media-gallery-two/slider.jpg";s:7:"preview";s:64:"http://revolution.themepunch.com/wordpress-media-gallery-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1230";s:6:"height";s:3:"692";s:11:"description";s:127:"<span class="ttm_content">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:14;a:20:{s:2:"id";s:2:"15";s:5:"title";s:23:"Media Carousel Autoplay";s:5:"alias";s:23:"media-carousel-autoplay";s:3:"zip";s:27:"media-carousel-autoplay.zip";s:3:"uid";s:32:"393d7875b1cc9d933378b35e4f645d76";s:3:"img";s:34:"media-carousel-autoplay/slider.jpg";s:7:"preview";s:57:"http://revolution.themepunch.com/wordpress-media-gallery/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:3:"720";s:6:"height";s:3:"405";s:11:"description";s:153:"<span class="ttm_content">A media carousel with "autoplay" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:315:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:8:"carousel";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:15;a:20:{s:2:"id";s:2:"16";s:5:"title";s:21:"News Background Video";s:5:"alias";s:21:"news-background-video";s:3:"zip";s:17:"news-bg-video.zip";s:3:"uid";s:32:"a0efe44ac3af0f958b3f84c816a08272";s:3:"img";s:24:"news-bg-video/slider.jpg";s:7:"preview";s:58:"http://revolution.themepunch.com/wordpress-content-blocks/";s:7:"version";s:5:"1.0.2";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"500";s:11:"description";s:143:"<span class="ttm_content">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:16;a:20:{s:2:"id";s:2:"17";s:5:"title";s:12:"News Gallery";s:5:"alias";s:12:"news-gallery";s:3:"zip";s:16:"news-gallery.zip";s:3:"uid";s:32:"3a069c3b286dbb9ee435563f747e3300";s:3:"img";s:23:"news-gallery/slider.jpg";s:7:"preview";s:56:"http://revolution.themepunch.com/wordpress-news-rotator/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"500";s:11:"description";s:131:"<span class="ttm_content">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:17;a:20:{s:2:"id";s:2:"18";s:5:"title";s:23:"News Gallery Post Based";s:5:"alias";s:23:"news-gallery-post-based";s:3:"zip";s:27:"news-gallery-post-based.zip";s:3:"uid";s:32:"32fe05b1039c29ab9420bfd15aec5488";s:3:"img";s:34:"news-gallery-post-based/slider.jpg";s:7:"preview";s:55:"http://revolution.themepunch.com/wordpress-post-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"500";s:11:"description";s:125:"<span class="ttm_content"> This slider is automatically populated by WordPress posts.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:447:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"Post-Based Slider"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:9:"postbased";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:18;a:20:{s:2:"id";s:2:"19";s:5:"title";s:9:"News Hero";s:5:"alias";s:9:"news-hero";s:3:"zip";s:13:"news-hero.zip";s:3:"uid";s:32:"96a0385538a17c8c81ed8175740f70ea";s:3:"img";s:20:"news-hero/slider.jpg";s:7:"preview";s:58:"http://revolution.themepunch.com/wordpress-content-blocks/";s:7:"version";s:5:"1.0.1";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"500";s:11:"description";s:107:"<span class="ttm_content">A image hero block with ken burns effect.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:19;a:20:{s:2:"id";s:2:"20";s:5:"title";s:10:"News Video";s:5:"alias";s:10:"news-video";s:3:"zip";s:14:"news-video.zip";s:3:"uid";s:32:"f901e9e16e0363248156c2209eb584e9";s:3:"img";s:21:"news-video/slider.jpg";s:7:"preview";s:58:"http://revolution.themepunch.com/wordpress-content-blocks/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"500";s:11:"description";s:128:"<span class="ttm_content">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:315:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:20;a:20:{s:2:"id";s:2:"21";s:5:"title";s:15:"Newsletter Hero";s:5:"alias";s:15:"newsletter-hero";s:3:"zip";s:19:"newsletter-hero.zip";s:3:"uid";s:32:"6290a9864d8c4c6311784586ed1cc5fe";s:3:"img";s:26:"newsletter-hero/slider.jpg";s:7:"preview";s:61:"http://revolution.themepunch.com/wordpress-newsletter-signup/";s:7:"version";s:5:"1.0.1";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:137:"<span class="ttm_content">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:461:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image, texts, and <a href="https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/" target="_blank">Mailchimp code</a>.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:21;a:20:{s:2:"id";s:2:"22";s:5:"title";s:11:"Not Generic";s:5:"alias";s:10:"notgeneric";s:3:"zip";s:14:"notgeneric.zip";s:3:"uid";s:32:"9d87ba95e02210a9f82387add2ceadf9";s:3:"img";s:21:"notgeneric/slider.jpg";s:7:"preview";s:61:"http://revolution.themepunch.com/wordpress-fullscreen-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:144:"<span class="ttm_content">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:617:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Instructions for <a href="https://www.themepunch.com/faq/modify-burger-menu/" target="_blank">changing the menu</a>.</span><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:22;a:20:{s:2:"id";s:2:"23";s:5:"title";s:11:"Photography";s:5:"alias";s:11:"photography";s:3:"zip";s:15:"photography.zip";s:3:"uid";s:32:"1b2072547afb75e49f33b016751ed360";s:3:"img";s:22:"photography/slider.jpg";s:7:"preview";s:62:"http://revolution.themepunch.com/wordpress-photography-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:194:"<span class="ttm_content">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:617:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Instructions for <a href="https://www.themepunch.com/faq/modify-burger-menu/" target="_blank">changing the menu</a>.</span><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:23;a:20:{s:2:"id";s:2:"24";s:5:"title";s:20:"Photography Carousel";s:5:"alias";s:20:"photography-carousel";s:3:"zip";s:24:"photography-carousel.zip";s:3:"uid";s:32:"9a84b859ba23dc49ba8784e3a86545fa";s:3:"img";s:31:"photography-carousel/slider.jpg";s:7:"preview";s:57:"http://revolution.themepunch.com/wordpress-photo-gallery/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"868";s:11:"description";s:196:"<span class="ttm_content">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:617:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Instructions for <a href="https://www.themepunch.com/faq/modify-burger-menu/" target="_blank">changing the menu</a>.</span><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:8:"carousel";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:24;a:20:{s:2:"id";s:2:"25";s:5:"title";s:16:"Search Form Hero";s:5:"alias";s:16:"search-form-hero";s:3:"zip";s:20:"search-form-hero.zip";s:3:"uid";s:32:"e09eb1bd0f22b3a2b02a1aa251dd1f3e";s:3:"img";s:27:"search-form-hero/slider.jpg";s:7:"preview";s:60:"http://revolution.themepunch.com/wordpress-search-form-hero/";s:7:"version";s:5:"1.0.1";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:158:"<span class="ttm_content">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:346:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:25;a:20:{s:2:"id";s:2:"26";s:5:"title";s:17:"Showcase Carousel";s:5:"alias";s:16:"showcasecarousel";s:3:"zip";s:20:"showcasecarousel.zip";s:3:"uid";s:32:"c5ca218398331bd2c064efc2f62eae56";s:3:"img";s:27:"showcasecarousel/slider.jpg";s:7:"preview";s:62:"http://revolution.themepunch.com/wordpress-cover-flow-gallery/";s:7:"version";s:5:"1.0.1";s:8:"required";s:5:"5.0.5";s:5:"width";s:3:"600";s:6:"height";s:3:"600";s:11:"description";s:129:"<span class="ttm_content">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class="ttm_space"></span>\r\n";s:11:"setup_notes";s:310:"<span class="ttm_content">This is a "Default" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:8:"carousel";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:26;a:20:{s:2:"id";s:2:"27";s:5:"title";s:11:"Sports Hero";s:5:"alias";s:11:"sports-hero";s:3:"zip";s:14:"sportshero.zip";s:3:"uid";s:32:"8de7a145f32a362d618d2595ffa2f724";s:3:"img";s:21:"sportshero/slider.jpg";s:7:"preview";s:54:"http://revolution.themepunch.com/wordpress-image-hero/";s:7:"version";s:5:"1.0.2";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"720";s:11:"description";s:113:"<span class="ttm_content">An sports themed image hero block with buttons.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:27;a:20:{s:2:"id";s:2:"28";s:5:"title";s:12:"Twitter Feed";s:5:"alias";s:12:"twitter-feed";s:3:"zip";s:16:"twitter-feed.zip";s:3:"uid";s:32:"efbfc2af5da5258e7b7bed8598e483cc";s:3:"img";s:23:"twitter-feed/slider.jpg";s:7:"preview";s:56:"http://revolution.themepunch.com/wordpress-twitter-feed/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:3:"800";s:6:"height";s:3:"640";s:11:"description";s:173:"<span class="ttm_content"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:438:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"Twitter Stream"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:11:"socialmedia";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:28;a:20:{s:2:"id";s:2:"29";s:5:"title";s:13:"Vimeo Gallery";s:5:"alias";s:13:"vimeo-gallery";s:3:"zip";s:17:"vimeo-gallery.zip";s:3:"uid";s:32:"fa824ce1ff3942ec268fc9eda60df539";s:3:"img";s:24:"vimeo-gallery/slider.jpg";s:7:"preview";s:57:"http://revolution.themepunch.com/wordpress-vimeo-gallery/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1230";s:6:"height";s:3:"692";s:11:"description";s:170:"<span class="ttm_content">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:436:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"Vimeo Stream"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:11:"socialmedia";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:29;a:20:{s:2:"id";s:2:"30";s:5:"title";s:10:"Vimeo Hero";s:5:"alias";s:9:"vimeohero";s:3:"zip";s:13:"vimeohero.zip";s:3:"uid";s:32:"c575575f96173d88589cddcb06120b77";s:3:"img";s:20:"vimeohero/slider.jpg";s:7:"preview";s:54:"http://revolution.themepunch.com/wordpress-hero-vimeo/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:116:"<span class="ttm_content">A commonly used Vimeo video background hero block.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:461:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href="https://www.youtube.com/watch?v=I4qGepR4aWw" target="_blank">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:30;a:20:{s:2:"id";s:2:"31";s:5:"title";s:16:"Web Product Dark";s:5:"alias";s:16:"web-product-dark";s:3:"zip";s:20:"web-product-dark.zip";s:3:"uid";s:32:"39b872cf0608e63c3a503e58374dc30a";s:3:"img";s:27:"web-product-dark/slider.jpg";s:7:"preview";s:60:"http://revolution.themepunch.com/wordpress-frontpage-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1400";s:6:"height";s:3:"868";s:11:"description";s:194:"<span class="ttm_content">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:617:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Instructions for <a href="https://www.themepunch.com/faq/modify-burger-menu/" target="_blank">changing the menu</a>.</span><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:31;a:20:{s:2:"id";s:2:"32";s:5:"title";s:21:"Web Product Dark Hero";s:5:"alias";s:21:"web-product-dark-hero";s:3:"zip";s:25:"web-product-dark-hero.zip";s:3:"uid";s:32:"b6784e8925221f36677217979d26e6f0";s:3:"img";s:32:"web-product-dark-hero/slider.jpg";s:7:"preview";s:56:"http://revolution.themepunch.com/wordpress-header-image/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1400";s:6:"height";s:3:"768";s:11:"description";s:162:"<span class="ttm_content">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:32;a:20:{s:2:"id";s:2:"33";s:5:"title";s:22:"Web Product Light Hero";s:5:"alias";s:22:"web-product-light-hero";s:3:"zip";s:26:"web-product-light-hero.zip";s:3:"uid";s:32:"428e65d6aaa6ef775429989d50516492";s:3:"img";s:33:"web-product-light-hero/slider.jpg";s:7:"preview";s:54:"http://revolution.themepunch.com/hero-image-wordpress/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1400";s:6:"height";s:3:"768";s:11:"description";s:162:"<span class="ttm_content">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:315:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:33;a:20:{s:2:"id";s:2:"34";s:5:"title";s:17:"Web Product Light";s:5:"alias";s:15:"webproductlight";s:3:"zip";s:19:"webproductlight.zip";s:3:"uid";s:32:"fa23dab5bf1139c6393828647a9de4e0";s:3:"img";s:26:"webproductlight/slider.jpg";s:7:"preview";s:54:"http://revolution.themepunch.com/wordpress-cover-page/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1400";s:6:"height";s:3:"868";s:11:"description";s:194:"<span class="ttm_content">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:617:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Instructions for <a href="https://www.themepunch.com/faq/modify-burger-menu/" target="_blank">changing the menu</a>.</span><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:34;a:20:{s:2:"id";s:2:"35";s:5:"title";s:15:"Youtube Gallery";s:5:"alias";s:15:"youtube-gallery";s:3:"zip";s:19:"youtube-gallery.zip";s:3:"uid";s:32:"ee9e4928ac74f5f0c0b697ce708f5aa7";s:3:"img";s:26:"youtube-gallery/slider.jpg";s:7:"preview";s:59:"http://revolution.themepunch.com/wordpress-youtube-gallery/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:173:"<span class="ttm_content"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:438:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"YouTube Stream"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:11:"socialmedia";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:35;a:20:{s:2:"id";s:2:"36";s:5:"title";s:12:"Youtube Hero";s:5:"alias";s:11:"youtubehero";s:3:"zip";s:15:"youtubehero.zip";s:3:"uid";s:32:"e0b2c12a45841bdf21cb96305f2c85bf";s:3:"img";s:22:"youtubehero/slider.jpg";s:7:"preview";s:58:"http://revolution.themepunch.com/wordpress-youtube-header/";s:7:"version";s:5:"1.0.2";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:104:"<span class="ttm_content">A YouTube video background hero block.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:630:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href="https://www.youtube.com/watch?v=I4qGepR4aWw" target="_blank">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href="https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/" target="_blank">enable sound for the background video</a><br /><br />\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:15:"Revolution Base";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:36;a:20:{s:2:"id";s:2:"37";s:5:"title";s:13:"Scroll Effect";s:5:"alias";s:13:"scroll-effect";s:3:"zip";s:17:"scroll-effect.zip";s:3:"uid";s:32:"417f59e9db87aa7e47c8509eb88d4af6";s:3:"img";s:23:"scrolleffect/slide1.jpg";s:7:"preview";s:60:"http://revolution.themepunch.com/big-bold-fullscreen-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:134:"<span class="ttm_content">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:508:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">"Custom CSS/JS"</a> section in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:37;a:20:{s:2:"id";s:2:"38";s:5:"title";s:12:"Content Zoom";s:5:"alias";s:12:"content-zoom";s:3:"zip";s:16:"content-zoom.zip";s:3:"uid";s:32:"42ef8cdb70d42ec6ff6fa3b69a027b5f";s:3:"img";s:22:"contentzoom/slide1.jpg";s:7:"preview";s:53:"http://revolution.themepunch.com/content-zoom-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:243:"<span class="ttm_content">A very unique full-width slider that uses <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> to their potential.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:397:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:38;a:20:{s:2:"id";s:2:"39";s:5:"title";s:13:"Food Carousel";s:5:"alias";s:13:"food-carousel";s:3:"zip";s:17:"food-carousel.zip";s:3:"uid";s:32:"a7bf54527b6658a0a308c70c729779fe";s:3:"img";s:29:"foodcarousel/slider_cover.jpg";s:7:"preview";s:54:"http://revolution.themepunch.com/food-carousel-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:267:"<span class="ttm_content">A fancy carousel with detail content on each slide. <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> are used to show and hide layers.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:397:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:8:"carousel";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:39;a:20:{s:2:"id";s:2:"40";s:5:"title";s:14:"Rotating Words";s:5:"alias";s:14:"rotating-words";s:3:"zip";s:18:"rotating-words.zip";s:3:"uid";s:32:"70190463d9376f278c8197b7b2ef6c1b";s:3:"img";s:24:"rotatingwords/slide1.jpg";s:7:"preview";s:53:"http://revolution.themepunch.com/rotating-words-hero/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:134:"<span class="ttm_content">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:518:"<span class="ttm_content">This is a "Default" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">"Custom CSS/JS"</a> section in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:40;a:20:{s:2:"id";s:2:"41";s:5:"title";s:22:"Travel Static Captions";s:5:"alias";s:22:"travel-static-captions";s:3:"zip";s:26:"travel-static-captions.zip";s:3:"uid";s:32:"bbe7d61c7c741ebc7aa1ce1082b0cb71";s:3:"img";s:33:"travel-static-captions/slide1.jpg";s:7:"preview";s:50:"http://revolution.themepunch.com/travel-slideshow/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:148:"<span class="ttm_content">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:449:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:41;a:20:{s:2:"id";s:2:"42";s:5:"title";s:7:"Concept";s:5:"alias";s:7:"concept";s:3:"zip";s:11:"concept.zip";s:3:"uid";s:32:"47cb06083e87503762f6746725117a3c";s:3:"img";s:18:"concept/slide1.jpg";s:7:"preview";s:61:"http://revolution.themepunch.com/fullscreen-wordpress-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:232:"<span class="ttm_content">A full-screen slider that uses <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> to their potential.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:397:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:42;a:20:{s:2:"id";s:2:"43";s:5:"title";s:15:"True Fullscreen";s:5:"alias";s:17:"fullscreen-button";s:3:"zip";s:21:"fullscreen-button.zip";s:3:"uid";s:32:"618a43bdf89333b555531f6d6ecde359";s:3:"img";s:28:"fullscreen-button/slide1.jpg";s:7:"preview";s:61:"http://revolution.themepunch.com/wordpress-sidebar-slideshow/";s:7:"version";s:5:"1.0.0";s:8:"required";s:3:"5.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"800";s:11:"description";s:246:"<span class="ttm_content">A slider with a full-screen button that uses <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> to their potential.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:323:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:43;a:20:{s:2:"id";s:2:"44";s:5:"title";s:16:"Creative Freedom";s:5:"alias";s:15:"creativefreedom";s:3:"zip";s:19:"creativefreedom.zip";s:3:"uid";s:32:"8902bf6c93126c2c6323626b9e872621";s:3:"img";s:26:"creativefreedom/slide1.jpg";s:7:"preview";s:56:"http://revolution.themepunch.com/wordpress-touch-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:3:"5.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:145:"<span class="ttm_content">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:316:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:44;a:20:{s:2:"id";s:2:"45";s:5:"title";s:17:"3D Parallax Scene";s:5:"alias";s:13:"parallaxscene";s:3:"zip";s:17:"parallaxscene.zip";s:3:"uid";s:32:"51566f1ce649708e97a0f5dfaf05ea19";s:3:"img";s:24:"parallaxscene/slide1.jpg";s:7:"preview";s:55:"http://revolution.themepunch.com/wordpress-3d-parallax/";s:7:"version";s:5:"1.0.2";s:8:"required";s:3:"5.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"700";s:11:"description";s:328:"<span class="ttm_content">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a>.</span>\r\n</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:45;a:20:{s:2:"id";s:2:"46";s:5:"title";s:10:"Wow Factor";s:5:"alias";s:15:"slidingoverlays";s:3:"zip";s:19:"slidingoverlays.zip";s:3:"uid";s:32:"18002d17e8bc7ca61b0951f5305a759e";s:3:"img";s:26:"slidingoverlays/slide1.jpg";s:7:"preview";s:61:"http://revolution.themepunch.com/responsive-wordpress-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:3:"5.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"768";s:11:"description";s:106:"<span class="ttm_content">A 3D-parallax effect full-screen slider.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:443:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href="https://www.youtube.com/watch?v=I4qGepR4aWw" target="_blank">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:46;a:20:{s:2:"id";s:2:"47";s:5:"title";s:14:"3D Web Product";s:5:"alias";s:25:"web-product-light-hero-3d";s:3:"zip";s:29:"web-product-light-hero-3d.zip";s:3:"uid";s:32:"efd345c5da805414093e46066cefd751";s:3:"img";s:36:"web-product-light-hero-3d/slide1.jpg";s:7:"preview";s:52:"http://revolution.themepunch.com/wordpress-3d-scene/";s:7:"version";s:5:"1.0.0";s:8:"required";s:3:"5.1";s:5:"width";s:4:"1400";s:6:"height";s:3:"668";s:11:"description";s:149:"<span class="ttm_content">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:47;a:20:{s:2:"id";s:2:"48";s:5:"title";s:15:"WooCommerce Big";s:5:"alias";s:6:"woobig";s:3:"zip";s:10:"woobig.zip";s:3:"uid";s:32:"bfb09a39656c7c80e86b468fc5b3403c";s:3:"img";s:17:"woobig/slide1.jpg";s:7:"preview";s:52:"http://revolution.themepunch.com/woocommerce-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1200";s:6:"height";s:3:"600";s:11:"description";s:173:"<span class="ttm_content">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:444:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"WooCommerce Slider"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:9:"postbased";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:48;a:20:{s:2:"id";s:2:"49";s:5:"title";s:17:"WooCommerce Small";s:5:"alias";s:16:"woocommercesmall";s:3:"zip";s:20:"woocommercesmall.zip";s:3:"uid";s:32:"b17c2adcc5c4c4b68a7ac6fee32fa030";s:3:"img";s:27:"woocommercesmall/slide1.jpg";s:7:"preview";s:52:"http://revolution.themepunch.com/woocommerce-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:3:"5.1";s:5:"width";s:3:"400";s:6:"height";s:3:"266";s:11:"description";s:174:" <span class="ttm_content">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:444:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"WooCommerce Slider"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:9:"postbased";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:49;a:20:{s:2:"id";s:2:"50";s:5:"title";s:17:"Restaurant Header";s:5:"alias";s:10:"finedining";s:3:"zip";s:14:"finedining.zip";s:3:"uid";s:32:"03481a9e258501fbe3888b48830ea845";s:3:"img";s:21:"finedining/slide1.jpg";s:7:"preview";s:56:"http://revolution.themepunch.com/restaurant-hero-header/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:275:"<span class="ttm_content">A full-screen hero block slider that shows different background layers on button hover using <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a>.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:461:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href="https://www.youtube.com/watch?v=I4qGepR4aWw" target="_blank">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:50;a:20:{s:2:"id";s:2:"51";s:5:"title";s:21:"Agency Website Header";s:5:"alias";s:12:"agency-intro";s:3:"zip";s:16:"agency-intro.zip";s:3:"uid";s:32:"e9be2afdd55a0c8d0d8d0cc12ba4c82f";s:3:"img";s:23:"agency-intro/slide1.jpg";s:7:"preview";s:60:"http://revolution.themepunch.com/agency-website-hero-header/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:302:" <span class="ttm_content">A full-screen hero block slider with ken burns effect and video modal on button click. <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> are used to achieve this effect.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:397:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:51;a:20:{s:2:"id";s:2:"52";s:5:"title";s:11:"Team Slider";s:5:"alias";s:7:"ourteam";s:3:"zip";s:11:"ourteam.zip";s:3:"uid";s:32:"d8eb1fec07a79202d1118bb17f70c233";s:3:"img";s:18:"ourteam/slide1.jpg";s:7:"preview";s:74:"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.1.4";s:5:"width";s:4:"1400";s:6:"height";s:3:"800";s:11:"description";s:303:"<span class="ttm_content">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> to achieve this effect.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:691:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\nLearn how to <a href="https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/" target="_blank">modify the thumbnails</a><br/><br/>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:52;a:20:{s:2:"id";s:2:"53";s:5:"title";s:13:"Team Carousel";s:5:"alias";s:17:"our-team-carousel";s:3:"zip";s:21:"our-team-carousel.zip";s:3:"uid";s:32:"37656d5dcab1f265c025cb2a3d669809";s:3:"img";s:26:"ourteamcarousel/slide1.jpg";s:7:"preview";s:83:"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.1.4";s:5:"width";s:4:"1000";s:6:"height";s:3:"800";s:11:"description";s:306:" <span class="ttm_content">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> to achieve this effect.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:693:"<span class="ttm_content">This is a "Default" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\nLearn how to <a href="https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/" target="_blank">modify the thumbnails</a><br/><br/>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:8:"carousel";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:53;a:20:{s:2:"id";s:2:"54";s:5:"title";s:17:"4K Youtube Slider";s:5:"alias";s:13:"betteryoutube";s:3:"zip";s:17:"betteryoutube.zip";s:3:"uid";s:32:"d7c5fef9f257037d7a148038aa2a1857";s:3:"img";s:24:"betteryoutube/slide1.jpg";s:7:"preview";s:94:"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.1.4";s:5:"width";s:4:"1200";s:6:"height";s:3:"675";s:11:"description";s:293:" <span class="ttm_content">A full-screen youtube gallery with 4K videos as an example. <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> are used to breathe life into navigation elements.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:532:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href="https://www.youtube.com/watch?v=I4qGepR4aWw" target="_blank">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:54;a:20:{s:2:"id";s:2:"55";s:5:"title";s:21:"Agency Website Header";s:5:"alias";s:19:"agencywebsiteheader";s:3:"zip";s:23:"agencywebsiteheader.zip";s:3:"uid";s:32:"c11d272c87277a7a38d9e7fd13e27947";s:3:"img";s:30:"agencywebsiteheader/slide1.jpg";s:7:"preview";s:56:"http://revolution.themepunch.com/fullscreen-hero-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.1.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:245:" <span class="ttm_content">A very unique full-screen slider that uses <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> to their potential.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:543:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:55;a:20:{s:2:"id";s:2:"56";s:5:"title";s:11:"Coming Soon";s:5:"alias";s:10:"comingsoon";s:3:"zip";s:14:"comingsoon.zip";s:3:"uid";s:32:"0f89edf995512e6d6e864a2ee7221829";s:3:"img";s:21:"comingsoon/slide1.jpg";s:7:"preview";s:79:"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.1.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:299:"<span class="ttm_content">A full-screen slider that can be used as a "Coming Soon" page. <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a> are used to achieve various interaction possibilities.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:661:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">"Custom CSS/JS"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href="https://www.themepunch.com/faq/change-date-for-coming-soon-template/" target="_blank">how to change the date.</a><br /><br />\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:56;a:20:{s:2:"id";s:2:"57";s:5:"title";s:20:"Christmas Snow Scene";s:5:"alias";s:9:"snowscene";s:3:"zip";s:13:"snowscene.zip";s:3:"uid";s:32:"a747bf0837caff86c62419a746690209";s:3:"img";s:20:"snowscene/slide1.jpg";s:7:"preview";s:54:"http://revolution.themepunch.com/christmas-snow-scene/";s:7:"version";s:5:"1.0.5";s:8:"required";s:5:"5.0.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:141:"<span class="ttm_content">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:508:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">"Custom CSS/JS"</a> section in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:57;a:20:{s:2:"id";s:2:"58";s:5:"title";s:15:"Rock Band Music";s:5:"alias";s:8:"rockband";s:3:"zip";s:12:"rockband.zip";s:3:"uid";s:32:"5f557a5fad2fd6ca982a6ae6e9619637";s:3:"img";s:19:"rockband/slide1.jpg";s:7:"preview";s:80:"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.1.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:140:" <span class="ttm_content">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:461:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href="https://www.youtube.com/watch?v=I4qGepR4aWw" target="_blank">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-24 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:58;a:20:{s:2:"id";s:2:"59";s:5:"title";s:18:"Sleek Landing Page";s:5:"alias";s:16:"sleeklandingpage";s:3:"zip";s:20:"sleeklandingpage.zip";s:3:"uid";s:32:"07f7f2608936a8ae226213b7d99eee3f";s:3:"img";s:27:"sleeklandingpage/slide1.jpg";s:7:"preview";s:70:"http://revolution.themepunch.com/landing-page-free-wordpress-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.1.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:191:"<span class="ttm_content">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:449:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-02-22 13:21:33";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:59;a:20:{s:2:"id";s:2:"60";s:5:"title";s:16:"App Landing Page";s:5:"alias";s:14:"applandingpage";s:3:"zip";s:18:"applandingpage.zip";s:3:"uid";s:32:"38eb600893c1484ab8fd2a3dce3678d7";s:3:"img";s:25:"applandingpage/slide1.jpg";s:7:"preview";s:64:"http://revolution.themepunch.com/app-landing-page-free-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:263:"<span class="ttm_content">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a>.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:397:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the "hide/show layer" feature to efficiently edit all content.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:60;a:20:{s:2:"id";s:2:"61";s:5:"title";s:10:"Desk Scene";s:5:"alias";s:9:"deskscene";s:3:"zip";s:13:"deskscene.zip";s:3:"uid";s:32:"172a1a89a3e3b333cb4dbeb238f534c5";s:3:"img";s:20:"deskscene/slide1.jpg";s:7:"preview";s:49:"http://revolution.themepunch.com/hero-desk-scene/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:135:"<span class="ttm_content">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:61;a:20:{s:2:"id";s:2:"62";s:5:"title";s:17:"Clean News Slider";s:5:"alias";s:15:"cleannewsslider";s:3:"zip";s:19:"cleannewsslider.zip";s:3:"uid";s:32:"82c3f521fe31b80984be0f19e1a9899e";s:3:"img";s:26:"cleannewsslider/slide1.jpg";s:7:"preview";s:55:"http://revolution.themepunch.com/wordpress-news-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:132:"<span class="ttm_content">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class="ttm_space"></span>\r\n";s:11:"setup_notes";s:308:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:62;a:20:{s:2:"id";s:2:"63";s:5:"title";s:13:"Image Gallery";s:5:"alias";s:12:"imagegallery";s:3:"zip";s:16:"imagegallery.zip";s:3:"uid";s:32:"cef1d75357df2cb53b990c74a214813e";s:3:"img";s:23:"imagegallery/slide1.jpg";s:7:"preview";s:64:"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.0";s:5:"width";s:4:"1000";s:6:"height";s:3:"667";s:11:"description";s:239:"<span class="ttm_content">A photo gallery suitable to display your images using <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a> to their potential.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:449:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:63;a:20:{s:2:"id";s:2:"64";s:5:"title";s:19:"Standard WP Gallery";s:5:"alias";s:19:"standard-wp-gallery";s:3:"zip";s:23:"standard-wp-gallery.zip";s:3:"uid";s:32:"632035b8a27652d8081dbdfa343dc93d";s:3:"img";s:30:"standard-wp-gallery/slide1.jpg";s:7:"preview";s:64:"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.0";s:5:"width";s:4:"1000";s:6:"height";s:3:"667";s:11:"description";s:143:"<span class="ttm_content">A photo gallery that uses the "Standard WP Gallery" add-on to display images.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:441:"<span class="ttm_content">Please follow the setup guide on the "Standard WP Gallery" add-on page.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:9:"postbased";}s:14:"plugin_require";s:166:"[{"path":"revslider-gallery-addon\\/revslider-gallery-addon.php","name":"WP Gallery AddOn","url":"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin"}]";s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:64;a:20:{s:2:"id";s:2:"65";s:5:"title";s:21:"Clean News Post Based";s:5:"alias";s:21:"clean-news-post-based";s:3:"zip";s:25:"clean-news-post-based.zip";s:3:"uid";s:32:"f4cf5bbe51afa5a361754bb081cbabf2";s:3:"img";s:32:"clean-news-post-based/slide1.jpg";s:7:"preview";s:55:"http://revolution.themepunch.com/wordpress-news-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.0";s:5:"width";s:4:"1200";s:6:"height";s:3:"600";s:11:"description";s:125:"<span class="ttm_content"> This slider is automatically populated by WordPress posts.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:447:"<span class="ttm_content">The content source is set to <a href="https://www.themepunch.com/revslider-doc/special-content-sources/" target="_blank">"Post-Based Slider"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:2:{i:0;s:6:"slider";i:1;s:9:"postbased";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:65;a:20:{s:2:"id";s:2:"66";s:5:"title";s:22:"Interactive Whiteboard";s:5:"alias";s:21:"interactivewhiteboard";s:3:"zip";s:25:"interactivewhiteboard.zip";s:3:"uid";s:32:"058b4af535d6c6c7bcec5225845e3eb4";s:3:"img";s:32:"interactivewhiteboard/slide1.jpg";s:7:"preview";s:77:"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/";s:7:"version";s:5:"1.0.5";s:8:"required";s:5:"5.2.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:269:"<span class="ttm_content">This is the example slider from the Whiteboard add-on preview.<br/><a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a> are used to achieve certain effects.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:572:"<span class="ttm_content">This slider template requires the <a href="https://www.themepunch.com/revslider-doc/add-on-whiteboard/" target="_blank">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";s:185:"[{"path":"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php","name":"Whiteboard AddOn","url":"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon"}]";s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:66;a:20:{s:2:"id";s:2:"68";s:5:"title";s:17:"Innovation Slider";s:5:"alias";s:10:"innovation";s:3:"zip";s:14:"innovation.zip";s:3:"uid";s:32:"d3440b69126d9c186fddc713b18b0002";s:3:"img";s:21:"innovation/slide1.jpg";s:7:"preview";s:68:"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/";s:7:"version";s:5:"1.0.5";s:8:"required";s:7:"5.2.3.5";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:258:"<span class="ttm_content">A full-screen slider with an elegant fade-out parallax effect. <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a> are used for links on layers.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:516:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">"Custom CSS/JS"</a> section in the slider settings.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"2016-03-29 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:67;a:23:{s:2:"id";s:2:"69";s:5:"title";s:25:"Dark Content Block - Menu";s:5:"alias";s:24:"dark-fullsite-block-menu";s:3:"zip";s:34:"packs/dark-fullsite-block-menu.zip";s:3:"uid";s:32:"bf4bd226719d3c3d3146592976e31ca1";s:3:"img";s:35:"dark-fullsite-block-menu/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"0";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:68;a:23:{s:2:"id";s:2:"70";s:5:"title";s:25:"Dark Content Block - Hero";s:5:"alias";s:21:"dark-fullsite-block-1";s:3:"zip";s:31:"packs/dark-fullsite-block-1.zip";s:3:"uid";s:32:"d8859245fe600288ca932dc29aca751f";s:3:"img";s:32:"dark-fullsite-block-1/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"1";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:69;a:23:{s:2:"id";s:2:"71";s:5:"title";s:26:"Dark Content Block - About";s:5:"alias";s:27:"dark-fullsite-block-2-about";s:3:"zip";s:37:"packs/dark-fullsite-block-2-about.zip";s:3:"uid";s:32:"298401901521a197a8294c1b4f73df3e";s:3:"img";s:38:"dark-fullsite-block-2-about/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"2";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:70;a:23:{s:2:"id";s:2:"72";s:5:"title";s:29:"Dark Content Block - Services";s:5:"alias";s:30:"dark-fullsite-block-3-services";s:3:"zip";s:40:"packs/dark-fullsite-block-3-services.zip";s:3:"uid";s:32:"8da3ed605472ed6a26c745fb52f85f82";s:3:"img";s:41:"dark-fullsite-block-3-services/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"3";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:71;a:23:{s:2:"id";s:2:"73";s:5:"title";s:29:"Dark Content Block - Products";s:5:"alias";s:30:"dark-fullsite-block-4-products";s:3:"zip";s:40:"packs/dark-fullsite-block-4-products.zip";s:3:"uid";s:32:"99e4f40399d20261a6131043d0e50b0c";s:3:"img";s:41:"dark-fullsite-block-4-products/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:448:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>\r\n";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"4";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:72;a:23:{s:2:"id";s:2:"74";s:5:"title";s:33:"Dark Content Block - Testimonials";s:5:"alias";s:34:"dark-fullsite-block-5-testimonials";s:3:"zip";s:44:"packs/dark-fullsite-block-5-testimonials.zip";s:3:"uid";s:32:"2f9121e0eedd51afe85e233d0743acab";s:3:"img";s:45:"dark-fullsite-block-5-testimonials/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"5";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:73;a:23:{s:2:"id";s:2:"75";s:5:"title";s:28:"Dark Content Block - Callout";s:5:"alias";s:29:"dark-fullsite-block-6-callout";s:3:"zip";s:39:"packs/dark-fullsite-block-6-callout.zip";s:3:"uid";s:32:"55fbecb113ff21f050be7adc08637329";s:3:"img";s:40:"dark-fullsite-block-6-callout/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"6";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:74;a:23:{s:2:"id";s:2:"76";s:5:"title";s:27:"Dark Content Block - Footer";s:5:"alias";s:28:"dark-fullsite-block-7-footer";s:3:"zip";s:38:"packs/dark-fullsite-block-7-footer.zip";s:3:"uid";s:32:"2ff517f5c7c54e3e0c2dd733cfd3400e";s:3:"img";s:39:"dark-fullsite-block-7-footer/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"7";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:75;a:23:{s:2:"id";s:2:"77";s:5:"title";s:26:"Light Content Block - Menu";s:5:"alias";s:19:"fullsite-block-menu";s:3:"zip";s:29:"packs/fullsite-block-menu.zip";s:3:"uid";s:32:"8010971f34387d5f94a1f4e577ef382a";s:3:"img";s:30:"fullsite-block-menu/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"0";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:76;a:23:{s:2:"id";s:2:"78";s:5:"title";s:26:"Light Content Block - Hero";s:5:"alias";s:15:"fullsite-block1";s:3:"zip";s:25:"packs/fullsite-block1.zip";s:3:"uid";s:32:"45bf7179843e01ce112e8ec754b0455c";s:3:"img";s:26:"fullsite-block1/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"1";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:77;a:23:{s:2:"id";s:2:"79";s:5:"title";s:27:"Light Content Block - About";s:5:"alias";s:22:"fullsite-block-2-about";s:3:"zip";s:32:"packs/fullsite-block-2-about.zip";s:3:"uid";s:32:"8402b460638a746d36433cb161440b7d";s:3:"img";s:33:"fullsite-block-2-about/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"2";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:78;a:23:{s:2:"id";s:2:"80";s:5:"title";s:30:"Light Content Block - Services";s:5:"alias";s:25:"fullsite-block-3-services";s:3:"zip";s:35:"packs/fullsite-block-3-services.zip";s:3:"uid";s:32:"7b8cea27f4d6ae17c5e1eae12457bd06";s:3:"img";s:36:"fullsite-block-3-services/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"3";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:79;a:23:{s:2:"id";s:2:"81";s:5:"title";s:30:"Light Content Block - Products";s:5:"alias";s:25:"fullsite-block-4-products";s:3:"zip";s:35:"packs/fullsite-block-4-products.zip";s:3:"uid";s:32:"d148935362d7122636cda0635eae4be7";s:3:"img";s:36:"fullsite-block-4-products/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"4";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:80;a:23:{s:2:"id";s:2:"82";s:5:"title";s:34:"Light Content Block - Testimonials";s:5:"alias";s:29:"fullsite-block-5-testimonials";s:3:"zip";s:39:"packs/fullsite-block-5-testimonials.zip";s:3:"uid";s:32:"06255bfd421e40f71fa8197b839dbf03";s:3:"img";s:40:"fullsite-block-5-testimonials/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"5";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:81;a:23:{s:2:"id";s:2:"83";s:5:"title";s:29:"Light Content Block - Callout";s:5:"alias";s:24:"fullsite-block-6-callout";s:3:"zip";s:34:"packs/fullsite-block-6-callout.zip";s:3:"uid";s:32:"8a88c3447676b613ec5db2fe5d63315c";s:3:"img";s:35:"fullsite-block-6-callout/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"6";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:82;a:23:{s:2:"id";s:2:"84";s:5:"title";s:28:"Light Content Block - Footer";s:5:"alias";s:23:"fullsite-block-7-footer";s:3:"zip";s:33:"packs/fullsite-block-7-footer.zip";s:3:"uid";s:32:"34300b4407a2093eb2e1e08868fa8319";s:3:"img";s:34:"fullsite-block-7-footer/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"7";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:83;a:20:{s:2:"id";s:2:"85";s:5:"title";s:12:"Tech Journal";s:5:"alias";s:11:"techjournal";s:3:"zip";s:15:"techjournal.zip";s:3:"uid";s:32:"7f92d70d1c108378f915b18c2ceb71d6";s:3:"img";s:22:"techjournal/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.1";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:130:"<span class="ttm_content">A full-width slider with navigation direction-based transitions.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:303:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:84;a:20:{s:2:"id";s:2:"86";s:5:"title";s:14:"Car Dealership";s:5:"alias";s:13:"cardealership";s:3:"zip";s:17:"cardealership.zip";s:3:"uid";s:32:"bb010838855a8ae4d1dd68e139bf169e";s:3:"img";s:24:"cardealership/slide1.jpg";s:7:"preview";s:56:"https://revolution.themepunch.com/car-dealership-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"650";s:11:"description";s:130:"<span class="ttm_content">A full-width slider with navigation direction-based transitions.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:303:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:85;a:20:{s:2:"id";s:2:"87";s:5:"title";s:22:"FullScreen Menu Slider";s:5:"alias";s:14:"fullscreenmenu";s:3:"zip";s:18:"fullscreenmenu.zip";s:3:"uid";s:32:"6de81d74c4bf193e2e274d43038adc85";s:3:"img";s:25:"fullscreenmenu/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-fullscreen-menu/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:131:"<span class="ttm_content">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:449:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:86;a:20:{s:2:"id";s:2:"88";s:5:"title";s:18:"Creative Frontpage";s:5:"alias";s:17:"creativefrontpage";s:3:"zip";s:21:"creativefrontpage.zip";s:3:"uid";s:32:"0636cb368af3bcaa2f68eb0ebefe6439";s:3:"img";s:28:"creativefrontpage/slide1.jpg";s:7:"preview";s:56:"https://revolution.themepunch.com/best-wordpress-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:246:"<span class="ttm_content">A full-screen slider with hidden slides that are triggered via  <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions" target="_blank">"Layer Actions"</a>.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:449:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:87;a:23:{s:2:"id";s:2:"89";s:5:"title";s:20:"Website Builder Menu";s:5:"alias";s:19:"websitebuilder-menu";s:3:"zip";s:29:"packs/websitebuilder-menu.zip";s:3:"uid";s:32:"d9e6d9c961f123a3a4847b51fc3ba3a2";s:3:"img";s:30:"websitebuilder-menu/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:2:"60";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"0";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:88;a:23:{s:2:"id";s:2:"90";s:5:"title";s:20:"Website Builder Hero";s:5:"alias";s:19:"websitebuilder-hero";s:3:"zip";s:29:"packs/websitebuilder-hero.zip";s:3:"uid";s:32:"6cb2df9a41ad2e7865bb9bbea7e39cb5";s:3:"img";s:30:"websitebuilder-hero/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1230";s:6:"height";s:3:"700";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"1";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:89;a:23:{s:2:"id";s:2:"91";s:5:"title";s:23:"Website Builder Clients";s:5:"alias";s:22:"websitebuilder-clients";s:3:"zip";s:32:"packs/websitebuilder-clients.zip";s:3:"uid";s:32:"050e59c43c9a693510d01f29532088cf";s:3:"img";s:33:"websitebuilder-clients/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"120";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"2";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:90;a:23:{s:2:"id";s:2:"92";s:5:"title";s:24:"Website Builder Services";s:5:"alias";s:23:"websitebuilder-services";s:3:"zip";s:33:"packs/websitebuilder-services.zip";s:3:"uid";s:32:"48d56d67615efce619ae973ab4358c07";s:3:"img";s:34:"websitebuilder-services/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"558";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"3";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:91;a:23:{s:2:"id";s:2:"93";s:5:"title";s:24:"Website Builder Discover";s:5:"alias";s:23:"websitebuilder-discover";s:3:"zip";s:33:"packs/websitebuilder-discover.zip";s:3:"uid";s:32:"425a08a7be338daea3df02a07ff5c316";s:3:"img";s:34:"websitebuilder-discover/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"955";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"4";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:92;a:23:{s:2:"id";s:2:"94";s:5:"title";s:22:"Website Builder Slider";s:5:"alias";s:21:"websitebuilder-slider";s:3:"zip";s:31:"packs/websitebuilder-slider.zip";s:3:"uid";s:32:"9d670b7335016accb590dc8d52bfb6f0";s:3:"img";s:32:"websitebuilder-slider/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"500";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"5";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:93;a:23:{s:2:"id";s:2:"95";s:5:"title";s:28:"Website Builder CallToAction";s:5:"alias";s:27:"websitebuilder-calltoaction";s:3:"zip";s:37:"packs/websitebuilder-calltoaction.zip";s:3:"uid";s:32:"45851baf9e61f55ed9f5fa9d0beff77e";s:3:"img";s:38:"websitebuilder-calltoaction/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"960";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"6";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:94;a:23:{s:2:"id";s:2:"96";s:5:"title";s:22:"Website Builder Footer";s:5:"alias";s:21:"websitebuilder-footer";s:3:"zip";s:31:"packs/websitebuilder-footer.zip";s:3:"uid";s:32:"2732bbe66ef28219d6cc53ce8cc78863";s:3:"img";s:32:"websitebuilder-footer/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"600";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"7";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:95;a:20:{s:2:"id";s:2:"97";s:5:"title";s:21:"Focus Parallax Effect";s:5:"alias";s:13:"focusparallax";s:3:"zip";s:17:"focusparallax.zip";s:3:"uid";s:32:"13bd15fb3ddf8b9841cb55b89389cc73";s:3:"img";s:24:"focusparallax/slide1.jpg";s:7:"preview";s:68:" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:3:"900";s:11:"description";s:256:"<span class="ttm_content">A full-screen slider with mouse controlled parallax effects. <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a> are used for links on layers.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:449:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href="https://www.themepunch.com/revslider-doc/second-steps/#staticlayers" target="_blank">"Static / Global Layers"</a><br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:96;a:20:{s:2:"id";s:2:"98";s:5:"title";s:14:"Duotone Slider";s:5:"alias";s:7:"duotone";s:3:"zip";s:11:"duotone.zip";s:3:"uid";s:32:"494862ceb6cb7c6658ad7cd36848cccd";s:3:"img";s:18:"duotone/slide1.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/wordpress-header-image-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.4";s:5:"width";s:4:"1200";s:6:"height";s:3:"800";s:11:"description";s:252:"<span class="ttm_content">A full-screen slider with unique parallax scroll effect. <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a> are used for links on layers.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:303:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:97;a:23:{s:2:"id";s:2:"99";s:5:"title";s:12:"Minimal Menu";s:5:"alias";s:6:"r_menu";s:3:"zip";s:16:"packs/r_menu.zip";s:3:"uid";s:32:"30d6a6895db1a5f29b1679061551c9f0";s:3:"img";s:17:"r_menu/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/minimal-website-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1240";s:6:"height";s:3:"110";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:913:"<span class="ttm_content">\r\nIn the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">Custom JavaScript</a> section of the "Minimal Menu" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href="https://www.themepunch.com/revslider-doc/layer-attributes/" target="_blank">Layers Attributes</a> ".tp-colorchange".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:24:"Minimal Website Template";s:13:"package_order";s:1:"0";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"4";s:9:"installed";b:0;}i:98;a:23:{s:2:"id";s:3:"100";s:5:"title";s:12:"Minimal Hero";s:5:"alias";s:5:"rhero";s:3:"zip";s:16:"packs/r_hero.zip";s:3:"uid";s:32:"b8b46186956f6e66ad0c08e4532bbbde";s:3:"img";s:17:"r_hero/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/minimal-website-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1240";s:6:"height";s:3:"700";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:913:"<span class="ttm_content">\r\nIn the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">Custom JavaScript</a> section of the "Minimal Menu" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href="https://www.themepunch.com/revslider-doc/layer-attributes/" target="_blank">Layers Attributes</a> ".tp-colorchange".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:24:"Minimal Website Template";s:13:"package_order";s:1:"1";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"4";s:9:"installed";b:0;}i:99;a:23:{s:2:"id";s:3:"101";s:5:"title";s:13:"Minimal About";s:5:"alias";s:7:"r_about";s:3:"zip";s:17:"packs/r_about.zip";s:3:"uid";s:32:"343010c4b4c03f92888c3e9e95bc2bb1";s:3:"img";s:18:"r_about/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/minimal-website-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1240";s:6:"height";s:3:"900";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:913:"<span class="ttm_content">\r\nIn the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">Custom JavaScript</a> section of the "Minimal Menu" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href="https://www.themepunch.com/revslider-doc/layer-attributes/" target="_blank">Layers Attributes</a> ".tp-colorchange".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:24:"Minimal Website Template";s:13:"package_order";s:1:"2";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"4";s:9:"installed";b:0;}i:100;a:23:{s:2:"id";s:3:"102";s:5:"title";s:16:"Minimal Products";s:5:"alias";s:10:"r_products";s:3:"zip";s:20:"packs/r_products.zip";s:3:"uid";s:32:"dda93e85c6a4456d132040147f087f39";s:3:"img";s:21:"r_products/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/minimal-website-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1240";s:6:"height";s:4:"1100";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:913:"<span class="ttm_content">\r\nIn the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">Custom JavaScript</a> section of the "Minimal Menu" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href="https://www.themepunch.com/revslider-doc/layer-attributes/" target="_blank">Layers Attributes</a> ".tp-colorchange".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:24:"Minimal Website Template";s:13:"package_order";s:1:"3";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"4";s:9:"installed";b:0;}i:101;a:23:{s:2:"id";s:3:"103";s:5:"title";s:12:"Minimal Info";s:5:"alias";s:6:"r_info";s:3:"zip";s:16:"packs/r_info.zip";s:3:"uid";s:32:"d6e368e8fd4862174af6c980389ae530";s:3:"img";s:17:"r_info/slide1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/minimal-website-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1240";s:6:"height";s:3:"800";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:913:"<span class="ttm_content">\r\nIn the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">Custom JavaScript</a> section of the "Minimal Menu" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href="https://www.themepunch.com/revslider-doc/layer-attributes/" target="_blank">Layers Attributes</a> ".tp-colorchange".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:24:"Minimal Website Template";s:13:"package_order";s:1:"4";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"4";s:9:"installed";b:0;}i:102;a:20:{s:2:"id";s:3:"104";s:5:"title";s:18:"Inspiration Header";s:5:"alias";s:17:"inspirationheader";s:3:"zip";s:21:"inspirationheader.zip";s:3:"uid";s:32:"69f04b2be0b618fa7e184af83b86b7e7";s:3:"img";s:28:"inspirationheader/slide1.jpg";s:7:"preview";s:57:"https://revolution.themepunch.com/wordpress-theme-header/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:159:"<span class="ttm_content">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:103;a:20:{s:2:"id";s:3:"105";s:5:"title";s:15:"Magazine Slider";s:5:"alias";s:13:"magazineposts";s:3:"zip";s:17:"magazineposts.zip";s:3:"uid";s:32:"c562f3457e4edbd030959f7c5e6e0f7c";s:3:"img";s:24:"magazineposts/slide1.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-magazine-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1400";s:6:"height";s:4:"1000";s:11:"description";s:266:"<span class="ttm_content">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a> are used for links on layers.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:303:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:104;a:20:{s:2:"id";s:3:"106";s:5:"title";s:11:"News Header";s:5:"alias";s:17:"explorationheader";s:3:"zip";s:21:"explorationheader.zip";s:3:"uid";s:32:"8f20d5a868c90ded08b835fb9e8307d7";s:3:"img";s:28:"explorationheader/slide1.jpg";s:7:"preview";s:56:"https://revolution.themepunch.com/wordpress-news-header/";s:7:"version";s:5:"1.0.1";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:288:"<span class="ttm_content">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a> to add links to buttons.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:303:"<span class="ttm_content">This is a "Default" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:105;a:23:{s:2:"id";s:3:"107";s:5:"title";s:23:"Minimal Website Package";s:5:"alias";s:23:"minimal-website-package";s:3:"zip";s:0:"";s:3:"uid";s:23:"minimal-website-package";s:3:"img";s:31:"packages/template_group_1_1.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/minimal-website-template/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.6";s:5:"width";s:4:"1240";s:6:"height";s:3:"110";s:11:"description";s:181:"<span class="ttm_content">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:913:"<span class="ttm_content">\r\nIn the <a href="https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/" target="_blank">Custom JavaScript</a> section of the "Minimal Menu" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href="https://www.themepunch.com/revslider-doc/layer-attributes/" target="_blank">Layers Attributes</a> ".tp-colorchange".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:24:"Minimal Website Template";s:13:"package_order";s:1:"0";s:14:"package_parent";s:4:"true";s:6:"active";s:1:"1";s:10:"package_id";s:1:"4";s:9:"installed";b:0;}i:106;a:23:{s:2:"id";s:3:"108";s:5:"title";s:23:"Website Builder Package";s:5:"alias";s:22:"websitebuilder-package";s:3:"zip";s:0:"";s:3:"uid";s:22:"websitebuilder-package";s:3:"img";s:29:"packages/template_group_2.jpg";s:7:"preview";s:60:"https://revolution.themepunch.com/wordpress-website-builder/";s:7:"version";s:5:"1.0.0";s:8:"required";s:7:"5.2.5.3";s:5:"width";s:4:"1240";s:6:"height";s:2:"60";s:11:"description";s:191:"<span class="ttm_content">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:15:"Website Builder";s:13:"package_order";s:1:"0";s:14:"package_parent";s:4:"true";s:6:"active";s:1:"1";s:10:"package_id";s:1:"3";s:9:"installed";b:0;}i:107;a:23:{s:2:"id";s:3:"109";s:5:"title";s:26:"Dark Content Block Package";s:5:"alias";s:27:"dark-fullsite-block-package";s:3:"zip";s:0:"";s:3:"uid";s:27:"dark-fullsite-block-package";s:3:"img";s:29:"packages/template_group_4.jpg";s:7:"preview";s:64:"https://revolution.themepunch.com/dark-wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:158:"<span class="ttm_content">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:13:"Fullsite Dark";s:13:"package_order";s:1:"0";s:14:"package_parent";s:4:"true";s:6:"active";s:1:"1";s:10:"package_id";s:1:"2";s:9:"installed";b:0;}i:108;a:23:{s:2:"id";s:3:"110";s:5:"title";s:27:"Light Content Block Package";s:5:"alias";s:22:"fullsite-block-package";s:3:"zip";s:0:"";s:3:"uid";s:22:"fullsite-block-package";s:3:"img";s:29:"packages/template_group_3.jpg";s:7:"preview";s:59:"https://revolution.themepunch.com/wordpress-parallax-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.2.5";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:158:"<span class="ttm_content">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:8:"Fullsite";s:13:"package_order";s:1:"0";s:14:"package_parent";s:4:"true";s:6:"active";s:1:"1";s:10:"package_id";s:1:"1";s:9:"installed";b:0;}i:109;a:20:{s:2:"id";s:3:"111";s:5:"title";s:17:"Typewriter Effect";s:5:"alias";s:16:"typewritereffect";s:3:"zip";s:20:"typewritereffect.zip";s:3:"uid";s:32:"d6f8bae06cc4a7b158d680c01e59ddc2";s:3:"img";s:27:"typewritereffect/slide1.jpg";s:7:"preview";s:62:"https://revolution.themepunch.com/wordpress-typewriter-effect/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:263:"<span class="ttm_content">This is the example slider from the Typewriter add-on preview.<br/><a href="https://www.themepunch.com/revslider-doc/layer-settings/#layeractions">"Layer Actions"</a> are used for links on buttons.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:426:"<span class="ttm_content">This slider template requires the <a href="https://www.themepunch.com/revslider-doc/add-on-typewriter/" target="_blank">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";s:170:"[{"path":"revslider-typewriter-addon\\/revslider-typewriter-addon.php","name":"Typewriter AddOn","url":"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-on-typewriter\\/"}]";s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:110;a:20:{s:2:"id";s:3:"112";s:5:"title";s:17:"Blend Mode Header";s:5:"alias";s:15:"blendmodeheader";s:3:"zip";s:19:"blendmodeheader.zip";s:3:"uid";s:32:"2e44e976596d757aab40ffa28086dcf9";s:3:"img";s:26:"blendmodeheader/slide1.jpg";s:7:"preview";s:57:"https://revolution.themepunch.com/blend-mode-hero-header/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:4:"1000";s:11:"description";s:163:"<span class="ttm_content">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:326:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:111;a:23:{s:2:"id";s:3:"113";s:5:"title";s:17:"Themeplicity Menu";s:5:"alias";s:17:"themeplicity_menu";s:3:"zip";s:27:"packs/themeplicity_menu.zip";s:3:"uid";s:32:"7d5c1e75eaafa63683895a32a62f4ce0";s:3:"img";s:28:"themeplicity_menu/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:2:"90";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"0";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:112;a:23:{s:2:"id";s:3:"114";s:5:"title";s:19:"Themeplicity Header";s:5:"alias";s:19:"themeplicity_header";s:3:"zip";s:29:"packs/themeplicity_header.zip";s:3:"uid";s:32:"907091e4d58acc7d12f802de2f280b7d";s:3:"img";s:30:"themeplicity_header/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:4:"1000";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"1";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:113;a:23:{s:2:"id";s:3:"115";s:5:"title";s:18:"Themeplicity Offer";s:5:"alias";s:18:"themeplicity_offer";s:3:"zip";s:28:"packs/themeplicity_offer.zip";s:3:"uid";s:32:"1bd8f9aa2f3e340449664c65ba17fb51";s:3:"img";s:29:"themeplicity_offer/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"330";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"2";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:114;a:23:{s:2:"id";s:3:"116";s:5:"title";s:23:"Themeplicity What We Do";s:5:"alias";s:21:"themeplicity_whatwedo";s:3:"zip";s:31:"packs/themeplicity_whatwedo.zip";s:3:"uid";s:32:"aa800a44b5a3eab30414dde1f32bfed7";s:3:"img";s:32:"themeplicity_whatwedo/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"813";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"3";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:115;a:23:{s:2:"id";s:3:"117";s:5:"title";s:21:"Themeplicity Projects";s:5:"alias";s:21:"themeplicity_projects";s:3:"zip";s:31:"packs/themeplicity_projects.zip";s:3:"uid";s:32:"5f61b3a13033ba6a51a18270163e0a50";s:3:"img";s:32:"themeplicity_projects/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"813";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"4";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:116;a:23:{s:2:"id";s:3:"118";s:5:"title";s:24:"Themeplicity Whats Great";s:5:"alias";s:23:"themeplicity_whatsgreat";s:3:"zip";s:33:"packs/themeplicity_whatsgreat.zip";s:3:"uid";s:32:"ce9faf8c55ed2e33e091b23667e7173b";s:3:"img";s:34:"themeplicity_whatsgreat/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"900";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"5";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:117;a:23:{s:2:"id";s:3:"119";s:5:"title";s:19:"Themeplicity Tables";s:5:"alias";s:19:"themeplicity_tables";s:3:"zip";s:29:"packs/themeplicity_tables.zip";s:3:"uid";s:32:"f28bb4cd20ec1f29a1de7da5ad09c293";s:3:"img";s:30:"themeplicity_tables/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:4:"1059";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"6";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:118;a:23:{s:2:"id";s:3:"120";s:5:"title";s:24:"Themeplicity Contactform";s:5:"alias";s:24:"themeplicity_contactform";s:3:"zip";s:34:"packs/themeplicity_contactform.zip";s:3:"uid";s:32:"3e59da970f534490774fa8e053f5b5ed";s:3:"img";s:35:"themeplicity_contactform/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:4:"1067";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"7";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:119;a:23:{s:2:"id";s:3:"121";s:5:"title";s:19:"Themeplicity Footer";s:5:"alias";s:19:"themeplicity_footer";s:3:"zip";s:29:"packs/themeplicity_footer.zip";s:3:"uid";s:32:"89eeb0b4b852c5f743e1bd76e3e8f2ef";s:3:"img";s:30:"themeplicity_footer/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1240";s:6:"height";s:3:"780";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"8";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:120;a:23:{s:2:"id";s:3:"122";s:5:"title";s:20:"Themeplicity Package";s:5:"alias";s:20:"themeplicity-package";s:3:"zip";s:0:"";s:3:"uid";s:20:"themeplicity-package";s:3:"img";s:38:"packages/templatepack_themeplicity.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.0";s:5:"width";s:4:"1024";s:6:"height";s:3:"768";s:11:"description";s:175:"<span class="ttm_content">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:29:"Themeplicity Website Template";s:13:"package_order";s:1:"0";s:14:"package_parent";s:4:"true";s:6:"active";s:1:"1";s:10:"package_id";s:1:"5";s:9:"installed";b:0;}i:121;a:23:{s:2:"id";s:3:"123";s:5:"title";s:19:"Nice And Clean Menu";s:5:"alias";s:17:"NiceAndClean_Menu";s:3:"zip";s:27:"packs/NiceAndClean_Menu.zip";s:3:"uid";s:32:"3f8c01e26c7446428e045c4b1180776d";s:3:"img";s:28:"NiceAndClean_Menu/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:2:"90";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"0";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:122;a:23:{s:2:"id";s:3:"124";s:5:"title";s:21:"Nice And Clean Header";s:5:"alias";s:19:"NiceAndClean_Header";s:3:"zip";s:29:"packs/NiceAndClean_Header.zip";s:3:"uid";s:32:"76931033addb20a62557c2845a4d6a11";s:3:"img";s:30:"NiceAndClean_Header/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"1";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:123;a:23:{s:2:"id";s:3:"125";s:5:"title";s:23:"Nice And Clean Services";s:5:"alias";s:21:"NiceAndClean_Services";s:3:"zip";s:31:"packs/NiceAndClean_Services.zip";s:3:"uid";s:32:"02f72ec606800c8215bcadea09624e87";s:3:"img";s:32:"NiceAndClean_Services/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"360";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"2";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:124;a:23:{s:2:"id";s:3:"126";s:5:"title";s:20:"Nice And Clean About";s:5:"alias";s:18:"NiceAndClean_About";s:3:"zip";s:28:"packs/NiceAndClean_About.zip";s:3:"uid";s:32:"9510f6fdbb8e9473e8c22f692a6bc89f";s:3:"img";s:29:"NiceAndClean_About/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"800";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"3";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:125;a:23:{s:2:"id";s:3:"127";s:5:"title";s:20:"Nice And Clean Video";s:5:"alias";s:18:"niceandclean_video";s:3:"zip";s:28:"packs/niceandclean_video.zip";s:3:"uid";s:32:"2bb9e1ad329435cc500542d0c7025e15";s:3:"img";s:29:"niceandclean_video/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"800";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"4";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:126;a:23:{s:2:"id";s:3:"128";s:5:"title";s:25:"Nice And Clean Highlights";s:5:"alias";s:23:"niceandclean_highlights";s:3:"zip";s:33:"packs/niceandclean_highlights.zip";s:3:"uid";s:32:"ff396af163a79d2d5b35db17c1ea7aa6";s:3:"img";s:34:"niceandclean_highlights/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"800";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"5";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:127;a:23:{s:2:"id";s:3:"129";s:5:"title";s:23:"Nice And Clean Projects";s:5:"alias";s:21:"NiceAndClean_Projects";s:3:"zip";s:31:"packs/NiceAndClean_Projects.zip";s:3:"uid";s:32:"1e6695959ef83f8975b52289c08a4d44";s:3:"img";s:32:"NiceAndClean_Projects/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:3:"600";s:6:"height";s:3:"600";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"6";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:128;a:23:{s:2:"id";s:3:"130";s:5:"title";s:25:"Nice And Clean TextBlocks";s:5:"alias";s:23:"niceandclean_textblocks";s:3:"zip";s:33:"packs/niceandclean_textblocks.zip";s:3:"uid";s:32:"1f33eb839c96ea3225faff1c8d382b05";s:3:"img";s:34:"niceandclean_textblocks/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"800";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"7";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:129;a:23:{s:2:"id";s:3:"131";s:5:"title";s:22:"Nice And Clean CallOut";s:5:"alias";s:20:"niceandclean_callout";s:3:"zip";s:30:"packs/niceandclean_callout.zip";s:3:"uid";s:32:"54d4d9bcf79d357de0e614700e909863";s:3:"img";s:31:"niceandclean_callout/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"500";s:11:"description";s:158:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"8";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:130;a:23:{s:2:"id";s:3:"132";s:5:"title";s:21:"Nice And Clean Footer";s:5:"alias";s:19:"niceandclean_footer";s:3:"zip";s:29:"packs/niceandclean_footer.zip";s:3:"uid";s:32:"5492d7f72b3771a4e754f91bda063b15";s:3:"img";s:30:"niceandclean_footer/slide1.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"400";s:11:"description";s:157:"<span class="ttm_content">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:568:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"9";s:14:"package_parent";s:0:"";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:131;a:20:{s:2:"id";s:3:"134";s:5:"title";s:15:"80s Style Intro";s:5:"alias";s:3:"80s";s:3:"zip";s:7:"80s.zip";s:3:"uid";s:32:"98881ab51f71b2fbdb220752d321b15a";s:3:"img";s:14:"80s/slide1.jpg";s:7:"preview";s:50:"https://revolution.themepunch.com/80s-style-intro/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:139:"<span class="ttm_content">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:343:"<span class="ttm_content">This is a "Default" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:132;a:20:{s:2:"id";s:3:"135";s:5:"title";s:18:"Blur Effect Slider";s:5:"alias";s:10:"blurslider";s:3:"zip";s:14:"blurslider.zip";s:3:"uid";s:32:"83bd6e1ccef83f03c944fa05b0a2d879";s:3:"img";s:21:"blurslider/slide1.jpg";s:7:"preview";s:53:"https://revolution.themepunch.com/blur-effect-slider/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:147:"<span class="ttm_content">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:341:"<span class="ttm_content">This is a "Default" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:133;a:20:{s:2:"id";s:3:"136";s:5:"title";s:18:"Coming Soon Add-On";s:5:"alias";s:15:"ComingSoonAddon";s:3:"zip";s:19:"ComingSoonAddon.zip";s:3:"uid";s:32:"51258492055b940099eb96ba52901fa9";s:3:"img";s:26:"ComingSoonAddon/slide1.jpg";s:7:"preview";s:53:"https://revolution.themepunch.com/coming-soon-add-on/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:133:"<span class="ttm_content">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:197:"<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:4:"hero";}s:14:"plugin_require";s:197:"[{"path":"revslider-maintenance-addon\\/revslider-maintenance-addon.php","name":"Coming Soon & Maintenance AddOn","url":"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/"}]";s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}i:134;a:23:{s:2:"id";s:3:"137";s:5:"title";s:22:"Nice And Clean Package";s:5:"alias";s:22:"nice-and-clean-package";s:3:"zip";s:0:"";s:3:"uid";s:22:"nice-and-clean-package";s:3:"img";s:38:"packages/templatepack_niceandclean.jpg";s:7:"preview";s:72:"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1024";s:6:"height";s:3:"800";s:11:"description";s:242:"<span class="ttm_content">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:446:"<span class="ttm_content">If you want to setup the full website example as seen in the preview, please follow the <a href="https://www.themepunch.com/faq/setup-content-blocks-template/" target="_blank">Content Blocks instructions here</a>.<br><br>\r\n<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;N;}s:14:"plugin_require";N;s:4:"date";s:19:"0000-00-00 00:00:00";s:7:"package";s:21:"Nice & Clean Template";s:13:"package_order";s:1:"0";s:14:"package_parent";s:4:"true";s:6:"active";s:1:"1";s:10:"package_id";s:1:"6";s:9:"installed";b:0;}i:135;a:20:{s:2:"id";s:3:"138";s:5:"title";s:18:"Snow Effect Add-On";s:5:"alias";s:9:"snowaddon";s:3:"zip";s:13:"snowaddon.zip";s:3:"uid";s:32:"7408d8567b8af5716eaabd390422e51b";s:3:"img";s:20:"snowaddon/slide1.jpg";s:7:"preview";s:53:"https://revolution.themepunch.com/snow-effect-add-on/";s:7:"version";s:5:"1.0.0";s:8:"required";s:5:"5.3.1";s:5:"width";s:4:"1240";s:6:"height";s:3:"868";s:11:"description";s:183:"<span class="ttm_content">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the "Holiday Snow" Add-On.</span>\r\n<span class="ttm_space"></span>";s:11:"setup_notes";s:197:"<span class="ttm_content">Checkout our <a href="https://www.themepunch.com/revslider-doc/slider-revolution-documentation/" target="_blank">Documentation</a> for basic Slider Revolution help.</span>";s:3:"cat";s:7:"Premium";s:6:"filter";a:1:{i:0;s:6:"slider";}s:14:"plugin_require";s:164:"[{"path":"revslider-snow-addon\\/revslider-snow-addon.php","name":"Snow AddOn","url":"https:\\/\\/revolution.themepunch.com\\/direct-customer-benefits\\/#addoninstall"}]";s:4:"date";s:19:"0000-00-00 00:00:00";s:13:"package_order";s:1:"0";s:6:"active";s:1:"1";s:9:"installed";b:0;}}s:6:"slides";a:130:{s:16:"classic-carousel";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:27:"classic-carousel/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:27:"classic-carousel/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:27:"classic-carousel/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:27:"classic-carousel/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:27:"classic-carousel/slide5.jpg";}}s:13:"classicslider";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"classicslider/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:24:"classicslider/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:24:"classicslider/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:24:"classicslider/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:24:"classicslider/slide5.jpg";}}s:11:"contenttabs";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:22:"contenttabs/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:22:"contenttabs/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:22:"contenttabs/slide3.jpg";}}s:13:"facebook-feed";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"facebook-feed/slide1.jpg";}}s:7:"fashion";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:18:"fashion/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:18:"fashion/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:18:"fashion/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:18:"fashion/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:18:"fashion/slide5.jpg";}}s:14:"flickr-gallery";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:25:"flickr-gallery/slide1.jpg";}}s:3:"gym";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:14:"gym/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:14:"gym/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:14:"gym/slide3.jpg";}}s:18:"highlight-carousel";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:29:"highlight-carousel/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:29:"highlight-carousel/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:29:"highlight-carousel/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:29:"highlight-carousel/slide4.jpg";}}s:18:"highlight-showcase";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:29:"highlight-showcase/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:29:"highlight-showcase/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:29:"highlight-showcase/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:29:"highlight-showcase/slide4.jpg";}}s:10:"image-hero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:20:"imagehero/slide1.jpg";}}s:13:"insta-gallery";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"insta-gallery/slide1.jpg";}}s:19:"levanorestaurantbar";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"levanorestaurantbar/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:30:"levanorestaurantbar/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:30:"levanorestaurantbar/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:30:"levanorestaurantbar/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:30:"levanorestaurantbar/slide5.jpg";}}s:11:"mainfeature";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:22:"mainfeature/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:22:"mainfeature/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:22:"mainfeature/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:22:"mainfeature/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:22:"mainfeature/slide7.jpg";}}s:17:"media-gallery-two";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:28:"media-gallery-two/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:28:"media-gallery-two/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:28:"media-gallery-two/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:28:"media-gallery-two/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:28:"media-gallery-two/slide6.jpg";}}s:23:"media-carousel-autoplay";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:34:"media-carousel-autoplay/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:34:"media-carousel-autoplay/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:34:"media-carousel-autoplay/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:34:"media-carousel-autoplay/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:34:"media-carousel-autoplay/slide6.jpg";}}s:21:"news-background-video";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"news-bg-video/slide1.jpg";}}s:12:"news-gallery";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:23:"news-gallery/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:23:"news-gallery/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:23:"news-gallery/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:23:"news-gallery/slide4.jpg";}}s:23:"news-gallery-post-based";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:34:"news-gallery-post-based/slide1.jpg";}}s:9:"news-hero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:20:"news-hero/slide1.jpg";}}s:10:"news-video";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:21:"news-video/slide1.jpg";}}s:15:"newsletter-hero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"newsletter-hero/slide1.jpg";}}s:10:"notgeneric";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:21:"notgeneric/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:21:"notgeneric/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:21:"notgeneric/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:21:"notgeneric/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:21:"notgeneric/slide5.jpg";}}s:11:"photography";a:10:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:22:"photography/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:22:"photography/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:22:"photography/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:22:"photography/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:22:"photography/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:22:"photography/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:22:"photography/slide7.jpg";}i:7;a:2:{s:5:"title";s:7:"Slide 8";s:3:"img";s:22:"photography/slide8.jpg";}i:8;a:2:{s:5:"title";s:7:"Slide 9";s:3:"img";s:22:"photography/slide9.jpg";}i:9;a:2:{s:5:"title";s:8:"Slide 10";s:3:"img";s:23:"photography/slide10.jpg";}}s:20:"photography-carousel";a:10:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:31:"photography-carousel/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:31:"photography-carousel/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:31:"photography-carousel/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:31:"photography-carousel/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:31:"photography-carousel/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:31:"photography-carousel/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:31:"photography-carousel/slide7.jpg";}i:7;a:2:{s:5:"title";s:7:"Slide 8";s:3:"img";s:31:"photography-carousel/slide8.jpg";}i:8;a:2:{s:5:"title";s:7:"Slide 9";s:3:"img";s:31:"photography-carousel/slide9.jpg";}i:9;a:2:{s:5:"title";s:8:"Slide 10";s:3:"img";s:32:"photography-carousel/slide10.jpg";}}s:16:"search-form-hero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:27:"search-form-hero/slide1.jpg";}}s:16:"showcasecarousel";a:9:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:27:"showcasecarousel/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:27:"showcasecarousel/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:27:"showcasecarousel/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:27:"showcasecarousel/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:27:"showcasecarousel/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:27:"showcasecarousel/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:27:"showcasecarousel/slide7.jpg";}i:7;a:2:{s:5:"title";s:7:"Slide 8";s:3:"img";s:27:"showcasecarousel/slide8.jpg";}i:8;a:2:{s:5:"title";s:7:"Slide 9";s:3:"img";s:27:"showcasecarousel/slide9.jpg";}}s:11:"sports-hero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:21:"sportshero/slide1.jpg";}}s:12:"twitter-feed";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:23:"twitter-feed/slide1.jpg";}}s:13:"vimeo-gallery";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"vimeo-gallery/slide1.jpg";}}s:9:"vimeohero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:20:"vimeohero/slide1.jpg";}}s:16:"web-product-dark";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:27:"web-product-dark/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:27:"web-product-dark/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:27:"web-product-dark/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:27:"web-product-dark/slide4.jpg";}}s:21:"web-product-dark-hero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"web-product-dark-hero/slide1.jpg";}}s:22:"web-product-light-hero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:33:"web-product-light-hero/slide1.jpg";}}s:15:"webproductlight";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"webproductlight/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:26:"webproductlight/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:26:"webproductlight/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:26:"webproductlight/slide4.jpg";}}s:15:"youtube-gallery";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"youtube-gallery/slide1.jpg";}}s:11:"youtubehero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:22:"youtubehero/slide1.jpg";}}s:13:"scroll-effect";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:23:"scrolleffect/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:23:"scrolleffect/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:23:"scrolleffect/slide3.jpg";}}s:12:"content-zoom";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:22:"contentzoom/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:22:"contentzoom/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:22:"contentzoom/slide3.jpg";}}s:13:"food-carousel";a:7:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:23:"foodcarousel/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:23:"foodcarousel/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:23:"foodcarousel/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:23:"foodcarousel/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:23:"foodcarousel/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:23:"foodcarousel/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:23:"foodcarousel/slide7.jpg";}}s:14:"rotating-words";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"rotatingwords/slide1.jpg";}}s:22:"travel-static-captions";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:33:"travel-static-captions/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:33:"travel-static-captions/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:33:"travel-static-captions/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:33:"travel-static-captions/slide4.jpg";}}s:7:"concept";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:18:"concept/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:18:"concept/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:18:"concept/slide3.jpg";}}s:17:"fullscreen-button";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:28:"fullscreen-button/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:28:"fullscreen-button/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:28:"fullscreen-button/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:28:"fullscreen-button/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:28:"fullscreen-button/slide5.jpg";}}s:15:"creativefreedom";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"creativefreedom/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:26:"creativefreedom/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:26:"creativefreedom/slide3.jpg";}}s:13:"parallaxscene";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"parallaxscene/slide1.jpg";}}s:15:"slidingoverlays";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"slidingoverlays/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:26:"slidingoverlays/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:26:"slidingoverlays/slide3.jpg";}}s:25:"web-product-light-hero-3d";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:36:"web-product-light-hero-3d/slide1.jpg";}}s:6:"woobig";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:17:"woobig/slide1.jpg";}}s:16:"woocommercesmall";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:27:"woocommercesmall/slide1.jpg";}}s:10:"finedining";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:21:"finedining/slide1.jpg";}}s:12:"agency-intro";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:23:"agency-intro/slide1.jpg";}}s:7:"ourteam";a:7:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:18:"ourteam/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:18:"ourteam/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:18:"ourteam/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:18:"ourteam/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:18:"ourteam/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:18:"ourteam/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:18:"ourteam/slide7.jpg";}}s:17:"our-team-carousel";a:7:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"ourteamcarousel/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:26:"ourteamcarousel/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:26:"ourteamcarousel/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:26:"ourteamcarousel/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:26:"ourteamcarousel/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:26:"ourteamcarousel/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:26:"ourteamcarousel/slide7.jpg";}}s:13:"betteryoutube";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"betteryoutube/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:24:"betteryoutube/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:24:"betteryoutube/slide3.jpg";}}s:19:"agencywebsiteheader";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"agencywebsiteheader/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:30:"agencywebsiteheader/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:30:"agencywebsiteheader/slide3.jpg";}}s:10:"comingsoon";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:21:"comingsoon/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:21:"comingsoon/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:21:"comingsoon/slide3.jpg";}}s:9:"snowscene";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:20:"snowscene/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:20:"snowscene/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:20:"snowscene/slide3.jpg";}}s:8:"rockband";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:19:"rockband/slide1.jpg";}}s:16:"sleeklandingpage";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:27:"sleeklandingpage/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:27:"sleeklandingpage/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:27:"sleeklandingpage/slide3.jpg";}}s:14:"applandingpage";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:25:"applandingpage/slide1.jpg";}}s:9:"deskscene";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:20:"deskscene/slide1.jpg";}}s:15:"cleannewsslider";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"cleannewsslider/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:26:"cleannewsslider/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:26:"cleannewsslider/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:26:"cleannewsslider/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:26:"cleannewsslider/slide5.jpg";}}s:12:"imagegallery";a:8:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:23:"imagegallery/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:23:"imagegallery/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:23:"imagegallery/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:23:"imagegallery/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:23:"imagegallery/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:23:"imagegallery/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:23:"imagegallery/slide7.jpg";}i:7;a:2:{s:5:"title";s:7:"Slide 8";s:3:"img";s:23:"imagegallery/slide8.jpg";}}s:19:"standard-wp-gallery";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"standard-wp-gallery/slide1.jpg";}}s:21:"clean-news-post-based";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"clean-news-post-based/slide1.jpg";}}s:21:"interactivewhiteboard";a:8:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"interactivewhiteboard/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:32:"interactivewhiteboard/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:32:"interactivewhiteboard/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:32:"interactivewhiteboard/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:32:"interactivewhiteboard/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:32:"interactivewhiteboard/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:32:"interactivewhiteboard/slide7.jpg";}i:7;a:2:{s:5:"title";s:7:"Slide 8";s:3:"img";s:32:"interactivewhiteboard/slide8.jpg";}}s:10:"innovation";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:21:"innovation/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:21:"innovation/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:21:"innovation/slide3.jpg";}}s:24:"dark-fullsite-block-menu";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:35:"dark-fullsite-block-menu/slide1.jpg";}}s:21:"dark-fullsite-block-1";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"dark-fullsite-block-1/slide1.jpg";}}s:27:"dark-fullsite-block-2-about";a:2:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:38:"dark-fullsite-block-2-about/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:38:"dark-fullsite-block-2-about/slide2.jpg";}}s:30:"dark-fullsite-block-3-services";a:2:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:41:"dark-fullsite-block-3-services/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:41:"dark-fullsite-block-3-services/slide2.jpg";}}s:30:"dark-fullsite-block-4-products";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:41:"dark-fullsite-block-4-products/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:41:"dark-fullsite-block-4-products/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:41:"dark-fullsite-block-4-products/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:41:"dark-fullsite-block-4-products/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:41:"dark-fullsite-block-4-products/slide5.jpg";}}s:34:"dark-fullsite-block-5-testimonials";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:45:"dark-fullsite-block-5-testimonials/slide1.jpg";}}s:29:"dark-fullsite-block-6-callout";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:40:"dark-fullsite-block-6-callout/slide1.jpg";}}s:28:"dark-fullsite-block-7-footer";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:39:"dark-fullsite-block-7-footer/slide1.jpg";}}s:19:"fullsite-block-menu";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"fullsite-block-menu/slide1.jpg";}}s:15:"fullsite-block1";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"fullsite-block1/slide1.jpg";}}s:22:"fullsite-block-2-about";a:2:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:33:"fullsite-block-2-about/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:33:"fullsite-block-2-about/slide2.jpg";}}s:25:"fullsite-block-3-services";a:2:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:36:"fullsite-block-3-services/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:36:"fullsite-block-3-services/slide2.jpg";}}s:25:"fullsite-block-4-products";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:36:"fullsite-block-4-products/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:36:"fullsite-block-4-products/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:36:"fullsite-block-4-products/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:36:"fullsite-block-4-products/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:36:"fullsite-block-4-products/slide5.jpg";}}s:29:"fullsite-block-5-testimonials";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:40:"fullsite-block-5-testimonials/slide1.jpg";}}s:24:"fullsite-block-6-callout";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:35:"fullsite-block-6-callout/slide1.jpg";}}s:23:"fullsite-block-7-footer";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:34:"fullsite-block-7-footer/slide1.jpg";}}s:11:"techjournal";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:22:"techjournal/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:22:"techjournal/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:22:"techjournal/slide3.jpg";}}s:13:"cardealership";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"cardealership/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:24:"cardealership/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:24:"cardealership/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:24:"cardealership/slide4.jpg";}}s:14:"fullscreenmenu";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:25:"fullscreenmenu/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:25:"fullscreenmenu/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:25:"fullscreenmenu/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:25:"fullscreenmenu/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:25:"fullscreenmenu/slide5.jpg";}}s:17:"creativefrontpage";a:8:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:28:"creativefrontpage/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:28:"creativefrontpage/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:28:"creativefrontpage/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:28:"creativefrontpage/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:28:"creativefrontpage/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:28:"creativefrontpage/slide6.jpg";}i:6;a:2:{s:5:"title";s:7:"Slide 7";s:3:"img";s:28:"creativefrontpage/slide7.jpg";}i:7;a:2:{s:5:"title";s:7:"Slide 8";s:3:"img";s:28:"creativefrontpage/slide8.jpg";}}s:19:"websitebuilder-menu";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"websitebuilder-menu/slide1.jpg";}}s:19:"websitebuilder-hero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"websitebuilder-hero/slide1.jpg";}}s:22:"websitebuilder-clients";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:33:"websitebuilder-clients/slide1.jpg";}}s:23:"websitebuilder-services";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:34:"websitebuilder-services/slide1.jpg";}}s:23:"websitebuilder-discover";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:34:"websitebuilder-discover/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:34:"websitebuilder-discover/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:34:"websitebuilder-discover/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:34:"websitebuilder-discover/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:34:"websitebuilder-discover/slide5.jpg";}}s:21:"websitebuilder-slider";a:2:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"websitebuilder-slider/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:32:"websitebuilder-slider/slide2.jpg";}}s:27:"websitebuilder-calltoaction";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:38:"websitebuilder-calltoaction/slide1.jpg";}}s:21:"websitebuilder-footer";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"websitebuilder-footer/slide1.jpg";}}s:13:"focusparallax";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"focusparallax/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:24:"focusparallax/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:24:"focusparallax/slide3.jpg";}}s:7:"duotone";a:6:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:18:"duotone/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:18:"duotone/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:18:"duotone/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:18:"duotone/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:18:"duotone/slide5.jpg";}i:5;a:2:{s:5:"title";s:7:"Slide 6";s:3:"img";s:18:"duotone/slide6.jpg";}}s:6:"r_menu";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:17:"r_menu/slide1.jpg";}}s:5:"rhero";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:17:"r_hero/slide1.jpg";}}s:7:"r_about";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:18:"r_about/slide1.jpg";}}s:10:"r_products";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:21:"r_products/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:21:"r_products/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:21:"r_products/slide3.jpg";}}s:6:"r_info";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:17:"r_info/slide1.jpg";}}s:17:"inspirationheader";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:28:"inspirationheader/slide1.jpg";}}s:13:"magazineposts";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:24:"magazineposts/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:24:"magazineposts/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:24:"magazineposts/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:24:"magazineposts/slide4.jpg";}}s:17:"explorationheader";a:4:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:28:"explorationheader/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:28:"explorationheader/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:28:"explorationheader/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:28:"explorationheader/slide4.jpg";}}s:16:"typewritereffect";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:27:"typewritereffect/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:27:"typewritereffect/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:27:"typewritereffect/slide3.jpg";}}s:15:"blendmodeheader";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"blendmodeheader/slide1.jpg";}}s:17:"themeplicity_menu";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:28:"themeplicity_menu/slide1.jpg";}}s:19:"themeplicity_header";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"themeplicity_header/slide1.jpg";}}s:18:"themeplicity_offer";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:29:"themeplicity_offer/slide1.jpg";}}s:21:"themeplicity_whatwedo";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"themeplicity_whatwedo/slide1.jpg";}}s:21:"themeplicity_projects";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"themeplicity_projects/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:32:"themeplicity_projects/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:32:"themeplicity_projects/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:32:"themeplicity_projects/slide4.jpg";}i:4;a:2:{s:5:"title";s:32:"themeplicity_projects/slide5.jpg";s:3:"img";s:7:"Slide 5";}}s:23:"themeplicity_whatsgreat";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:34:"themeplicity_whatsgreat/slide1.jpg";}}s:19:"themeplicity_tables";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"themeplicity_tables/slide1.jpg";}}s:24:"themeplicity_contactform";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:35:"themeplicity_contactform/slide1.jpg";}}s:19:"themeplicity_footer";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"themeplicity_footer/slide1.jpg";}}s:17:"NiceAndClean_Menu";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:28:"NiceAndClean_Menu/slide1.jpg";}}s:19:"NiceAndClean_Header";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"NiceAndClean_Header/slide1.jpg";}}s:21:"NiceAndClean_Services";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"NiceAndClean_Services/slide1.jpg";}}s:18:"NiceAndClean_About";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:29:"NiceAndClean_About/slide1.jpg";}}s:18:"niceandclean_video";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:29:"niceandclean_video/slide1.jpg";}}s:23:"niceandclean_highlights";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:34:"niceandclean_highlights/slide1.jpg";}}s:21:"NiceAndClean_Projects";a:5:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:32:"NiceAndClean_Projects/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:32:"NiceAndClean_Projects/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:32:"NiceAndClean_Projects/slide3.jpg";}i:3;a:2:{s:5:"title";s:7:"Slide 4";s:3:"img";s:32:"NiceAndClean_Projects/slide4.jpg";}i:4;a:2:{s:5:"title";s:7:"Slide 5";s:3:"img";s:32:"NiceAndClean_Projects/slide5.jpg";}}s:23:"niceandclean_textblocks";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:34:"niceandclean_textblocks/slide1.jpg";}}s:20:"niceandclean_callout";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:31:"niceandclean_callout/slide1.jpg";}}s:19:"niceandclean_footer";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:30:"niceandclean_footer/slide1.jpg";}}s:3:"80s";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:14:"80s/slide1.jpg";}}s:10:"blurslider";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:21:"blurslider/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:21:"blurslider/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:21:"blurslider/slide3.jpg";}}s:15:"ComingSoonAddon";a:1:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:26:"ComingSoonAddon/slide1.jpg";}}s:9:"snowaddon";a:3:{i:0;a:2:{s:5:"title";s:7:"Slide 1";s:3:"img";s:20:"snowaddon/slide1.jpg";}i:1;a:2:{s:5:"title";s:7:"Slide 2";s:3:"img";s:20:"snowaddon/slide2.jpg";}i:2;a:2:{s:5:"title";s:7:"Slide 3";s:3:"img";s:20:"snowaddon/slide3.jpg";}}}}', 'no');
REPLACE INTO `xwlpv_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(139, 'theme_mods_goarch', 'a:28:{i:0;b:0;s:12:"Header_phone";s:18:"+7 (212) 674-25-10";s:9:"logo_text";s:2:"go";s:17:"logo_text_primary";s:1:".";s:11:"logo_text_2";s:4:"arch";s:16:"footer_copyright";s:37:"© go.arch 2016. All Rights Reserved.";s:18:"nav_menu_locations";a:1:{s:14:"goarch_topmenu";i:193;}s:15:"ot_google_fonts";a:809:{s:7:"abeezee";a:3:{s:6:"family";s:7:"ABeeZee";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"abel";a:3:{s:6:"family";s:4:"Abel";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"abhayalibre";a:3:{s:6:"family";s:12:"Abhaya Libre";s:8:"variants";a:5:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"600";i:3;s:3:"700";i:4;s:3:"800";}s:7:"subsets";a:3:{i:0;s:7:"sinhala";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:12:"abrilfatface";a:3:{s:6:"family";s:13:"Abril Fatface";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"aclonica";a:3:{s:6:"family";s:8:"Aclonica";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"acme";a:3:{s:6:"family";s:4:"Acme";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"actor";a:3:{s:6:"family";s:5:"Actor";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"adamina";a:3:{s:6:"family";s:7:"Adamina";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"adventpro";a:3:{s:6:"family";s:10:"Advent Pro";s:8:"variants";a:7:{i:0;s:3:"100";i:1;s:3:"200";i:2;s:3:"300";i:3;s:7:"regular";i:4;s:3:"500";i:5;s:3:"600";i:6;s:3:"700";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"greek";}}s:14:"aguafinascript";a:3:{s:6:"family";s:15:"Aguafina Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"akronim";a:3:{s:6:"family";s:7:"Akronim";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"aladin";a:3:{s:6:"family";s:6:"Aladin";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"aldrich";a:3:{s:6:"family";s:7:"Aldrich";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"alef";a:3:{s:6:"family";s:4:"Alef";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"hebrew";}}s:8:"alegreya";a:3:{s:6:"family";s:8:"Alegreya";s:8:"variants";a:6:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";i:4;s:3:"900";i:5;s:9:"900italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"alegreyasc";a:3:{s:6:"family";s:11:"Alegreya SC";s:8:"variants";a:6:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";i:4;s:3:"900";i:5;s:9:"900italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"alegreyasans";a:3:{s:6:"family";s:13:"Alegreya Sans";s:8:"variants";a:14:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"500";i:7;s:9:"500italic";i:8;s:3:"700";i:9;s:9:"700italic";i:10;s:3:"800";i:11;s:9:"800italic";i:12;s:3:"900";i:13;s:9:"900italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:14:"alegreyasanssc";a:3:{s:6:"family";s:16:"Alegreya Sans SC";s:8:"variants";a:14:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"500";i:7;s:9:"500italic";i:8;s:3:"700";i:9;s:9:"700italic";i:10;s:3:"800";i:11;s:9:"800italic";i:12;s:3:"900";i:13;s:9:"900italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:9:"alexbrush";a:3:{s:6:"family";s:10:"Alex Brush";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"alfaslabone";a:3:{s:6:"family";s:13:"Alfa Slab One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"alice";a:3:{s:6:"family";s:5:"Alice";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"alike";a:3:{s:6:"family";s:5:"Alike";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"alikeangular";a:3:{s:6:"family";s:13:"Alike Angular";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"allan";a:3:{s:6:"family";s:5:"Allan";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"allerta";a:3:{s:6:"family";s:7:"Allerta";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"allertastencil";a:3:{s:6:"family";s:15:"Allerta Stencil";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"allura";a:3:{s:6:"family";s:6:"Allura";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"almendra";a:3:{s:6:"family";s:8:"Almendra";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:15:"almendradisplay";a:3:{s:6:"family";s:16:"Almendra Display";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"almendrasc";a:3:{s:6:"family";s:11:"Almendra SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"amarante";a:3:{s:6:"family";s:8:"Amarante";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"amaranth";a:3:{s:6:"family";s:8:"Amaranth";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"amaticsc";a:3:{s:6:"family";s:9:"Amatic SC";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"amaticasc";a:3:{s:6:"family";s:10:"Amatica SC";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:6:"hebrew";}}s:9:"amethysta";a:3:{s:6:"family";s:9:"Amethysta";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"amiko";a:3:{s:6:"family";s:5:"Amiko";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:3:"600";i:2;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:5:"amiri";a:3:{s:6:"family";s:5:"Amiri";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:6:"arabic";i:1;s:5:"latin";}}s:5:"amita";a:3:{s:6:"family";s:5:"Amita";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"anaheim";a:3:{s:6:"family";s:7:"Anaheim";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"andada";a:3:{s:6:"family";s:6:"Andada";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"andika";a:3:{s:6:"family";s:6:"Andika";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:5:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";}}s:6:"angkor";a:3:{s:6:"family";s:6:"Angkor";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:21:"annieuseyourtelescope";a:3:{s:6:"family";s:24:"Annie Use Your Telescope";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"anonymouspro";a:3:{s:6:"family";s:13:"Anonymous Pro";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:5:"greek";}}s:5:"antic";a:3:{s:6:"family";s:5:"Antic";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"anticdidone";a:3:{s:6:"family";s:12:"Antic Didone";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"anticslab";a:3:{s:6:"family";s:10:"Antic Slab";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"anton";a:3:{s:6:"family";s:5:"Anton";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"arapey";a:3:{s:6:"family";s:6:"Arapey";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"arbutus";a:3:{s:6:"family";s:7:"Arbutus";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"arbutusslab";a:3:{s:6:"family";s:12:"Arbutus Slab";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:18:"architectsdaughter";a:3:{s:6:"family";s:19:"Architects Daughter";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"archivoblack";a:3:{s:6:"family";s:13:"Archivo Black";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"archivonarrow";a:3:{s:6:"family";s:14:"Archivo Narrow";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"arefruqaa";a:3:{s:6:"family";s:10:"Aref Ruqaa";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:6:"arabic";i:1;s:5:"latin";}}s:12:"arimamadurai";a:3:{s:6:"family";s:13:"Arima Madurai";s:8:"variants";a:8:{i:0;s:3:"100";i:1;s:3:"200";i:2;s:3:"300";i:3;s:7:"regular";i:4;s:3:"500";i:5;s:3:"700";i:6;s:3:"800";i:7;s:3:"900";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"tamil";i:3;s:10:"vietnamese";}}s:5:"arimo";a:3:{s:6:"family";s:5:"Arimo";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:8:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:6:"hebrew";i:4;s:8:"cyrillic";i:5;s:10:"vietnamese";i:6;s:5:"greek";i:7;s:9:"greek-ext";}}s:8:"arizonia";a:3:{s:6:"family";s:8:"Arizonia";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"armata";a:3:{s:6:"family";s:6:"Armata";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"artifika";a:3:{s:6:"family";s:8:"Artifika";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"arvo";a:3:{s:6:"family";s:4:"Arvo";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"arya";a:3:{s:6:"family";s:4:"Arya";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:4:"asap";a:3:{s:6:"family";s:4:"Asap";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:4:"asar";a:3:{s:6:"family";s:4:"Asar";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:5:"asset";a:3:{s:6:"family";s:5:"Asset";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"assistant";a:3:{s:6:"family";s:9:"Assistant";s:8:"variants";a:6:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"600";i:4;s:3:"700";i:5;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"hebrew";}}s:7:"astloch";a:3:{s:6:"family";s:7:"Astloch";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"asul";a:3:{s:6:"family";s:4:"Asul";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"athiti";a:3:{s:6:"family";s:6:"Athiti";s:8:"variants";a:6:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:4:"atma";a:3:{s:6:"family";s:4:"Atma";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:7:"bengali";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:9:"atomicage";a:3:{s:6:"family";s:10:"Atomic Age";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"aubrey";a:3:{s:6:"family";s:6:"Aubrey";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"audiowide";a:3:{s:6:"family";s:9:"Audiowide";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"autourone";a:3:{s:6:"family";s:10:"Autour One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"average";a:3:{s:6:"family";s:7:"Average";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"averagesans";a:3:{s:6:"family";s:12:"Average Sans";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:17:"averiagruesalibre";a:3:{s:6:"family";s:19:"Averia Gruesa Libre";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"averialibre";a:3:{s:6:"family";s:12:"Averia Libre";s:8:"variants";a:6:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"700";i:5;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:15:"averiasanslibre";a:3:{s:6:"family";s:17:"Averia Sans Libre";s:8:"variants";a:6:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"700";i:5;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:16:"averiaseriflibre";a:3:{s:6:"family";s:18:"Averia Serif Libre";s:8:"variants";a:6:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"700";i:5;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"badscript";a:3:{s:6:"family";s:10:"Bad Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:8:"cyrillic";}}s:5:"baloo";a:3:{s:6:"family";s:5:"Baloo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:10:"vietnamese";}}s:9:"baloobhai";a:3:{s:6:"family";s:10:"Baloo Bhai";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:10:"vietnamese";}}s:11:"baloobhaina";a:3:{s:6:"family";s:12:"Baloo Bhaina";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"oriya";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:10:"vietnamese";}}s:12:"baloochettan";a:3:{s:6:"family";s:13:"Baloo Chettan";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:9:"malayalam";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:10:"vietnamese";}}s:7:"balooda";a:3:{s:6:"family";s:8:"Baloo Da";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:7:"bengali";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:10:"vietnamese";}}s:10:"baloopaaji";a:3:{s:6:"family";s:11:"Baloo Paaji";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:8:"gurmukhi";}}s:10:"balootamma";a:3:{s:6:"family";s:11:"Baloo Tamma";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:7:"kannada";}}s:11:"baloothambi";a:3:{s:6:"family";s:12:"Baloo Thambi";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"tamil";i:3;s:10:"vietnamese";}}s:9:"balthazar";a:3:{s:6:"family";s:9:"Balthazar";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"bangers";a:3:{s:6:"family";s:7:"Bangers";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"basic";a:3:{s:6:"family";s:5:"Basic";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"battambang";a:3:{s:6:"family";s:10:"Battambang";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:7:"baumans";a:3:{s:6:"family";s:7:"Baumans";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"bayon";a:3:{s:6:"family";s:5:"Bayon";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:8:"belgrano";a:3:{s:6:"family";s:8:"Belgrano";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"belleza";a:3:{s:6:"family";s:7:"Belleza";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"benchnine";a:3:{s:6:"family";s:9:"BenchNine";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"bentham";a:3:{s:6:"family";s:7:"Bentham";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"berkshireswash";a:3:{s:6:"family";s:15:"Berkshire Swash";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"bevan";a:3:{s:6:"family";s:5:"Bevan";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"bigelowrules";a:3:{s:6:"family";s:13:"Bigelow Rules";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"bigshotone";a:3:{s:6:"family";s:11:"Bigshot One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"bilbo";a:3:{s:6:"family";s:5:"Bilbo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:14:"bilboswashcaps";a:3:{s:6:"family";s:16:"Bilbo Swash Caps";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"biorhyme";a:3:{s:6:"family";s:8:"BioRhyme";s:8:"variants";a:5:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"700";i:4;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:16:"biorhymeexpanded";a:3:{s:6:"family";s:17:"BioRhyme Expanded";s:8:"variants";a:5:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"700";i:4;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"biryani";a:3:{s:6:"family";s:7:"Biryani";s:8:"variants";a:7:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"600";i:4;s:3:"700";i:5;s:3:"800";i:6;s:3:"900";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:6:"bitter";a:3:{s:6:"family";s:6:"Bitter";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"blackopsone";a:3:{s:6:"family";s:13:"Black Ops One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"bokor";a:3:{s:6:"family";s:5:"Bokor";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:6:"bonbon";a:3:{s:6:"family";s:6:"Bonbon";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"boogaloo";a:3:{s:6:"family";s:8:"Boogaloo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"bowlbyone";a:3:{s:6:"family";s:10:"Bowlby One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"bowlbyonesc";a:3:{s:6:"family";s:13:"Bowlby One SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"brawler";a:3:{s:6:"family";s:7:"Brawler";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"breeserif";a:3:{s:6:"family";s:10:"Bree Serif";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"bubblegumsans";a:3:{s:6:"family";s:14:"Bubblegum Sans";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"bubblerone";a:3:{s:6:"family";s:11:"Bubbler One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:4:"buda";a:3:{s:6:"family";s:4:"Buda";s:8:"variants";a:1:{i:0;s:3:"300";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"buenard";a:3:{s:6:"family";s:7:"Buenard";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"bungee";a:3:{s:6:"family";s:6:"Bungee";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:14:"bungeehairline";a:3:{s:6:"family";s:15:"Bungee Hairline";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:12:"bungeeinline";a:3:{s:6:"family";s:13:"Bungee Inline";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:13:"bungeeoutline";a:3:{s:6:"family";s:14:"Bungee Outline";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:11:"bungeeshade";a:3:{s:6:"family";s:12:"Bungee Shade";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:10:"butcherman";a:3:{s:6:"family";s:10:"Butcherman";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"butterflykids";a:3:{s:6:"family";s:14:"Butterfly Kids";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"cabin";a:3:{s:6:"family";s:5:"Cabin";s:8:"variants";a:8:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"500";i:3;s:9:"500italic";i:4;s:3:"600";i:5;s:9:"600italic";i:6;s:3:"700";i:7;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"cabincondensed";a:3:{s:6:"family";s:15:"Cabin Condensed";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"600";i:3;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"cabinsketch";a:3:{s:6:"family";s:12:"Cabin Sketch";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"caesardressing";a:3:{s:6:"family";s:15:"Caesar Dressing";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"cagliostro";a:3:{s:6:"family";s:10:"Cagliostro";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"cairo";a:3:{s:6:"family";s:5:"Cairo";s:8:"variants";a:6:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"600";i:4;s:3:"700";i:5;s:3:"900";}s:7:"subsets";a:3:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:14:"calligraffitti";a:3:{s:6:"family";s:14:"Calligraffitti";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"cambay";a:3:{s:6:"family";s:6:"Cambay";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:5:"cambo";a:3:{s:6:"family";s:5:"Cambo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"candal";a:3:{s:6:"family";s:6:"Candal";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"cantarell";a:3:{s:6:"family";s:9:"Cantarell";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"cantataone";a:3:{s:6:"family";s:11:"Cantata One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"cantoraone";a:3:{s:6:"family";s:11:"Cantora One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"capriola";a:3:{s:6:"family";s:8:"Capriola";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"cardo";a:3:{s:6:"family";s:5:"Cardo";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"greek";i:3;s:9:"greek-ext";}}s:5:"carme";a:3:{s:6:"family";s:5:"Carme";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"carroisgothic";a:3:{s:6:"family";s:14:"Carrois Gothic";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:15:"carroisgothicsc";a:3:{s:6:"family";s:17:"Carrois Gothic SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"carterone";a:3:{s:6:"family";s:10:"Carter One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"catamaran";a:3:{s:6:"family";s:9:"Catamaran";s:8:"variants";a:9:{i:0;s:3:"100";i:1;s:3:"200";i:2;s:3:"300";i:3;s:7:"regular";i:4;s:3:"500";i:5;s:3:"600";i:6;s:3:"700";i:7;s:3:"800";i:8;s:3:"900";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"tamil";}}s:6:"caudex";a:3:{s:6:"family";s:6:"Caudex";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"greek";i:3;s:9:"greek-ext";}}s:6:"caveat";a:3:{s:6:"family";s:6:"Caveat";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"caveatbrush";a:3:{s:6:"family";s:12:"Caveat Brush";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:17:"cedarvillecursive";a:3:{s:6:"family";s:18:"Cedarville Cursive";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"cevicheone";a:3:{s:6:"family";s:11:"Ceviche One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"changa";a:3:{s:6:"family";s:6:"Changa";s:8:"variants";a:7:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";i:6;s:3:"800";}s:7:"subsets";a:3:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:9:"changaone";a:3:{s:6:"family";s:10:"Changa One";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"chango";a:3:{s:6:"family";s:6:"Chango";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"chathura";a:3:{s:6:"family";s:8:"Chathura";s:8:"variants";a:5:{i:0;s:3:"100";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"700";i:4;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:16:"chauphilomeneone";a:3:{s:6:"family";s:18:"Chau Philomene One";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"chelaone";a:3:{s:6:"family";s:9:"Chela One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"chelseamarket";a:3:{s:6:"family";s:14:"Chelsea Market";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"chenla";a:3:{s:6:"family";s:6:"Chenla";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:15:"cherrycreamsoda";a:3:{s:6:"family";s:17:"Cherry Cream Soda";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"cherryswash";a:3:{s:6:"family";s:12:"Cherry Swash";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"chewy";a:3:{s:6:"family";s:5:"Chewy";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"chicle";a:3:{s:6:"family";s:6:"Chicle";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"chivo";a:3:{s:6:"family";s:5:"Chivo";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"900";i:3;s:9:"900italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"chonburi";a:3:{s:6:"family";s:8:"Chonburi";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:6:"cinzel";a:3:{s:6:"family";s:6:"Cinzel";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:3:"700";i:2;s:3:"900";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:16:"cinzeldecorative";a:3:{s:6:"family";s:17:"Cinzel Decorative";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:3:"700";i:2;s:3:"900";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"clickerscript";a:3:{s:6:"family";s:14:"Clicker Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:4:"coda";a:3:{s:6:"family";s:4:"Coda";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"codacaption";a:3:{s:6:"family";s:12:"Coda Caption";s:8:"variants";a:1:{i:0;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"codystar";a:3:{s:6:"family";s:8:"Codystar";s:8:"variants";a:2:{i:0;s:3:"300";i:1;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"coiny";a:3:{s:6:"family";s:5:"Coiny";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"tamil";i:3;s:10:"vietnamese";}}s:5:"combo";a:3:{s:6:"family";s:5:"Combo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"comfortaa";a:3:{s:6:"family";s:9:"Comfortaa";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:5:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";}}s:10:"comingsoon";a:3:{s:6:"family";s:11:"Coming Soon";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"concertone";a:3:{s:6:"family";s:11:"Concert One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"condiment";a:3:{s:6:"family";s:9:"Condiment";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"content";a:3:{s:6:"family";s:7:"Content";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:11:"contrailone";a:3:{s:6:"family";s:12:"Contrail One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"convergence";a:3:{s:6:"family";s:11:"Convergence";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"cookie";a:3:{s:6:"family";s:6:"Cookie";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"copse";a:3:{s:6:"family";s:5:"Copse";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"corben";a:3:{s:6:"family";s:6:"Corben";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"cormorant";a:3:{s:6:"family";s:9:"Cormorant";s:8:"variants";a:10:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"500";i:5;s:9:"500italic";i:6;s:3:"600";i:7;s:9:"600italic";i:8;s:3:"700";i:9;s:9:"700italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:10:"vietnamese";}}s:17:"cormorantgaramond";a:3:{s:6:"family";s:18:"Cormorant Garamond";s:8:"variants";a:10:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"500";i:5;s:9:"500italic";i:6;s:3:"600";i:7;s:9:"600italic";i:8;s:3:"700";i:9;s:9:"700italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:10:"vietnamese";}}s:15:"cormorantinfant";a:3:{s:6:"family";s:16:"Cormorant Infant";s:8:"variants";a:10:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"500";i:5;s:9:"500italic";i:6;s:3:"600";i:7;s:9:"600italic";i:8;s:3:"700";i:9;s:9:"700italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:10:"vietnamese";}}s:11:"cormorantsc";a:3:{s:6:"family";s:12:"Cormorant SC";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:10:"vietnamese";}}s:16:"cormorantunicase";a:3:{s:6:"family";s:17:"Cormorant Unicase";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:10:"vietnamese";}}s:16:"cormorantupright";a:3:{s:6:"family";s:17:"Cormorant Upright";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:9:"courgette";a:3:{s:6:"family";s:9:"Courgette";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"cousine";a:3:{s:6:"family";s:7:"Cousine";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:8:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:6:"hebrew";i:4;s:8:"cyrillic";i:5;s:10:"vietnamese";i:6;s:5:"greek";i:7;s:9:"greek-ext";}}s:8:"coustard";a:3:{s:6:"family";s:8:"Coustard";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"900";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:18:"coveredbyyourgrace";a:3:{s:6:"family";s:21:"Covered By Your Grace";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"craftygirls";a:3:{s:6:"family";s:12:"Crafty Girls";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"creepster";a:3:{s:6:"family";s:9:"Creepster";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"creteround";a:3:{s:6:"family";s:11:"Crete Round";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"crimsontext";a:3:{s:6:"family";s:12:"Crimson Text";s:8:"variants";a:6:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"600";i:3;s:9:"600italic";i:4;s:3:"700";i:5;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"croissantone";a:3:{s:6:"family";s:13:"Croissant One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"crushed";a:3:{s:6:"family";s:7:"Crushed";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"cuprum";a:3:{s:6:"family";s:6:"Cuprum";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:6:"cutive";a:3:{s:6:"family";s:6:"Cutive";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"cutivemono";a:3:{s:6:"family";s:11:"Cutive Mono";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"damion";a:3:{s:6:"family";s:6:"Damion";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"dancingscript";a:3:{s:6:"family";s:14:"Dancing Script";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"dangrek";a:3:{s:6:"family";s:7:"Dangrek";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:10:"davidlibre";a:3:{s:6:"family";s:11:"David Libre";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"700";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:6:"hebrew";i:3;s:10:"vietnamese";}}s:16:"dawningofanewday";a:3:{s:6:"family";s:20:"Dawning of a New Day";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"daysone";a:3:{s:6:"family";s:8:"Days One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"dekko";a:3:{s:6:"family";s:5:"Dekko";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:6:"delius";a:3:{s:6:"family";s:6:"Delius";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:15:"deliusswashcaps";a:3:{s:6:"family";s:17:"Delius Swash Caps";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"deliusunicase";a:3:{s:6:"family";s:14:"Delius Unicase";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"dellarespira";a:3:{s:6:"family";s:13:"Della Respira";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"denkone";a:3:{s:6:"family";s:8:"Denk One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"devonshire";a:3:{s:6:"family";s:10:"Devonshire";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"dhurjati";a:3:{s:6:"family";s:8:"Dhurjati";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:12:"didactgothic";a:3:{s:6:"family";s:13:"Didact Gothic";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:6:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";i:5;s:9:"greek-ext";}}s:9:"diplomata";a:3:{s:6:"family";s:9:"Diplomata";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"diplomatasc";a:3:{s:6:"family";s:12:"Diplomata SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"domine";a:3:{s:6:"family";s:6:"Domine";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"donegalone";a:3:{s:6:"family";s:11:"Donegal One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"doppioone";a:3:{s:6:"family";s:10:"Doppio One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"dorsa";a:3:{s:6:"family";s:5:"Dorsa";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"dosis";a:3:{s:6:"family";s:5:"Dosis";s:8:"variants";a:7:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";i:6;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"drsugiyama";a:3:{s:6:"family";s:11:"Dr Sugiyama";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"droidsans";a:3:{s:6:"family";s:10:"Droid Sans";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"droidsansmono";a:3:{s:6:"family";s:15:"Droid Sans Mono";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"droidserif";a:3:{s:6:"family";s:11:"Droid Serif";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"durusans";a:3:{s:6:"family";s:9:"Duru Sans";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"dynalight";a:3:{s:6:"family";s:9:"Dynalight";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"ebgaramond";a:3:{s:6:"family";s:11:"EB Garamond";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:5:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";}}s:9:"eaglelake";a:3:{s:6:"family";s:10:"Eagle Lake";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"eater";a:3:{s:6:"family";s:5:"Eater";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"economica";a:3:{s:6:"family";s:9:"Economica";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"eczar";a:3:{s:6:"family";s:5:"Eczar";s:8:"variants";a:5:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"600";i:3;s:3:"700";i:4;s:3:"800";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"ekmukta";a:3:{s:6:"family";s:8:"Ek Mukta";s:8:"variants";a:7:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";i:6;s:3:"800";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:9:"elmessiri";a:3:{s:6:"family";s:10:"El Messiri";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"600";i:3;s:3:"700";}s:7:"subsets";a:3:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:8:"cyrillic";}}s:11:"electrolize";a:3:{s:6:"family";s:11:"Electrolize";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"elsie";a:3:{s:6:"family";s:5:"Elsie";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"900";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:14:"elsieswashcaps";a:3:{s:6:"family";s:16:"Elsie Swash Caps";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"900";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"emblemaone";a:3:{s:6:"family";s:11:"Emblema One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"emilyscandy";a:3:{s:6:"family";s:12:"Emilys Candy";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"engagement";a:3:{s:6:"family";s:10:"Engagement";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"englebert";a:3:{s:6:"family";s:9:"Englebert";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"enriqueta";a:3:{s:6:"family";s:9:"Enriqueta";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"ericaone";a:3:{s:6:"family";s:9:"Erica One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"esteban";a:3:{s:6:"family";s:7:"Esteban";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:14:"euphoriascript";a:3:{s:6:"family";s:15:"Euphoria Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"ewert";a:3:{s:6:"family";s:5:"Ewert";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:3:"exo";a:3:{s:6:"family";s:3:"Exo";s:8:"variants";a:18:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"200";i:3;s:9:"200italic";i:4;s:3:"300";i:5;s:9:"300italic";i:6;s:7:"regular";i:7;s:6:"italic";i:8;s:3:"500";i:9;s:9:"500italic";i:10;s:3:"600";i:11;s:9:"600italic";i:12;s:3:"700";i:13;s:9:"700italic";i:14;s:3:"800";i:15;s:9:"800italic";i:16;s:3:"900";i:17;s:9:"900italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:4:"exo2";a:3:{s:6:"family";s:5:"Exo 2";s:8:"variants";a:18:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"200";i:3;s:9:"200italic";i:4;s:3:"300";i:5;s:9:"300italic";i:6;s:7:"regular";i:7;s:6:"italic";i:8;s:3:"500";i:9;s:9:"500italic";i:10;s:3:"600";i:11;s:9:"600italic";i:12;s:3:"700";i:13;s:9:"700italic";i:14;s:3:"800";i:15;s:9:"800italic";i:16;s:3:"900";i:17;s:9:"900italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:12:"expletussans";a:3:{s:6:"family";s:13:"Expletus Sans";s:8:"variants";a:8:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"500";i:3;s:9:"500italic";i:4;s:3:"600";i:5;s:9:"600italic";i:6;s:3:"700";i:7;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"fanwoodtext";a:3:{s:6:"family";s:12:"Fanwood Text";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"farsan";a:3:{s:6:"family";s:6:"Farsan";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:10:"vietnamese";}}s:9:"fascinate";a:3:{s:6:"family";s:9:"Fascinate";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:15:"fascinateinline";a:3:{s:6:"family";s:16:"Fascinate Inline";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"fasterone";a:3:{s:6:"family";s:10:"Faster One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"fasthand";a:3:{s:6:"family";s:8:"Fasthand";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:8:"faunaone";a:3:{s:6:"family";s:9:"Fauna One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"federant";a:3:{s:6:"family";s:8:"Federant";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"federo";a:3:{s:6:"family";s:6:"Federo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"felipa";a:3:{s:6:"family";s:6:"Felipa";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"fenix";a:3:{s:6:"family";s:5:"Fenix";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"fingerpaint";a:3:{s:6:"family";s:12:"Finger Paint";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"firamono";a:3:{s:6:"family";s:9:"Fira Mono";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:5:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";}}s:8:"firasans";a:3:{s:6:"family";s:9:"Fira Sans";s:8:"variants";a:8:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"500";i:5;s:9:"500italic";i:6;s:3:"700";i:7;s:9:"700italic";}s:7:"subsets";a:5:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";}}s:9:"fjallaone";a:3:{s:6:"family";s:10:"Fjalla One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"fjordone";a:3:{s:6:"family";s:9:"Fjord One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"flamenco";a:3:{s:6:"family";s:8:"Flamenco";s:8:"variants";a:2:{i:0;s:3:"300";i:1;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"flavors";a:3:{s:6:"family";s:7:"Flavors";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"fondamento";a:3:{s:6:"family";s:10:"Fondamento";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:15:"fontdinerswanky";a:3:{s:6:"family";s:16:"Fontdiner Swanky";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"forum";a:3:{s:6:"family";s:5:"Forum";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:11:"francoisone";a:3:{s:6:"family";s:12:"Francois One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:14:"frankruhllibre";a:3:{s:6:"family";s:16:"Frank Ruhl Libre";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"700";i:4;s:3:"900";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:6:"hebrew";}}s:11:"freckleface";a:3:{s:6:"family";s:12:"Freckle Face";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:18:"frederickathegreat";a:3:{s:6:"family";s:20:"Fredericka the Great";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"fredokaone";a:3:{s:6:"family";s:11:"Fredoka One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"freehand";a:3:{s:6:"family";s:8:"Freehand";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:6:"fresca";a:3:{s:6:"family";s:6:"Fresca";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"frijole";a:3:{s:6:"family";s:7:"Frijole";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"fruktur";a:3:{s:6:"family";s:7:"Fruktur";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"fugazone";a:3:{s:6:"family";s:9:"Fugaz One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"gfsdidot";a:3:{s:6:"family";s:9:"GFS Didot";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"greek";}}s:14:"gfsneohellenic";a:3:{s:6:"family";s:15:"GFS Neohellenic";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"greek";}}s:8:"gabriela";a:3:{s:6:"family";s:8:"Gabriela";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"gafata";a:3:{s:6:"family";s:6:"Gafata";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"galada";a:3:{s:6:"family";s:6:"Galada";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:7:"bengali";i:1;s:5:"latin";}}s:8:"galdeano";a:3:{s:6:"family";s:8:"Galdeano";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"galindo";a:3:{s:6:"family";s:7:"Galindo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"gentiumbasic";a:3:{s:6:"family";s:13:"Gentium Basic";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:16:"gentiumbookbasic";a:3:{s:6:"family";s:18:"Gentium Book Basic";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:3:"geo";a:3:{s:6:"family";s:3:"Geo";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"geostar";a:3:{s:6:"family";s:7:"Geostar";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"geostarfill";a:3:{s:6:"family";s:12:"Geostar Fill";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"germaniaone";a:3:{s:6:"family";s:12:"Germania One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"gidugu";a:3:{s:6:"family";s:6:"Gidugu";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:12:"gildadisplay";a:3:{s:6:"family";s:13:"Gilda Display";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"giveyouglory";a:3:{s:6:"family";s:14:"Give You Glory";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"glassantiqua";a:3:{s:6:"family";s:13:"Glass Antiqua";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"glegoo";a:3:{s:6:"family";s:6:"Glegoo";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:16:"gloriahallelujah";a:3:{s:6:"family";s:17:"Gloria Hallelujah";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"goblinone";a:3:{s:6:"family";s:10:"Goblin One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"gochihand";a:3:{s:6:"family";s:10:"Gochi Hand";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"gorditas";a:3:{s:6:"family";s:8:"Gorditas";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:19:"goudybookletter1911";a:3:{s:6:"family";s:21:"Goudy Bookletter 1911";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"graduate";a:3:{s:6:"family";s:8:"Graduate";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"grandhotel";a:3:{s:6:"family";s:11:"Grand Hotel";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"gravitasone";a:3:{s:6:"family";s:12:"Gravitas One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"greatvibes";a:3:{s:6:"family";s:11:"Great Vibes";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"griffy";a:3:{s:6:"family";s:6:"Griffy";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"gruppo";a:3:{s:6:"family";s:6:"Gruppo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"gudea";a:3:{s:6:"family";s:5:"Gudea";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"gurajada";a:3:{s:6:"family";s:8:"Gurajada";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:6:"habibi";a:3:{s:6:"family";s:6:"Habibi";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"halant";a:3:{s:6:"family";s:6:"Halant";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:14:"hammersmithone";a:3:{s:6:"family";s:15:"Hammersmith One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"hanalei";a:3:{s:6:"family";s:7:"Hanalei";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"hanaleifill";a:3:{s:6:"family";s:12:"Hanalei Fill";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"handlee";a:3:{s:6:"family";s:7:"Handlee";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"hanuman";a:3:{s:6:"family";s:7:"Hanuman";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:11:"happymonkey";a:3:{s:6:"family";s:12:"Happy Monkey";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"harmattan";a:3:{s:6:"family";s:9:"Harmattan";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:6:"arabic";i:1;s:5:"latin";}}s:11:"headlandone";a:3:{s:6:"family";s:12:"Headland One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"heebo";a:3:{s:6:"family";s:5:"Heebo";s:8:"variants";a:7:{i:0;s:3:"100";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"700";i:5;s:3:"800";i:6;s:3:"900";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"hebrew";}}s:10:"hennypenny";a:3:{s:6:"family";s:11:"Henny Penny";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:18:"herrvonmuellerhoff";a:3:{s:6:"family";s:20:"Herr Von Muellerhoff";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:4:"hind";a:3:{s:6:"family";s:4:"Hind";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:10:"hindguntur";a:3:{s:6:"family";s:11:"Hind Guntur";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:6:"telugu";}}s:11:"hindmadurai";a:3:{s:6:"family";s:12:"Hind Madurai";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"tamil";}}s:12:"hindsiliguri";a:3:{s:6:"family";s:13:"Hind Siliguri";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:7:"bengali";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:12:"hindvadodara";a:3:{s:6:"family";s:13:"Hind Vadodara";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:13:"holtwoodonesc";a:3:{s:6:"family";s:15:"Holtwood One SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"homemadeapple";a:3:{s:6:"family";s:14:"Homemade Apple";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"homenaje";a:3:{s:6:"family";s:8:"Homenaje";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"imfelldwpica";a:3:{s:6:"family";s:15:"IM Fell DW Pica";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"imfelldwpicasc";a:3:{s:6:"family";s:18:"IM Fell DW Pica SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:16:"imfelldoublepica";a:3:{s:6:"family";s:19:"IM Fell Double Pica";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:18:"imfelldoublepicasc";a:3:{s:6:"family";s:22:"IM Fell Double Pica SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"imfellenglish";a:3:{s:6:"family";s:15:"IM Fell English";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:15:"imfellenglishsc";a:3:{s:6:"family";s:18:"IM Fell English SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:17:"imfellfrenchcanon";a:3:{s:6:"family";s:20:"IM Fell French Canon";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:19:"imfellfrenchcanonsc";a:3:{s:6:"family";s:23:"IM Fell French Canon SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:17:"imfellgreatprimer";a:3:{s:6:"family";s:20:"IM Fell Great Primer";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:19:"imfellgreatprimersc";a:3:{s:6:"family";s:23:"IM Fell Great Primer SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"iceberg";a:3:{s:6:"family";s:7:"Iceberg";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"iceland";a:3:{s:6:"family";s:7:"Iceland";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"imprima";a:3:{s:6:"family";s:7:"Imprima";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"inconsolata";a:3:{s:6:"family";s:11:"Inconsolata";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"inder";a:3:{s:6:"family";s:5:"Inder";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"indieflower";a:3:{s:6:"family";s:12:"Indie Flower";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"inika";a:3:{s:6:"family";s:5:"Inika";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"inknutantiqua";a:3:{s:6:"family";s:14:"Inknut Antiqua";s:8:"variants";a:7:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";i:5;s:3:"800";i:6;s:3:"900";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:11:"irishgrover";a:3:{s:6:"family";s:12:"Irish Grover";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"istokweb";a:3:{s:6:"family";s:9:"Istok Web";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:8:"italiana";a:3:{s:6:"family";s:8:"Italiana";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"italianno";a:3:{s:6:"family";s:9:"Italianno";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:4:"itim";a:3:{s:6:"family";s:4:"Itim";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:15:"jacquesfrancois";a:3:{s:6:"family";s:16:"Jacques Francois";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:21:"jacquesfrancoisshadow";a:3:{s:6:"family";s:23:"Jacques Francois Shadow";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"jaldi";a:3:{s:6:"family";s:5:"Jaldi";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:13:"jimnightshade";a:3:{s:6:"family";s:14:"Jim Nightshade";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"jockeyone";a:3:{s:6:"family";s:10:"Jockey One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"jollylodger";a:3:{s:6:"family";s:12:"Jolly Lodger";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"jomhuria";a:3:{s:6:"family";s:8:"Jomhuria";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:11:"josefinsans";a:3:{s:6:"family";s:12:"Josefin Sans";s:8:"variants";a:10:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"600";i:7;s:9:"600italic";i:8;s:3:"700";i:9;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"josefinslab";a:3:{s:6:"family";s:12:"Josefin Slab";s:8:"variants";a:10:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"600";i:7;s:9:"600italic";i:8;s:3:"700";i:9;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"jotione";a:3:{s:6:"family";s:8:"Joti One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"judson";a:3:{s:6:"family";s:6:"Judson";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:5:"julee";a:3:{s:6:"family";s:5:"Julee";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"juliussansone";a:3:{s:6:"family";s:15:"Julius Sans One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"junge";a:3:{s:6:"family";s:5:"Junge";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"jura";a:3:{s:6:"family";s:4:"Jura";s:8:"variants";a:4:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";}s:7:"subsets";a:5:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";}}s:15:"justanotherhand";a:3:{s:6:"family";s:17:"Just Another Hand";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:19:"justmeagaindownhere";a:3:{s:6:"family";s:23:"Just Me Again Down Here";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"kadwa";a:3:{s:6:"family";s:5:"Kadwa";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:10:"devanagari";i:1;s:5:"latin";}}s:5:"kalam";a:3:{s:6:"family";s:5:"Kalam";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"kameron";a:3:{s:6:"family";s:7:"Kameron";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"kanit";a:3:{s:6:"family";s:5:"Kanit";s:8:"variants";a:18:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"200";i:3;s:9:"200italic";i:4;s:3:"300";i:5;s:9:"300italic";i:6;s:7:"regular";i:7;s:6:"italic";i:8;s:3:"500";i:9;s:9:"500italic";i:10;s:3:"600";i:11;s:9:"600italic";i:12;s:3:"700";i:13;s:9:"700italic";i:14;s:3:"800";i:15;s:9:"800italic";i:16;s:3:"900";i:17;s:9:"900italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:9:"kantumruy";a:3:{s:6:"family";s:9:"Kantumruy";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:5:"karla";a:3:{s:6:"family";s:5:"Karla";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"karma";a:3:{s:6:"family";s:5:"Karma";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"katibeh";a:3:{s:6:"family";s:7:"Katibeh";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:13:"kaushanscript";a:3:{s:6:"family";s:14:"Kaushan Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"kavivanar";a:3:{s:6:"family";s:9:"Kavivanar";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"tamil";}}s:6:"kavoon";a:3:{s:6:"family";s:6:"Kavoon";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"kdamthmor";a:3:{s:6:"family";s:10:"Kdam Thmor";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:9:"keaniaone";a:3:{s:6:"family";s:10:"Keania One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"kellyslab";a:3:{s:6:"family";s:10:"Kelly Slab";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:5:"kenia";a:3:{s:6:"family";s:5:"Kenia";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"khand";a:3:{s:6:"family";s:5:"Khand";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:5:"khmer";a:3:{s:6:"family";s:5:"Khmer";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:5:"khula";a:3:{s:6:"family";s:5:"Khula";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"600";i:3;s:3:"700";i:4;s:3:"800";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"kiteone";a:3:{s:6:"family";s:8:"Kite One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"knewave";a:3:{s:6:"family";s:7:"Knewave";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"kottaone";a:3:{s:6:"family";s:9:"Kotta One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"koulen";a:3:{s:6:"family";s:6:"Koulen";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:6:"kranky";a:3:{s:6:"family";s:6:"Kranky";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"kreon";a:3:{s:6:"family";s:5:"Kreon";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"kristi";a:3:{s:6:"family";s:6:"Kristi";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"kronaone";a:3:{s:6:"family";s:9:"Krona One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"kumarone";a:3:{s:6:"family";s:9:"Kumar One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:15:"kumaroneoutline";a:3:{s:6:"family";s:17:"Kumar One Outline";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:6:"kurale";a:3:{s:6:"family";s:6:"Kurale";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:13:"labelleaurore";a:3:{s:6:"family";s:15:"La Belle Aurore";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"laila";a:3:{s:6:"family";s:5:"Laila";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:10:"lakkireddy";a:3:{s:6:"family";s:11:"Lakki Reddy";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:7:"lalezar";a:3:{s:6:"family";s:7:"Lalezar";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:10:"vietnamese";}}s:8:"lancelot";a:3:{s:6:"family";s:8:"Lancelot";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"lateef";a:3:{s:6:"family";s:6:"Lateef";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:6:"arabic";i:1;s:5:"latin";}}s:4:"lato";a:3:{s:6:"family";s:4:"Lato";s:8:"variants";a:10:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"700";i:7;s:9:"700italic";i:8;s:3:"900";i:9;s:9:"900italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"leaguescript";a:3:{s:6:"family";s:13:"League Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"leckerlione";a:3:{s:6:"family";s:12:"Leckerli One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"ledger";a:3:{s:6:"family";s:6:"Ledger";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:6:"lekton";a:3:{s:6:"family";s:6:"Lekton";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"lemon";a:3:{s:6:"family";s:5:"Lemon";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"lemonada";a:3:{s:6:"family";s:8:"Lemonada";s:8:"variants";a:4:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"600";i:3;s:3:"700";}s:7:"subsets";a:4:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:10:"vietnamese";}}s:16:"librebaskerville";a:3:{s:6:"family";s:17:"Libre Baskerville";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"librefranklin";a:3:{s:6:"family";s:14:"Libre Franklin";s:8:"variants";a:18:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"200";i:3;s:9:"200italic";i:4;s:3:"300";i:5;s:9:"300italic";i:6;s:7:"regular";i:7;s:6:"italic";i:8;s:3:"500";i:9;s:9:"500italic";i:10;s:3:"600";i:11;s:9:"600italic";i:12;s:3:"700";i:13;s:9:"700italic";i:14;s:3:"800";i:15;s:9:"800italic";i:16;s:3:"900";i:17;s:9:"900italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"lifesavers";a:3:{s:6:"family";s:11:"Life Savers";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"lilitaone";a:3:{s:6:"family";s:10:"Lilita One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"lilyscriptone";a:3:{s:6:"family";s:15:"Lily Script One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"limelight";a:3:{s:6:"family";s:9:"Limelight";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"lindenhill";a:3:{s:6:"family";s:11:"Linden Hill";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"lobster";a:3:{s:6:"family";s:7:"Lobster";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:10:"vietnamese";}}s:10:"lobstertwo";a:3:{s:6:"family";s:11:"Lobster Two";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:15:"londrinaoutline";a:3:{s:6:"family";s:16:"Londrina Outline";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"londrinashadow";a:3:{s:6:"family";s:15:"Londrina Shadow";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"londrinasketch";a:3:{s:6:"family";s:15:"Londrina Sketch";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"londrinasolid";a:3:{s:6:"family";s:14:"Londrina Solid";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"lora";a:3:{s:6:"family";s:4:"Lora";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:17:"loveyalikeasister";a:3:{s:6:"family";s:21:"Love Ya Like A Sister";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"lovedbytheking";a:3:{s:6:"family";s:17:"Loved by the King";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"loversquarrel";a:3:{s:6:"family";s:14:"Lovers Quarrel";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"luckiestguy";a:3:{s:6:"family";s:12:"Luckiest Guy";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"lusitana";a:3:{s:6:"family";s:8:"Lusitana";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"lustria";a:3:{s:6:"family";s:7:"Lustria";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"macondo";a:3:{s:6:"family";s:7:"Macondo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:16:"macondoswashcaps";a:3:{s:6:"family";s:18:"Macondo Swash Caps";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"mada";a:3:{s:6:"family";s:4:"Mada";s:8:"variants";a:4:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"900";}s:7:"subsets";a:2:{i:0;s:6:"arabic";i:1;s:5:"latin";}}s:5:"magra";a:3:{s:6:"family";s:5:"Magra";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"maidenorange";a:3:{s:6:"family";s:13:"Maiden Orange";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"maitree";a:3:{s:6:"family";s:7:"Maitree";s:8:"variants";a:6:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:4:"mako";a:3:{s:6:"family";s:4:"Mako";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"mallanna";a:3:{s:6:"family";s:8:"Mallanna";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:7:"mandali";a:3:{s:6:"family";s:7:"Mandali";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:9:"marcellus";a:3:{s:6:"family";s:9:"Marcellus";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"marcellussc";a:3:{s:6:"family";s:12:"Marcellus SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"marckscript";a:3:{s:6:"family";s:12:"Marck Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:9:"margarine";a:3:{s:6:"family";s:9:"Margarine";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"markoone";a:3:{s:6:"family";s:9:"Marko One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"marmelad";a:3:{s:6:"family";s:8:"Marmelad";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:6:"martel";a:3:{s:6:"family";s:6:"Martel";s:8:"variants";a:7:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"600";i:4;s:3:"700";i:5;s:3:"800";i:6;s:3:"900";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:10:"martelsans";a:3:{s:6:"family";s:11:"Martel Sans";s:8:"variants";a:7:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"600";i:4;s:3:"700";i:5;s:3:"800";i:6;s:3:"900";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:6:"marvel";a:3:{s:6:"family";s:6:"Marvel";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"mate";a:3:{s:6:"family";s:4:"Mate";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"matesc";a:3:{s:6:"family";s:7:"Mate SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"mavenpro";a:3:{s:6:"family";s:9:"Maven Pro";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"700";i:3;s:3:"900";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"mclaren";a:3:{s:6:"family";s:7:"McLaren";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"meddon";a:3:{s:6:"family";s:6:"Meddon";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"medievalsharp";a:3:{s:6:"family";s:13:"MedievalSharp";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"medulaone";a:3:{s:6:"family";s:10:"Medula One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"meerainimai";a:3:{s:6:"family";s:12:"Meera Inimai";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:5:"tamil";}}s:6:"megrim";a:3:{s:6:"family";s:6:"Megrim";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"meiescript";a:3:{s:6:"family";s:11:"Meie Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"merienda";a:3:{s:6:"family";s:8:"Merienda";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"meriendaone";a:3:{s:6:"family";s:12:"Merienda One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"merriweather";a:3:{s:6:"family";s:12:"Merriweather";s:8:"variants";a:8:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"700";i:5;s:9:"700italic";i:6;s:3:"900";i:7;s:9:"900italic";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:16:"merriweathersans";a:3:{s:6:"family";s:17:"Merriweather Sans";s:8:"variants";a:8:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"700";i:5;s:9:"700italic";i:6;s:3:"800";i:7;s:9:"800italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"metal";a:3:{s:6:"family";s:5:"Metal";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:10:"metalmania";a:3:{s:6:"family";s:11:"Metal Mania";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"metamorphous";a:3:{s:6:"family";s:12:"Metamorphous";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"metrophobic";a:3:{s:6:"family";s:11:"Metrophobic";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"michroma";a:3:{s:6:"family";s:8:"Michroma";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"milonga";a:3:{s:6:"family";s:7:"Milonga";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"miltonian";a:3:{s:6:"family";s:9:"Miltonian";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:15:"miltoniantattoo";a:3:{s:6:"family";s:16:"Miltonian Tattoo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"miniver";a:3:{s:6:"family";s:7:"Miniver";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"miriamlibre";a:3:{s:6:"family";s:12:"Miriam Libre";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:6:"hebrew";}}s:5:"mirza";a:3:{s:6:"family";s:5:"Mirza";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"600";i:3;s:3:"700";}s:7:"subsets";a:3:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:13:"missfajardose";a:3:{s:6:"family";s:14:"Miss Fajardose";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:4:"mitr";a:3:{s:6:"family";s:4:"Mitr";s:8:"variants";a:6:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:5:"modak";a:3:{s:6:"family";s:5:"Modak";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:13:"modernantiqua";a:3:{s:6:"family";s:14:"Modern Antiqua";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"mogra";a:3:{s:6:"family";s:5:"Mogra";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"molengo";a:3:{s:6:"family";s:7:"Molengo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"molle";a:3:{s:6:"family";s:5:"Molle";s:8:"variants";a:1:{i:0;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"monda";a:3:{s:6:"family";s:5:"Monda";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"monofett";a:3:{s:6:"family";s:8:"Monofett";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"monoton";a:3:{s:6:"family";s:7:"Monoton";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:18:"monsieurladoulaise";a:3:{s:6:"family";s:20:"Monsieur La Doulaise";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"montaga";a:3:{s:6:"family";s:7:"Montaga";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"montez";a:3:{s:6:"family";s:6:"Montez";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"montserrat";a:3:{s:6:"family";s:10:"Montserrat";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:20:"montserratalternates";a:3:{s:6:"family";s:21:"Montserrat Alternates";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:19:"montserratsubrayada";a:3:{s:6:"family";s:20:"Montserrat Subrayada";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"moul";a:3:{s:6:"family";s:4:"Moul";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:8:"moulpali";a:3:{s:6:"family";s:8:"Moulpali";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:20:"mountainsofchristmas";a:3:{s:6:"family";s:22:"Mountains of Christmas";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"mousememoirs";a:3:{s:6:"family";s:13:"Mouse Memoirs";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"mrbedfort";a:3:{s:6:"family";s:10:"Mr Bedfort";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"mrdafoe";a:3:{s:6:"family";s:8:"Mr Dafoe";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"mrdehaviland";a:3:{s:6:"family";s:14:"Mr De Haviland";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:17:"mrssaintdelafield";a:3:{s:6:"family";s:19:"Mrs Saint Delafield";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"mrssheppards";a:3:{s:6:"family";s:13:"Mrs Sheppards";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"muktavaani";a:3:{s:6:"family";s:11:"Mukta Vaani";s:8:"variants";a:7:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";i:6;s:3:"800";}s:7:"subsets";a:3:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:4:"muli";a:3:{s:6:"family";s:4:"Muli";s:8:"variants";a:4:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"mysteryquest";a:3:{s:6:"family";s:13:"Mystery Quest";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:3:"ntr";a:3:{s:6:"family";s:3:"NTR";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:6:"neucha";a:3:{s:6:"family";s:6:"Neucha";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:8:"cyrillic";}}s:6:"neuton";a:3:{s:6:"family";s:6:"Neuton";s:8:"variants";a:6:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"700";i:5;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"newrocker";a:3:{s:6:"family";s:10:"New Rocker";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"newscycle";a:3:{s:6:"family";s:10:"News Cycle";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"niconne";a:3:{s:6:"family";s:7:"Niconne";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"nixieone";a:3:{s:6:"family";s:9:"Nixie One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"nobile";a:3:{s:6:"family";s:6:"Nobile";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"nokora";a:3:{s:6:"family";s:6:"Nokora";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:7:"norican";a:3:{s:6:"family";s:7:"Norican";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"nosifer";a:3:{s:6:"family";s:7:"Nosifer";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:17:"nothingyoucoulddo";a:3:{s:6:"family";s:20:"Nothing You Could Do";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"noticiatext";a:3:{s:6:"family";s:12:"Noticia Text";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:8:"notosans";a:3:{s:6:"family";s:9:"Noto Sans";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:8:{i:0;s:10:"devanagari";i:1;s:12:"cyrillic-ext";i:2;s:5:"latin";i:3;s:9:"latin-ext";i:4;s:8:"cyrillic";i:5;s:10:"vietnamese";i:6;s:5:"greek";i:7;s:9:"greek-ext";}}s:9:"notoserif";a:3:{s:6:"family";s:10:"Noto Serif";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:7:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";i:5;s:5:"greek";i:6;s:9:"greek-ext";}}s:7:"novacut";a:3:{s:6:"family";s:8:"Nova Cut";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"novaflat";a:3:{s:6:"family";s:9:"Nova Flat";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"novamono";a:3:{s:6:"family";s:9:"Nova Mono";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:5:"greek";}}s:8:"novaoval";a:3:{s:6:"family";s:9:"Nova Oval";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"novaround";a:3:{s:6:"family";s:10:"Nova Round";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"novascript";a:3:{s:6:"family";s:11:"Nova Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"novaslim";a:3:{s:6:"family";s:9:"Nova Slim";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"novasquare";a:3:{s:6:"family";s:11:"Nova Square";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"numans";a:3:{s:6:"family";s:6:"Numans";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"nunito";a:3:{s:6:"family";s:6:"Nunito";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"odormeanchey";a:3:{s:6:"family";s:14:"Odor Mean Chey";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:7:"offside";a:3:{s:6:"family";s:7:"Offside";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"oldstandardtt";a:3:{s:6:"family";s:15:"Old Standard TT";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"oldenburg";a:3:{s:6:"family";s:9:"Oldenburg";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"oleoscript";a:3:{s:6:"family";s:11:"Oleo Script";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:19:"oleoscriptswashcaps";a:3:{s:6:"family";s:22:"Oleo Script Swash Caps";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"opensans";a:3:{s:6:"family";s:9:"Open Sans";s:8:"variants";a:10:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"600";i:5;s:9:"600italic";i:6;s:3:"700";i:7;s:9:"700italic";i:8;s:3:"800";i:9;s:9:"800italic";}s:7:"subsets";a:7:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";i:5;s:5:"greek";i:6;s:9:"greek-ext";}}s:17:"opensanscondensed";a:3:{s:6:"family";s:19:"Open Sans Condensed";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:3:"700";}s:7:"subsets";a:7:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";i:5;s:5:"greek";i:6;s:9:"greek-ext";}}s:11:"oranienbaum";a:3:{s:6:"family";s:11:"Oranienbaum";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:8:"orbitron";a:3:{s:6:"family";s:8:"Orbitron";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"700";i:3;s:3:"900";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"oregano";a:3:{s:6:"family";s:7:"Oregano";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"orienta";a:3:{s:6:"family";s:7:"Orienta";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:14:"originalsurfer";a:3:{s:6:"family";s:15:"Original Surfer";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"oswald";a:3:{s:6:"family";s:6:"Oswald";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:14:"overtherainbow";a:3:{s:6:"family";s:16:"Over the Rainbow";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"overlock";a:3:{s:6:"family";s:8:"Overlock";s:8:"variants";a:6:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";i:4;s:3:"900";i:5;s:9:"900italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"overlocksc";a:3:{s:6:"family";s:11:"Overlock SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:3:"ovo";a:3:{s:6:"family";s:3:"Ovo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"oxygen";a:3:{s:6:"family";s:6:"Oxygen";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"oxygenmono";a:3:{s:6:"family";s:11:"Oxygen Mono";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"ptmono";a:3:{s:6:"family";s:7:"PT Mono";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:6:"ptsans";a:3:{s:6:"family";s:7:"PT Sans";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:13:"ptsanscaption";a:3:{s:6:"family";s:15:"PT Sans Caption";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:12:"ptsansnarrow";a:3:{s:6:"family";s:14:"PT Sans Narrow";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:7:"ptserif";a:3:{s:6:"family";s:8:"PT Serif";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:14:"ptserifcaption";a:3:{s:6:"family";s:16:"PT Serif Caption";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:4:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";}}s:8:"pacifico";a:3:{s:6:"family";s:8:"Pacifico";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"palanquin";a:3:{s:6:"family";s:9:"Palanquin";s:8:"variants";a:7:{i:0;s:3:"100";i:1;s:3:"200";i:2;s:3:"300";i:3;s:7:"regular";i:4;s:3:"500";i:5;s:3:"600";i:6;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:13:"palanquindark";a:3:{s:6:"family";s:14:"Palanquin Dark";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"600";i:3;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"paprika";a:3:{s:6:"family";s:7:"Paprika";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"parisienne";a:3:{s:6:"family";s:10:"Parisienne";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"passeroone";a:3:{s:6:"family";s:11:"Passero One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"passionone";a:3:{s:6:"family";s:11:"Passion One";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:3:"700";i:2;s:3:"900";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:16:"pathwaygothicone";a:3:{s:6:"family";s:18:"Pathway Gothic One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"patrickhand";a:3:{s:6:"family";s:12:"Patrick Hand";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:13:"patrickhandsc";a:3:{s:6:"family";s:15:"Patrick Hand SC";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:7:"pattaya";a:3:{s:6:"family";s:7:"Pattaya";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:5:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:10:"vietnamese";i:4;s:4:"thai";}}s:8:"patuaone";a:3:{s:6:"family";s:9:"Patua One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"pavanam";a:3:{s:6:"family";s:7:"Pavanam";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:5:"tamil";}}s:10:"paytoneone";a:3:{s:6:"family";s:11:"Paytone One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"peddana";a:3:{s:6:"family";s:7:"Peddana";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:7:"peralta";a:3:{s:6:"family";s:7:"Peralta";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:15:"permanentmarker";a:3:{s:6:"family";s:16:"Permanent Marker";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:17:"petitformalscript";a:3:{s:6:"family";s:19:"Petit Formal Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"petrona";a:3:{s:6:"family";s:7:"Petrona";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"philosopher";a:3:{s:6:"family";s:11:"Philosopher";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:8:"cyrillic";}}s:6:"piedra";a:3:{s:6:"family";s:6:"Piedra";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"pinyonscript";a:3:{s:6:"family";s:13:"Pinyon Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"pirataone";a:3:{s:6:"family";s:10:"Pirata One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"plaster";a:3:{s:6:"family";s:7:"Plaster";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:4:"play";a:3:{s:6:"family";s:4:"Play";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:5:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";}}s:8:"playball";a:3:{s:6:"family";s:8:"Playball";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:15:"playfairdisplay";a:3:{s:6:"family";s:16:"Playfair Display";s:8:"variants";a:6:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";i:4;s:3:"900";i:5;s:9:"900italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:17:"playfairdisplaysc";a:3:{s:6:"family";s:19:"Playfair Display SC";s:8:"variants";a:6:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";i:4;s:3:"900";i:5;s:9:"900italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:7:"podkova";a:3:{s:6:"family";s:7:"Podkova";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"poiretone";a:3:{s:6:"family";s:10:"Poiret One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:9:"pollerone";a:3:{s:6:"family";s:10:"Poller One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"poly";a:3:{s:6:"family";s:4:"Poly";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"pompiere";a:3:{s:6:"family";s:8:"Pompiere";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"pontanosans";a:3:{s:6:"family";s:12:"Pontano Sans";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"poppins";a:3:{s:6:"family";s:7:"Poppins";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:14:"portlligatsans";a:3:{s:6:"family";s:16:"Port Lligat Sans";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"portlligatslab";a:3:{s:6:"family";s:16:"Port Lligat Slab";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"pragatinarrow";a:3:{s:6:"family";s:14:"Pragati Narrow";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:5:"prata";a:3:{s:6:"family";s:5:"Prata";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"preahvihear";a:3:{s:6:"family";s:11:"Preahvihear";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:12:"pressstart2p";a:3:{s:6:"family";s:14:"Press Start 2P";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";i:3;s:5:"greek";}}s:5:"pridi";a:3:{s:6:"family";s:5:"Pridi";s:8:"variants";a:6:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:13:"princesssofia";a:3:{s:6:"family";s:14:"Princess Sofia";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"prociono";a:3:{s:6:"family";s:8:"Prociono";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"prompt";a:3:{s:6:"family";s:6:"Prompt";s:8:"variants";a:18:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"200";i:3;s:9:"200italic";i:4;s:3:"300";i:5;s:9:"300italic";i:6;s:7:"regular";i:7;s:6:"italic";i:8;s:3:"500";i:9;s:9:"500italic";i:10;s:3:"600";i:11;s:9:"600italic";i:12;s:3:"700";i:13;s:9:"700italic";i:14;s:3:"800";i:15;s:9:"800italic";i:16;s:3:"900";i:17;s:9:"900italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:9:"prostoone";a:3:{s:6:"family";s:10:"Prosto One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:10:"prozalibre";a:3:{s:6:"family";s:11:"Proza Libre";s:8:"variants";a:10:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"500";i:3;s:9:"500italic";i:4;s:3:"600";i:5;s:9:"600italic";i:6;s:3:"700";i:7;s:9:"700italic";i:8;s:3:"800";i:9;s:9:"800italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"puritan";a:3:{s:6:"family";s:7:"Puritan";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"purplepurse";a:3:{s:6:"family";s:12:"Purple Purse";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"quando";a:3:{s:6:"family";s:6:"Quando";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"quantico";a:3:{s:6:"family";s:8:"Quantico";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"quattrocento";a:3:{s:6:"family";s:12:"Quattrocento";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:16:"quattrocentosans";a:3:{s:6:"family";s:17:"Quattrocento Sans";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"questrial";a:3:{s:6:"family";s:9:"Questrial";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"quicksand";a:3:{s:6:"family";s:9:"Quicksand";s:8:"variants";a:3:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"quintessential";a:3:{s:6:"family";s:14:"Quintessential";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"qwigley";a:3:{s:6:"family";s:7:"Qwigley";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"racingsansone";a:3:{s:6:"family";s:15:"Racing Sans One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"radley";a:3:{s:6:"family";s:6:"Radley";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"rajdhani";a:3:{s:6:"family";s:8:"Rajdhani";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:6:"rakkas";a:3:{s:6:"family";s:6:"Rakkas";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:6:"arabic";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"raleway";a:3:{s:6:"family";s:7:"Raleway";s:8:"variants";a:18:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"200";i:3;s:9:"200italic";i:4;s:3:"300";i:5;s:9:"300italic";i:6;s:7:"regular";i:7;s:6:"italic";i:8;s:3:"500";i:9;s:9:"500italic";i:10;s:3:"600";i:11;s:9:"600italic";i:12;s:3:"700";i:13;s:9:"700italic";i:14;s:3:"800";i:15;s:9:"800italic";i:16;s:3:"900";i:17;s:9:"900italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"ralewaydots";a:3:{s:6:"family";s:12:"Raleway Dots";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"ramabhadra";a:3:{s:6:"family";s:10:"Ramabhadra";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:8:"ramaraja";a:3:{s:6:"family";s:8:"Ramaraja";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:6:"rambla";a:3:{s:6:"family";s:6:"Rambla";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"rammettoone";a:3:{s:6:"family";s:12:"Rammetto One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"ranchers";a:3:{s:6:"family";s:8:"Ranchers";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"rancho";a:3:{s:6:"family";s:6:"Rancho";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"ranga";a:3:{s:6:"family";s:5:"Ranga";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:4:"rasa";a:3:{s:6:"family";s:4:"Rasa";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:9:"rationale";a:3:{s:6:"family";s:9:"Rationale";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"raviprakash";a:3:{s:6:"family";s:12:"Ravi Prakash";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:9:"redressed";a:3:{s:6:"family";s:9:"Redressed";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"reemkufi";a:3:{s:6:"family";s:9:"Reem Kufi";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:6:"arabic";i:1;s:5:"latin";}}s:12:"reeniebeanie";a:3:{s:6:"family";s:13:"Reenie Beanie";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"revalia";a:3:{s:6:"family";s:7:"Revalia";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"rhodiumlibre";a:3:{s:6:"family";s:13:"Rhodium Libre";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:6:"ribeye";a:3:{s:6:"family";s:6:"Ribeye";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"ribeyemarrow";a:3:{s:6:"family";s:13:"Ribeye Marrow";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"righteous";a:3:{s:6:"family";s:9:"Righteous";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"risque";a:3:{s:6:"family";s:6:"Risque";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"roboto";a:3:{s:6:"family";s:6:"Roboto";s:8:"variants";a:12:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"500";i:7;s:9:"500italic";i:8;s:3:"700";i:9;s:9:"700italic";i:10;s:3:"900";i:11;s:9:"900italic";}s:7:"subsets";a:7:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";i:5;s:5:"greek";i:6;s:9:"greek-ext";}}s:15:"robotocondensed";a:3:{s:6:"family";s:16:"Roboto Condensed";s:8:"variants";a:6:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"700";i:5;s:9:"700italic";}s:7:"subsets";a:7:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";i:5;s:5:"greek";i:6;s:9:"greek-ext";}}s:10:"robotomono";a:3:{s:6:"family";s:11:"Roboto Mono";s:8:"variants";a:10:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"500";i:7;s:9:"500italic";i:8;s:3:"700";i:9;s:9:"700italic";}s:7:"subsets";a:7:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";i:5;s:5:"greek";i:6;s:9:"greek-ext";}}s:10:"robotoslab";a:3:{s:6:"family";s:11:"Roboto Slab";s:8:"variants";a:4:{i:0;s:3:"100";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"700";}s:7:"subsets";a:7:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:10:"vietnamese";i:5;s:5:"greek";i:6;s:9:"greek-ext";}}s:9:"rochester";a:3:{s:6:"family";s:9:"Rochester";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"rocksalt";a:3:{s:6:"family";s:9:"Rock Salt";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"rokkitt";a:3:{s:6:"family";s:7:"Rokkitt";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"romanesco";a:3:{s:6:"family";s:9:"Romanesco";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"ropasans";a:3:{s:6:"family";s:9:"Ropa Sans";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"rosario";a:3:{s:6:"family";s:7:"Rosario";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"rosarivo";a:3:{s:6:"family";s:8:"Rosarivo";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"rougescript";a:3:{s:6:"family";s:12:"Rouge Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"rozhaone";a:3:{s:6:"family";s:9:"Rozha One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:5:"rubik";a:3:{s:6:"family";s:5:"Rubik";s:8:"variants";a:10:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"500";i:5;s:9:"500italic";i:6;s:3:"700";i:7;s:9:"700italic";i:8;s:3:"900";i:9;s:9:"900italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:6:"hebrew";i:3;s:8:"cyrillic";}}s:12:"rubikmonoone";a:3:{s:6:"family";s:14:"Rubik Mono One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:8:"rubikone";a:3:{s:6:"family";s:9:"Rubik One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:4:"ruda";a:3:{s:6:"family";s:4:"Ruda";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:3:"700";i:2;s:3:"900";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"rufina";a:3:{s:6:"family";s:6:"Rufina";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"rugeboogie";a:3:{s:6:"family";s:11:"Ruge Boogie";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"ruluko";a:3:{s:6:"family";s:6:"Ruluko";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"rumraisin";a:3:{s:6:"family";s:10:"Rum Raisin";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"ruslandisplay";a:3:{s:6:"family";s:14:"Ruslan Display";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:8:"russoone";a:3:{s:6:"family";s:9:"Russo One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:6:"ruthie";a:3:{s:6:"family";s:6:"Ruthie";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:3:"rye";a:3:{s:6:"family";s:3:"Rye";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"sacramento";a:3:{s:6:"family";s:10:"Sacramento";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"sahitya";a:3:{s:6:"family";s:7:"Sahitya";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:10:"devanagari";i:1;s:5:"latin";}}s:4:"sail";a:3:{s:6:"family";s:4:"Sail";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"salsa";a:3:{s:6:"family";s:5:"Salsa";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"sanchez";a:3:{s:6:"family";s:7:"Sanchez";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"sancreek";a:3:{s:6:"family";s:8:"Sancreek";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"sansitaone";a:3:{s:6:"family";s:11:"Sansita One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"sarala";a:3:{s:6:"family";s:6:"Sarala";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:6:"sarina";a:3:{s:6:"family";s:6:"Sarina";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"sarpanch";a:3:{s:6:"family";s:8:"Sarpanch";s:8:"variants";a:6:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"600";i:3;s:3:"700";i:4;s:3:"800";i:5;s:3:"900";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"satisfy";a:3:{s:6:"family";s:7:"Satisfy";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"scada";a:3:{s:6:"family";s:5:"Scada";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:12:"scheherazade";a:3:{s:6:"family";s:12:"Scheherazade";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:6:"arabic";i:1;s:5:"latin";}}s:10:"schoolbell";a:3:{s:6:"family";s:10:"Schoolbell";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"scopeone";a:3:{s:6:"family";s:9:"Scope One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"seaweedscript";a:3:{s:6:"family";s:14:"Seaweed Script";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"secularone";a:3:{s:6:"family";s:11:"Secular One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:6:"hebrew";}}s:9:"sevillana";a:3:{s:6:"family";s:9:"Sevillana";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"seymourone";a:3:{s:6:"family";s:11:"Seymour One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:16:"shadowsintolight";a:3:{s:6:"family";s:18:"Shadows Into Light";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:19:"shadowsintolighttwo";a:3:{s:6:"family";s:22:"Shadows Into Light Two";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"shanti";a:3:{s:6:"family";s:6:"Shanti";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"share";a:3:{s:6:"family";s:5:"Share";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"sharetech";a:3:{s:6:"family";s:10:"Share Tech";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"sharetechmono";a:3:{s:6:"family";s:15:"Share Tech Mono";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"shojumaru";a:3:{s:6:"family";s:9:"Shojumaru";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"shortstack";a:3:{s:6:"family";s:11:"Short Stack";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"shrikhand";a:3:{s:6:"family";s:9:"Shrikhand";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:8:"gujarati";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:8:"siemreap";a:3:{s:6:"family";s:8:"Siemreap";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:9:"sigmarone";a:3:{s:6:"family";s:10:"Sigmar One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"signika";a:3:{s:6:"family";s:7:"Signika";s:8:"variants";a:4:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"600";i:3;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:15:"signikanegative";a:3:{s:6:"family";s:16:"Signika Negative";s:8:"variants";a:4:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"600";i:3;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"simonetta";a:3:{s:6:"family";s:9:"Simonetta";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"900";i:3;s:9:"900italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"sintony";a:3:{s:6:"family";s:7:"Sintony";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"sirinstencil";a:3:{s:6:"family";s:13:"Sirin Stencil";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"sixcaps";a:3:{s:6:"family";s:8:"Six Caps";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"skranji";a:3:{s:6:"family";s:7:"Skranji";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"slabo13px";a:3:{s:6:"family";s:10:"Slabo 13px";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"slabo27px";a:3:{s:6:"family";s:10:"Slabo 27px";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"slackey";a:3:{s:6:"family";s:7:"Slackey";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"smokum";a:3:{s:6:"family";s:6:"Smokum";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"smythe";a:3:{s:6:"family";s:6:"Smythe";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"sniglet";a:3:{s:6:"family";s:7:"Sniglet";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"800";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"snippet";a:3:{s:6:"family";s:7:"Snippet";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:12:"snowburstone";a:3:{s:6:"family";s:13:"Snowburst One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"sofadione";a:3:{s:6:"family";s:10:"Sofadi One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"sofia";a:3:{s:6:"family";s:5:"Sofia";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"sonsieone";a:3:{s:6:"family";s:10:"Sonsie One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:14:"sortsmillgoudy";a:3:{s:6:"family";s:16:"Sorts Mill Goudy";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:6:"italic";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"sourcecodepro";a:3:{s:6:"family";s:15:"Source Code Pro";s:8:"variants";a:7:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"600";i:5;s:3:"700";i:6;s:3:"900";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:13:"sourcesanspro";a:3:{s:6:"family";s:15:"Source Sans Pro";s:8:"variants";a:12:{i:0;s:3:"200";i:1;s:9:"200italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"600";i:7;s:9:"600italic";i:8;s:3:"700";i:9;s:9:"700italic";i:10;s:3:"900";i:11;s:9:"900italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:14:"sourceserifpro";a:3:{s:6:"family";s:16:"Source Serif Pro";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:3:"600";i:2;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"spacemono";a:3:{s:6:"family";s:10:"Space Mono";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";}}s:12:"specialelite";a:3:{s:6:"family";s:13:"Special Elite";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"spicyrice";a:3:{s:6:"family";s:10:"Spicy Rice";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"spinnaker";a:3:{s:6:"family";s:9:"Spinnaker";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"spirax";a:3:{s:6:"family";s:6:"Spirax";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"squadaone";a:3:{s:6:"family";s:10:"Squada One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:19:"sreekrushnadevaraya";a:3:{s:6:"family";s:20:"Sree Krushnadevaraya";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:8:"sriracha";a:3:{s:6:"family";s:8:"Sriracha";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:9:"stalemate";a:3:{s:6:"family";s:9:"Stalemate";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"stalinistone";a:3:{s:6:"family";s:13:"Stalinist One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:14:"stardosstencil";a:3:{s:6:"family";s:15:"Stardos Stencil";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:19:"stintultracondensed";a:3:{s:6:"family";s:21:"Stint Ultra Condensed";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:18:"stintultraexpanded";a:3:{s:6:"family";s:20:"Stint Ultra Expanded";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"stoke";a:3:{s:6:"family";s:5:"Stoke";s:8:"variants";a:2:{i:0;s:3:"300";i:1;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"strait";a:3:{s:6:"family";s:6:"Strait";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:17:"sueellenfrancisco";a:3:{s:6:"family";s:19:"Sue Ellen Francisco";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"suezone";a:3:{s:6:"family";s:8:"Suez One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:6:"hebrew";}}s:6:"sumana";a:3:{s:6:"family";s:6:"Sumana";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:9:"sunshiney";a:3:{s:6:"family";s:9:"Sunshiney";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:15:"supermercadoone";a:3:{s:6:"family";s:16:"Supermercado One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"sura";a:3:{s:6:"family";s:4:"Sura";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"suranna";a:3:{s:6:"family";s:7:"Suranna";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:9:"suravaram";a:3:{s:6:"family";s:9:"Suravaram";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:11:"suwannaphum";a:3:{s:6:"family";s:11:"Suwannaphum";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:15:"swankyandmoomoo";a:3:{s:6:"family";s:18:"Swanky and Moo Moo";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"syncopate";a:3:{s:6:"family";s:9:"Syncopate";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"tangerine";a:3:{s:6:"family";s:9:"Tangerine";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"taprom";a:3:{s:6:"family";s:6:"Taprom";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"khmer";}}s:5:"tauri";a:3:{s:6:"family";s:5:"Tauri";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"taviraj";a:3:{s:6:"family";s:7:"Taviraj";s:8:"variants";a:18:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"200";i:3;s:9:"200italic";i:4;s:3:"300";i:5;s:9:"300italic";i:6;s:7:"regular";i:7;s:6:"italic";i:8;s:3:"500";i:9;s:9:"500italic";i:10;s:3:"600";i:11;s:9:"600italic";i:12;s:3:"700";i:13;s:9:"700italic";i:14;s:3:"800";i:15;s:9:"800italic";i:16;s:3:"900";i:17;s:9:"900italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:4:"teko";a:3:{s:6:"family";s:4:"Teko";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:5:"telex";a:3:{s:6:"family";s:5:"Telex";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:17:"tenaliramakrishna";a:3:{s:6:"family";s:18:"Tenali Ramakrishna";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:9:"tenorsans";a:3:{s:6:"family";s:10:"Tenor Sans";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:9:"textmeone";a:3:{s:6:"family";s:11:"Text Me One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:15:"thegirlnextdoor";a:3:{s:6:"family";s:18:"The Girl Next Door";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"tienne";a:3:{s:6:"family";s:6:"Tienne";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:3:"700";i:2;s:3:"900";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"tillana";a:3:{s:6:"family";s:7:"Tillana";s:8:"variants";a:5:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"600";i:3;s:3:"700";i:4;s:3:"800";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:7:"timmana";a:3:{s:6:"family";s:7:"Timmana";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"telugu";}}s:5:"tinos";a:3:{s:6:"family";s:5:"Tinos";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:8:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:6:"hebrew";i:4;s:8:"cyrillic";i:5;s:10:"vietnamese";i:6;s:5:"greek";i:7;s:9:"greek-ext";}}s:8:"titanone";a:3:{s:6:"family";s:9:"Titan One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:12:"titilliumweb";a:3:{s:6:"family";s:13:"Titillium Web";s:8:"variants";a:11:{i:0;s:3:"200";i:1;s:9:"200italic";i:2;s:3:"300";i:3;s:9:"300italic";i:4;s:7:"regular";i:5;s:6:"italic";i:6;s:3:"600";i:7;s:9:"600italic";i:8;s:3:"700";i:9;s:9:"700italic";i:10;s:3:"900";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:10:"tradewinds";a:3:{s:6:"family";s:11:"Trade Winds";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"trirong";a:3:{s:6:"family";s:7:"Trirong";s:8:"variants";a:18:{i:0;s:3:"100";i:1;s:9:"100italic";i:2;s:3:"200";i:3;s:9:"200italic";i:4;s:3:"300";i:5;s:9:"300italic";i:6;s:7:"regular";i:7;s:6:"italic";i:8;s:3:"500";i:9;s:9:"500italic";i:10;s:3:"600";i:11;s:9:"600italic";i:12;s:3:"700";i:13;s:9:"700italic";i:14;s:3:"800";i:15;s:9:"800italic";i:16;s:3:"900";i:17;s:9:"900italic";}s:7:"subsets";a:4:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:10:"vietnamese";i:3;s:4:"thai";}}s:7:"trocchi";a:3:{s:6:"family";s:7:"Trocchi";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"trochut";a:3:{s:6:"family";s:7:"Trochut";s:8:"variants";a:3:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"trykker";a:3:{s:6:"family";s:7:"Trykker";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"tulpenone";a:3:{s:6:"family";s:10:"Tulpen One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"ubuntu";a:3:{s:6:"family";s:6:"Ubuntu";s:8:"variants";a:8:{i:0;s:3:"300";i:1;s:9:"300italic";i:2;s:7:"regular";i:3;s:6:"italic";i:4;s:3:"500";i:5;s:9:"500italic";i:6;s:3:"700";i:7;s:9:"700italic";}s:7:"subsets";a:6:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";i:5;s:9:"greek-ext";}}s:15:"ubuntucondensed";a:3:{s:6:"family";s:16:"Ubuntu Condensed";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:6:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";i:5;s:9:"greek-ext";}}s:10:"ubuntumono";a:3:{s:6:"family";s:11:"Ubuntu Mono";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:6:{i:0;s:12:"cyrillic-ext";i:1;s:5:"latin";i:2;s:9:"latin-ext";i:3;s:8:"cyrillic";i:4;s:5:"greek";i:5;s:9:"greek-ext";}}s:5:"ultra";a:3:{s:6:"family";s:5:"Ultra";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:13:"uncialantiqua";a:3:{s:6:"family";s:14:"Uncial Antiqua";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"underdog";a:3:{s:6:"family";s:8:"Underdog";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:8:"unicaone";a:3:{s:6:"family";s:9:"Unica One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:14:"unifrakturcook";a:3:{s:6:"family";s:14:"UnifrakturCook";s:8:"variants";a:1:{i:0;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:18:"unifrakturmaguntia";a:3:{s:6:"family";s:18:"UnifrakturMaguntia";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:7:"unkempt";a:3:{s:6:"family";s:7:"Unkempt";s:8:"variants";a:2:{i:0;s:7:"regular";i:1;s:3:"700";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"unlock";a:3:{s:6:"family";s:6:"Unlock";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"unna";a:3:{s:6:"family";s:4:"Unna";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:5:"vt323";a:3:{s:6:"family";s:5:"VT323";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:10:"vampiroone";a:3:{s:6:"family";s:11:"Vampiro One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"varela";a:3:{s:6:"family";s:6:"Varela";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"varelaround";a:3:{s:6:"family";s:12:"Varela Round";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:6:"hebrew";}}s:10:"vastshadow";a:3:{s:6:"family";s:11:"Vast Shadow";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:11:"vesperlibre";a:3:{s:6:"family";s:12:"Vesper Libre";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:3:"500";i:2;s:3:"700";i:3;s:3:"900";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:5:"vibur";a:3:{s:6:"family";s:5:"Vibur";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"vidaloka";a:3:{s:6:"family";s:8:"Vidaloka";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"viga";a:3:{s:6:"family";s:4:"Viga";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:5:"voces";a:3:{s:6:"family";s:5:"Voces";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"volkhov";a:3:{s:6:"family";s:7:"Volkhov";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"vollkorn";a:3:{s:6:"family";s:8:"Vollkorn";s:8:"variants";a:4:{i:0;s:7:"regular";i:1;s:6:"italic";i:2;s:3:"700";i:3;s:9:"700italic";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"voltaire";a:3:{s:6:"family";s:8:"Voltaire";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:20:"waitingforthesunrise";a:3:{s:6:"family";s:23:"Waiting for the Sunrise";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"wallpoet";a:3:{s:6:"family";s:8:"Wallpoet";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:14:"walterturncoat";a:3:{s:6:"family";s:15:"Walter Turncoat";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:6:"warnes";a:3:{s:6:"family";s:6:"Warnes";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:9:"wellfleet";a:3:{s:6:"family";s:9:"Wellfleet";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:8:"wendyone";a:3:{s:6:"family";s:9:"Wendy One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:7:"wireone";a:3:{s:6:"family";s:8:"Wire One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:8:"worksans";a:3:{s:6:"family";s:9:"Work Sans";s:8:"variants";a:9:{i:0;s:3:"100";i:1;s:3:"200";i:2;s:3:"300";i:3;s:7:"regular";i:4;s:3:"500";i:5;s:3:"600";i:6;s:3:"700";i:7;s:3:"800";i:8;s:3:"900";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:16:"yanonekaffeesatz";a:3:{s:6:"family";s:17:"Yanone Kaffeesatz";s:8:"variants";a:4:{i:0;s:3:"200";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:11:"yantramanav";a:3:{s:6:"family";s:11:"Yantramanav";s:8:"variants";a:6:{i:0;s:3:"100";i:1;s:3:"300";i:2;s:7:"regular";i:3;s:3:"500";i:4;s:3:"700";i:5;s:3:"900";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:8:"yatraone";a:3:{s:6:"family";s:9:"Yatra One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:10:"devanagari";i:1;s:5:"latin";i:2;s:9:"latin-ext";}}s:10:"yellowtail";a:3:{s:6:"family";s:10:"Yellowtail";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:9:"yesevaone";a:3:{s:6:"family";s:10:"Yeseva One";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:3:{i:0;s:5:"latin";i:1;s:9:"latin-ext";i:2;s:8:"cyrillic";}}s:10:"yesteryear";a:3:{s:6:"family";s:10:"Yesteryear";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}s:4:"yrsa";a:3:{s:6:"family";s:4:"Yrsa";s:8:"variants";a:5:{i:0;s:3:"300";i:1;s:7:"regular";i:2;s:3:"500";i:3;s:3:"600";i:4;s:3:"700";}s:7:"subsets";a:2:{i:0;s:5:"latin";i:1;s:9:"latin-ext";}}s:6:"zeyada";a:3:{s:6:"family";s:6:"Zeyada";s:8:"variants";a:1:{i:0;s:7:"regular";}s:7:"subsets";a:1:{i:0;s:5:"latin";}}}s:19:"ot_set_google_fonts";a:0:{}s:27:"goarch_sidebar_cat_position";s:2:"s3";s:18:"footer_author_link";s:95:"<a class="author-link" href="http://themeforest.net/user/murren20" target="_blank">Murren20</a>";s:21:"goarch_map_google_key";s:39:"AIzaSyAQ0FBrS86laigd1gOb6NniK5MkwRZAZ5k";s:24:"goarch_map_stylemap_json";s:4657:"[\n            {\n                "featureType": "all",\n                "elementType": "labels.text.fill",\n                "stylers": [\n                    {\n                        "saturation": 36\n                    },\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 40\n                    }\n                ]\n            },\n            {\n                "featureType": "all",\n                "elementType": "labels.text.stroke",\n                "stylers": [\n                    {\n                        "visibility": "on"\n                    },\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 16\n                    }\n                ]\n            },\n            {\n                "featureType": "all",\n                "elementType": "labels.icon",\n                "stylers": [\n                    {\n                        "visibility": "off"\n                    }\n                ]\n            },\n            {\n                "featureType": "administrative",\n                "elementType": "geometry.fill",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 20\n                    }\n                ]\n            },\n            {\n                "featureType": "administrative",\n                "elementType": "geometry.stroke",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 17\n                    },\n                    {\n                        "weight": 1.2\n                    }\n                ]\n            },\n            {\n                "featureType": "landscape",\n                "elementType": "geometry",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 20\n                    }\n                ]\n            },\n            {\n                "featureType": "poi",\n                "elementType": "geometry",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 21\n                    }\n                ]\n            },\n            {\n                "featureType": "road.highway",\n                "elementType": "geometry.fill",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 17\n                    }\n                ]\n            },\n            {\n                "featureType": "road.highway",\n                "elementType": "geometry.stroke",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 29\n                    },\n                    {\n                        "weight": 0.2\n                    }\n                ]\n            },\n            {\n                "featureType": "road.arterial",\n                "elementType": "geometry",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 18\n                    }\n                ]\n            },\n            {\n                "featureType": "road.local",\n                "elementType": "geometry",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 16\n                    }\n                ]\n            },\n            {\n                "featureType": "transit",\n                "elementType": "geometry",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 19\n                    }\n                ]\n            },\n            {\n                "featureType": "water",\n                "elementType": "geometry",\n                "stylers": [\n                    {\n                        "color": "#000000"\n                    },\n                    {\n                        "lightness": 17\n                    }\n                ]\n            }\n        ]";s:23:"goarch_performans_style";s:5:"light";s:32:"sotial_networks_control_facebook";s:25:"https://www.facebook.com/";s:31:"sotial_networks_control_twitter";s:20:"https://twitter.com/";s:31:"sotial_networks_control_behance";s:24:"https://www.behance.net/";s:33:"sotial_networks_control_instagram";s:26:"https://www.instagram.com/";s:15:"logo_brand_name";s:7:"Go.arch";s:19:"goarch_c_form_s_val";s:368:"[goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"]";s:23:"goarch_sidebar_position";s:2:"s2";s:15:"colors_m_F3F3F3";s:7:"#f3f3f3";s:15:"colors_m_F6F5F3";s:7:"#f6f5f3";s:27:"goarch_performans_preloader";b:1;s:40:"sotial_networks_control_social_shortcode";s:0:"";s:15:"colors_m_747474";s:7:"#747474";s:15:"colors_m_C5A47E";s:7:"#c5a47e";s:18:"custom_css_post_id";i:-1;}', 'yes');
REPLACE INTO `xwlpv_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(33, 'active_plugins', 'a:4:{i:1;s:23:"goarch_plugin/index.php";i:2;s:27:"js_composer/js_composer.php";i:3;s:25:"option-tree/ot-loader.php";i:4;s:23:"revslider/revslider.php";}', 'yes'),
(4138, 'rs-templates-new', '', 'no'),
(92, 'xwlpv_user_roles', 'a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:72:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:31:"vc_access_rules_post_types/page";b:1;s:35:"vc_access_rules_post_types/projects";b:1;s:26:"vc_access_rules_post_types";s:6:"custom";s:30:"vc_access_rules_backend_editor";b:1;s:31:"vc_access_rules_frontend_editor";b:1;s:29:"vc_access_rules_post_settings";b:1;s:24:"vc_access_rules_settings";b:1;s:25:"vc_access_rules_templates";b:1;s:26:"vc_access_rules_shortcodes";b:1;s:28:"vc_access_rules_grid_builder";b:1;s:23:"vc_access_rules_presets";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:42:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:26:"vc_access_rules_post_types";b:1;s:30:"vc_access_rules_backend_editor";b:1;s:31:"vc_access_rules_frontend_editor";b:1;s:29:"vc_access_rules_post_settings";b:1;s:25:"vc_access_rules_templates";b:1;s:26:"vc_access_rules_shortcodes";b:1;s:28:"vc_access_rules_grid_builder";b:1;s:23:"vc_access_rules_presets";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:18:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;s:26:"vc_access_rules_post_types";b:1;s:30:"vc_access_rules_backend_editor";b:1;s:31:"vc_access_rules_frontend_editor";b:1;s:29:"vc_access_rules_post_settings";b:1;s:25:"vc_access_rules_templates";b:1;s:26:"vc_access_rules_shortcodes";b:1;s:28:"vc_access_rules_grid_builder";b:1;s:23:"vc_access_rules_presets";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:13:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:26:"vc_access_rules_post_types";b:1;s:30:"vc_access_rules_backend_editor";b:1;s:31:"vc_access_rules_frontend_editor";b:1;s:29:"vc_access_rules_post_settings";b:1;s:25:"vc_access_rules_templates";b:1;s:26:"vc_access_rules_shortcodes";b:1;s:28:"vc_access_rules_grid_builder";b:1;s:23:"vc_access_rules_presets";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}', 'yes');

CREATE TABLE IF NOT EXISTS `xwlpv_postmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2392 DEFAULT CHARSET=utf8;

REPLACE INTO `xwlpv_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(1, 2, '_wp_page_template', 'default'),
(2, 6, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(3, 6, '_edit_lock', '1480005404:1'),
(4, 6, '_edit_last', '2'),
(5, 6, '_wp_page_template', 'page-like-lp.php'),
(6, 6, '_wpb_vc_js_status', 'false'),
(2002, 1831, '_wp_attached_file', '2011/05/2.png'),
(9, 9, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(10, 9, '_wp_page_template', 'default'),
(11, 146, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(12, 146, '_wp_page_template', 'default'),
(13, 155, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(14, 155, '_wp_page_template', 'default'),
(15, 156, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(16, 156, '_wp_page_template', 'default'),
(17, 172, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(18, 172, '_wp_page_template', 'default'),
(19, 173, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(20, 173, '_wp_page_template', 'default'),
(21, 174, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(22, 174, '_wp_page_template', 'default'),
(23, 501, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(24, 501, '_wp_page_template', 'default'),
(25, 611, '_wp_attached_file', '2011/01/canola2.jpg'),
(26, 611, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:19:"2011/01/canola2.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"canola2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:19:"canola2-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"canola2-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:19:"canola2-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"5.6";s:6:"credit";s:0:"";s:6:"camera";s:18:"Canon PowerShot G2";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1094915268";s:9:"copyright";s:0:"";s:12:"focal_length";s:7:"16.8125";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:9:"0.0015625";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(27, 611, '_wp_attachment_image_alt', 'canola'),
(28, 611, '_wp_attachment_image_alt', 'canola'),
(29, 611, '_attachment_original_parent_id', '555'),
(30, 616, '_wp_attached_file', '2011/01/dsc20050727_091048_222.jpg'),
(31, 616, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:34:"2011/01/dsc20050727_091048_222.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:34:"dsc20050727_091048_222-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:34:"dsc20050727_091048_222-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:34:"dsc20050727_091048_222-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:34:"dsc20050727_091048_222-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"4";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1122455448";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"9.7";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:5:"0.004";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(32, 616, '_wp_attachment_image_alt', 'dsc20050727_091048_222'),
(33, 616, '_wp_attachment_image_alt', 'dsc20050727_091048_222'),
(34, 616, '_attachment_original_parent_id', '555'),
(35, 617, '_wp_attached_file', '2011/01/dsc20050813_115856_52.jpg'),
(36, 617, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:33:"2011/01/dsc20050813_115856_52.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"dsc20050813_115856_52-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:33:"dsc20050813_115856_52-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:33:"dsc20050813_115856_52-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:33:"dsc20050813_115856_52-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"3.2";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1123934337";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"9.7";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:5:"0.008";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(37, 617, '_wp_attachment_image_alt', 'dsc20050813_115856_52'),
(38, 617, '_wp_attachment_image_alt', 'dsc20050813_115856_52'),
(39, 617, '_attachment_original_parent_id', '555'),
(40, 701, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(41, 701, '_wp_page_template', 'template-fullwidth.php'),
(42, 703, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(43, 703, '_wp_page_template', 'default'),
(44, 754, '_wp_attached_file', '2011/07/100_5478.jpg'),
(45, 754, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:20:"2011/07/100_5478.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"100_5478-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"100_5478-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"100_5478-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"100_5478-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"100_5478-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"100_5478-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"100_5478-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"6.3";s:6:"credit";s:0:"";s:6:"camera";s:32:"KODAK DX7590 ZOOM DIGITAL CAMERA";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1145694068";s:9:"copyright";s:0:"";s:12:"focal_length";s:4:"17.5";s:3:"iso";s:2:"80";s:13:"shutter_speed";s:5:"0.002";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(46, 754, '_wp_attachment_image_alt', 'Bell on Wharf'),
(47, 754, '_wp_attachment_image_alt', 'Bell on Wharf'),
(48, 754, '_attachment_original_parent_id', '555'),
(49, 755, '_wp_attached_file', '2011/07/100_5540.jpg'),
(50, 755, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:20:"2011/07/100_5540.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"100_5540-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"100_5540-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"100_5540-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"100_5540-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"100_5540-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"100_5540-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"100_5540-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"4";s:6:"credit";s:0:"";s:6:"camera";s:32:"KODAK DX7590 ZOOM DIGITAL CAMERA";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1145697622";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"6.3";s:3:"iso";s:2:"80";s:13:"shutter_speed";s:7:"0.00125";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(51, 755, '_wp_attachment_image_alt', 'Golden Gate Bridge'),
(52, 755, '_wp_attachment_image_alt', 'Golden Gate Bridge'),
(53, 755, '_attachment_original_parent_id', '555'),
(54, 756, '_wp_attached_file', '2011/07/cep00032.jpg'),
(55, 756, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1500;s:6:"height";i:1200;s:4:"file";s:20:"2011/07/cep00032.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"cep00032-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"cep00032-300x240.jpg";s:5:"width";i:300;s:6:"height";i:240;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"cep00032-768x614.jpg";s:5:"width";i:768;s:6:"height";i:614;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"cep00032-1024x819.jpg";s:5:"width";i:1024;s:6:"height";i:819;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"cep00032-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"cep00032-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"cep00032-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"4";s:6:"credit";s:0:"";s:6:"camera";s:13:"Canon ELURA90";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1130775264";s:9:"copyright";s:0:"";s:12:"focal_length";s:4:"4.15";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:8:"0.002091";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(56, 756, '_wp_attachment_image_alt', 'Sunburst Over River'),
(57, 756, '_wp_attachment_image_alt', 'Sunburst Over River'),
(58, 756, '_attachment_original_parent_id', '555'),
(59, 757, '_wp_attached_file', '2011/07/dcp_2082.jpg'),
(60, 757, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1066;s:4:"file";s:20:"2011/07/dcp_2082.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"dcp_2082-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"dcp_2082-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"dcp_2082-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"dcp_2082-1024x682.jpg";s:5:"width";i:1024;s:6:"height";i:682;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"dcp_2082-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"dcp_2082-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"dcp_2082-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"5.6";s:6:"credit";s:0:"";s:6:"camera";s:32:"KODAK DX4900 ZOOM DIGITAL CAMERA";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1054666444";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"7.3";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:5:"0.002";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(61, 757, '_wp_attachment_image_alt', 'Boardwalk'),
(62, 757, '_wp_attachment_image_alt', 'Boardwalk'),
(63, 757, '_attachment_original_parent_id', '555'),
(64, 758, '_wp_attached_file', '2011/07/dsc03149.jpg'),
(65, 758, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1280;s:6:"height";i:960;s:4:"file";s:20:"2011/07/dsc03149.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"dsc03149-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"dsc03149-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"dsc03149-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"dsc03149-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"dsc03149-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"dsc03149-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"dsc03149-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"4";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1034618291";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"9.7";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:5:"0.004";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(66, 758, '_wp_attachment_image_alt', 'Yachtsody in Blue'),
(67, 758, '_wp_attachment_image_alt', 'Yachtsody in Blue'),
(68, 758, '_attachment_original_parent_id', '555'),
(69, 759, '_wp_attached_file', '2011/07/dsc04563.jpg'),
(70, 759, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:20:"2011/07/dsc04563.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"dsc04563-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"dsc04563-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"dsc04563-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"dsc04563-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"dsc04563-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"dsc04563-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"dsc04563-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"4";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1040567677";s:9:"copyright";s:0:"";s:12:"focal_length";s:4:"48.5";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:5:"0.002";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(71, 759, '_wp_attachment_image_alt', 'Rain Ripples'),
(72, 759, '_wp_attachment_image_alt', 'Rain Ripples'),
(73, 759, '_attachment_original_parent_id', '555'),
(74, 760, '_wp_attached_file', '2011/07/dsc09114.jpg'),
(75, 760, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:20:"2011/07/dsc09114.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"dsc09114-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"dsc09114-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"dsc09114-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"dsc09114-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"dsc09114-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"dsc09114-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"dsc09114-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"5.6";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1067174771";s:9:"copyright";s:0:"";s:12:"focal_length";s:4:"11.8";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:5:"0.002";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(76, 760, '_wp_attachment_image_alt', 'Sydney Harbor Bridge'),
(77, 760, '_wp_attachment_image_alt', 'Sydney Harbor Bridge'),
(78, 760, '_attachment_original_parent_id', '555'),
(79, 761, '_wp_attached_file', '2011/07/dsc20050102_192118_51.jpg'),
(80, 761, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:33:"2011/07/dsc20050102_192118_51.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"dsc20050102_192118_51-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:33:"dsc20050102_192118_51-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:33:"dsc20050102_192118_51-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:34:"dsc20050102_192118_51-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:33:"dsc20050102_192118_51-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:33:"dsc20050102_192118_51-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:33:"dsc20050102_192118_51-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"4";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1104693678";s:9:"copyright";s:0:"";s:12:"focal_length";s:4:"33.3";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:7:"0.00625";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(81, 761, '_wp_attachment_image_alt', 'Wind Farm'),
(82, 761, '_wp_attachment_image_alt', 'Wind Farm'),
(83, 761, '_attachment_original_parent_id', '555'),
(84, 762, '_wp_attached_file', '2011/07/dsc20051220_160808_102.jpg'),
(85, 762, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1066;s:4:"file";s:34:"2011/07/dsc20051220_160808_102.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:34:"dsc20051220_160808_102-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:34:"dsc20051220_160808_102-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:34:"dsc20051220_160808_102-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:35:"dsc20051220_160808_102-1024x682.jpg";s:5:"width";i:1024;s:6:"height";i:682;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:34:"dsc20051220_160808_102-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:34:"dsc20051220_160808_102-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:34:"dsc20051220_160808_102-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"2.5";s:6:"credit";s:0:"";s:6:"camera";s:13:"Canon EOS 10D";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1135094888";s:9:"copyright";s:0:"";s:12:"focal_length";s:2:"50";s:3:"iso";s:3:"400";s:13:"shutter_speed";s:17:"0.016666666666667";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(86, 762, '_wp_attachment_image_alt', 'Antique Farm Machinery'),
(87, 762, '_wp_attachment_image_alt', 'Antique Farm Machinery'),
(88, 762, '_attachment_original_parent_id', '555'),
(89, 763, '_wp_attached_file', '2011/07/dsc02085.jpg'),
(90, 763, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:20:"2011/07/dsc02085.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"dsc02085-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"dsc02085-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"dsc02085-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"dsc02085-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"dsc02085-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"dsc02085-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"dsc02085-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"2.9";s:6:"credit";s:0:"";s:6:"camera";s:8:"DSC-S930";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1288861799";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"6.4";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:5:"0.008";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(91, 763, '_wp_attachment_image_alt', 'Orange Iris'),
(92, 763, '_wp_attachment_image_alt', 'Orange Iris'),
(93, 763, '_attachment_original_parent_id', '555'),
(94, 764, '_wp_attached_file', '2011/07/dsc20051220_173257_119.jpg'),
(95, 764, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1066;s:4:"file";s:34:"2011/07/dsc20051220_173257_119.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:34:"dsc20051220_173257_119-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:34:"dsc20051220_173257_119-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:34:"dsc20051220_173257_119-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:35:"dsc20051220_173257_119-1024x682.jpg";s:5:"width";i:1024;s:6:"height";i:682;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:34:"dsc20051220_173257_119-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:34:"dsc20051220_173257_119-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:34:"dsc20051220_173257_119-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"6.7";s:6:"credit";s:0:"";s:6:"camera";s:13:"Canon EOS 10D";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1135099977";s:9:"copyright";s:0:"";s:12:"focal_length";s:2:"50";s:3:"iso";s:3:"400";s:13:"shutter_speed";s:18:"0.0013333333333333";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(96, 764, '_wp_attachment_image_alt', 'Rusty Rail'),
(97, 764, '_wp_attachment_image_alt', 'Rusty Rail'),
(98, 764, '_attachment_original_parent_id', '555'),
(99, 765, '_wp_attached_file', '2011/07/dscn3316.jpg'),
(100, 765, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:20:"2011/07/dscn3316.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"dscn3316-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"dscn3316-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"dscn3316-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"dscn3316-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"dscn3316-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"dscn3316-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"dscn3316-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"7.6";s:6:"credit";s:0:"";s:6:"camera";s:5:"E4300";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1170775967";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"8";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:18:"0.0045454545454545";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(101, 765, '_wp_attachment_image_alt', 'Sea and Rocks'),
(102, 765, '_wp_attachment_image_alt', 'Sea and Rocks'),
(103, 765, '_attachment_original_parent_id', '555'),
(104, 766, '_wp_attached_file', '2011/07/michelle_049.jpg'),
(105, 766, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:24:"2011/07/michelle_049.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:24:"michelle_049-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:24:"michelle_049-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:24:"michelle_049-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:25:"michelle_049-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:24:"michelle_049-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:24:"michelle_049-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:24:"michelle_049-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"7.1";s:6:"credit";s:0:"";s:6:"camera";s:18:"Canon PowerShot G3";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1096133874";s:9:"copyright";s:0:"";s:12:"focal_length";s:7:"15.8125";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:7:"0.00625";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(106, 766, '_wp_attachment_image_alt', 'Big Sur'),
(107, 766, '_wp_attachment_image_alt', 'Big Sur'),
(108, 766, '_attachment_original_parent_id', '555'),
(109, 767, '_wp_attached_file', '2011/07/windmill.jpg'),
(110, 767, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:20:"2011/07/windmill.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"windmill-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"windmill-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"windmill-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"windmill-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"windmill-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"windmill-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"windmill-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"5.6";s:6:"credit";s:0:"";s:6:"camera";s:8:"DiMAGE 7";s:7:"caption";s:7:"DCF 1.0";s:17:"created_timestamp";s:10:"1125077631";s:9:"copyright";s:0:"";s:12:"focal_length";s:11:"50.69140625";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:18:"0.0055555555555556";s:5:"title";s:7:"DCF 1.0";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(111, 767, '_wp_attachment_image_alt', 'Windmill'),
(112, 767, '_wp_attachment_image_alt', 'Windmill'),
(113, 767, '_attachment_original_parent_id', '555'),
(114, 768, '_wp_attached_file', '2011/07/img_0513-1.jpg'),
(115, 768, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:800;s:6:"height";i:533;s:4:"file";s:22:"2011/07/img_0513-1.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"img_0513-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"img_0513-1-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:22:"img_0513-1-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"img_0513-1-800x450.jpg";s:5:"width";i:800;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:22:"img_0513-1-800x450.jpg";s:5:"width";i:800;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:22:"img_0513-1-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"5.6";s:6:"credit";s:10:"Picasa 2.0";s:6:"camera";s:12:"Canon EOS 5D";s:7:"caption";s:32:"Alas! I have found my Shangri-La";s:17:"created_timestamp";s:10:"1158217614";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"105";s:3:"iso";s:3:"400";s:13:"shutter_speed";s:5:"0.005";s:5:"title";s:32:"Alas! I have found my Shangri-La";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(116, 768, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(117, 768, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(118, 768, '_attachment_original_parent_id', '555'),
(119, 703, '_edit_lock', '1478256170:1'),
(120, 703, '_wpb_vc_js_status', 'false'),
(1913, 1153, '_edit_lock', '1480414502:1'),
(1914, 1787, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(126, 9, '_wp_page_template', 'default'),
(127, 146, '_wp_page_template', 'default'),
(128, 155, '_wp_page_template', 'default'),
(129, 156, '_wp_page_template', 'default'),
(130, 172, '_wp_page_template', 'default'),
(131, 173, '_wp_page_template', 'default'),
(132, 174, '_wp_page_template', 'default'),
(133, 501, '_wp_page_template', 'default'),
(134, 611, '_wp_attachment_image_alt', 'canola'),
(135, 611, '_wp_attachment_image_alt', 'canola'),
(136, 611, '_attachment_original_parent_id', '555'),
(137, 616, '_wp_attachment_image_alt', 'dsc20050727_091048_222'),
(138, 616, '_wp_attachment_image_alt', 'dsc20050727_091048_222'),
(139, 616, '_attachment_original_parent_id', '555'),
(140, 617, '_wp_attachment_image_alt', 'dsc20050813_115856_52'),
(141, 617, '_wp_attachment_image_alt', 'dsc20050813_115856_52'),
(142, 617, '_attachment_original_parent_id', '555'),
(143, 701, '_wp_page_template', 'template-fullwidth.php'),
(144, 703, '_wp_page_template', 'default'),
(145, 754, '_wp_attachment_image_alt', 'Bell on Wharf'),
(146, 754, '_wp_attachment_image_alt', 'Bell on Wharf'),
(147, 754, '_attachment_original_parent_id', '555'),
(148, 755, '_wp_attachment_image_alt', 'Golden Gate Bridge'),
(149, 755, '_wp_attachment_image_alt', 'Golden Gate Bridge'),
(150, 755, '_attachment_original_parent_id', '555'),
(151, 756, '_wp_attachment_image_alt', 'Sunburst Over River'),
(152, 756, '_wp_attachment_image_alt', 'Sunburst Over River'),
(153, 756, '_attachment_original_parent_id', '555'),
(154, 757, '_wp_attachment_image_alt', 'Boardwalk'),
(155, 757, '_wp_attachment_image_alt', 'Boardwalk'),
(156, 757, '_attachment_original_parent_id', '555'),
(157, 758, '_wp_attachment_image_alt', 'Yachtsody in Blue'),
(158, 758, '_wp_attachment_image_alt', 'Yachtsody in Blue'),
(159, 758, '_attachment_original_parent_id', '555'),
(160, 759, '_wp_attachment_image_alt', 'Rain Ripples'),
(161, 759, '_wp_attachment_image_alt', 'Rain Ripples'),
(162, 759, '_attachment_original_parent_id', '555'),
(163, 760, '_wp_attachment_image_alt', 'Sydney Harbor Bridge'),
(164, 760, '_wp_attachment_image_alt', 'Sydney Harbor Bridge'),
(165, 760, '_attachment_original_parent_id', '555'),
(166, 761, '_wp_attachment_image_alt', 'Wind Farm'),
(167, 761, '_wp_attachment_image_alt', 'Wind Farm'),
(168, 761, '_attachment_original_parent_id', '555'),
(169, 762, '_wp_attachment_image_alt', 'Antique Farm Machinery'),
(170, 762, '_wp_attachment_image_alt', 'Antique Farm Machinery'),
(171, 762, '_attachment_original_parent_id', '555'),
(172, 763, '_wp_attachment_image_alt', 'Orange Iris'),
(173, 763, '_wp_attachment_image_alt', 'Orange Iris'),
(174, 763, '_attachment_original_parent_id', '555'),
(175, 764, '_wp_attachment_image_alt', 'Rusty Rail'),
(176, 764, '_wp_attachment_image_alt', 'Rusty Rail'),
(177, 764, '_attachment_original_parent_id', '555'),
(178, 765, '_wp_attachment_image_alt', 'Sea and Rocks'),
(179, 765, '_wp_attachment_image_alt', 'Sea and Rocks'),
(180, 765, '_attachment_original_parent_id', '555'),
(181, 766, '_wp_attachment_image_alt', 'Big Sur'),
(182, 766, '_wp_attachment_image_alt', 'Big Sur'),
(183, 766, '_attachment_original_parent_id', '555'),
(184, 767, '_wp_attachment_image_alt', 'Windmill'),
(185, 767, '_wp_attachment_image_alt', 'Windmill'),
(186, 767, '_attachment_original_parent_id', '555'),
(187, 768, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(188, 768, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(189, 768, '_attachment_original_parent_id', '555'),
(190, 773, '_wp_attached_file', '2011/07/img_0747-1.jpg'),
(191, 773, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1066;s:4:"file";s:22:"2011/07/img_0747-1.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"img_0747-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:22:"img_0747-1-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:22:"img_0747-1-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:23:"img_0747-1-1024x682.jpg";s:5:"width";i:1024;s:6:"height";i:682;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:22:"img_0747-1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:22:"img_0747-1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:22:"img_0747-1-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:2:"11";s:6:"credit";s:0:"";s:6:"camera";s:19:"Canon EOS REBEL T2i";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1271654325";s:9:"copyright";s:0:"";s:12:"focal_length";s:2:"18";s:3:"iso";s:3:"800";s:13:"shutter_speed";s:7:"0.00125";s:5:"title";s:0:"";s:11:"orientation";s:1:"1";s:8:"keywords";a:0:{}}}'),
(192, 773, '_wp_attachment_image_alt', 'Brazil Beach'),
(193, 773, '_wp_attachment_image_alt', 'Brazil Beach'),
(194, 773, '_attachment_original_parent_id', '555'),
(195, 774, '_wp_attached_file', '2011/07/img_0767.jpg'),
(196, 774, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:800;s:6:"height";i:533;s:4:"file";s:20:"2011/07/img_0767.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"img_0767-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"img_0767-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"img_0767-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"img_0767-800x450.jpg";s:5:"width";i:800;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"img_0767-800x450.jpg";s:5:"width";i:800;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"img_0767-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:2:"10";s:6:"credit";s:10:"Picasa 2.6";s:6:"camera";s:12:"Canon EOS 5D";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1158320386";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"105";s:3:"iso";s:3:"400";s:13:"shutter_speed";s:5:"0.002";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(197, 774, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(198, 774, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(199, 774, '_attachment_original_parent_id', '555'),
(1919, 1787, '_thumbnail_id', '1788'),
(1929, 1792, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:760;s:6:"height";i:514;s:4:"file";s:21:"2016/11/3-760x514.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"3-760x514-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"3-760x514-300x203.jpg";s:5:"width";i:300;s:6:"height";i:203;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"3-760x514-760x450.jpg";s:5:"width";i:760;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"3-760x514-760x450.jpg";s:5:"width";i:760;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:21:"3-760x514-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2183, 1842, '_wpb_shortcodes_custom_css', '.vc_custom_1481618532323{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/about.jpg?id=1964) !important;}'),
(1925, 1791, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1926, 1791, '_edit_lock', '1478265239:1'),
(1927, 1791, '_edit_last', '1'),
(1928, 1792, '_wp_attached_file', '2016/11/3-760x514.jpg'),
(205, 807, '_wp_attached_file', '2012/06/dsc20040724_152504_532.jpg'),
(206, 807, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:34:"2012/06/dsc20040724_152504_532.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"2";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1090682704";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"9.7";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:4:"0.02";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(207, 807, '_attachment_original_parent_id', '555'),
(208, 811, '_wp_attached_file', '2012/06/dsc20050604_133440_34211.jpg'),
(209, 811, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:36:"2012/06/dsc20050604_133440_34211.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"2";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1117892080";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"9.7";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:6:"0.0125";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(210, 811, '_attachment_original_parent_id', '555'),
(211, 821, '_wp_attached_file', '2012/07/originaldixielandjazzbandwithalbernard-stlouisblues.mp3'),
(212, 821, '_wp_attachment_metadata', 'a:20:{s:10:"dataformat";s:3:"mp3";s:8:"channels";i:2;s:11:"sample_rate";i:44100;s:7:"bitrate";i:128000;s:11:"channelmode";s:12:"joint stereo";s:12:"bitrate_mode";s:3:"cbr";s:8:"lossless";b:0;s:15:"encoder_options";s:6:"CBR128";s:17:"compression_ratio";d:0.090702947845804988;s:10:"fileformat";s:3:"mp3";s:8:"filesize";i:3043247;s:9:"mime_type";s:10:"audio/mpeg";s:6:"length";i:190;s:16:"length_formatted";s:4:"3:10";s:7:"comment";s:4:"None";s:4:"year";s:4:"1921";s:5:"title";s:22:"St. Louis Blues (1921)";s:6:"artist";s:44:"Original Dixieland Jazz Band with Al Bernard";s:5:"genre";s:12:"Acoustic Era";s:5:"album";s:12:"Victor-18772";}'),
(213, 827, '_wp_attached_file', '2012/07/manhattansummer.jpg'),
(214, 827, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:27:"2012/07/manhattansummer.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:27:"manhattansummer-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:27:"manhattansummer-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:27:"manhattansummer-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:27:"manhattansummer-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"2.8";s:6:"credit";s:0:"";s:6:"camera";s:11:"C990Z,D490Z";s:7:"caption";s:22:"OLYMPUS DIGITAL CAMERA";s:17:"created_timestamp";s:10:"1089358496";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"5.6";s:3:"iso";s:3:"200";s:13:"shutter_speed";s:17:"0.076923076923077";s:5:"title";s:22:"OLYMPUS DIGITAL CAMERA";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(215, 967, '_wp_attached_file', '2013/03/image-alignment-580x300.jpg'),
(216, 967, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:580;s:6:"height";i:300;s:4:"file";s:35:"2013/03/image-alignment-580x300.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:35:"image-alignment-580x300-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:35:"image-alignment-580x300-300x155.jpg";s:5:"width";i:300;s:6:"height";i:155;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(217, 967, 'pre_import_post_parent', '0'),
(218, 967, 'pre_import_post_id', '906'),
(219, 967, '_wp_attachment_image_alt', 'Image Alignment 580x300'),
(220, 967, '_attachment_original_parent_id', '903'),
(221, 968, '_wp_attached_file', '2013/03/image-alignment-150x150.jpg'),
(222, 968, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:150;s:6:"height";i:150;s:4:"file";s:35:"2013/03/image-alignment-150x150.jpg";s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(223, 968, 'pre_import_post_parent', '0'),
(224, 968, 'pre_import_post_id', '904'),
(225, 968, '_wp_attachment_image_alt', 'Image Alignment 150x150'),
(226, 968, '_attachment_original_parent_id', '903'),
(227, 1022, '_wp_attached_file', '2013/03/featured-image-horizontal.jpg'),
(228, 1022, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:580;s:6:"height";i:300;s:4:"file";s:37:"2013/03/featured-image-horizontal.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:37:"featured-image-horizontal-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:37:"featured-image-horizontal-300x155.jpg";s:5:"width";i:300;s:6:"height";i:155;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(229, 1022, 'pre_import_post_parent', '0'),
(230, 1022, 'pre_import_post_id', '1022'),
(231, 1022, '_wp_attachment_image_alt', 'Horizontal Featured Image'),
(232, 1022, '_attachment_original_parent_id', '1011'),
(233, 1023, '_wp_attached_file', '2013/03/soworthloving-wallpaper.jpg'),
(234, 1023, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1200;s:4:"file";s:35:"2013/03/soworthloving-wallpaper.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:35:"soworthloving-wallpaper-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:35:"soworthloving-wallpaper-300x188.jpg";s:5:"width";i:300;s:6:"height";i:188;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:35:"soworthloving-wallpaper-768x480.jpg";s:5:"width";i:768;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:36:"soworthloving-wallpaper-1024x640.jpg";s:5:"width";i:1024;s:6:"height";i:640;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:35:"soworthloving-wallpaper-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:35:"soworthloving-wallpaper-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:35:"soworthloving-wallpaper-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(235, 1023, 'pre_import_post_parent', '0'),
(236, 1023, 'pre_import_post_id', '842'),
(237, 1023, '_wp_attachment_image_alt', 'I Am Worth Loving Wallpaper'),
(238, 1025, '_wp_attached_file', '2013/03/image-alignment-300x200.jpg'),
(239, 1025, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:300;s:6:"height";i:200;s:4:"file";s:35:"2013/03/image-alignment-300x200.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:35:"image-alignment-300x200-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:35:"image-alignment-300x200-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(240, 1025, 'pre_import_post_parent', '0'),
(241, 1025, 'pre_import_post_id', '905'),
(242, 1025, '_wp_attachment_image_alt', 'Image Alignment 300x200'),
(243, 1025, '_attachment_original_parent_id', '903'),
(244, 1027, '_wp_attached_file', '2013/03/featured-image-vertical.jpg'),
(245, 1027, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:300;s:6:"height";i:580;s:4:"file";s:35:"2013/03/featured-image-vertical.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:35:"featured-image-vertical-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:35:"featured-image-vertical-155x300.jpg";s:5:"width";i:155;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:35:"featured-image-vertical-300x450.jpg";s:5:"width";i:300;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:35:"featured-image-vertical-300x450.jpg";s:5:"width";i:300;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:35:"featured-image-vertical-300x514.jpg";s:5:"width";i:300;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(246, 1027, 'pre_import_post_parent', '0'),
(247, 1027, 'pre_import_post_id', '1024'),
(248, 1027, '_wp_attachment_image_alt', 'Horizontal Featured Image');
REPLACE INTO `xwlpv_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(249, 1027, '_attachment_original_parent_id', '1016'),
(250, 1029, '_wp_attached_file', '2013/03/image-alignment-1200x4002.jpg'),
(251, 1029, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1200;s:6:"height";i:400;s:4:"file";s:37:"2013/03/image-alignment-1200x4002.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:37:"image-alignment-1200x4002-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:37:"image-alignment-1200x4002-300x100.jpg";s:5:"width";i:300;s:6:"height";i:100;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:37:"image-alignment-1200x4002-768x256.jpg";s:5:"width";i:768;s:6:"height";i:256;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:38:"image-alignment-1200x4002-1024x341.jpg";s:5:"width";i:1024;s:6:"height";i:341;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:37:"image-alignment-1200x4002-849x400.jpg";s:5:"width";i:849;s:6:"height";i:400;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:37:"image-alignment-1200x4002-849x400.jpg";s:5:"width";i:849;s:6:"height";i:400;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:37:"image-alignment-1200x4002-760x400.jpg";s:5:"width";i:760;s:6:"height";i:400;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:37:"image-alignment-1200x4002-480x400.jpg";s:5:"width";i:480;s:6:"height";i:400;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(252, 1029, 'pre_import_post_parent', '0'),
(253, 1029, 'pre_import_post_id', '907'),
(254, 1029, '_wp_attachment_image_alt', 'Image Alignment 1200x4002'),
(255, 1029, '_attachment_original_parent_id', '903'),
(256, 1045, '_wp_attached_file', '2013/03/unicorn-wallpaper.jpg'),
(257, 1045, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1600;s:6:"height";i:1200;s:4:"file";s:29:"2013/03/unicorn-wallpaper.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"unicorn-wallpaper-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:29:"unicorn-wallpaper-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:29:"unicorn-wallpaper-768x576.jpg";s:5:"width";i:768;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:30:"unicorn-wallpaper-1024x768.jpg";s:5:"width";i:1024;s:6:"height";i:768;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:29:"unicorn-wallpaper-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:29:"unicorn-wallpaper-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:29:"unicorn-wallpaper-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:29:"unicorn-wallpaper-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(258, 1045, 'pre_import_post_parent', '0'),
(259, 1045, 'pre_import_post_id', '967'),
(260, 1045, '_wp_attachment_image_alt', 'Unicorn Wallpaper'),
(261, 1045, '_attachment_original_parent_id', '568'),
(262, 1046, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(263, 1046, '_menu_item_type', 'custom'),
(264, 1046, '_menu_item_menu_item_parent', '0'),
(265, 1046, '_menu_item_object_id', '1046'),
(266, 1046, '_menu_item_object', 'custom'),
(267, 1046, '_menu_item_target', ''),
(268, 1046, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(269, 1046, '_menu_item_xfn', ''),
(270, 1046, '_menu_item_url', '#'),
(271, 1047, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(272, 1047, '_menu_item_type', 'custom'),
(273, 1047, '_menu_item_menu_item_parent', '0'),
(274, 1047, '_menu_item_object_id', '1047'),
(275, 1047, '_menu_item_object', 'custom'),
(276, 1047, '_menu_item_target', ''),
(277, 1047, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(278, 1047, '_menu_item_xfn', ''),
(279, 1047, '_menu_item_url', '#'),
(280, 1048, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(281, 1048, '_menu_item_type', 'taxonomy'),
(282, 1048, '_menu_item_menu_item_parent', '1047'),
(283, 1048, '_menu_item_object_id', '29'),
(284, 1048, '_menu_item_object', 'category'),
(285, 1048, '_menu_item_target', ''),
(286, 1048, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(287, 1048, '_menu_item_xfn', ''),
(288, 1048, '_menu_item_url', ''),
(1930, 1791, '_thumbnail_id', '1792'),
(298, 1050, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(299, 1050, '_menu_item_type', 'taxonomy'),
(300, 1050, '_menu_item_menu_item_parent', '1047'),
(301, 1050, '_menu_item_object_id', '50'),
(302, 1050, '_menu_item_object', 'category'),
(303, 1050, '_menu_item_target', ''),
(304, 1050, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(305, 1050, '_menu_item_xfn', ''),
(306, 1050, '_menu_item_url', ''),
(307, 1051, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(308, 1051, '_menu_item_type', 'custom'),
(309, 1051, '_menu_item_menu_item_parent', '0'),
(310, 1051, '_menu_item_object_id', '1051'),
(311, 1051, '_menu_item_object', 'custom'),
(312, 1051, '_menu_item_target', ''),
(313, 1051, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(314, 1051, '_menu_item_xfn', ''),
(315, 1051, '_menu_item_url', '#'),
(316, 1052, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(317, 1052, '_menu_item_type', 'custom'),
(318, 1052, '_menu_item_menu_item_parent', '1051'),
(319, 1052, '_menu_item_object_id', '1052'),
(320, 1052, '_menu_item_object', 'custom'),
(321, 1052, '_menu_item_target', ''),
(322, 1052, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(323, 1052, '_menu_item_xfn', ''),
(324, 1052, '_menu_item_url', '#'),
(325, 1053, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(326, 1053, '_menu_item_type', 'custom'),
(327, 1053, '_menu_item_menu_item_parent', '1052'),
(328, 1053, '_menu_item_object_id', '1053'),
(329, 1053, '_menu_item_object', 'custom'),
(330, 1053, '_menu_item_target', ''),
(331, 1053, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(332, 1053, '_menu_item_xfn', ''),
(333, 1053, '_menu_item_url', '#'),
(334, 1054, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(335, 1054, '_menu_item_type', 'custom'),
(336, 1054, '_menu_item_menu_item_parent', '1053'),
(337, 1054, '_menu_item_object_id', '1054'),
(338, 1054, '_menu_item_object', 'custom'),
(339, 1054, '_menu_item_target', ''),
(340, 1054, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(341, 1054, '_menu_item_xfn', ''),
(342, 1054, '_menu_item_url', '#'),
(343, 1055, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(344, 1055, '_menu_item_type', 'custom'),
(345, 1055, '_menu_item_menu_item_parent', '1054'),
(346, 1055, '_menu_item_object_id', '1055'),
(347, 1055, '_menu_item_object', 'custom'),
(348, 1055, '_menu_item_target', ''),
(349, 1055, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(350, 1055, '_menu_item_xfn', ''),
(351, 1055, '_menu_item_url', '#'),
(352, 1056, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(353, 1056, '_menu_item_type', 'custom'),
(354, 1056, '_menu_item_menu_item_parent', '1055'),
(355, 1056, '_menu_item_object_id', '1056'),
(356, 1056, '_menu_item_object', 'custom'),
(357, 1056, '_menu_item_target', ''),
(358, 1056, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(359, 1056, '_menu_item_xfn', ''),
(360, 1056, '_menu_item_url', '#'),
(361, 1057, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(362, 1057, '_menu_item_type', 'custom'),
(363, 1057, '_menu_item_menu_item_parent', '1056'),
(364, 1057, '_menu_item_object_id', '1057'),
(365, 1057, '_menu_item_object', 'custom'),
(366, 1057, '_menu_item_target', ''),
(367, 1057, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(368, 1057, '_menu_item_xfn', ''),
(369, 1057, '_menu_item_url', '#'),
(370, 1058, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(371, 1058, '_menu_item_type', 'custom'),
(372, 1058, '_menu_item_menu_item_parent', '1057'),
(373, 1058, '_menu_item_object_id', '1058'),
(374, 1058, '_menu_item_object', 'custom'),
(375, 1058, '_menu_item_target', ''),
(376, 1058, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(377, 1058, '_menu_item_xfn', ''),
(378, 1058, '_menu_item_url', '#'),
(379, 1059, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(380, 1059, '_menu_item_type', 'custom'),
(381, 1059, '_menu_item_menu_item_parent', '1058'),
(382, 1059, '_menu_item_object_id', '1059'),
(383, 1059, '_menu_item_object', 'custom'),
(384, 1059, '_menu_item_target', ''),
(385, 1059, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(386, 1059, '_menu_item_xfn', ''),
(387, 1059, '_menu_item_url', '#'),
(388, 1060, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(389, 1060, '_menu_item_type', 'custom'),
(390, 1060, '_menu_item_menu_item_parent', '1059'),
(391, 1060, '_menu_item_object_id', '1060'),
(392, 1060, '_menu_item_object', 'custom'),
(393, 1060, '_menu_item_target', ''),
(394, 1060, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(395, 1060, '_menu_item_xfn', ''),
(396, 1060, '_menu_item_url', '#'),
(397, 1061, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(398, 1061, '_menu_item_type', 'custom'),
(399, 1061, '_menu_item_menu_item_parent', '1060'),
(400, 1061, '_menu_item_object_id', '1061'),
(401, 1061, '_menu_item_object', 'custom'),
(402, 1061, '_menu_item_target', ''),
(403, 1061, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(404, 1061, '_menu_item_xfn', ''),
(405, 1061, '_menu_item_url', '#'),
(406, 1062, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(407, 1062, '_menu_item_type', 'custom'),
(408, 1062, '_menu_item_menu_item_parent', '0'),
(409, 1062, '_menu_item_object_id', '1062'),
(410, 1062, '_menu_item_object', 'custom'),
(411, 1062, '_menu_item_target', ''),
(412, 1062, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(413, 1062, '_menu_item_xfn', ''),
(414, 1062, '_menu_item_url', '#'),
(415, 1063, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(416, 1063, '_menu_item_type', 'custom'),
(417, 1063, '_menu_item_menu_item_parent', '0'),
(418, 1063, '_menu_item_object_id', '1063'),
(419, 1063, '_menu_item_object', 'custom'),
(420, 1063, '_menu_item_target', ''),
(421, 1063, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(422, 1063, '_menu_item_xfn', ''),
(423, 1063, '_menu_item_url', '#'),
(424, 1064, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(425, 1064, '_menu_item_type', 'custom'),
(426, 1064, '_menu_item_menu_item_parent', '1062'),
(427, 1064, '_menu_item_object_id', '1064'),
(428, 1064, '_menu_item_object', 'custom'),
(429, 1064, '_menu_item_target', ''),
(430, 1064, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(431, 1064, '_menu_item_xfn', ''),
(432, 1064, '_menu_item_url', '#'),
(433, 1065, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(434, 1065, '_menu_item_type', 'custom'),
(435, 1065, '_menu_item_menu_item_parent', '1062'),
(436, 1065, '_menu_item_object_id', '1065'),
(437, 1065, '_menu_item_object', 'custom'),
(438, 1065, '_menu_item_target', ''),
(439, 1065, '_menu_item_classes', 'a:1:{i:0;s:21:"custom-menu-css-class";}'),
(440, 1065, '_menu_item_xfn', ''),
(441, 1065, '_menu_item_url', '#'),
(442, 1066, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(443, 1066, '_menu_item_type', 'custom'),
(444, 1066, '_menu_item_menu_item_parent', '1062'),
(445, 1066, '_menu_item_object_id', '1066'),
(446, 1066, '_menu_item_object', 'custom'),
(447, 1066, '_menu_item_target', '_blank'),
(448, 1066, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(449, 1066, '_menu_item_xfn', ''),
(450, 1066, '_menu_item_url', 'http://apple.com'),
(451, 1628, '_wp_attached_file', '2013/04/triforce-wallpaper.jpg'),
(452, 1628, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1131;s:6:"height";i:707;s:4:"file";s:30:"2013/04/triforce-wallpaper.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"triforce-wallpaper-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:30:"triforce-wallpaper-300x188.jpg";s:5:"width";i:300;s:6:"height";i:188;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:30:"triforce-wallpaper-768x480.jpg";s:5:"width";i:768;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:31:"triforce-wallpaper-1024x640.jpg";s:5:"width";i:1024;s:6:"height";i:640;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:30:"triforce-wallpaper-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:30:"triforce-wallpaper-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:30:"triforce-wallpaper-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:30:"triforce-wallpaper-480x707.jpg";s:5:"width";i:480;s:6:"height";i:707;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(453, 1629, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(454, 1629, '_menu_item_type', 'custom'),
(455, 1629, '_menu_item_menu_item_parent', '0'),
(456, 1629, '_menu_item_object_id', '1629'),
(457, 1629, '_menu_item_object', 'custom'),
(458, 1629, '_menu_item_target', ''),
(459, 1629, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(460, 1629, '_menu_item_xfn', ''),
(461, 1629, '_menu_item_url', 'http://wpthemetestdata.wordpress.com/'),
(462, 1630, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(463, 1630, '_menu_item_type', 'post_type'),
(464, 1630, '_menu_item_menu_item_parent', '0'),
(465, 1630, '_menu_item_object_id', '703'),
(466, 1630, '_menu_item_object', 'page'),
(467, 1630, '_menu_item_target', ''),
(468, 1630, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(469, 1630, '_menu_item_xfn', ''),
(470, 1630, '_menu_item_url', ''),
(471, 1631, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(472, 1631, '_menu_item_type', 'post_type'),
(473, 1631, '_menu_item_menu_item_parent', '0'),
(474, 1631, '_menu_item_object_id', '9'),
(475, 1631, '_menu_item_object', 'page'),
(476, 1631, '_menu_item_target', ''),
(477, 1631, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(478, 1631, '_menu_item_xfn', ''),
(479, 1631, '_menu_item_url', ''),
(480, 1632, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(481, 1632, '_menu_item_type', 'post_type'),
(482, 1632, '_menu_item_menu_item_parent', '1631'),
(483, 1632, '_menu_item_object_id', '501'),
(484, 1632, '_menu_item_object', 'page'),
(485, 1632, '_menu_item_target', ''),
(486, 1632, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(487, 1632, '_menu_item_xfn', ''),
(488, 1632, '_menu_item_url', ''),
(489, 1633, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(490, 1633, '_menu_item_type', 'post_type'),
(491, 1633, '_menu_item_menu_item_parent', '1631'),
(492, 1633, '_menu_item_object_id', '155'),
(493, 1633, '_menu_item_object', 'page'),
(494, 1633, '_menu_item_target', ''),
(495, 1633, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(496, 1633, '_menu_item_xfn', ''),
(497, 1633, '_menu_item_url', ''),
(498, 1634, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(499, 1634, '_menu_item_type', 'post_type'),
(500, 1634, '_menu_item_menu_item_parent', '1631'),
(501, 1634, '_menu_item_object_id', '156'),
(502, 1634, '_menu_item_object', 'page'),
(503, 1634, '_menu_item_target', ''),
(504, 1634, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(505, 1634, '_menu_item_xfn', ''),
(506, 1634, '_menu_item_url', ''),
(507, 1635, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(508, 1635, '_menu_item_type', 'post_type'),
(509, 1635, '_menu_item_menu_item_parent', '0'),
(510, 1635, '_menu_item_object_id', '146'),
(511, 1635, '_menu_item_object', 'page'),
(512, 1635, '_menu_item_target', ''),
(513, 1635, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(514, 1635, '_menu_item_xfn', ''),
(515, 1635, '_menu_item_url', ''),
(516, 1636, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(517, 1636, '_menu_item_type', 'custom'),
(518, 1636, '_menu_item_menu_item_parent', '0'),
(519, 1636, '_menu_item_object_id', '1636'),
(520, 1636, '_menu_item_object', 'custom'),
(521, 1636, '_menu_item_target', ''),
(522, 1636, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(523, 1636, '_menu_item_xfn', ''),
(524, 1636, '_menu_item_url', 'http://wpthemetestdata.wordpress.com/'),
(2064, 1883, '_edit_last', '1'),
(2063, 1883, '_edit_lock', '1481798926:1'),
(2062, 1883, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2195, 1931, '_wp_attached_file', '2016/09/slide1.jpg'),
(2357, 1999, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2059, 1880, '_thumbnail_id', '1816'),
(2058, 1880, '_edit_last', '1'),
(2057, 1880, '_edit_lock', '1481740737:1'),
(2056, 1880, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2055, 1879, '_thumbnail_id', '1815'),
(2054, 1879, '_edit_last', '1'),
(2053, 1879, '_edit_lock', '1481740736:1'),
(543, 1639, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(544, 1639, '_menu_item_type', 'post_type'),
(545, 1639, '_menu_item_menu_item_parent', '0'),
(546, 1639, '_menu_item_object_id', '9'),
(547, 1639, '_menu_item_object', 'page'),
(548, 1639, '_menu_item_target', ''),
(549, 1639, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(550, 1639, '_menu_item_xfn', ''),
(551, 1639, '_menu_item_url', ''),
(552, 1640, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(553, 1640, '_menu_item_type', 'post_type'),
(554, 1640, '_menu_item_menu_item_parent', '1639'),
(555, 1640, '_menu_item_object_id', '501'),
(556, 1640, '_menu_item_object', 'page'),
(557, 1640, '_menu_item_target', ''),
(558, 1640, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(559, 1640, '_menu_item_xfn', ''),
(560, 1640, '_menu_item_url', ''),
(561, 1641, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(562, 1641, '_menu_item_type', 'post_type'),
(563, 1641, '_menu_item_menu_item_parent', '1639'),
(564, 1641, '_menu_item_object_id', '155'),
(565, 1641, '_menu_item_object', 'page'),
(566, 1641, '_menu_item_target', ''),
(567, 1641, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(568, 1641, '_menu_item_xfn', ''),
(569, 1641, '_menu_item_url', ''),
(570, 1642, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(571, 1642, '_menu_item_type', 'post_type'),
(572, 1642, '_menu_item_menu_item_parent', '1639'),
(573, 1642, '_menu_item_object_id', '156'),
(574, 1642, '_menu_item_object', 'page'),
(575, 1642, '_menu_item_target', ''),
(576, 1642, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(577, 1642, '_menu_item_xfn', ''),
(578, 1642, '_menu_item_url', ''),
(579, 1643, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(580, 1643, '_menu_item_type', 'post_type'),
(581, 1643, '_menu_item_menu_item_parent', '0'),
(582, 1643, '_menu_item_object_id', '174'),
(583, 1643, '_menu_item_object', 'page'),
(584, 1643, '_menu_item_target', ''),
(585, 1643, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(586, 1643, '_menu_item_xfn', ''),
(587, 1643, '_menu_item_url', ''),
(588, 1644, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(589, 1644, '_menu_item_type', 'post_type'),
(590, 1644, '_menu_item_menu_item_parent', '1643'),
(591, 1644, '_menu_item_object_id', '173'),
(592, 1644, '_menu_item_object', 'page'),
(593, 1644, '_menu_item_target', ''),
(594, 1644, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(595, 1644, '_menu_item_xfn', ''),
(596, 1644, '_menu_item_url', ''),
(2052, 1879, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2051, 1878, '_thumbnail_id', '1818'),
(2050, 1878, '_edit_last', '1'),
(2049, 1878, '_edit_lock', '1481740738:1'),
(2048, 1878, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2042, 1871, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1080;s:4:"file";s:20:"2016/11/projects.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"projects-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"projects-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"projects-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"projects-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"projects-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"projects-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"projects-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:20:"projects-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2037, 1867, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1080;s:4:"file";s:19:"2016/11/project.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"project-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:19:"project-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:19:"project-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:20:"project-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"project-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:19:"project-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:19:"project-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:19:"project-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2036, 1867, '_wp_attached_file', '2016/11/project.jpg'),
(2035, 1862, '_wpb_vc_js_status', 'true'),
(615, 1686, '_wp_attached_file', '2013/09/dsc20040724_152504_532.jpg'),
(616, 1686, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:34:"2013/09/dsc20040724_152504_532.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:34:"dsc20040724_152504_532-480x480.jpg";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"2";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1090682704";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"9.7";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:4:"0.02";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(617, 1687, '_wp_attached_file', '2013/09/dsc20050604_133440_34211.jpg'),
(618, 1687, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:36:"2013/09/dsc20050604_133440_34211.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:36:"dsc20050604_133440_34211-480x480.jpg";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"2";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1117892080";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"9.7";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:6:"0.0125";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1912, 1171, '_edit_lock', '1478281972:1'),
(2196, 1931, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1280;s:4:"file";s:18:"2016/09/slide1.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"slide1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"slide1-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:18:"slide1-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:19:"slide1-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"slide1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:18:"slide1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:18:"slide1-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:18:"slide1-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(621, 9, '_wp_page_template', 'default'),
(622, 146, '_wp_page_template', 'default'),
(623, 155, '_wp_page_template', 'default'),
(624, 156, '_wp_page_template', 'default'),
(625, 172, '_wp_page_template', 'default'),
(626, 173, '_wp_page_template', 'default'),
(627, 174, '_wp_page_template', 'default'),
(628, 501, '_wp_page_template', 'default'),
(629, 611, '_wp_attachment_image_alt', 'canola'),
(630, 611, '_wp_attachment_image_alt', 'canola'),
(631, 611, '_attachment_original_parent_id', '555'),
(632, 616, '_wp_attachment_image_alt', 'dsc20050727_091048_222'),
(633, 616, '_wp_attachment_image_alt', 'dsc20050727_091048_222'),
(634, 616, '_attachment_original_parent_id', '555'),
(635, 617, '_wp_attachment_image_alt', 'dsc20050813_115856_52'),
(636, 617, '_wp_attachment_image_alt', 'dsc20050813_115856_52'),
(637, 617, '_attachment_original_parent_id', '555'),
(638, 701, '_wp_page_template', 'template-fullwidth.php'),
(639, 703, '_wp_page_template', 'default'),
(640, 754, '_wp_attachment_image_alt', 'Bell on Wharf'),
(641, 754, '_wp_attachment_image_alt', 'Bell on Wharf'),
(642, 754, '_attachment_original_parent_id', '555'),
(643, 755, '_wp_attachment_image_alt', 'Golden Gate Bridge'),
(644, 755, '_wp_attachment_image_alt', 'Golden Gate Bridge'),
(645, 755, '_attachment_original_parent_id', '555'),
(646, 756, '_wp_attachment_image_alt', 'Sunburst Over River'),
(647, 756, '_wp_attachment_image_alt', 'Sunburst Over River'),
(648, 756, '_attachment_original_parent_id', '555'),
(649, 757, '_wp_attachment_image_alt', 'Boardwalk'),
(650, 757, '_wp_attachment_image_alt', 'Boardwalk'),
(651, 757, '_attachment_original_parent_id', '555'),
(652, 758, '_wp_attachment_image_alt', 'Yachtsody in Blue'),
(653, 758, '_wp_attachment_image_alt', 'Yachtsody in Blue'),
(654, 758, '_attachment_original_parent_id', '555'),
(655, 759, '_wp_attachment_image_alt', 'Rain Ripples'),
(656, 759, '_wp_attachment_image_alt', 'Rain Ripples'),
(657, 759, '_attachment_original_parent_id', '555'),
(658, 760, '_wp_attachment_image_alt', 'Sydney Harbor Bridge'),
(659, 760, '_wp_attachment_image_alt', 'Sydney Harbor Bridge'),
(660, 760, '_attachment_original_parent_id', '555'),
(661, 761, '_wp_attachment_image_alt', 'Wind Farm'),
(662, 761, '_wp_attachment_image_alt', 'Wind Farm'),
(663, 761, '_attachment_original_parent_id', '555'),
(664, 762, '_wp_attachment_image_alt', 'Antique Farm Machinery'),
(665, 762, '_wp_attachment_image_alt', 'Antique Farm Machinery'),
(666, 762, '_attachment_original_parent_id', '555'),
(667, 763, '_wp_attachment_image_alt', 'Orange Iris'),
(668, 763, '_wp_attachment_image_alt', 'Orange Iris'),
(669, 763, '_attachment_original_parent_id', '555'),
(670, 764, '_wp_attachment_image_alt', 'Rusty Rail'),
(671, 764, '_wp_attachment_image_alt', 'Rusty Rail'),
(672, 764, '_attachment_original_parent_id', '555'),
(673, 765, '_wp_attachment_image_alt', 'Sea and Rocks'),
(674, 765, '_wp_attachment_image_alt', 'Sea and Rocks'),
(675, 765, '_attachment_original_parent_id', '555'),
(676, 766, '_wp_attachment_image_alt', 'Big Sur'),
(677, 766, '_wp_attachment_image_alt', 'Big Sur'),
(678, 766, '_attachment_original_parent_id', '555'),
(679, 767, '_wp_attachment_image_alt', 'Windmill'),
(680, 767, '_wp_attachment_image_alt', 'Windmill'),
(681, 767, '_attachment_original_parent_id', '555'),
(682, 768, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(683, 768, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(684, 768, '_attachment_original_parent_id', '555'),
(685, 773, '_wp_attachment_image_alt', 'Brazil Beach'),
(686, 773, '_wp_attachment_image_alt', 'Brazil Beach'),
(687, 773, '_attachment_original_parent_id', '555'),
(688, 774, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(689, 774, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(690, 774, '_attachment_original_parent_id', '555'),
(1918, 1788, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:760;s:6:"height";i:514;s:4:"file";s:21:"2016/11/1-760x514.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"1-760x514-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"1-760x514-300x203.jpg";s:5:"width";i:300;s:6:"height";i:203;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"1-760x514-760x450.jpg";s:5:"width";i:760;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"1-760x514-760x450.jpg";s:5:"width";i:760;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:21:"1-760x514-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1917, 1788, '_wp_attached_file', '2016/11/1-760x514.jpg'),
(694, 807, '_attachment_original_parent_id', '555'),
(695, 811, '_attachment_original_parent_id', '555'),
(696, 967, 'pre_import_post_parent', '0'),
(697, 967, 'pre_import_post_id', '906'),
(698, 967, '_wp_attachment_image_alt', 'Image Alignment 580x300'),
(699, 967, '_attachment_original_parent_id', '903'),
(700, 968, 'pre_import_post_parent', '0'),
(701, 968, 'pre_import_post_id', '904'),
(702, 968, '_wp_attachment_image_alt', 'Image Alignment 150x150'),
(703, 968, '_attachment_original_parent_id', '903'),
(704, 1022, 'pre_import_post_parent', '0'),
(705, 1022, 'pre_import_post_id', '1022'),
(706, 1022, '_wp_attachment_image_alt', 'Horizontal Featured Image'),
(707, 1022, '_attachment_original_parent_id', '1011'),
(708, 1023, 'pre_import_post_parent', '0'),
(709, 1023, 'pre_import_post_id', '842'),
(710, 1023, '_wp_attachment_image_alt', 'I Am Worth Loving Wallpaper'),
(711, 1025, 'pre_import_post_parent', '0'),
(712, 1025, 'pre_import_post_id', '905'),
(713, 1025, '_wp_attachment_image_alt', 'Image Alignment 300x200'),
(714, 1025, '_attachment_original_parent_id', '903'),
(715, 1027, 'pre_import_post_parent', '0'),
(716, 1027, 'pre_import_post_id', '1024'),
(717, 1027, '_wp_attachment_image_alt', 'Horizontal Featured Image'),
(718, 1027, '_attachment_original_parent_id', '1016'),
(719, 1029, 'pre_import_post_parent', '0'),
(720, 1029, 'pre_import_post_id', '907'),
(721, 1029, '_wp_attachment_image_alt', 'Image Alignment 1200x4002'),
(722, 1029, '_attachment_original_parent_id', '903'),
(723, 1045, 'pre_import_post_parent', '0'),
(724, 1045, 'pre_import_post_id', '967'),
(725, 1045, '_wp_attachment_image_alt', 'Unicorn Wallpaper'),
(726, 1045, '_attachment_original_parent_id', '568'),
(727, 1689, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(728, 1689, '_menu_item_type', 'custom'),
(729, 1689, '_menu_item_menu_item_parent', '0'),
(730, 1689, '_menu_item_object_id', '1689'),
(731, 1689, '_menu_item_object', 'custom'),
(732, 1689, '_menu_item_target', ''),
(733, 1689, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(734, 1689, '_menu_item_xfn', ''),
(735, 1689, '_menu_item_url', '#'),
(736, 1690, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(737, 1690, '_menu_item_type', 'custom'),
(738, 1690, '_menu_item_menu_item_parent', '0'),
(739, 1690, '_menu_item_object_id', '1690'),
(740, 1690, '_menu_item_object', 'custom'),
(741, 1690, '_menu_item_target', ''),
(742, 1690, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(743, 1690, '_menu_item_xfn', ''),
(744, 1690, '_menu_item_url', '#'),
(745, 1691, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(746, 1691, '_menu_item_type', 'taxonomy'),
(747, 1691, '_menu_item_menu_item_parent', '1690'),
(748, 1691, '_menu_item_object_id', '29'),
(749, 1691, '_menu_item_object', 'category'),
(750, 1691, '_menu_item_target', ''),
(751, 1691, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(752, 1691, '_menu_item_xfn', ''),
(753, 1691, '_menu_item_url', ''),
(763, 1693, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(764, 1693, '_menu_item_type', 'taxonomy'),
(765, 1693, '_menu_item_menu_item_parent', '1690'),
(766, 1693, '_menu_item_object_id', '50'),
(767, 1693, '_menu_item_object', 'category'),
(768, 1693, '_menu_item_target', ''),
(769, 1693, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(770, 1693, '_menu_item_xfn', ''),
(771, 1693, '_menu_item_url', ''),
(772, 1694, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(773, 1694, '_menu_item_type', 'custom'),
(774, 1694, '_menu_item_menu_item_parent', '0'),
(775, 1694, '_menu_item_object_id', '1694'),
(776, 1694, '_menu_item_object', 'custom'),
(777, 1694, '_menu_item_target', ''),
(778, 1694, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(779, 1694, '_menu_item_xfn', ''),
(780, 1694, '_menu_item_url', '#'),
(781, 1695, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(782, 1695, '_menu_item_type', 'custom'),
(783, 1695, '_menu_item_menu_item_parent', '1694'),
(784, 1695, '_menu_item_object_id', '1695'),
(785, 1695, '_menu_item_object', 'custom'),
(786, 1695, '_menu_item_target', ''),
(787, 1695, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(788, 1695, '_menu_item_xfn', ''),
(789, 1695, '_menu_item_url', '#'),
(790, 1696, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(791, 1696, '_menu_item_type', 'custom'),
(792, 1696, '_menu_item_menu_item_parent', '1695'),
(793, 1696, '_menu_item_object_id', '1696'),
(794, 1696, '_menu_item_object', 'custom'),
(795, 1696, '_menu_item_target', ''),
(796, 1696, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(797, 1696, '_menu_item_xfn', ''),
(798, 1696, '_menu_item_url', '#'),
(799, 1697, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(800, 1697, '_menu_item_type', 'custom'),
(801, 1697, '_menu_item_menu_item_parent', '1696'),
(802, 1697, '_menu_item_object_id', '1697'),
(803, 1697, '_menu_item_object', 'custom'),
(804, 1697, '_menu_item_target', ''),
(805, 1697, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(806, 1697, '_menu_item_xfn', ''),
(807, 1697, '_menu_item_url', '#'),
(808, 1698, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(809, 1698, '_menu_item_type', 'custom'),
(810, 1698, '_menu_item_menu_item_parent', '1697'),
(811, 1698, '_menu_item_object_id', '1698'),
(812, 1698, '_menu_item_object', 'custom'),
(813, 1698, '_menu_item_target', ''),
(814, 1698, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(815, 1698, '_menu_item_xfn', ''),
(816, 1698, '_menu_item_url', '#'),
(817, 1699, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(818, 1699, '_menu_item_type', 'custom'),
(819, 1699, '_menu_item_menu_item_parent', '1698'),
(820, 1699, '_menu_item_object_id', '1699'),
(821, 1699, '_menu_item_object', 'custom'),
(822, 1699, '_menu_item_target', ''),
(823, 1699, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(824, 1699, '_menu_item_xfn', ''),
(825, 1699, '_menu_item_url', '#'),
(826, 1700, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(827, 1700, '_menu_item_type', 'custom'),
(828, 1700, '_menu_item_menu_item_parent', '1699'),
(829, 1700, '_menu_item_object_id', '1700'),
(830, 1700, '_menu_item_object', 'custom'),
(831, 1700, '_menu_item_target', ''),
(832, 1700, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(833, 1700, '_menu_item_xfn', ''),
(834, 1700, '_menu_item_url', '#'),
(835, 1701, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(836, 1701, '_menu_item_type', 'custom'),
(837, 1701, '_menu_item_menu_item_parent', '1700'),
(838, 1701, '_menu_item_object_id', '1701'),
(839, 1701, '_menu_item_object', 'custom'),
(840, 1701, '_menu_item_target', ''),
(841, 1701, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(842, 1701, '_menu_item_xfn', ''),
(843, 1701, '_menu_item_url', '#'),
(844, 1702, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(845, 1702, '_menu_item_type', 'custom'),
(846, 1702, '_menu_item_menu_item_parent', '1701'),
(847, 1702, '_menu_item_object_id', '1702'),
(848, 1702, '_menu_item_object', 'custom'),
(849, 1702, '_menu_item_target', ''),
(850, 1702, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(851, 1702, '_menu_item_xfn', ''),
(852, 1702, '_menu_item_url', '#'),
(853, 1703, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(854, 1703, '_menu_item_type', 'custom'),
(855, 1703, '_menu_item_menu_item_parent', '1702'),
(856, 1703, '_menu_item_object_id', '1703'),
(857, 1703, '_menu_item_object', 'custom'),
(858, 1703, '_menu_item_target', ''),
(859, 1703, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(860, 1703, '_menu_item_xfn', ''),
(861, 1703, '_menu_item_url', '#'),
(862, 1704, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(863, 1704, '_menu_item_type', 'custom'),
(864, 1704, '_menu_item_menu_item_parent', '1703'),
(865, 1704, '_menu_item_object_id', '1704'),
(866, 1704, '_menu_item_object', 'custom'),
(867, 1704, '_menu_item_target', ''),
(868, 1704, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(869, 1704, '_menu_item_xfn', ''),
(870, 1704, '_menu_item_url', '#'),
(871, 1705, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(872, 1705, '_menu_item_type', 'custom'),
(873, 1705, '_menu_item_menu_item_parent', '0'),
(874, 1705, '_menu_item_object_id', '1705'),
(875, 1705, '_menu_item_object', 'custom'),
(876, 1705, '_menu_item_target', ''),
(877, 1705, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(878, 1705, '_menu_item_xfn', ''),
(879, 1705, '_menu_item_url', '#'),
(880, 1706, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(881, 1706, '_menu_item_type', 'custom'),
(882, 1706, '_menu_item_menu_item_parent', '0'),
(883, 1706, '_menu_item_object_id', '1706'),
(884, 1706, '_menu_item_object', 'custom'),
(885, 1706, '_menu_item_target', ''),
(886, 1706, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(887, 1706, '_menu_item_xfn', ''),
(888, 1706, '_menu_item_url', '#'),
(889, 1707, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(890, 1707, '_menu_item_type', 'custom'),
(891, 1707, '_menu_item_menu_item_parent', '1705'),
(892, 1707, '_menu_item_object_id', '1707'),
(893, 1707, '_menu_item_object', 'custom'),
(894, 1707, '_menu_item_target', ''),
(895, 1707, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(896, 1707, '_menu_item_xfn', ''),
(897, 1707, '_menu_item_url', '#'),
(898, 1708, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(899, 1708, '_menu_item_type', 'custom'),
(900, 1708, '_menu_item_menu_item_parent', '1705'),
(901, 1708, '_menu_item_object_id', '1708'),
(902, 1708, '_menu_item_object', 'custom'),
(903, 1708, '_menu_item_target', ''),
(904, 1708, '_menu_item_classes', 'a:1:{i:0;s:21:"custom-menu-css-class";}'),
(905, 1708, '_menu_item_xfn', ''),
(906, 1708, '_menu_item_url', '#'),
(907, 1709, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(908, 1709, '_menu_item_type', 'custom'),
(909, 1709, '_menu_item_menu_item_parent', '1705'),
(910, 1709, '_menu_item_object_id', '1709'),
(911, 1709, '_menu_item_object', 'custom'),
(912, 1709, '_menu_item_target', '_blank'),
(913, 1709, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(914, 1709, '_menu_item_xfn', ''),
(915, 1709, '_menu_item_url', 'http://apple.com'),
(916, 1710, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(917, 1710, '_menu_item_type', 'custom'),
(918, 1710, '_menu_item_menu_item_parent', '0'),
(919, 1710, '_menu_item_object_id', '1710'),
(920, 1710, '_menu_item_object', 'custom'),
(921, 1710, '_menu_item_target', ''),
(922, 1710, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(923, 1710, '_menu_item_xfn', ''),
(924, 1710, '_menu_item_url', 'http://wpthemetestdata.wordpress.com/'),
(925, 1711, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(926, 1711, '_menu_item_type', 'post_type'),
(927, 1711, '_menu_item_menu_item_parent', '0'),
(928, 1711, '_menu_item_object_id', '703'),
(929, 1711, '_menu_item_object', 'page'),
(930, 1711, '_menu_item_target', ''),
(931, 1711, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(932, 1711, '_menu_item_xfn', ''),
(933, 1711, '_menu_item_url', ''),
(934, 1712, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(935, 1712, '_menu_item_type', 'post_type'),
(936, 1712, '_menu_item_menu_item_parent', '0'),
(937, 1712, '_menu_item_object_id', '9'),
(938, 1712, '_menu_item_object', 'page'),
(939, 1712, '_menu_item_target', ''),
(940, 1712, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(941, 1712, '_menu_item_xfn', ''),
(942, 1712, '_menu_item_url', ''),
(943, 1713, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(944, 1713, '_menu_item_type', 'post_type'),
(945, 1713, '_menu_item_menu_item_parent', '1712'),
(946, 1713, '_menu_item_object_id', '501'),
(947, 1713, '_menu_item_object', 'page'),
(948, 1713, '_menu_item_target', ''),
(949, 1713, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(950, 1713, '_menu_item_xfn', ''),
(951, 1713, '_menu_item_url', ''),
(952, 1714, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(953, 1714, '_menu_item_type', 'post_type'),
(954, 1714, '_menu_item_menu_item_parent', '1712'),
(955, 1714, '_menu_item_object_id', '155'),
(956, 1714, '_menu_item_object', 'page'),
(957, 1714, '_menu_item_target', ''),
(958, 1714, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(959, 1714, '_menu_item_xfn', ''),
(960, 1714, '_menu_item_url', ''),
(961, 1715, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(962, 1715, '_menu_item_type', 'post_type'),
(963, 1715, '_menu_item_menu_item_parent', '1712'),
(964, 1715, '_menu_item_object_id', '156'),
(965, 1715, '_menu_item_object', 'page'),
(966, 1715, '_menu_item_target', ''),
(967, 1715, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(968, 1715, '_menu_item_xfn', ''),
(969, 1715, '_menu_item_url', ''),
(970, 1716, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(971, 1716, '_menu_item_type', 'post_type'),
(972, 1716, '_menu_item_menu_item_parent', '0'),
(973, 1716, '_menu_item_object_id', '146'),
(974, 1716, '_menu_item_object', 'page'),
(975, 1716, '_menu_item_target', ''),
(976, 1716, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(977, 1716, '_menu_item_xfn', ''),
(978, 1716, '_menu_item_url', ''),
(979, 1717, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(980, 1717, '_menu_item_type', 'custom'),
(981, 1717, '_menu_item_menu_item_parent', '1775'),
(982, 1717, '_menu_item_object_id', '1717'),
(983, 1717, '_menu_item_object', 'custom'),
(984, 1717, '_menu_item_target', ''),
(985, 1717, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(986, 1717, '_menu_item_xfn', ''),
(987, 1717, '_menu_item_url', 'http://wpthemetestdata.wordpress.com/'),
(988, 1718, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(989, 1718, '_menu_item_type', 'post_type'),
(990, 1718, '_menu_item_menu_item_parent', '0'),
(991, 1718, '_menu_item_object_id', '703'),
(992, 1718, '_menu_item_object', 'page'),
(993, 1718, '_menu_item_target', ''),
(994, 1718, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(995, 1718, '_menu_item_xfn', ''),
(996, 1718, '_menu_item_url', ''),
(2359, 1959, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2358, 1959, '_wpb_vc_js_status', 'true'),
(2041, 1871, '_wp_attached_file', '2016/11/projects.jpg'),
(2038, 1862, '_wpb_shortcodes_custom_css', '.vc_custom_1478698102010{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/projects.jpg?id=1871) !important;}'),
(1042, 1724, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1043, 1724, '_menu_item_type', 'post_type'),
(1044, 1724, '_menu_item_menu_item_parent', '0'),
(1045, 1724, '_menu_item_object_id', '174'),
(1046, 1724, '_menu_item_object', 'page'),
(1047, 1724, '_menu_item_target', ''),
(1048, 1724, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1049, 1724, '_menu_item_xfn', ''),
(1050, 1724, '_menu_item_url', ''),
(1051, 1725, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1052, 1725, '_menu_item_type', 'post_type'),
(1053, 1725, '_menu_item_menu_item_parent', '1724'),
(1054, 1725, '_menu_item_object_id', '173'),
(1055, 1725, '_menu_item_object', 'page'),
(1056, 1725, '_menu_item_target', ''),
(1057, 1725, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1058, 1725, '_menu_item_xfn', ''),
(1059, 1725, '_menu_item_url', ''),
(1060, 1726, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1061, 1726, '_menu_item_type', 'post_type'),
(1062, 1726, '_menu_item_menu_item_parent', '1725'),
(1063, 1726, '_menu_item_object_id', '172'),
(1064, 1726, '_menu_item_object', 'page'),
(1065, 1726, '_menu_item_target', ''),
(1066, 1726, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1067, 1726, '_menu_item_xfn', ''),
(1068, 1726, '_menu_item_url', ''),
(1904, 1179, '_oembed_87c7d27b2ded306fa13b795701ad2913', '<blockquote class="twitter-tweet" data-width="550"><p lang="en" dir="ltr">Really cool to read through and find so much awesomeness added to WordPress 3.6 while I was gone. I should take three weeks off more often.</p>&mdash; Andrew Nacin (@nacin) <a href="https://twitter.com/nacin/status/319508408669708289">April 3, 2013</a></blockquote><script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>'),
(1080, 9, '_wp_page_template', 'default'),
(1081, 146, '_wp_page_template', 'default'),
(1082, 155, '_wp_page_template', 'default'),
(1083, 156, '_wp_page_template', 'default'),
(1084, 172, '_wp_page_template', 'default'),
(1085, 173, '_wp_page_template', 'default'),
(1086, 174, '_wp_page_template', 'default'),
(1087, 501, '_wp_page_template', 'default'),
(1088, 611, '_wp_attachment_image_alt', 'canola'),
(1089, 611, '_wp_attachment_image_alt', 'canola'),
(1090, 611, '_attachment_original_parent_id', '555'),
(1091, 616, '_wp_attachment_image_alt', 'dsc20050727_091048_222'),
(1092, 616, '_wp_attachment_image_alt', 'dsc20050727_091048_222'),
(1093, 616, '_attachment_original_parent_id', '555'),
(1094, 617, '_wp_attachment_image_alt', 'dsc20050813_115856_52'),
(1095, 617, '_wp_attachment_image_alt', 'dsc20050813_115856_52'),
(1096, 617, '_attachment_original_parent_id', '555'),
(1097, 701, '_wp_page_template', 'template-fullwidth.php'),
(1098, 703, '_wp_page_template', 'default'),
(1099, 754, '_wp_attachment_image_alt', 'Bell on Wharf'),
(1100, 754, '_wp_attachment_image_alt', 'Bell on Wharf'),
(1101, 754, '_attachment_original_parent_id', '555'),
(1102, 755, '_wp_attachment_image_alt', 'Golden Gate Bridge'),
(1103, 755, '_wp_attachment_image_alt', 'Golden Gate Bridge'),
(1104, 755, '_attachment_original_parent_id', '555'),
(1105, 756, '_wp_attachment_image_alt', 'Sunburst Over River'),
(1106, 756, '_wp_attachment_image_alt', 'Sunburst Over River'),
(1107, 756, '_attachment_original_parent_id', '555'),
(1108, 757, '_wp_attachment_image_alt', 'Boardwalk'),
(1109, 757, '_wp_attachment_image_alt', 'Boardwalk'),
(1110, 757, '_attachment_original_parent_id', '555'),
(1111, 758, '_wp_attachment_image_alt', 'Yachtsody in Blue'),
(1112, 758, '_wp_attachment_image_alt', 'Yachtsody in Blue'),
(1113, 758, '_attachment_original_parent_id', '555'),
(1114, 759, '_wp_attachment_image_alt', 'Rain Ripples'),
(1115, 759, '_wp_attachment_image_alt', 'Rain Ripples'),
(1116, 759, '_attachment_original_parent_id', '555'),
(1117, 760, '_wp_attachment_image_alt', 'Sydney Harbor Bridge'),
(1118, 760, '_wp_attachment_image_alt', 'Sydney Harbor Bridge'),
(1119, 760, '_attachment_original_parent_id', '555');
REPLACE INTO `xwlpv_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(1120, 761, '_wp_attachment_image_alt', 'Wind Farm'),
(1121, 761, '_wp_attachment_image_alt', 'Wind Farm'),
(1122, 761, '_attachment_original_parent_id', '555'),
(1123, 762, '_wp_attachment_image_alt', 'Antique Farm Machinery'),
(1124, 762, '_wp_attachment_image_alt', 'Antique Farm Machinery'),
(1125, 762, '_attachment_original_parent_id', '555'),
(1126, 763, '_wp_attachment_image_alt', 'Orange Iris'),
(1127, 763, '_wp_attachment_image_alt', 'Orange Iris'),
(1128, 763, '_attachment_original_parent_id', '555'),
(1129, 764, '_wp_attachment_image_alt', 'Rusty Rail'),
(1130, 764, '_wp_attachment_image_alt', 'Rusty Rail'),
(1131, 764, '_attachment_original_parent_id', '555'),
(1132, 765, '_wp_attachment_image_alt', 'Sea and Rocks'),
(1133, 765, '_wp_attachment_image_alt', 'Sea and Rocks'),
(1134, 765, '_attachment_original_parent_id', '555'),
(1135, 766, '_wp_attachment_image_alt', 'Big Sur'),
(1136, 766, '_wp_attachment_image_alt', 'Big Sur'),
(1137, 766, '_attachment_original_parent_id', '555'),
(1138, 767, '_wp_attachment_image_alt', 'Windmill'),
(1139, 767, '_wp_attachment_image_alt', 'Windmill'),
(1140, 767, '_attachment_original_parent_id', '555'),
(1141, 768, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(1142, 768, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(1143, 768, '_attachment_original_parent_id', '555'),
(1144, 773, '_wp_attachment_image_alt', 'Brazil Beach'),
(1145, 773, '_wp_attachment_image_alt', 'Brazil Beach'),
(1146, 773, '_attachment_original_parent_id', '555'),
(1147, 774, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(1148, 774, '_wp_attachment_image_alt', 'Huatulco Coastline'),
(1149, 774, '_attachment_original_parent_id', '555'),
(1916, 1787, '_edit_last', '1'),
(1915, 1787, '_edit_lock', '1478265140:1'),
(1153, 807, '_attachment_original_parent_id', '555'),
(1154, 811, '_attachment_original_parent_id', '555'),
(1155, 967, 'pre_import_post_parent', '0'),
(1156, 967, 'pre_import_post_id', '906'),
(1157, 967, '_wp_attachment_image_alt', 'Image Alignment 580x300'),
(1158, 967, '_attachment_original_parent_id', '903'),
(1159, 968, 'pre_import_post_parent', '0'),
(1160, 968, 'pre_import_post_id', '904'),
(1161, 968, '_wp_attachment_image_alt', 'Image Alignment 150x150'),
(1162, 968, '_attachment_original_parent_id', '903'),
(1163, 1022, 'pre_import_post_parent', '0'),
(1164, 1022, 'pre_import_post_id', '1022'),
(1165, 1022, '_wp_attachment_image_alt', 'Horizontal Featured Image'),
(1166, 1022, '_attachment_original_parent_id', '1011'),
(1167, 1023, 'pre_import_post_parent', '0'),
(1168, 1023, 'pre_import_post_id', '842'),
(1169, 1023, '_wp_attachment_image_alt', 'I Am Worth Loving Wallpaper'),
(1170, 1025, 'pre_import_post_parent', '0'),
(1171, 1025, 'pre_import_post_id', '905'),
(1172, 1025, '_wp_attachment_image_alt', 'Image Alignment 300x200'),
(1173, 1025, '_attachment_original_parent_id', '903'),
(1174, 1027, 'pre_import_post_parent', '0'),
(1175, 1027, 'pre_import_post_id', '1024'),
(1176, 1027, '_wp_attachment_image_alt', 'Horizontal Featured Image'),
(1177, 1027, '_attachment_original_parent_id', '1016'),
(1178, 1029, 'pre_import_post_parent', '0'),
(1179, 1029, 'pre_import_post_id', '907'),
(1180, 1029, '_wp_attachment_image_alt', 'Image Alignment 1200x4002'),
(1181, 1029, '_attachment_original_parent_id', '903'),
(1182, 1045, 'pre_import_post_parent', '0'),
(1183, 1045, 'pre_import_post_id', '967'),
(1184, 1045, '_wp_attachment_image_alt', 'Unicorn Wallpaper'),
(1185, 1045, '_attachment_original_parent_id', '568'),
(1186, 1729, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1187, 1729, '_menu_item_type', 'custom'),
(1188, 1729, '_menu_item_menu_item_parent', '0'),
(1189, 1729, '_menu_item_object_id', '1729'),
(1190, 1729, '_menu_item_object', 'custom'),
(1191, 1729, '_menu_item_target', ''),
(1192, 1729, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1193, 1729, '_menu_item_xfn', ''),
(1194, 1729, '_menu_item_url', '#'),
(1195, 1730, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1196, 1730, '_menu_item_type', 'custom'),
(1197, 1730, '_menu_item_menu_item_parent', '0'),
(1198, 1730, '_menu_item_object_id', '1730'),
(1199, 1730, '_menu_item_object', 'custom'),
(1200, 1730, '_menu_item_target', ''),
(1201, 1730, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1202, 1730, '_menu_item_xfn', ''),
(1203, 1730, '_menu_item_url', '#'),
(1204, 1731, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1205, 1731, '_menu_item_type', 'taxonomy'),
(1206, 1731, '_menu_item_menu_item_parent', '1730'),
(1207, 1731, '_menu_item_object_id', '29'),
(1208, 1731, '_menu_item_object', 'category'),
(1209, 1731, '_menu_item_target', ''),
(1210, 1731, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1211, 1731, '_menu_item_xfn', ''),
(1212, 1731, '_menu_item_url', ''),
(1222, 1733, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1223, 1733, '_menu_item_type', 'taxonomy'),
(1224, 1733, '_menu_item_menu_item_parent', '1730'),
(1225, 1733, '_menu_item_object_id', '50'),
(1226, 1733, '_menu_item_object', 'category'),
(1227, 1733, '_menu_item_target', ''),
(1228, 1733, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1229, 1733, '_menu_item_xfn', ''),
(1230, 1733, '_menu_item_url', ''),
(1231, 1734, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1232, 1734, '_menu_item_type', 'custom'),
(1233, 1734, '_menu_item_menu_item_parent', '0'),
(1234, 1734, '_menu_item_object_id', '1734'),
(1235, 1734, '_menu_item_object', 'custom'),
(1236, 1734, '_menu_item_target', ''),
(1237, 1734, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1238, 1734, '_menu_item_xfn', ''),
(1239, 1734, '_menu_item_url', '#'),
(1240, 1735, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1241, 1735, '_menu_item_type', 'custom'),
(1242, 1735, '_menu_item_menu_item_parent', '1734'),
(1243, 1735, '_menu_item_object_id', '1735'),
(1244, 1735, '_menu_item_object', 'custom'),
(1245, 1735, '_menu_item_target', ''),
(1246, 1735, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1247, 1735, '_menu_item_xfn', ''),
(1248, 1735, '_menu_item_url', '#'),
(1249, 1736, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1250, 1736, '_menu_item_type', 'custom'),
(1251, 1736, '_menu_item_menu_item_parent', '1735'),
(1252, 1736, '_menu_item_object_id', '1736'),
(1253, 1736, '_menu_item_object', 'custom'),
(1254, 1736, '_menu_item_target', ''),
(1255, 1736, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1256, 1736, '_menu_item_xfn', ''),
(1257, 1736, '_menu_item_url', '#'),
(1258, 1737, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1259, 1737, '_menu_item_type', 'custom'),
(1260, 1737, '_menu_item_menu_item_parent', '1736'),
(1261, 1737, '_menu_item_object_id', '1737'),
(1262, 1737, '_menu_item_object', 'custom'),
(1263, 1737, '_menu_item_target', ''),
(1264, 1737, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1265, 1737, '_menu_item_xfn', ''),
(1266, 1737, '_menu_item_url', '#'),
(1267, 1738, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1268, 1738, '_menu_item_type', 'custom'),
(1269, 1738, '_menu_item_menu_item_parent', '1737'),
(1270, 1738, '_menu_item_object_id', '1738'),
(1271, 1738, '_menu_item_object', 'custom'),
(1272, 1738, '_menu_item_target', ''),
(1273, 1738, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1274, 1738, '_menu_item_xfn', ''),
(1275, 1738, '_menu_item_url', '#'),
(1276, 1739, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1277, 1739, '_menu_item_type', 'custom'),
(1278, 1739, '_menu_item_menu_item_parent', '1738'),
(1279, 1739, '_menu_item_object_id', '1739'),
(1280, 1739, '_menu_item_object', 'custom'),
(1281, 1739, '_menu_item_target', ''),
(1282, 1739, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1283, 1739, '_menu_item_xfn', ''),
(1284, 1739, '_menu_item_url', '#'),
(1285, 1740, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1286, 1740, '_menu_item_type', 'custom'),
(1287, 1740, '_menu_item_menu_item_parent', '1739'),
(1288, 1740, '_menu_item_object_id', '1740'),
(1289, 1740, '_menu_item_object', 'custom'),
(1290, 1740, '_menu_item_target', ''),
(1291, 1740, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1292, 1740, '_menu_item_xfn', ''),
(1293, 1740, '_menu_item_url', '#'),
(1294, 1741, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1295, 1741, '_menu_item_type', 'custom'),
(1296, 1741, '_menu_item_menu_item_parent', '1740'),
(1297, 1741, '_menu_item_object_id', '1741'),
(1298, 1741, '_menu_item_object', 'custom'),
(1299, 1741, '_menu_item_target', ''),
(1300, 1741, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1301, 1741, '_menu_item_xfn', ''),
(1302, 1741, '_menu_item_url', '#'),
(1303, 1742, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1304, 1742, '_menu_item_type', 'custom'),
(1305, 1742, '_menu_item_menu_item_parent', '1741'),
(1306, 1742, '_menu_item_object_id', '1742'),
(1307, 1742, '_menu_item_object', 'custom'),
(1308, 1742, '_menu_item_target', ''),
(1309, 1742, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1310, 1742, '_menu_item_xfn', ''),
(1311, 1742, '_menu_item_url', '#'),
(1312, 1743, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1313, 1743, '_menu_item_type', 'custom'),
(1314, 1743, '_menu_item_menu_item_parent', '1742'),
(1315, 1743, '_menu_item_object_id', '1743'),
(1316, 1743, '_menu_item_object', 'custom'),
(1317, 1743, '_menu_item_target', ''),
(1318, 1743, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1319, 1743, '_menu_item_xfn', ''),
(1320, 1743, '_menu_item_url', '#'),
(1321, 1744, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1322, 1744, '_menu_item_type', 'custom'),
(1323, 1744, '_menu_item_menu_item_parent', '1743'),
(1324, 1744, '_menu_item_object_id', '1744'),
(1325, 1744, '_menu_item_object', 'custom'),
(1326, 1744, '_menu_item_target', ''),
(1327, 1744, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1328, 1744, '_menu_item_xfn', ''),
(1329, 1744, '_menu_item_url', '#'),
(1330, 1745, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1331, 1745, '_menu_item_type', 'custom'),
(1332, 1745, '_menu_item_menu_item_parent', '0'),
(1333, 1745, '_menu_item_object_id', '1745'),
(1334, 1745, '_menu_item_object', 'custom'),
(1335, 1745, '_menu_item_target', ''),
(1336, 1745, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1337, 1745, '_menu_item_xfn', ''),
(1338, 1745, '_menu_item_url', '#'),
(1339, 1746, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1340, 1746, '_menu_item_type', 'custom'),
(1341, 1746, '_menu_item_menu_item_parent', '0'),
(1342, 1746, '_menu_item_object_id', '1746'),
(1343, 1746, '_menu_item_object', 'custom'),
(1344, 1746, '_menu_item_target', ''),
(1345, 1746, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1346, 1746, '_menu_item_xfn', ''),
(1347, 1746, '_menu_item_url', '#'),
(1348, 1747, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1349, 1747, '_menu_item_type', 'custom'),
(1350, 1747, '_menu_item_menu_item_parent', '1745'),
(1351, 1747, '_menu_item_object_id', '1747'),
(1352, 1747, '_menu_item_object', 'custom'),
(1353, 1747, '_menu_item_target', ''),
(1354, 1747, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1355, 1747, '_menu_item_xfn', ''),
(1356, 1747, '_menu_item_url', '#'),
(1357, 1748, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1358, 1748, '_menu_item_type', 'custom'),
(1359, 1748, '_menu_item_menu_item_parent', '1745'),
(1360, 1748, '_menu_item_object_id', '1748'),
(1361, 1748, '_menu_item_object', 'custom'),
(1362, 1748, '_menu_item_target', ''),
(1363, 1748, '_menu_item_classes', 'a:1:{i:0;s:21:"custom-menu-css-class";}'),
(1364, 1748, '_menu_item_xfn', ''),
(1365, 1748, '_menu_item_url', '#'),
(1366, 1749, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1367, 1749, '_menu_item_type', 'custom'),
(1368, 1749, '_menu_item_menu_item_parent', '1745'),
(1369, 1749, '_menu_item_object_id', '1749'),
(1370, 1749, '_menu_item_object', 'custom'),
(1371, 1749, '_menu_item_target', '_blank'),
(1372, 1749, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1373, 1749, '_menu_item_xfn', ''),
(1374, 1749, '_menu_item_url', 'http://apple.com'),
(1375, 1750, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1376, 1750, '_menu_item_type', 'custom'),
(1377, 1750, '_menu_item_menu_item_parent', '0'),
(1378, 1750, '_menu_item_object_id', '1750'),
(1379, 1750, '_menu_item_object', 'custom'),
(1380, 1750, '_menu_item_target', ''),
(1381, 1750, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1382, 1750, '_menu_item_xfn', ''),
(1383, 1750, '_menu_item_url', 'http://wpthemetestdata.wordpress.com/'),
(1384, 1751, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1385, 1751, '_menu_item_type', 'post_type'),
(1386, 1751, '_menu_item_menu_item_parent', '0'),
(1387, 1751, '_menu_item_object_id', '703'),
(1388, 1751, '_menu_item_object', 'page'),
(1389, 1751, '_menu_item_target', ''),
(1390, 1751, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1391, 1751, '_menu_item_xfn', ''),
(1392, 1751, '_menu_item_url', ''),
(1393, 1752, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1394, 1752, '_menu_item_type', 'post_type'),
(1395, 1752, '_menu_item_menu_item_parent', '0'),
(1396, 1752, '_menu_item_object_id', '9'),
(1397, 1752, '_menu_item_object', 'page'),
(1398, 1752, '_menu_item_target', ''),
(1399, 1752, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1400, 1752, '_menu_item_xfn', ''),
(1401, 1752, '_menu_item_url', ''),
(1402, 1753, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1403, 1753, '_menu_item_type', 'post_type'),
(1404, 1753, '_menu_item_menu_item_parent', '1752'),
(1405, 1753, '_menu_item_object_id', '501'),
(1406, 1753, '_menu_item_object', 'page'),
(1407, 1753, '_menu_item_target', ''),
(1408, 1753, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1409, 1753, '_menu_item_xfn', ''),
(1410, 1753, '_menu_item_url', ''),
(1411, 1754, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1412, 1754, '_menu_item_type', 'post_type'),
(1413, 1754, '_menu_item_menu_item_parent', '1752'),
(1414, 1754, '_menu_item_object_id', '155'),
(1415, 1754, '_menu_item_object', 'page'),
(1416, 1754, '_menu_item_target', ''),
(1417, 1754, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1418, 1754, '_menu_item_xfn', ''),
(1419, 1754, '_menu_item_url', ''),
(1420, 1755, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1421, 1755, '_menu_item_type', 'post_type'),
(1422, 1755, '_menu_item_menu_item_parent', '1752'),
(1423, 1755, '_menu_item_object_id', '156'),
(1424, 1755, '_menu_item_object', 'page'),
(1425, 1755, '_menu_item_target', ''),
(1426, 1755, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1427, 1755, '_menu_item_xfn', ''),
(1428, 1755, '_menu_item_url', ''),
(1429, 1756, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1430, 1756, '_menu_item_type', 'post_type'),
(1431, 1756, '_menu_item_menu_item_parent', '0'),
(1432, 1756, '_menu_item_object_id', '146'),
(1433, 1756, '_menu_item_object', 'page'),
(1434, 1756, '_menu_item_target', ''),
(1435, 1756, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1436, 1756, '_menu_item_xfn', ''),
(1437, 1756, '_menu_item_url', ''),
(2341, 1993, '_menu_item_object', 'custom'),
(2340, 1993, '_menu_item_object_id', '1993'),
(2339, 1993, '_menu_item_menu_item_parent', '1994'),
(2338, 1993, '_menu_item_type', 'custom'),
(2337, 1993, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1465, 1760, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1466, 1760, '_menu_item_type', 'post_type'),
(1467, 1760, '_menu_item_menu_item_parent', '0'),
(1468, 1760, '_menu_item_object_id', '9'),
(1469, 1760, '_menu_item_object', 'page'),
(1470, 1760, '_menu_item_target', ''),
(1471, 1760, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1472, 1760, '_menu_item_xfn', ''),
(1473, 1760, '_menu_item_url', ''),
(1474, 1761, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1475, 1761, '_menu_item_type', 'post_type'),
(1476, 1761, '_menu_item_menu_item_parent', '1760'),
(1477, 1761, '_menu_item_object_id', '501'),
(1478, 1761, '_menu_item_object', 'page'),
(1479, 1761, '_menu_item_target', ''),
(1480, 1761, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1481, 1761, '_menu_item_xfn', ''),
(1482, 1761, '_menu_item_url', ''),
(1483, 1762, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1484, 1762, '_menu_item_type', 'post_type'),
(1485, 1762, '_menu_item_menu_item_parent', '1760'),
(1486, 1762, '_menu_item_object_id', '155'),
(1487, 1762, '_menu_item_object', 'page'),
(1488, 1762, '_menu_item_target', ''),
(1489, 1762, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1490, 1762, '_menu_item_xfn', ''),
(1491, 1762, '_menu_item_url', ''),
(1492, 1763, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1493, 1763, '_menu_item_type', 'post_type'),
(1494, 1763, '_menu_item_menu_item_parent', '1760'),
(1495, 1763, '_menu_item_object_id', '156'),
(1496, 1763, '_menu_item_object', 'page'),
(1497, 1763, '_menu_item_target', ''),
(1498, 1763, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1499, 1763, '_menu_item_xfn', ''),
(1500, 1763, '_menu_item_url', ''),
(1501, 1764, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1502, 1764, '_menu_item_type', 'post_type'),
(1503, 1764, '_menu_item_menu_item_parent', '0'),
(1504, 1764, '_menu_item_object_id', '174'),
(1505, 1764, '_menu_item_object', 'page'),
(1506, 1764, '_menu_item_target', ''),
(1507, 1764, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1508, 1764, '_menu_item_xfn', ''),
(1509, 1764, '_menu_item_url', ''),
(1510, 1765, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1511, 1765, '_menu_item_type', 'post_type'),
(1512, 1765, '_menu_item_menu_item_parent', '1764'),
(1513, 1765, '_menu_item_object_id', '173'),
(1514, 1765, '_menu_item_object', 'page'),
(1515, 1765, '_menu_item_target', ''),
(1516, 1765, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1517, 1765, '_menu_item_xfn', ''),
(1518, 1765, '_menu_item_url', ''),
(1519, 1766, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1520, 1766, '_menu_item_type', 'post_type'),
(1521, 1766, '_menu_item_menu_item_parent', '1765'),
(1522, 1766, '_menu_item_object_id', '172'),
(1523, 1766, '_menu_item_object', 'page'),
(1524, 1766, '_menu_item_target', ''),
(1525, 1766, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1526, 1766, '_menu_item_xfn', ''),
(1527, 1766, '_menu_item_url', ''),
(2034, 1862, '_wp_page_template', 'template-fullwidth.php'),
(2033, 1862, '_edit_last', '1'),
(1537, 1768, '_wp_attached_file', '2013/12/2014-slider-mobile-behavior-2.mov'),
(1538, 1768, '_wp_attachment_metadata', 'a:9:{s:8:"filesize";i:29881426;s:9:"mime_type";s:15:"video/quicktime";s:6:"length";i:18;s:16:"length_formatted";s:4:"0:18";s:5:"width";i:1920;s:6:"height";i:1080;s:10:"fileformat";s:3:"mp4";s:10:"dataformat";s:9:"quicktime";s:5:"audio";a:7:{s:10:"dataformat";s:3:"mp4";s:5:"codec";s:19:"ISO/IEC 14496-3 AAC";s:11:"sample_rate";d:44100;s:8:"channels";i:1;s:15:"bits_per_sample";i:16;s:8:"lossless";b:0;s:11:"channelmode";s:4:"mono";}}'),
(1539, 1769, '_wp_attached_file', '2014/01/dsc20050315_145007_132.jpg'),
(1540, 1769, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:640;s:6:"height";i:480;s:4:"file";s:34:"2014/01/dsc20050315_145007_132.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:34:"dsc20050315_145007_132-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:34:"dsc20050315_145007_132-300x225.jpg";s:5:"width";i:300;s:6:"height";i:225;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:34:"dsc20050315_145007_132-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:34:"dsc20050315_145007_132-640x450.jpg";s:5:"width";i:640;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:34:"dsc20050315_145007_132-480x480.jpg";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:3:"2.2";s:6:"credit";s:0:"";s:6:"camera";s:9:"CYBERSHOT";s:7:"caption";s:0:"";s:17:"created_timestamp";s:10:"1110898207";s:9:"copyright";s:0:"";s:12:"focal_length";s:3:"9.7";s:3:"iso";s:3:"100";s:13:"shutter_speed";s:5:"0.008";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1541, 1770, '_wp_attached_file', '2014/01/spectacles.gif'),
(1542, 1770, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:165;s:6:"height";i:210;s:4:"file";s:22:"2014/01/spectacles.gif";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"spectacles-150x150.gif";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/gif";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1543, 358, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1544, 358, '_wp_old_slug', ''),
(1545, 358, '_wp_old_slug', 'post-format-standard-2'),
(1546, 358, '_wp_old_slug', 'readability-test'),
(1547, 358, '_wp_old_slug', 'markup-readability-test'),
(1548, 555, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1549, 555, '_wp_old_slug', 'post-format-gallery-2'),
(1551, 555, '_wp_old_slug', 'post-format-test-gallery'),
(1552, 559, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1553, 559, '_wp_old_slug', 'post-format-aside-2'),
(1554, 559, '_wp_old_slug', 'post-format-test-aside'),
(1555, 562, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1556, 562, '_wp_old_slug', 'post-format-test-chat'),
(1557, 565, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1558, 565, '_wp_old_slug', 'post-format-test-link'),
(1559, 568, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1560, 568, '_wp_old_slug', 'post-format-test-image'),
(1561, 568, '_wp_old_slug', 'post-format-test-image-linked'),
(1562, 575, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1563, 575, '_wp_old_slug', 'post-format-test-quote'),
(1564, 579, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1565, 579, '_wp_old_slug', 'post-format-test-status'),
(1566, 582, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1567, 582, '_wp_old_slug', 'post-format-test-video'),
(1568, 582, '_oembed_4321638fc1a6fee26443f7fe8a70a871', '<embed src="http://v.wordpress.com/hrPKeL5t" type="application/x-shockwave-flash" width="500" height="281" allowscriptaccess="always" allowfullscreen="true" wmode="transparent"></embed>'),
(1569, 582, '_oembed_29351fff85c1be1d1e9a965a0332a861', '<div class="embed-"><embed src="http://v.wordpress.com/hrPKeL5t" type="application/x-shockwave-flash" width="604" height="339" allowscriptaccess="always" allowfullscreen="true" wmode="transparent"></embed></div>'),
(1570, 582, '_oembed_9fcc86d7d9398ff736577f922307f64d', '<div class="embed-"><embed src="http://v.wordpress.com/hrPKeL5t" type="application/x-shockwave-flash" width="808" height="454" allowscriptaccess="always" allowfullscreen="true" wmode="transparent"></embed></div>'),
(1571, 582, '_oembed_366237792d32461d0052efb2edec37f5', '<div class="embed-"><embed src="http://v.wordpress.com/hrPKeL5t" type="application/x-shockwave-flash" width="584" height="328" allowscriptaccess="always" allowfullscreen="true" wmode="transparent"></embed></div>'),
(1572, 582, '_oembed_37fdfe862c13c46a93be2921279bf675', '<div class="embed-"><embed src="http://v.wordpress.com/hrPKeL5t" type="application/x-shockwave-flash" width="599" height="336" allowscriptaccess="always" allowfullscreen="true" wmode="transparent"></embed></div>'),
(1573, 587, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1574, 587, 'enclosure', 'http://wpthemetestdata.files.wordpress.com/2008/06/originaldixielandjazzbandwithalbernard-stlouisblues.mp3\n3043247\naudio/mpeg\n'),
(1575, 587, '_wp_old_slug', 'post-format-test-audio'),
(1576, 733, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1577, 733, '_wp_page_template', 'default'),
(1578, 735, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1579, 735, '_wp_page_template', 'default'),
(1580, 742, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1581, 742, '_wp_page_template', 'default'),
(1582, 744, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1583, 744, '_wp_page_template', 'default'),
(1584, 746, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1585, 746, '_wp_page_template', 'default'),
(1586, 748, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1587, 748, '_wp_page_template', 'default'),
(1588, 993, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1589, 993, '_wp_old_slug', 'excerpt'),
(1590, 993, '_wp_old_slug', 'template-excerpt'),
(1591, 993, '_publicize_pending', '1'),
(1592, 993, 'original_post_id', '993'),
(1593, 993, '_wp_old_slug', '993'),
(1594, 996, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1595, 996, '_wp_old_slug', 'more-tag'),
(1596, 996, '_publicize_pending', '1'),
(1597, 996, 'original_post_id', '996'),
(1598, 996, '_wp_old_slug', '996'),
(1599, 1000, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1600, 1000, '_wp_old_slug', 'nested-and-mixed-lists'),
(1601, 1000, '_wp_old_slug', 'html-nested-and-mixed-lists'),
(1602, 1000, '_wp_old_slug', 'markup-nested-and-mixed-lists'),
(1603, 1000, '_publicize_pending', '1'),
(1604, 1000, 'original_post_id', '1000'),
(1605, 1000, '_wp_old_slug', '1000'),
(1606, 1005, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1607, 1005, '_publicize_pending', '1'),
(1608, 1005, 'standard_seo_post_level_layout', ''),
(1609, 1005, 'standard_link_url_field', ''),
(1610, 1005, 'standard_seo_post_meta_description', ''),
(1611, 1005, 'original_post_id', '1005'),
(1612, 1005, '_wp_old_slug', '1005'),
(1613, 1011, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1614, 1011, '_wp_old_slug', 'media-featured-image-horizontal'),
(1615, 1011, '_wp_old_slug', 'featured-image-horizontal'),
(1616, 1011, '_publicize_pending', '1'),
(1617, 1011, '_wp_old_slug', 'featured-image'),
(1618, 1011, '_thumbnail_id', '1022'),
(1619, 1011, 'standard_seo_post_level_layout', ''),
(1620, 1011, 'standard_link_url_field', ''),
(1621, 1011, 'standard_seo_post_meta_description', ''),
(1622, 1011, 'original_post_id', '1011'),
(1623, 1011, '_wp_old_slug', '1011'),
(1624, 1016, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1625, 1016, '_wp_old_slug', 'media-featured-image-vertical'),
(1626, 1016, '_wp_old_slug', 'featured-image-vertical'),
(1627, 1016, '_publicize_pending', '1'),
(1628, 1016, '_thumbnail_id', '1027'),
(1629, 1016, 'standard_seo_post_level_layout', ''),
(1630, 1016, 'standard_link_url_field', ''),
(1631, 1016, 'standard_seo_post_meta_description', ''),
(1632, 1016, 'original_post_id', '1016'),
(1633, 1016, '_wp_old_slug', '1016'),
(1634, 1031, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1635, 1031, '_wp_old_slug', 'tiled-gallery'),
(1636, 1031, '_wp_old_slug', 'media-tiled-gallery'),
(1637, 1031, '_publicize_pending', '1'),
(1638, 1031, 'standard_seo_post_level_layout', ''),
(1639, 1031, 'standard_link_url_field', ''),
(1640, 1031, 'standard_seo_post_meta_description', ''),
(1641, 1031, 'original_post_id', '1031'),
(1642, 1031, '_wp_old_slug', '1031'),
(1643, 1133, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1644, 1133, '_publicize_pending', '1'),
(1645, 1133, '_wp_page_template', 'default'),
(1646, 1133, 'original_post_id', '1080'),
(1647, 1133, '_wp_old_slug', '1080'),
(1648, 1134, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1649, 1134, '_publicize_pending', '1'),
(1650, 1134, '_wp_page_template', 'default'),
(1651, 1134, 'standard_seo_post_meta_description', ''),
(1652, 1134, 'original_post_id', '1083'),
(1653, 1134, '_wp_old_slug', '1083'),
(1654, 1148, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1655, 1148, '_publicize_pending', '1'),
(1656, 1148, '_wp_old_slug', 'comment-test'),
(1657, 1148, 'original_post_id', '149'),
(1658, 1148, '_wp_old_slug', '149'),
(1659, 1148, '_wp_old_slug', 'comments'),
(1660, 1149, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1661, 1149, '_wp_old_slug', 'pingbacks-an-trackbacks'),
(1662, 1149, '_publicize_pending', '1'),
(1663, 1149, '_wp_old_slug', 'many-trackbacks'),
(1664, 1149, 'original_post_id', '151'),
(1665, 1149, '_wp_old_slug', '151'),
(1666, 1150, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1667, 1150, '_publicize_pending', '1'),
(1668, 1150, '_wp_old_slug', 'no-comments'),
(1669, 1150, 'original_post_id', '152'),
(1670, 1150, '_wp_old_slug', '152'),
(1671, 1150, '_wp_old_slug', 'comments-disabled-2'),
(1672, 1151, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1673, 1151, '_publicize_pending', '1'),
(1674, 1151, 'original_post_id', '167'),
(1675, 1151, '_wp_old_slug', '167'),
(1676, 1151, '_wp_old_slug', 'many-tags-2'),
(1677, 1152, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1678, 1152, '_wp_old_slug', 'many-categories-2'),
(1679, 1152, '_publicize_pending', '1'),
(1680, 1152, 'original_post_id', '168'),
(1681, 1152, '_wp_old_slug', '168'),
(1682, 1153, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1683, 1153, 'original_post_id', '418'),
(1684, 1153, '_wp_old_slug', '418'),
(1685, 1158, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1686, 1158, '_publicize_pending', '1'),
(1687, 1158, '_wp_old_slug', 'post-format-test-image'),
(1688, 1158, '_wp_old_slug', 'post-format-test-image-linked'),
(1689, 1158, 'original_post_id', '568'),
(1690, 1158, '_wp_old_slug', '568'),
(1691, 1161, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1692, 1161, '_publicize_pending', '1'),
(1693, 1161, '_wp_old_slug', 'post-format-test-video'),
(1694, 1161, '_wp_old_slug', 'post-format-video'),
(1695, 1161, 'original_post_id', '582'),
(1696, 1161, '_wp_old_slug', '582'),
(1697, 1163, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1698, 1163, '_publicize_pending', '1'),
(1699, 1163, '_wp_old_slug', 'post-format-test-image-attached'),
(1700, 1163, 'original_post_id', '674'),
(1701, 1163, '_wp_old_slug', '674'),
(1702, 1163, '_thumbnail_id', '1628'),
(1703, 1163, '_format_url', ''),
(1704, 1163, '_format_link_url', ''),
(1705, 1163, '_format_quote_source_url', ''),
(1706, 1163, '_format_quote_source_name', ''),
(1707, 1163, '_format_image', ''),
(1708, 1163, '_format_audio_embed', ''),
(1709, 1163, '_format_video_embed', ''),
(1710, 1164, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1711, 1164, 'standard_seo_post_level_layout', ''),
(1712, 1164, 'standard_link_url_field', ''),
(1713, 1164, 'standard_seo_post_meta_description', ''),
(1714, 1164, 'original_post_id', '922'),
(1715, 1164, '_wp_old_slug', '922'),
(1716, 1168, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1717, 1168, '_wp_old_slug', 'password-protected'),
(1718, 1168, '_publicize_pending', '1'),
(1719, 1168, '_wp_old_slug', 'test-with-secret-password'),
(1720, 1168, 'original_post_id', '131'),
(1721, 1168, '_wp_old_slug', '131'),
(1722, 1169, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1723, 1169, '_publicize_pending', '1'),
(1724, 1169, '_wp_old_slug', '14'),
(1725, 1169, 'original_post_id', '133'),
(1726, 1169, '_wp_old_slug', '133'),
(1727, 1169, '_wp_old_slug', 'no-title-2'),
(1728, 1170, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1729, 1170, '_publicize_pending', '1'),
(1730, 1170, '_wp_old_slug', 'this-post-has-no-body'),
(1731, 1170, 'original_post_id', '134'),
(1732, 1170, '_wp_old_slug', '134'),
(1733, 1170, '_wp_old_slug', 'no-content'),
(1734, 1171, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1735, 1171, '_publicize_pending', '1'),
(1736, 1171, '_wp_old_slug', 'layout-test'),
(1737, 1171, 'original_post_id', '188'),
(1738, 1171, '_wp_old_slug', '188'),
(1739, 1171, '_wp_old_slug', 'paginated'),
(1740, 1173, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1741, 1173, '_publicize_pending', '1'),
(1742, 1173, 'original_post_id', '861'),
(1743, 1173, '_wp_old_slug', '861'),
(1744, 1173, '_wp_old_slug', 'title-with-markup'),
(1745, 1174, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1746, 1174, '_publicize_pending', '1'),
(1747, 1174, 'original_post_id', '867'),
(1748, 1174, '_wp_old_slug', '867'),
(1749, 1175, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1750, 1175, '_wp_old_slug', 'edge-case-non-breaking-text'),
(1751, 1175, '_wp_old_slug', 'non-breaking-text'),
(1752, 1175, '_publicize_pending', '1'),
(1753, 1175, '_wp_old_slug', 'non-breaking-tex'),
(1754, 1175, 'original_post_id', '877'),
(1755, 1175, '_wp_old_slug', '877'),
(1756, 1176, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1757, 1176, '_wp_old_slug', 'text-alignment'),
(1758, 1176, '_publicize_pending', '1'),
(1759, 1176, 'original_post_id', '895'),
(1760, 1176, '_wp_old_slug', '895'),
(1761, 1177, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1762, 1177, '_thumbnail_id', '1023'),
(1763, 1177, '_wp_old_slug', 'image-alignment'),
(1764, 1177, '_publicize_pending', '1'),
(1765, 1177, 'standard_seo_post_level_layout', ''),
(1766, 1177, 'standard_link_url_field', ''),
(1767, 1177, 'standard_seo_post_meta_description', ''),
(1768, 1177, 'original_post_id', '903'),
(1769, 1177, '_wp_old_slug', '903'),
(1770, 1178, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1771, 1178, '_wp_old_slug', 'markup-and-formatting'),
(1772, 1178, '_publicize_pending', '1'),
(1773, 1178, 'standard_seo_post_level_layout', ''),
(1774, 1178, 'standard_link_url_field', ''),
(1775, 1178, 'standard_seo_post_meta_description', ''),
(1776, 1178, 'original_post_id', '919'),
(1777, 1178, '_wp_old_slug', '919'),
(1778, 1179, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1779, 1179, '_publicize_pending', '1'),
(1780, 1179, 'standard_seo_post_level_layout', ''),
(1781, 1179, 'standard_link_url_field', ''),
(1782, 1179, 'standard_seo_post_meta_description', ''),
(1783, 1179, '_wp_old_slug', 'twitter-embeds'),
(1784, 1179, 'original_post_id', '1027'),
(1785, 1179, '_wp_old_slug', '1027'),
(1786, 1241, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1787, 1241, '_publicize_pending', '1'),
(1788, 1241, 'standard_seo_post_level_layout', ''),
(1789, 1241, 'standard_link_url_field', ''),
(1790, 1241, 'standard_seo_post_meta_description', ''),
(1791, 1241, 'original_post_id', '1241'),
(1792, 1241, '_wp_old_slug', '1241'),
(1793, 1241, '_wp_old_slug', 'sticky'),
(1794, 1446, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1795, 1446, '_publicize_pending', '1'),
(1796, 1771, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1797, 1771, '_menu_item_type', 'post_type'),
(1798, 1771, '_menu_item_menu_item_parent', '1729'),
(1799, 1771, '_menu_item_object_id', '1133'),
(1800, 1771, '_menu_item_object', 'page'),
(1801, 1771, '_menu_item_target', ''),
(1802, 1771, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1803, 1771, '_menu_item_xfn', ''),
(1804, 1771, '_menu_item_url', ''),
(1805, 1772, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1806, 1772, '_menu_item_type', 'post_type'),
(1807, 1772, '_menu_item_menu_item_parent', '1729'),
(1808, 1772, '_menu_item_object_id', '1134'),
(1809, 1772, '_menu_item_object', 'page'),
(1810, 1772, '_menu_item_target', ''),
(1811, 1772, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1812, 1772, '_menu_item_xfn', ''),
(1813, 1772, '_menu_item_url', ''),
(1814, 1773, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1815, 1773, '_menu_item_type', 'post_type'),
(1816, 1773, '_menu_item_menu_item_parent', '1729'),
(1817, 1773, '_menu_item_object_id', '1133'),
(1818, 1773, '_menu_item_object', 'page'),
(1819, 1773, '_menu_item_target', ''),
(1820, 1773, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1821, 1773, '_menu_item_xfn', ''),
(1822, 1773, '_menu_item_url', ''),
(1823, 1774, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1824, 1774, '_menu_item_type', 'post_type'),
(1825, 1774, '_menu_item_menu_item_parent', '1729'),
(1826, 1774, '_menu_item_object_id', '1134'),
(1827, 1774, '_menu_item_object', 'page'),
(1828, 1774, '_menu_item_target', ''),
(1829, 1774, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1830, 1774, '_menu_item_xfn', ''),
(1831, 1774, '_menu_item_url', ''),
(1832, 1775, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1833, 1775, '_menu_item_type', 'post_type'),
(1834, 1775, '_menu_item_menu_item_parent', '1760'),
(1835, 1775, '_menu_item_object_id', '1133'),
(1836, 1775, '_menu_item_object', 'page'),
(1837, 1775, '_menu_item_target', ''),
(1838, 1775, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1839, 1775, '_menu_item_xfn', ''),
(1840, 1775, '_menu_item_url', ''),
(1841, 1776, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1842, 1776, '_menu_item_type', 'post_type'),
(1843, 1776, '_menu_item_menu_item_parent', '1760'),
(1844, 1776, '_menu_item_object_id', '1134'),
(1845, 1776, '_menu_item_object', 'page'),
(1846, 1776, '_menu_item_target', ''),
(1847, 1776, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1848, 1776, '_menu_item_xfn', ''),
(1849, 1776, '_menu_item_url', ''),
(1850, 1777, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1851, 1777, '_menu_item_type', 'post_type'),
(1852, 1777, '_menu_item_menu_item_parent', '1765'),
(1853, 1777, '_menu_item_object_id', '746'),
(1854, 1777, '_menu_item_object', 'page'),
(1855, 1777, '_menu_item_target', ''),
(1856, 1777, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1857, 1777, '_menu_item_xfn', ''),
(1858, 1777, '_menu_item_url', ''),
(1859, 1778, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1860, 1778, '_menu_item_type', 'post_type'),
(1861, 1778, '_menu_item_menu_item_parent', '1765'),
(1862, 1778, '_menu_item_object_id', '748'),
(1863, 1778, '_menu_item_object', 'page'),
(1864, 1778, '_menu_item_target', ''),
(1865, 1778, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1866, 1778, '_menu_item_xfn', ''),
(1867, 1778, '_menu_item_url', ''),
(1868, 1779, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1869, 1779, '_menu_item_type', 'post_type'),
(1870, 1779, '_menu_item_menu_item_parent', '1764'),
(1871, 1779, '_menu_item_object_id', '742'),
(1872, 1779, '_menu_item_object', 'page'),
(1873, 1779, '_menu_item_target', ''),
(1874, 1779, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1875, 1779, '_menu_item_xfn', ''),
(1876, 1779, '_menu_item_url', ''),
(1877, 1780, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1878, 1780, '_menu_item_type', 'post_type'),
(1879, 1780, '_menu_item_menu_item_parent', '1764'),
(1880, 1780, '_menu_item_object_id', '744'),
(1881, 1780, '_menu_item_object', 'page'),
(1882, 1780, '_menu_item_target', ''),
(1883, 1780, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(1884, 1780, '_menu_item_xfn', ''),
(1885, 1780, '_menu_item_url', ''),
(2028, 1854, '_wp_attached_file', '2016/11/map.png'),
(2029, 1854, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:956;s:4:"file";s:15:"2016/11/map.png";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:15:"map-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:15:"map-300x149.png";s:5:"width";i:300;s:6:"height";i:149;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:15:"map-768x382.png";s:5:"width";i:768;s:6:"height";i:382;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:16:"map-1024x510.png";s:5:"width";i:1024;s:6:"height";i:510;s:9:"mime-type";s:9:"image/png";}s:14:"post-thumbnail";a:4:{s:4:"file";s:15:"map-849x450.png";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:9:"image/png";}s:11:"goarch_post";a:4:{s:4:"file";s:15:"map-849x450.png";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:9:"image/png";}s:14:"goarch_760_514";a:4:{s:4:"file";s:15:"map-760x514.png";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:9:"image/png";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:15:"map-480x880.png";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2026, 1842, '_wpb_vc_js_status', 'true'),
(2025, 1842, '_wp_page_template', 'template-fullwidth.php'),
(2024, 1842, '_edit_last', '1'),
(2023, 1842, '_edit_lock', '1481620777:1'),
(2022, 1842, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1905, 1179, '_oembed_time_87c7d27b2ded306fa13b795701ad2913', '1474396648'),
(1906, 582, '_oembed_08d080607881e062e6a170b81b728a19', '<iframe width=\'1170\' height=\'658\' src=\'https://videopress.com/embed/hrPKeL5t?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script>'),
(1907, 582, '_oembed_time_08d080607881e062e6a170b81b728a19', '1474396655'),
(1908, 1161, '_oembed_19ab97114275c4b7fc54f2c8ed714fd3', '<iframe width="1170" height="658" src="https://www.youtube.com/embed/SQEQr7c0-dw?feature=oembed" frameborder="0" allowfullscreen></iframe>'),
(1909, 1161, '_oembed_time_19ab97114275c4b7fc54f2c8ed714fd3', '1474396655'),
(1939, 1798, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:380;s:6:"height";i:370;s:4:"file";s:19:"2011/05/380x370.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"380x370-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:19:"380x370-300x292.jpg";s:5:"width";i:300;s:6:"height";i:292;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1938, 1798, '_wp_attached_file', '2011/05/380x370.jpg'),
(1935, 701, '_edit_lock', '1481297669:1'),
(1936, 701, '_edit_last', '1'),
(1937, 701, '_wpb_vc_js_status', 'true'),
(1940, 1799, '_wp_attached_file', '2011/05/icon-architecture.png'),
(1941, 1799, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:88;s:6:"height";i:62;s:4:"file";s:29:"2011/05/icon-architecture.png";s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1942, 1800, '_wp_attached_file', '2011/05/icon-interiors.png'),
(1943, 1800, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:112;s:6:"height";i:59;s:4:"file";s:26:"2011/05/icon-interiors.png";s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1944, 1801, '_wp_attached_file', '2011/05/icon-planing.png'),
(1945, 1801, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:113;s:6:"height";i:51;s:4:"file";s:24:"2011/05/icon-planing.png";s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1946, 1806, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1947, 1806, '_edit_lock', '1481740720:1'),
(1948, 1806, '_edit_last', '1'),
(1949, 1808, '_wp_attached_file', '2016/11/1-480x880.jpg'),
(1950, 1808, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:21:"2016/11/1-480x880.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"1-480x880-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"1-480x880-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"1-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"1-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"1-480x880-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1951, 1809, '_wp_attached_file', '2016/11/1-780x668.jpg'),
(1952, 1809, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:780;s:6:"height";i:668;s:4:"file";s:21:"2016/11/1-780x668.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"1-780x668-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"1-780x668-300x257.jpg";s:5:"width";i:300;s:6:"height";i:257;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:21:"1-780x668-768x658.jpg";s:5:"width";i:768;s:6:"height";i:658;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"1-780x668-780x450.jpg";s:5:"width";i:780;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"1-780x668-780x450.jpg";s:5:"width";i:780;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"1-780x668-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:21:"1-780x668-480x668.jpg";s:5:"width";i:480;s:6:"height";i:668;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1953, 1810, '_wp_attached_file', '2016/11/2-480x880.jpg'),
(1954, 1810, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:21:"2016/11/2-480x880.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"2-480x880-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"2-480x880-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"2-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"2-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"2-480x880-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1955, 1811, '_wp_attached_file', '2016/11/2-780x668.jpg'),
(1956, 1811, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:780;s:6:"height";i:668;s:4:"file";s:21:"2016/11/2-780x668.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"2-780x668-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"2-780x668-300x257.jpg";s:5:"width";i:300;s:6:"height";i:257;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:21:"2-780x668-768x658.jpg";s:5:"width";i:768;s:6:"height";i:658;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"2-780x668-780x450.jpg";s:5:"width";i:780;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"2-780x668-780x450.jpg";s:5:"width";i:780;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"2-780x668-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:21:"2-780x668-480x668.jpg";s:5:"width";i:480;s:6:"height";i:668;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1957, 1812, '_wp_attached_file', '2016/11/3-480x880.jpg'),
(1958, 1812, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:21:"2016/11/3-480x880.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"3-480x880-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"3-480x880-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"3-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"3-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"3-480x880-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1959, 1813, '_wp_attached_file', '2016/11/3-780x668.jpg');
REPLACE INTO `xwlpv_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(1960, 1813, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:780;s:6:"height";i:668;s:4:"file";s:21:"2016/11/3-780x668.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"3-780x668-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"3-780x668-300x257.jpg";s:5:"width";i:300;s:6:"height";i:257;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:21:"3-780x668-768x658.jpg";s:5:"width";i:768;s:6:"height";i:658;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"3-780x668-780x450.jpg";s:5:"width";i:780;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"3-780x668-780x450.jpg";s:5:"width";i:780;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"3-780x668-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:21:"3-780x668-480x668.jpg";s:5:"width";i:480;s:6:"height";i:668;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1961, 1814, '_wp_attached_file', '2016/11/4-480x880.jpg'),
(1962, 1814, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:21:"2016/11/4-480x880.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"4-480x880-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"4-480x880-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"4-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"4-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"4-480x880-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1963, 1815, '_wp_attached_file', '2016/11/5-480x880.jpg'),
(1964, 1815, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:21:"2016/11/5-480x880.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"5-480x880-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"5-480x880-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"5-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"5-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"5-480x880-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1965, 1816, '_wp_attached_file', '2016/11/6-480x880.jpg'),
(1966, 1816, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:21:"2016/11/6-480x880.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"6-480x880-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"6-480x880-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"6-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"6-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"6-480x880-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1967, 1817, '_wp_attached_file', '2016/11/7-480x880.jpg'),
(1968, 1817, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:21:"2016/11/7-480x880.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"7-480x880-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"7-480x880-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"7-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"7-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"7-480x880-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1969, 1818, '_wp_attached_file', '2016/11/8-480x880.jpg'),
(1970, 1818, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:21:"2016/11/8-480x880.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"8-480x880-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"8-480x880-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"8-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"8-480x880-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:21:"8-480x880-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(1971, 1806, '_thumbnail_id', '1808'),
(1972, 1819, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1973, 1819, '_edit_lock', '1481740730:1'),
(1974, 1819, '_edit_last', '1'),
(1975, 1819, '_thumbnail_id', '1810'),
(1976, 1820, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1977, 1820, '_edit_lock', '1481740731:1'),
(1978, 1820, '_edit_last', '1'),
(1979, 1820, '_thumbnail_id', '1812'),
(1980, 1821, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1981, 1821, '_edit_lock', '1481740732:1'),
(1982, 1821, '_edit_last', '1'),
(1983, 1821, '_thumbnail_id', '1814'),
(1984, 1822, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1985, 1822, '_edit_lock', '1481740733:1'),
(1986, 1822, '_edit_last', '1'),
(1987, 1822, '_thumbnail_id', '1815'),
(1988, 1823, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1989, 1823, '_edit_lock', '1481740738:1'),
(1990, 1823, '_edit_last', '1'),
(1991, 1823, '_thumbnail_id', '1816'),
(1992, 1824, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1993, 1824, '_edit_lock', '1481740737:1'),
(1994, 1824, '_edit_last', '1'),
(1995, 1824, '_thumbnail_id', '1817'),
(1996, 1825, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(1997, 1825, '_edit_lock', '1481740736:1'),
(1998, 1825, '_edit_last', '1'),
(1999, 1825, '_thumbnail_id', '1814'),
(2000, 1828, '_wp_attached_file', '2011/05/502X526.jpg'),
(2001, 1828, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:502;s:6:"height";i:526;s:4:"file";s:19:"2011/05/502X526.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"502X526-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:19:"502X526-286x300.jpg";s:5:"width";i:286;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:19:"502X526-502x450.jpg";s:5:"width";i:502;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:19:"502X526-502x450.jpg";s:5:"width";i:502;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:19:"502X526-502x514.jpg";s:5:"width";i:502;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:19:"502X526-480x526.jpg";s:5:"width";i:480;s:6:"height";i:526;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2003, 1831, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:170;s:6:"height";i:57;s:4:"file";s:13:"2011/05/2.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:12:"2-150x57.png";s:5:"width";i:150;s:6:"height";i:57;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2065, 1883, '_wp_page_template', 'template-fullwidth.php'),
(2030, 1842, '_goarch_short_description', '<p><br></p>'),
(2031, 1862, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2032, 1862, '_edit_lock', '1478781417:1'),
(2322, 1991, '_menu_item_target', ''),
(2321, 1991, '_menu_item_object', 'custom'),
(2320, 1991, '_menu_item_object_id', '1991'),
(2319, 1991, '_menu_item_menu_item_parent', '1636'),
(2318, 1991, '_menu_item_type', 'custom'),
(2317, 1991, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2010, 1835, '_wp_attached_file', '2011/05/1.png'),
(2011, 1835, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:171;s:6:"height";i:35;s:4:"file";s:13:"2011/05/1.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:12:"1-150x35.png";s:5:"width";i:150;s:6:"height";i:35;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2066, 1883, '_wpb_vc_js_status', 'true'),
(2067, 1883, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2068, 1890, '_wp_attached_file', '2016/11/1-780x668-1.jpg'),
(2069, 1890, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:780;s:6:"height";i:668;s:4:"file";s:23:"2016/11/1-780x668-1.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"1-780x668-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:23:"1-780x668-1-300x257.jpg";s:5:"width";i:300;s:6:"height";i:257;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:23:"1-780x668-1-768x658.jpg";s:5:"width";i:768;s:6:"height";i:658;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:23:"1-780x668-1-780x450.jpg";s:5:"width";i:780;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:23:"1-780x668-1-780x450.jpg";s:5:"width";i:780;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:23:"1-780x668-1-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:23:"1-780x668-1-480x668.jpg";s:5:"width";i:480;s:6:"height";i:668;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2070, 1898, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2071, 1898, '_menu_item_type', 'post_type'),
(2072, 1898, '_menu_item_menu_item_parent', '0'),
(2073, 1898, '_menu_item_object_id', '1842'),
(2074, 1898, '_menu_item_object', 'page'),
(2075, 1898, '_menu_item_target', ''),
(2076, 1898, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2077, 1898, '_menu_item_xfn', ''),
(2078, 1898, '_menu_item_url', ''),
(2079, 1898, '_menu_item_orphaned', '1478803027'),
(2182, 1916, '_wpb_vc_js_status', 'true'),
(2181, 1916, '_wp_page_template', 'template-fullwidth.php'),
(2180, 1916, '_edit_last', '1'),
(2179, 1916, '_edit_lock', '1481298245:1'),
(2178, 1916, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2151, 1906, '_edit_lock', '1481201976:1'),
(2187, 1929, '_menu_item_object_id', '1916'),
(2186, 1929, '_menu_item_menu_item_parent', '0'),
(2185, 1929, '_menu_item_type', 'post_type'),
(2184, 1929, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2100, 1901, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2101, 1901, '_menu_item_type', 'post_type'),
(2102, 1901, '_menu_item_menu_item_parent', '0'),
(2103, 1901, '_menu_item_object_id', '1842'),
(2104, 1901, '_menu_item_object', 'page'),
(2105, 1901, '_menu_item_target', ''),
(2106, 1901, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2107, 1901, '_menu_item_xfn', ''),
(2108, 1901, '_menu_item_url', ''),
(2152, 1906, '_edit_last', '1'),
(2250, 1153, 'slide_template', 'default'),
(2249, 1153, '_goarch_image_id', '0'),
(2248, 1153, '_thumbnail_id', '1871'),
(2247, 1153, '_edit_last', '1'),
(2150, 1906, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2120, 1903, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2121, 1903, '_menu_item_type', 'post_type'),
(2122, 1903, '_menu_item_menu_item_parent', '1994'),
(2123, 1903, '_menu_item_object_id', '701'),
(2124, 1903, '_menu_item_object', 'page'),
(2125, 1903, '_menu_item_target', ''),
(2126, 1903, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2127, 1903, '_menu_item_xfn', ''),
(2128, 1903, '_menu_item_url', ''),
(2153, 1906, '_wp_page_template', 'template-fullwidth.php'),
(2364, 1879, '_wpb_vc_js_status', 'true'),
(2363, 1879, 'slide_template', 'default'),
(2362, 1880, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2361, 1880, '_wpb_vc_js_status', 'true'),
(2140, 1905, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2141, 1905, '_menu_item_type', 'post_type'),
(2142, 1905, '_menu_item_menu_item_parent', '1912'),
(2143, 1905, '_menu_item_object_id', '1883'),
(2144, 1905, '_menu_item_object', 'page'),
(2145, 1905, '_menu_item_target', ''),
(2146, 1905, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2147, 1905, '_menu_item_xfn', ''),
(2148, 1905, '_menu_item_url', ''),
(2154, 1906, '_wpb_vc_js_status', 'true'),
(2158, 1911, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2159, 1911, '_menu_item_type', 'post_type'),
(2160, 1911, '_menu_item_menu_item_parent', '1912'),
(2161, 1911, '_menu_item_object_id', '1906'),
(2162, 1911, '_menu_item_object', 'page'),
(2163, 1911, '_menu_item_target', ''),
(2164, 1911, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2165, 1911, '_menu_item_xfn', ''),
(2166, 1911, '_menu_item_url', ''),
(2168, 1912, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2169, 1912, '_menu_item_type', 'post_type'),
(2170, 1912, '_menu_item_menu_item_parent', '0'),
(2171, 1912, '_menu_item_object_id', '1906'),
(2172, 1912, '_menu_item_object', 'page'),
(2173, 1912, '_menu_item_target', ''),
(2174, 1912, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2175, 1912, '_menu_item_xfn', ''),
(2176, 1912, '_menu_item_url', ''),
(2188, 1929, '_menu_item_object', 'page'),
(2189, 1929, '_menu_item_target', ''),
(2190, 1929, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2191, 1929, '_menu_item_xfn', ''),
(2192, 1929, '_menu_item_url', ''),
(2197, 1932, '_wp_attached_file', '2016/09/slide2.jpg'),
(2198, 1932, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:900;s:4:"file";s:18:"2016/09/slide2.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"slide2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"slide2-300x141.jpg";s:5:"width";i:300;s:6:"height";i:141;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:18:"slide2-768x360.jpg";s:5:"width";i:768;s:6:"height";i:360;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:19:"slide2-1024x480.jpg";s:5:"width";i:1024;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"slide2-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:18:"slide2-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:18:"slide2-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:18:"slide2-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2199, 1933, '_wp_attached_file', '2016/09/slide3.jpg'),
(2200, 1933, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1358;s:4:"file";s:18:"2016/09/slide3.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"slide3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"slide3-300x212.jpg";s:5:"width";i:300;s:6:"height";i:212;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:18:"slide3-768x543.jpg";s:5:"width";i:768;s:6:"height";i:543;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:19:"slide3-1024x724.jpg";s:5:"width";i:1024;s:6:"height";i:724;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"slide3-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:18:"slide3-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:18:"slide3-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:18:"slide3-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2201, 701, 'slide_template', 'default'),
(2360, 1880, 'slide_template', 'default'),
(2203, 1936, '_wp_attached_file', '2016/09/slide1-1.jpg'),
(2204, 1936, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1280;s:4:"file";s:20:"2016/09/slide1-1.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"slide1-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"slide1-1-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"slide1-1-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"slide1-1-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"slide1-1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"slide1-1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"slide1-1-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:20:"slide1-1-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2205, 1937, '_wp_attached_file', '2016/09/slide3-1.jpg'),
(2206, 1937, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1358;s:4:"file";s:20:"2016/09/slide3-1.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"slide3-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"slide3-1-300x212.jpg";s:5:"width";i:300;s:6:"height";i:212;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"slide3-1-768x543.jpg";s:5:"width";i:768;s:6:"height";i:543;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"slide3-1-1024x724.jpg";s:5:"width";i:1024;s:6:"height";i:724;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"slide3-1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"slide3-1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"slide3-1-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:20:"slide3-1-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2207, 1938, '_wp_attached_file', 'revslider/mainslider/slide1.jpg'),
(2208, 1938, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1080;s:4:"file";s:31:"revslider/mainslider/slide1.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"slide1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"slide1-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:18:"slide1-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:19:"slide1-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"slide1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:18:"slide1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:18:"slide1-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:18:"slide1-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2209, 1939, '_wp_attached_file', 'revslider/mainslider/slide2.jpg'),
(2210, 1939, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1056;s:4:"file";s:31:"revslider/mainslider/slide2.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"slide2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"slide2-300x165.jpg";s:5:"width";i:300;s:6:"height";i:165;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:18:"slide2-768x422.jpg";s:5:"width";i:768;s:6:"height";i:422;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:19:"slide2-1024x563.jpg";s:5:"width";i:1024;s:6:"height";i:563;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"slide2-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:18:"slide2-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:18:"slide2-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:18:"slide2-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2211, 1940, '_wp_attached_file', 'revslider/mainslider/slide3.jpg'),
(2212, 1940, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1080;s:4:"file";s:31:"revslider/mainslider/slide3.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:18:"slide3-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:18:"slide3-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:18:"slide3-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:19:"slide3-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:18:"slide3-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:18:"slide3-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:18:"slide3-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:18:"slide3-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2213, 1943, '_wp_attached_file', '2016/09/slide1-2.jpg'),
(2214, 1943, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1280;s:4:"file";s:20:"2016/09/slide1-2.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"slide1-2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"slide1-2-300x200.jpg";s:5:"width";i:300;s:6:"height";i:200;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"slide1-2-768x512.jpg";s:5:"width";i:768;s:6:"height";i:512;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"slide1-2-1024x683.jpg";s:5:"width";i:1024;s:6:"height";i:683;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"slide1-2-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"slide1-2-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"slide1-2-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:20:"slide1-2-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2215, 1944, '_wp_attached_file', '2016/09/slide2-1.jpg'),
(2216, 1944, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:900;s:4:"file";s:20:"2016/09/slide2-1.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"slide2-1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"slide2-1-300x141.jpg";s:5:"width";i:300;s:6:"height";i:141;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"slide2-1-768x360.jpg";s:5:"width";i:768;s:6:"height";i:360;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"slide2-1-1024x480.jpg";s:5:"width";i:1024;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"slide2-1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"slide2-1-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"slide2-1-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:20:"slide2-1-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2217, 1945, '_wp_attached_file', '2016/09/slide3-2.jpg'),
(2218, 1945, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1358;s:4:"file";s:20:"2016/09/slide3-2.jpg";s:5:"sizes";a:8:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"slide3-2-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:20:"slide3-2-300x212.jpg";s:5:"width";i:300;s:6:"height";i:212;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:20:"slide3-2-768x543.jpg";s:5:"width";i:768;s:6:"height";i:543;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:21:"slide3-2-1024x724.jpg";s:5:"width";i:1024;s:6:"height";i:724;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:20:"slide3-2-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:20:"slide3-2-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:20:"slide3-2-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}s:27:"goarch-image-480x880-croped";a:4:{s:4:"file";s:20:"slide3-2-480x880.jpg";s:5:"width";i:480;s:6:"height";i:880;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2219, 1946, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2220, 1946, '_edit_lock', '1480967561:1'),
(2221, 1946, '_edit_last', '1'),
(2222, 1946, '_thumbnail_id', '1792'),
(2237, 1949, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2225, 1946, '_goarch_image_id', '0'),
(2226, 1946, 'slide_template', 'default'),
(2311, 155, '_edit_lock', '1481100224:1'),
(2238, 1949, '_menu_item_type', 'taxonomy'),
(2239, 1949, '_menu_item_menu_item_parent', '0'),
(2240, 1949, '_menu_item_object_id', '181'),
(2241, 1949, '_menu_item_object', 'category'),
(2242, 1949, '_menu_item_target', ''),
(2243, 1949, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2244, 1949, '_menu_item_xfn', ''),
(2245, 1949, '_menu_item_url', ''),
(2253, 1951, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2254, 1951, '_edit_lock', '1480967711:1'),
(2255, 1951, '_edit_last', '1'),
(2256, 1952, '_wp_attached_file', '2016/11/2-760x514.jpg'),
(2257, 1952, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:760;s:6:"height";i:514;s:4:"file";s:21:"2016/11/2-760x514.jpg";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"2-760x514-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"2-760x514-300x203.jpg";s:5:"width";i:300;s:6:"height";i:203;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:21:"2-760x514-760x450.jpg";s:5:"width";i:760;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:21:"2-760x514-760x450.jpg";s:5:"width";i:760;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2258, 1951, '_thumbnail_id', '1952'),
(2263, 1954, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2261, 1951, '_goarch_image_id', '0'),
(2262, 1951, 'slide_template', 'default'),
(2264, 1954, '_edit_lock', '1480967564:1'),
(2265, 1954, '_edit_last', '1'),
(2266, 1954, '_thumbnail_id', '1788'),
(2271, 1806, 'slide_template', 'default'),
(2269, 1954, '_goarch_image_id', '0'),
(2270, 1954, 'slide_template', 'default'),
(2272, 1959, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2273, 1959, '_edit_lock', '1481740737:1'),
(2274, 1959, '_edit_last', '1'),
(2275, 1960, '_wp_attached_file', '2016/11/11.jpg'),
(2276, 1960, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:480;s:6:"height";i:880;s:4:"file";s:14:"2016/11/11.jpg";s:5:"sizes";a:5:{s:9:"thumbnail";a:4:{s:4:"file";s:14:"11-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:14:"11-164x300.jpg";s:5:"width";i:164;s:6:"height";i:300;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:14:"11-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:14:"11-480x450.jpg";s:5:"width";i:480;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:14:"11-480x514.jpg";s:5:"width";i:480;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2277, 1959, '_thumbnail_id', '1960'),
(2278, 1959, 'slide_template', 'default'),
(2279, 1906, 'slide_template', 'default'),
(2280, 1916, 'slide_template', 'default'),
(2281, 1964, '_wp_attached_file', '2016/11/about.jpg'),
(2282, 1964, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1920;s:6:"height";i:1080;s:4:"file";s:17:"2016/11/about.jpg";s:5:"sizes";a:7:{s:9:"thumbnail";a:4:{s:4:"file";s:17:"about-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:17:"about-300x169.jpg";s:5:"width";i:300;s:6:"height";i:169;s:9:"mime-type";s:10:"image/jpeg";}s:12:"medium_large";a:4:{s:4:"file";s:17:"about-768x432.jpg";s:5:"width";i:768;s:6:"height";i:432;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:18:"about-1024x576.jpg";s:5:"width";i:1024;s:6:"height";i:576;s:9:"mime-type";s:10:"image/jpeg";}s:14:"post-thumbnail";a:4:{s:4:"file";s:17:"about-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:11:"goarch_post";a:4:{s:4:"file";s:17:"about-849x450.jpg";s:5:"width";i:849;s:6:"height";i:450;s:9:"mime-type";s:10:"image/jpeg";}s:14:"goarch_760_514";a:4:{s:4:"file";s:17:"about-760x514.jpg";s:5:"width";i:760;s:6:"height";i:514;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2283, 1842, 'slide_template', 'default'),
(2284, 1906, '_goarch_image_id', '0'),
(2285, 1916, '_goarch_image_id', '0'),
(2286, 701, '_goarch_image_id', '0'),
(2287, 1842, '_goarch_image_id', '0'),
(2290, 1980, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2291, 1980, '_edit_lock', '1480781419:1'),
(2292, 1980, '_edit_last', '1'),
(2293, 1980, '_wp_page_template', 'template-fullwidth.php'),
(2294, 1980, 'slide_template', 'default'),
(2295, 1980, '_goarch_image_id', '0'),
(2296, 1980, '_wpb_vc_js_status', 'false'),
(2309, 1983, '_wp_attached_file', '2016/12/favicon.png'),
(2310, 1983, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:32;s:6:"height";i:32;s:4:"file";s:19:"2016/12/favicon.png";s:5:"sizes";a:0:{}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2312, 1987, '_wp_attached_file', '2011/05/1-1.png'),
(2313, 1987, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:171;s:6:"height";i:35;s:4:"file";s:15:"2011/05/1-1.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:14:"1-1-150x35.png";s:5:"width";i:150;s:6:"height";i:35;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2314, 1988, '_wp_attached_file', '2011/05/2-1.png'),
(2315, 1988, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:170;s:6:"height";i:57;s:4:"file";s:15:"2011/05/2-1.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:14:"2-1-150x57.png";s:5:"width";i:150;s:6:"height";i:57;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
(2316, 1906, '_wpb_shortcodes_custom_css', '.vc_custom_1481186408229{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/2-480x880.jpg?id=1810) !important;}'),
(2323, 1991, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2324, 1991, '_menu_item_xfn', ''),
(2325, 1991, '_menu_item_url', 'http://murren.ru/templates/WP/go-arch/go-arch-light/'),
(2327, 1992, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2328, 1992, '_menu_item_type', 'post_type'),
(2329, 1992, '_menu_item_menu_item_parent', '1636'),
(2330, 1992, '_menu_item_object_id', '701'),
(2331, 1992, '_menu_item_object', 'page'),
(2332, 1992, '_menu_item_target', ''),
(2333, 1992, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2334, 1992, '_menu_item_xfn', ''),
(2335, 1992, '_menu_item_url', ''),
(2342, 1993, '_menu_item_target', ''),
(2343, 1993, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2344, 1993, '_menu_item_xfn', ''),
(2345, 1993, '_menu_item_url', 'http://murren.ru/templates/WP/go-arch/go-arch-light/'),
(2347, 1994, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(2348, 1994, '_menu_item_type', 'post_type'),
(2349, 1994, '_menu_item_menu_item_parent', '0'),
(2350, 1994, '_menu_item_object_id', '701'),
(2351, 1994, '_menu_item_object', 'page'),
(2352, 1994, '_menu_item_target', ''),
(2353, 1994, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(2354, 1994, '_menu_item_xfn', ''),
(2355, 1994, '_menu_item_url', ''),
(2365, 1879, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2366, 1878, 'slide_template', 'default'),
(2367, 1878, '_wpb_vc_js_status', 'true'),
(2368, 1878, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2369, 1825, 'slide_template', 'default'),
(2370, 1825, '_wpb_vc_js_status', 'true'),
(2371, 1825, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2372, 1824, 'slide_template', 'default'),
(2373, 1824, '_wpb_vc_js_status', 'true'),
(2374, 1824, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2375, 1823, 'slide_template', 'default'),
(2376, 1823, '_wpb_vc_js_status', 'true'),
(2377, 1823, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2378, 1822, 'slide_template', 'default'),
(2379, 1822, '_wpb_vc_js_status', 'true'),
(2380, 1822, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2381, 1821, 'slide_template', 'default'),
(2382, 1821, '_wpb_vc_js_status', 'true'),
(2383, 1821, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2384, 1820, 'slide_template', 'default'),
(2385, 1820, '_wpb_vc_js_status', 'true'),
(2386, 1820, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2387, 1819, 'slide_template', 'default'),
(2388, 1819, '_wpb_vc_js_status', 'true'),
(2389, 1819, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}'),
(2390, 1806, '_wpb_vc_js_status', 'true'),
(2391, 1806, '_wpb_shortcodes_custom_css', '.vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}');

CREATE TABLE IF NOT EXISTS `xwlpv_posts` (
  `ID` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2001 DEFAULT CHARSET=utf8;

REPLACE INTO `xwlpv_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(1, 1, '2016-09-11 12:57:37', '2016-09-11 12:57:37', 'Welcome to WordPress. This is your first post. Edit or delete it, then start writing!', 'Hello world!', '', 'publish', 'open', 'open', '', 'hello-world', '', '', '2016-09-11 12:57:37', '2016-09-11 12:57:37', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?p=1', 0, 'post', '', 1),
(2, 1, '2016-09-11 12:57:37', '2016-09-11 12:57:37', 'This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href="http://murren.ru/templates/WP/go-arch/go-arch-light/wp-admin/">your dashboard</a> to delete this page and create new pages for your content. Have fun!', 'Sample Page', '', 'publish', 'closed', 'open', '', 'sample-page', '', '', '2016-09-11 12:57:37', '2016-09-11 12:57:37', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?page_id=2', 0, 'page', '', 0),
(1999, 1, '2016-12-14 18:21:39', '0000-00-00 00:00:00', '', 'Auto Draft', '', 'auto-draft', 'open', 'open', '', '', '', '', '2016-12-14 18:21:39', '0000-00-00 00:00:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?p=1999', 0, 'post', '', 0),
(773, 2, '2011-07-15 14:50:37', '2011-07-15 21:50:37', 'Public domain via http://www.burningwell.org/gallery2/main.php?g2_view=dynamicalbum.UpdatesAlbum&amp;g2_itemId=25770', 'Brazil Beach', 'Jericoacoara Ceara Brasil', 'inherit', 'open', 'closed', '', 'img_0747', '', '', '2011-07-15 14:50:37', '2011-07-15 21:50:37', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/img_0747-1.jpg', 0, 'attachment', 'image/jpeg', 0),
(5, 2, '2016-09-11 16:59:19', '2016-09-11 16:59:19', '', 'Media', '', 'private', 'closed', 'closed', '', 'media', '', '', '2016-09-11 16:59:19', '2016-09-11 16:59:19', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?goarch=media', 0, 'goarch', '', 0),
(6, 2, '2016-09-11 17:02:34', '2016-09-11 17:02:34', '', 'Main Page', '', 'publish', 'closed', 'closed', '', 'main-page', '', '', '2016-09-11 17:02:34', '2016-09-11 17:02:34', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?page_id=6', 0, 'page', '', 0),
(7, 2, '2016-09-11 17:02:34', '2016-09-11 17:02:34', '', 'Main Page', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2016-09-11 17:02:34', '2016-09-11 17:02:34', '', 6, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/11/6-revision-v1/', 0, 'revision', '', 0),
(1787, 1, '2016-11-04 13:14:24', '2016-11-04 13:14:24', 'When you enter into any new area of science, you almost always find yourself with a baffling new language of technical terms to learn before you can converse with the experts. This is certainly true in astronomy both in terms of terms that refer to the cosmos and terms that describe the tools of the trade, the most prevalent being the telescope. So to get us off of first base, let’s define some of the key terms that pertain to telescopes to help you be able to talk to them more intelligently.\r\n\r\nThe first area of specialization in telescopes has to do with the types of telescopes people use. The three designs of telescopes that most people use are the Refractor, the Reflector and the Schmidt Cassegrain telescope. The refractor telescope uses a convex lens to focus the light on the eyepiece. The reflector telescope has a concave lens which means it bends in. It uses mirrors to focus the image that you eventually see. The Schmidt Cassegrain telescope uses an involved system of mirrors to capture the image you want to see. A binocular telescope uses a set of telescopes mounted and synchronized so your view of the sky is 3-D.\r\n\r\nBeyond the basic types, other terms refer to parts of the telescope or to the science behind how telescopes work. Collimation is a term for how well tuned the telescope is to give you a good clear image of what you are looking at. You want your telescope to have good collimation so you are not getting a false image of the celestial body.\r\n\r\nAperture is a fancy word for how big the lens of your telescope is. But it’s an important word because the aperture of the lens is the key to how powerful your telescope is. Magnification has nothing to do with it, its all in the aperture.', 'Advice for stirring your online community and fostering engagement  Sticky note agile personas', '', 'publish', 'open', 'open', '', 'advice-for-stirring-your-online-community-and-fostering-engagement-sticky-note-agile-personas', '', '', '2016-11-04 13:14:33', '2016-11-04 13:14:33', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?p=1787', 0, 'post', '', 0),
(9, 3, '2010-07-25 19:40:01', '2010-07-26 02:40:01', 'This site is using the standard WordPress Theme Unit Test Data for content. The Theme Unit Test is a series of posts and pages that match up with a checklist on the WordPress codex. You can use the data and checklist together to test your theme.\n\n<h2>WordPress Theme Development Resources</h2>\n\n<ol>\n	<li>See <a href="http://codex.wordpress.org/Theme_Development">Theme Development</a> for <a href="http://codex.wordpress.org/Theme_Development#Code_Standards">code standards</a>, examples of best practices, and <a href="http://codex.wordpress.org/Theme_Development#Resources_and_References">resources for Theme development</a>.</li>\n	<li>See <a href="http://codex.wordpress.org/Theme_Unit_Test">Theme Unit Test</a> for a robust test suite for your Theme and get the latest version of the test data you see here.</li>\n	<li>See <a href="http://codex.wordpress.org/Theme_Review">Theme Review</a> for a guide to submitting your Theme to the <a href="http://wordpress.org/extend/themes/">Themes Directory</a>.</li>\n</ol>', 'About The Tests', '', 'publish', 'closed', 'closed', '', 'about', '', '', '2010-07-25 19:40:01', '2010-07-26 02:40:01', '', 0, 'http://wpthemetestdata.wordpress.com/about/', 1, 'page', '', 0),
(146, 3, '2007-09-04 09:52:50', '2007-09-04 16:52:50', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec mollis. Quisque convallis libero in sapien pharetra tincidunt. Aliquam elit ante, malesuada id, tempor eu, gravida id, odio. Maecenas suscipit, risus et eleifend imperdiet, nisi orci ullamcorper massa, et adipiscing orci velit quis magna. Praesent sit amet ligula id orci venenatis auctor. Phasellus porttitor, metus non tincidunt dapibus, orci pede pretium neque, sit amet adipiscing ipsum lectus et libero. Aenean bibendum. Curabitur mattis quam id urna. Vivamus dui. Donec nonummy lacinia lorem. Cras risus arcu, sodales ac, ultrices ac, mollis quis, justo. Sed a libero. Quisque risus erat, posuere at, tristique non, lacinia quis, eros.\n\nCras volutpat, lacus quis semper pharetra, nisi enim dignissim est, et sollicitudin quam ipsum vel mi. Sed commodo urna ac urna. Nullam eu tortor. Curabitur sodales scelerisque magna. Donec ultricies tristique pede. Nullam libero. Nam sollicitudin felis vel metus. Nullam posuere molestie metus. Nullam molestie, nunc id suscipit rhoncus, felis mi vulputate lacus, a ultrices tortor dolor eget augue. Aenean ultricies felis ut turpis. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Suspendisse placerat tellus ac nulla. Proin adipiscing sem ac risus. Maecenas nisi. Cras semper.\n\nPraesent interdum mollis neque. In egestas nulla eget pede. Integer eu purus sed diam dictum scelerisque. Morbi cursus velit et felis. Maecenas faucibus aliquet erat. In aliquet rhoncus tellus. Integer auctor nibh a nunc fringilla tempus. Cras turpis urna, dignissim vel, suscipit pulvinar, rutrum quis, sem. Ut lobortis convallis dui. Sed nonummy orci a justo. Morbi nec diam eget eros eleifend tincidunt.\n\nCurabitur non elit. Pellentesque iaculis, nisl non aliquet adipiscing, purus urna aliquet orci, sed sodales pede neque at massa. Pellentesque laoreet, enim eget varius mollis, sapien erat suscipit metus, sit amet iaculis nulla sapien id felis. Aliquam erat volutpat. Nam congue nulla a ligula. Morbi tempor hendrerit erat. Curabitur augue. Vestibulum nulla est, commodo et, fringilla quis, bibendum eget, ipsum. Suspendisse pulvinar iaculis ante. Mauris dignissim ante quis nisi. Aliquam ante mi, aliquam et, pellentesque ac, dapibus et, enim. In vulputate justo vel magna. Phasellus imperdiet justo. Proin odio orci, dapibus id, porta a, pellentesque id, erat. Aliquam erat volutpat. Mauris nonummy varius libero. Sed dolor ipsum, tempor non, aliquet et, pulvinar quis, dui. Pellentesque mauris diam, lobortis id, varius varius, facilisis at, nulla.\n\nCras pede. Nullam id velit sit amet turpis tincidunt sagittis. Nunc malesuada. Nunc consequat scelerisque odio. Donec eu leo. Nunc pellentesque felis sed odio. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Vivamus lobortis metus in lectus. Cras mollis quam eget sapien. Pellentesque non lorem sit amet sem lacinia euismod.\n\nNulla eget diam eget leo imperdiet consequat. Morbi nunc magna, pellentesque eu, porta at, ultricies ut, neque. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; In tincidunt. Praesent ut orci id eros congue ultrices. Mauris non neque. Donec nulla ante, molestie sit amet, fermentum nec, blandit sit amet, purus. Fusce eget diam eu odio iaculis mollis. Phasellus consectetuer pede quis nisi. Proin non sem ut elit pulvinar faucibus. In a turpis nec augue fringilla elementum.\n\nNullam felis. Donec in nulla. Suspendisse sodales, turpis in suscipit ullamcorper, enim nunc sagittis risus, eu auctor velit tortor ut turpis. Mauris id augue at neque aliquam eleifend. Sed eget augue. Nunc faucibus ligula sed massa. Etiam non nulla. Etiam accumsan ullamcorper nisl. In pharetra massa at nunc. Nunc elementum. Duis sodales enim nec libero. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos hymenaeos. Praesent dapibus eros sodales urna. Duis magna nisi, lobortis quis, tincidunt rutrum, posuere non, ipsum.\n\nAliquam convallis neque vitae diam. In diam. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Duis fermentum arcu in tortor. Sed nibh leo, rhoncus eu, fermentum et, scelerisque ac, massa. Cras id turpis. Etiam commodo sem luctus lorem. Morbi at mi. In rutrum. Aenean luctus pede euismod tortor. Phasellus dictum. Cras neque justo, venenatis sit amet, tristique et, vulputate in, dui. Etiam sed mi gravida sapien imperdiet dictum. Aliquam gravida orci a tortor. Donec tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Vivamus risus ante, pellentesque vitae, luctus eget, scelerisque sed, libero. Donec massa.\n\nDonec libero mauris, volutpat at, convallis vel, laoreet euismod, augue. In accumsan malesuada risus. Mauris metus magna, condimentum in, nonummy non, ornare eu, velit. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Proin posuere. Proin rhoncus rutrum lorem. Phasellus dignissim massa non libero volutpat tincidunt. In hac habitasse platea dictumst. Phasellus eget eros. Nulla in nulla. Vivamus quis mauris. Maecenas pharetra rhoncus tellus. Sed sit amet lacus.\n\nQuisque interdum felis a tellus. Aliquam sed diam ac velit aliquam rutrum. Morbi commodo, risus a pulvinar adipiscing, tortor pede posuere risus, ac ornare tellus massa nec lectus. Vivamus mollis metus ac sapien. Nam sed est a libero ullamcorper dapibus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Aenean a erat ac nibh accumsan volutpat. Phasellus pulvinar consequat turpis. Curabitur ante metus, tempus ut, consequat eu, sollicitudin sit amet, justo. Duis ut libero.\n\nՀայերեն\n\nLorem Ipsum-ը տպագրության և տպագրական արդյունաբերության համար նախատեսված մոդելային տեքստ է: Սկսած 1500-ականներից` Lorem Ipsum-ը հանդիսացել է տպագրական արդյունաբերության ստանդարտ մոդելային տեքստ, ինչը մի անհայտ տպագրիչի կողմից տարբեր տառատեսակների օրինակների գիրք ստեղծելու ջանքերի արդյունք է: Այս տեքստը ոչ միայն կարողացել է գոյատևել հինգ դարաշրջան, այլև ներառվել է էլեկտրոնային տպագրության մեջ` մնալով էապես անփոփոխ: Այն հայտնի է դարձել 1960-ականներին Lorem Ipsum բովանդակող Letraset էջերի թողարկման արդյունքում, իսկ ավելի ուշ համակարգչային տպագրության այնպիսի ծրագրերի թողարկման հետևանքով, ինչպիսին է Aldus PageMaker-ը, որը ներառում է Lorem Ipsum-ի տարատեսակներ:\n\nБългарски\n\nLorem Ipsum е елементарен примерен текст, използван в печатарската и типографската индустрия. Lorem Ipsum е индустриален стандарт от около 1500 година, когато неизвестен печатар взема няколко печатарски букви и ги разбърква, за да напечата с тях книга с примерни шрифтове. Този начин не само е оцелял повече от 5 века, но е навлязъл и в публикуването на електронни издания като е запазен почти без промяна. Популяризиран е през 60те години на 20ти век със издаването на Letraset листи, съдържащи Lorem Ipsum пасажи, популярен е и в наши дни във софтуер за печатни издания като Aldus PageMaker, който включва различни версии на Lorem Ipsum.\n\nCatalà\n\nLorem Ipsum és un text de farciment usat per la indústria de la tipografia i la impremta. Lorem Ipsum ha estat el text estàndard de la indústria des de l\'any 1500, quan un impressor desconegut va fer servir una galerada de text i la va mesclar per crear un llibre de mostres tipogràfiques. No només ha sobreviscut cinc segles, sinó que ha fet el salt cap a la creació de tipus de lletra electrònics, romanent essencialment sense canvis. Es va popularitzar l\'any 1960 amb el llançament de fulls Letraset que contenien passatges de Lorem Ipsum, i més recentment amb programari d\'autoedició com Aldus Pagemaker que inclou versions de Lorem Ipsum.\n\nHrvatski\n\nLorem Ipsum je jednostavno probni tekst koji se koristi u tiskarskoj i slovoslagarskoj industriji. Lorem Ipsum postoji kao industrijski standard još od 16-og stoljeća, kada je nepoznati tiskar uzeo tiskarsku galiju slova i posložio ih da bi napravio knjigu s uzorkom tiska. Taj je tekst ne samo preživio pet stoljeća, već se i vinuo u svijet elektronskog slovoslagarstva, ostajući u suštini nepromijenjen. Postao je popularan tijekom 1960-ih s pojavom Letraset listova s odlomcima Lorem Ipsum-a, a u skorije vrijeme sa software-om za stolno izdavaštvo kao što je Aldus PageMaker koji također sadrži varijante Lorem Ipsum-a.\n\nČesky\n\nLorem Ipsum je demonstrativní výplňový text používaný v tiskařském a knihařském průmyslu. Lorem Ipsum je považováno za standard v této oblasti už od začátku 16. století, kdy dnes neznámý tiskař vzal kusy textu a na jejich základě vytvořil speciální vzorovou knihu. Jeho odkaz nevydržel pouze pět století, on přežil i nástup elektronické sazby v podstatě beze změny. Nejvíce popularizováno bylo Lorem Ipsum v šedesátých letech 20. století, kdy byly vydávány speciální vzorníky s jeho pasážemi a později pak díky počítačovým DTP programům jako Aldus PageMaker.\n\nRomâna\n\nLorem Ipsum este pur şi simplu o machetă pentru text a industriei tipografice. Lorem Ipsum a fost macheta standard a industriei încă din secolul al XVI-lea, când un tipograf anonim a luat o planşetă de litere şi le-a amestecat pentru a crea o carte demonstrativă pentru literele respective. Nu doar că a supravieţuit timp de cinci secole, dar şi a facut saltul în tipografia electronică practic neschimbată. A fost popularizată în anii \'60 odată cu ieşirea colilor Letraset care conţineau pasaje Lorem Ipsum, iar mai recent, prin programele de publicare pentru calculator, ca Aldus PageMaker care includeau versiuni de Lorem Ipsum.\n\nСрпски\n\nLorem Ipsum је једноставно модел текста који се користи у штампарској и словослагачкој индустрији. Lorem ipsum је био стандард за модел текста још од 1500. године, када је непознати штампар узео кутију са словима и сложио их како би направио узорак књиге. Не само што је овај модел опстао пет векова, него је чак почео да се користи и у електронским медијима, непроменивши се. Популаризован је шездесетих година двадесетог века заједно са листовима летерсета који су садржали Lorem Ipsum пасусе, а данас са софтверским пакетом за прелом као што је Aldus PageMaker који је садржао Lorem Ipsum верзије.', 'Lorem Ipsum', '', 'publish', 'closed', 'closed', '', 'lorem-ipsum', '', '', '2007-09-04 09:52:50', '2007-09-04 16:52:50', '', 0, 'http://wpthemetestdata.wordpress.com/lorem-ipsum/', 7, 'page', '', 0),
(155, 3, '2007-09-04 10:47:47', '2007-09-04 17:47:47', 'Repository-hosted Themes are required to support display of comments on static Pages as well as on single blog Posts.  This static Page has comments, and these comments should be displayed.\nIf the Theme includes a custom option to prevent static Pages from displaying comments, such option must be disabled (i.e. so that static Pages display comments) by default.\nAlso, verify that this Page does not display taxonomy information (e.g. categories or tags) or time-stamp information (Page publish date/time).', 'Page with comments', '', 'publish', 'open', 'closed', '', 'page-with-comments', '', '', '2007-09-04 10:47:47', '2007-09-04 17:47:47', '', 9, 'http://wpthemetestdata.wordpress.com/page-with-comments/', 3, 'page', '', 0),
(156, 3, '2007-09-04 10:48:10', '2007-09-04 17:48:10', 'This static Page is set not to allow comments. Verify that the Page does not display a comment list, comment reply links, or comment reply form.\nAlso, verify that the Page does not display a "comments are closed" type message. Such messages are not suitable for static Pages, and should only be used on blog Posts.', 'Page with comments disabled', '', 'publish', 'closed', 'closed', '', 'page-with-comments-disabled', '', '', '2007-09-04 10:48:10', '2007-09-04 17:48:10', '', 9, 'http://wpthemetestdata.wordpress.com/page-with-comments-disabled/', 4, 'page', '', 0),
(172, 3, '2007-12-11 16:23:16', '2007-12-11 06:23:16', 'Level 3 of the reverse hierarchy test.', 'Level 3', '', 'publish', 'closed', 'closed', '', 'level-3', '', '', '2007-12-11 16:23:16', '2007-12-11 06:23:16', '', 0, 'http://wpthemetestdata.wordpress.com/level-3/', 0, 'page', '', 0),
(173, 3, '2007-12-11 16:23:33', '2007-12-11 06:23:33', 'Level 2 of the reverse hierarchy test.', 'Level 2', '', 'publish', 'closed', 'closed', '', 'level-2', '', '', '2007-12-11 16:23:33', '2007-12-11 06:23:33', '', 0, 'http://wpthemetestdata.wordpress.com/level-2/', 0, 'page', '', 0),
(174, 3, '2007-12-11 16:25:40', '2007-12-11 23:25:40', 'Level 1 of the reverse hierarchy test.  This is to make sure the importer correctly assigns parents and children even when the children come first in the export file.', 'Level 1', '', 'publish', 'closed', 'closed', '', 'level-1', '', '', '2007-12-11 16:25:40', '2007-12-11 23:25:40', '', 0, 'http://wpthemetestdata.wordpress.com/level-1/', 5, 'page', '', 0),
(501, 3, '2010-08-01 09:42:26', '2010-08-01 16:42:26', 'The last item in this page\'s content is a floated image. Make sure any elements after it are clearing properly.\n\n<img class="alignleft size-thumbnail wp-image-827" title="Camera" src="http://wpthemetestdata.files.wordpress.com/2010/08/manhattansummer.jpg?w=150" alt="" width="150" height="112" />', 'Clearing Floats', '', 'publish', 'closed', 'closed', '', 'clearing-floats', '', '', '2010-08-01 09:42:26', '2010-08-01 16:42:26', '', 9, 'http://wpthemetestdata.wordpress.com/', 2, 'page', '', 0),
(611, 3, '2011-01-10 06:17:54', '2011-01-10 13:17:54', '', 'canola2', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec mollis. Quisque convallis libero in sapien pharetra tincidunt. Aliquam elit ante, malesuada id, tempor eu, gravida id, odio. Maecenas suscipit, risus et eleifend imperdiet, nisi orci ullamcorper massa, et adipiscing orci velit quis magna.', 'inherit', 'open', 'closed', '', 'canola2', '', '', '2011-01-10 06:17:54', '2011-01-10 13:17:54', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/01/canola2.jpg', 0, 'attachment', 'image/jpeg', 0),
(616, 3, '2011-01-10 06:20:37', '2011-01-10 13:20:37', '', 'dsc20050727_091048_222', '', 'inherit', 'open', 'closed', '', 'dsc20050727_091048_222', '', '', '2011-01-10 06:20:37', '2011-01-10 13:20:37', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/01/dsc20050727_091048_222.jpg', 0, 'attachment', 'image/jpeg', 0),
(617, 3, '2011-01-10 06:20:57', '2011-01-10 13:20:57', '', 'dsc20050813_115856_52', '', 'inherit', 'open', 'closed', '', 'dsc20050813_115856_52', '', '', '2011-01-10 06:20:57', '2011-01-10 13:20:57', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/01/dsc20050813_115856_52.jpg', 0, 'attachment', 'image/jpeg', 0),
(701, 1, '2011-05-20 18:49:43', '2011-05-21 01:49:43', '[vc_row][vc_column][goarch_main_slider alias_slider="home"][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D" section_id="about"][goarch_project portfolio_category="" post_id=" 1806 , 1959,1820 ,1821 , 1879, 1823, 1824,1878" order="ASC"][goarch_experience content2="12" img="1828"][goarch_clients heading="Our" b_text="Work together " img="1835" items="%5B%7B%22src%22%3A%221987%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221988%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221987%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221988%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221987%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221988%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221987%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221988%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221987%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221988%22%2C%22c_url%22%3A%22%23%22%7D%5D" b_url="http://murren.ru/templates/WP/go-arch/go-arch-light/projects-list/"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'Home', '', 'publish', 'open', 'closed', '', 'front-page', '', '', '2016-12-09 15:36:10', '2016-12-09 15:36:10', '', 0, 'http://wpthemetestdata.wordpress.com/?page_id=701', 0, 'page', '', 0),
(1795, 1, '2016-11-04 16:21:44', '2016-11-04 16:21:44', '', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-04 16:21:44', '2016-11-04 16:21:44', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/04/701-revision-v1/', 0, 'revision', '', 0),
(1798, 1, '2016-11-05 15:40:25', '2016-11-05 15:40:25', '', '380x370', '', 'inherit', 'open', 'closed', '', '380x370', '', '', '2016-11-05 15:40:25', '2016-11-05 15:40:25', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/05/380x370.jpg', 0, 'attachment', 'image/jpeg', 0),
(1799, 1, '2016-11-05 15:42:07', '2016-11-05 15:42:07', '', 'icon-architecture', '', 'inherit', 'open', 'closed', '', 'icon-architecture', '', '', '2016-11-05 15:42:07', '2016-11-05 15:42:07', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/05/icon-architecture.png', 0, 'attachment', 'image/png', 0),
(1797, 1, '2016-11-05 13:24:27', '2016-11-05 13:24:27', '[vc_row][vc_column][goarch_main_slider][goarch_about][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-05 13:24:27', '2016-11-05 13:24:27', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/05/701-revision-v1/', 0, 'revision', '', 0),
(703, 3, '2011-05-20 18:51:43', '2011-05-21 01:51:43', 'Use this static Page to test the Theme\'s handling of the Blog Posts Index page. If the site is set to display a static Page on the Front Page, and this Page is set to display the Blog Posts Index, then this text should not appear.', 'Blog', '', 'publish', 'open', 'closed', '', 'blog', '', '', '2011-05-20 18:51:43', '2011-05-21 01:51:43', '', 0, 'http://wpthemetestdata.wordpress.com/?page_id=703', 0, 'page', '', 0),
(754, 3, '2011-07-15 14:34:50', '2011-07-15 21:34:50', 'Public domain via http://www.burningwell.org/gallery2/v/Objects/100_5540.JPG.html', 'Bell on Wharf', 'Bell on wharf in San Francisco', 'inherit', 'open', 'closed', '', '100_5478', '', '', '2011-07-15 14:34:50', '2011-07-15 21:34:50', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/100_5478.jpg', 0, 'attachment', 'image/jpeg', 0),
(755, 3, '2011-07-15 14:35:55', '2011-07-15 21:35:55', 'Public domain via http://www.burningwell.org/gallery2/v/Objects/100_5478.JPG.html', 'Golden Gate Bridge', 'Golden Gate Bridge', 'inherit', 'open', 'closed', '', '100_5540', '', '', '2011-07-15 14:35:55', '2011-07-15 21:35:55', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/100_5540.jpg', 0, 'attachment', 'image/jpeg', 0),
(756, 3, '2011-07-15 14:41:24', '2011-07-15 21:41:24', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/CEP00032.jpg.html', 'Sunburst Over River', 'Sunburst over the Clinch River, Southwest Virginia.', 'inherit', 'open', 'closed', '', 'cep00032', '', '', '2011-07-15 14:41:24', '2011-07-15 21:41:24', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/cep00032.jpg', 0, 'attachment', 'image/jpeg', 0),
(757, 3, '2011-07-15 14:41:27', '2011-07-15 21:41:27', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/DCP_2082.jpg.html', 'Boardwalk', 'Boardwalk at Westport, WA', 'inherit', 'open', 'closed', '', 'dcp_2082', '', '', '2011-07-15 14:41:27', '2011-07-15 21:41:27', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dcp_2082.jpg', 0, 'attachment', 'image/jpeg', 0),
(758, 3, '2011-07-15 14:41:33', '2011-07-15 21:41:33', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/dsc03149.jpg.html', 'Yachtsody in Blue', 'Boats and reflections, Royal Perth Yacht Club', 'inherit', 'open', 'closed', '', 'dsc03149', '', '', '2011-07-15 14:41:33', '2011-07-15 21:41:33', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dsc03149.jpg', 0, 'attachment', 'image/jpeg', 0),
(759, 3, '2011-07-15 14:41:37', '2011-07-15 21:41:37', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/dsc04563.jpg.html', 'Rain Ripples', 'Raindrop ripples on a pond', 'inherit', 'open', 'closed', '', 'dsc04563', '', '', '2011-07-15 14:41:37', '2011-07-15 21:41:37', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dsc04563.jpg', 0, 'attachment', 'image/jpeg', 0),
(760, 3, '2011-07-15 14:41:41', '2011-07-15 21:41:41', 'Public domain via http://www.burningwell.org/gallery2/v/Objects/dsc09114.jpg.html', 'Sydney Harbor Bridge', 'Sydney Harbor Bridge', 'inherit', 'open', 'closed', '', 'dsc09114', '', '', '2011-07-15 14:41:41', '2011-07-15 21:41:41', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dsc09114.jpg', 0, 'attachment', 'image/jpeg', 0),
(761, 3, '2011-07-15 14:41:42', '2011-07-15 21:41:42', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/dsc20050102_192118_51.jpg.html', 'Wind Farm', 'Albany wind-farm against the sunset, Western Australia', 'inherit', 'open', 'closed', '', 'dsc20050102_192118_51', '', '', '2011-07-15 14:41:42', '2011-07-15 21:41:42', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dsc20050102_192118_51.jpg', 0, 'attachment', 'image/jpeg', 0),
(762, 3, '2011-07-15 14:41:45', '2011-07-15 21:41:45', 'Public domain via http://www.burningwell.org/gallery2/v/Objects/dsc20051220_160808_102.jpg.html', 'Antique Farm Machinery', 'Antique farm machinery, Mount Barker Museum, Western Australia', 'inherit', 'open', 'closed', '', 'dsc20051220_160808_102', '', '', '2011-07-15 14:41:45', '2011-07-15 21:41:45', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dsc20051220_160808_102.jpg', 0, 'attachment', 'image/jpeg', 0),
(763, 3, '2011-07-15 14:46:27', '2011-07-15 21:46:27', 'Public domain via http://www.burningwell.org/gallery2/main.php?g2_view=dynamicalbum.UpdatesAlbum&amp;g2_itemId=25895', 'Orange Iris', 'Orange Iris', 'inherit', 'open', 'closed', '', 'dsc02085', '', '', '2011-07-15 14:46:27', '2011-07-15 21:46:27', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dsc02085.jpg', 0, 'attachment', 'image/jpeg', 0),
(764, 3, '2011-07-15 14:47:17', '2011-07-15 21:47:17', 'Public domain via http://www.burningwell.org/gallery2/v/Objects/dsc20051220_173257_119.jpg.html', 'Rusty Rail', 'Rusty rails with fishplate, Kojonup', 'inherit', 'open', 'closed', '', 'dsc20051220_173257_119', '', '', '2011-07-15 14:47:17', '2011-07-15 21:47:17', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dsc20051220_173257_119.jpg', 0, 'attachment', 'image/jpeg', 0),
(765, 3, '2011-07-15 14:47:20', '2011-07-15 21:47:20', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/dscn3316.jpg.html', 'Sea and Rocks', 'Sea and rocks, Plimmerton, New Zealand', 'inherit', 'open', 'closed', '', 'dscn3316', '', '', '2011-07-15 14:47:20', '2011-07-15 21:47:20', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/dscn3316.jpg', 0, 'attachment', 'image/jpeg', 0),
(766, 3, '2011-07-15 14:47:23', '2011-07-15 21:47:23', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/michelle_049.jpg.html', 'Big Sur', 'Beach at Big Sur, CA', 'inherit', 'open', 'closed', '', 'michelle_049', '', '', '2011-07-15 14:47:23', '2011-07-15 21:47:23', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/michelle_049.jpg', 0, 'attachment', 'image/jpeg', 0),
(767, 3, '2011-07-15 14:47:26', '2011-07-15 21:47:26', 'Public domain via http://www.burningwell.org/gallery2/v/Objects/Windmill.jpg.html', 'Windmill', 'Windmill shrouded in fog at a farm outside of Walker, Iowa', 'inherit', 'open', 'closed', '', 'dcf-1-0', '', '', '2011-07-15 14:47:26', '2011-07-15 21:47:26', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/windmill.jpg', 0, 'attachment', 'image/jpeg', 0),
(768, 3, '2011-07-15 14:49:48', '2011-07-15 21:49:48', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/IMG_0513-1.JPG.html', 'Huatulco Coastline', 'Sunrise over the coast in Huatulco, Oaxaca, Mexico', 'inherit', 'open', 'closed', '', 'alas-i-have-found-my-shangri-la', '', '', '2011-07-15 14:49:48', '2011-07-15 21:49:48', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/img_0513-1.jpg', 0, 'attachment', 'image/jpeg', 0),
(1785, 1, '2016-11-04 10:33:27', '2016-11-04 10:33:27', 'Use this static Page to test the Theme\'s handling <!--nextpage-->of the Blog Posts Index page. If the site is set to display a static Page on the Front Page, and this Page is set to display the Blog Posts Index, then this text should not appear.', 'Blog', '', 'inherit', 'closed', 'closed', '', '703-autosave-v1', '', '', '2016-11-04 10:33:27', '2016-11-04 10:33:27', '', 703, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/04/703-autosave-v1/', 0, 'revision', '', 0),
(774, 2, '2011-07-15 14:51:19', '2011-07-15 21:51:19', 'Public domain via http://www.burningwell.org/gallery2/v/Landscapes/ocean/IMG_0767.JPG.html', 'Huatulco Coastline', 'Coastline in Huatulco, Oaxaca, Mexico', 'inherit', 'open', 'closed', '', 'img_0767', '', '', '2011-07-15 14:51:19', '2011-07-15 21:51:19', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/07/img_0767.jpg', 0, 'attachment', 'image/jpeg', 0),
(807, 2, '2012-06-04 11:36:56', '2012-06-04 18:36:56', '', 'dsc20040724_152504_532', '', 'inherit', 'open', 'closed', '', 'dsc20040724_152504_532-2', '', '', '2012-06-04 11:36:56', '2012-06-04 18:36:56', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2012/06/dsc20040724_152504_532.jpg', 0, 'attachment', 'image/jpeg', 0),
(811, 2, '2012-06-04 11:58:15', '2012-06-04 18:58:15', '', 'dsc20050604_133440_3421', '', 'inherit', 'open', 'closed', '', 'dsc20050604_133440_3421', '', '', '2012-06-04 11:58:15', '2012-06-04 18:58:15', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2012/06/dsc20050604_133440_34211.jpg', 0, 'attachment', 'image/jpeg', 0),
(821, 2, '2012-07-05 09:49:29', '2012-07-05 16:49:29', 'St. Louis Blues, by Original Dixieland Jazz Band with Al Bernard (public domain)', 'St. Louis Blues', 'St. Louis Blues, by Original Dixieland Jazz Band with Al Bernard (public domain)', 'inherit', 'open', 'closed', '', 'originaldixielandjazzbandwithalbernard-stlouisblues', '', '', '2012-07-05 09:49:29', '2012-07-05 16:49:29', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2012/07/originaldixielandjazzbandwithalbernard-stlouisblues.mp3', 0, 'attachment', 'audio/mpeg', 0),
(827, 2, '2012-07-05 11:07:34', '2012-07-05 18:07:34', '', 'OLYMPUS DIGITAL CAMERA', '', 'inherit', 'open', 'closed', '', 'olympus-digital-camera', '', '', '2012-07-05 11:07:34', '2012-07-05 18:07:34', '', 501, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2012/07/manhattansummer.jpg', 0, 'attachment', 'image/jpeg', 0),
(967, 2, '2013-03-14 19:44:50', '2013-03-15 00:44:50', '', 'Image Alignment 580x300', '', 'inherit', 'open', 'open', '', 'image-alignment-580x300', '', '', '2013-03-14 19:44:50', '2013-03-15 00:44:50', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/03/image-alignment-580x300.jpg', 0, 'attachment', 'image/jpeg', 0),
(968, 2, '2013-03-14 19:44:49', '2013-03-15 00:44:49', '', 'Image Alignment 150x150', '', 'inherit', 'open', 'open', '', 'image-alignment-150x150', '', '', '2013-03-14 19:44:49', '2013-03-15 00:44:49', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/03/image-alignment-150x150.jpg', 0, 'attachment', 'image/jpeg', 0),
(1022, 2, '2013-03-15 15:40:38', '2013-03-15 20:40:38', '', 'Horizontal Featured Image', '', 'inherit', 'open', 'open', '', 'featured-image-horizontal-2', '', '', '2013-03-15 15:40:38', '2013-03-15 20:40:38', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/03/featured-image-horizontal.jpg', 0, 'attachment', 'image/jpeg', 0),
(1023, 2, '2013-03-14 09:58:24', '2013-03-14 14:58:24', '', 'I Am Worth Loving Wallpaper', '', 'inherit', 'open', 'open', '', 'soworthloving-wallpaper', '', '', '2013-03-14 09:58:24', '2013-03-14 14:58:24', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/03/soworthloving-wallpaper.jpg', 0, 'attachment', 'image/jpeg', 0),
(1025, 2, '2013-03-14 19:44:49', '2013-03-15 00:44:49', '', 'Image Alignment 300x200', '', 'inherit', 'open', 'open', '', 'image-alignment-300x200', '', '', '2013-03-14 19:44:49', '2013-03-15 00:44:49', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/03/image-alignment-300x200.jpg', 0, 'attachment', 'image/jpeg', 0),
(1027, 2, '2013-03-15 15:41:09', '2013-03-15 20:41:09', '', 'Vertical Featured Image', '', 'inherit', 'open', 'open', '', 'featured-image-vertical-2', '', '', '2013-03-15 15:41:09', '2013-03-15 20:41:09', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/03/featured-image-vertical.jpg', 0, 'attachment', 'image/jpeg', 0),
(1029, 2, '2013-03-14 19:44:50', '2013-03-15 00:44:50', '', 'Image Alignment 1200x4002', '', 'inherit', 'open', 'open', '', 'image-alignment-1200x4002', '', '', '2013-03-14 19:44:50', '2013-03-15 00:44:50', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/03/image-alignment-1200x4002.jpg', 0, 'attachment', 'image/jpeg', 0),
(1045, 2, '2013-03-14 22:10:39', '2013-03-15 03:10:39', '', 'Unicorn Wallpaper', '', 'inherit', 'open', 'open', '', 'unicorn-wallpaper', '', '', '2013-03-14 22:10:39', '2013-03-15 03:10:39', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/03/unicorn-wallpaper.jpg', 0, 'attachment', 'image/jpeg', 0),
(1046, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Pages', '', 'publish', 'closed', 'closed', '', 'pages', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/pages/', 1, 'nav_menu_item', '', 0),
(1047, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Categories', '', 'publish', 'closed', 'closed', '', 'categories', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/categories/', 14, 'nav_menu_item', '', 0),
(1048, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', 'Posts in this category test markup tags and styles.', '', '', 'publish', 'closed', 'closed', '', '1048', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 15, 'nav_menu_item', '', 0),
(1050, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', 'Posts in this category test unpublished posts.', '', '', 'publish', 'closed', 'closed', '', '1050', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 16, 'nav_menu_item', '', 0),
(1051, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Depth', '', 'publish', 'closed', 'closed', '', 'depth', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/depth/', 39, 'nav_menu_item', '', 0),
(1052, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 01', '', 'publish', 'closed', 'closed', '', 'level-01', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-01/', 40, 'nav_menu_item', '', 0),
(1053, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 02', '', 'publish', 'closed', 'closed', '', 'level-02', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-02/', 41, 'nav_menu_item', '', 0),
(1054, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 03', '', 'publish', 'closed', 'closed', '', 'level-03', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-03/', 42, 'nav_menu_item', '', 0),
(1055, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 04', '', 'publish', 'closed', 'closed', '', 'level-04', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-04/', 43, 'nav_menu_item', '', 0),
(1056, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 05', '', 'publish', 'closed', 'closed', '', 'level-05', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-05/', 44, 'nav_menu_item', '', 0),
(1057, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 06', '', 'publish', 'closed', 'closed', '', 'level-06', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-06/', 45, 'nav_menu_item', '', 0),
(1058, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 07', '', 'publish', 'closed', 'closed', '', 'level-07', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-07/', 46, 'nav_menu_item', '', 0),
(1059, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 08', '', 'publish', 'closed', 'closed', '', 'level-08', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-08/', 47, 'nav_menu_item', '', 0),
(1060, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 09', '', 'publish', 'closed', 'closed', '', 'level-09', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-09/', 48, 'nav_menu_item', '', 0),
(1061, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Level 10', '', 'publish', 'closed', 'closed', '', 'level-10', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-10/', 49, 'nav_menu_item', '', 0),
(1062, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Advanced', '', 'publish', 'closed', 'closed', '', 'advanced', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/advanced/', 58, 'nav_menu_item', '', 0),
(1063, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', 'Custom Menu Description', 'Menu Description', '', 'publish', 'closed', 'closed', '', 'menu-description', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-description/', 63, 'nav_menu_item', '', 0),
(1064, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Menu Title Attribute', 'Custom Title Attribute', 'publish', 'closed', 'closed', '', 'menu-title-attribute', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-title-attribute/', 59, 'nav_menu_item', '', 0),
(1065, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'Menu CSS Class', '', 'publish', 'closed', 'closed', '', 'menu-css-class', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-css-class/', 60, 'nav_menu_item', '', 0),
(1066, 2, '2016-09-20 18:10:10', '2016-09-20 18:10:10', '', 'New Window / Tab', '', 'publish', 'closed', 'closed', '', 'new-window-tab', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/new-window-tab/', 61, 'nav_menu_item', '', 0),
(1628, 2, '2013-04-09 13:17:31', '2013-04-09 20:17:31', '', 'triforce-wallpaper', 'It’s dangerous to go alone! Take this.', 'inherit', 'open', 'closed', '', 'triforce-wallpaper', '', '', '2013-04-09 13:17:31', '2013-04-09 20:17:31', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/04/triforce-wallpaper.jpg', 0, 'attachment', 'image/jpeg', 0),
(1629, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 'Home', '', 'publish', 'closed', 'closed', '', 'home', '', '', '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/home/', 1, 'nav_menu_item', '', 0),
(1630, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1630', '', '', '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 2, 'nav_menu_item', '', 0),
(1631, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1631', '', '', '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 3, 'nav_menu_item', '', 0),
(1632, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1632', '', '', '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 4, 'nav_menu_item', '', 0),
(1633, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1633', '', '', '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 5, 'nav_menu_item', '', 0),
(1634, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1634', '', '', '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 6, 'nav_menu_item', '', 0),
(1635, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1635', '', '', '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 7, 'nav_menu_item', '', 0),
(1636, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', '', 'Home', '', 'publish', 'closed', 'closed', '', 'home-2', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/home-2/', 1, 'nav_menu_item', '', 0),
(1639, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1639', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 12, 'nav_menu_item', '', 0),
(1640, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1640', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 13, 'nav_menu_item', '', 0),
(1641, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1641', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 14, 'nav_menu_item', '', 0),
(1642, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1642', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 15, 'nav_menu_item', '', 0),
(1643, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1643', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 26, 'nav_menu_item', '', 0),
(1644, 2, '2016-09-20 18:10:11', '2016-09-20 18:10:11', ' ', '', '', 'publish', 'closed', 'closed', '', '1644', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 27, 'nav_menu_item', '', 0),
(1849, 1, '2016-11-08 17:34:58', '2016-11-08 17:34:58', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 17:34:58', '2016-11-08 17:34:58', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1686, 2, '2013-09-18 14:37:05', '2013-09-18 21:37:05', '', 'dsc20040724_152504_532', '', 'inherit', 'open', 'closed', '', 'dsc20040724_152504_532', '', '', '2013-09-18 14:37:05', '2013-09-18 21:37:05', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/09/dsc20040724_152504_532.jpg', 0, 'attachment', 'image/jpeg', 0),
(1687, 2, '2013-09-18 14:37:07', '2013-09-18 21:37:07', '', 'dsc20050604_133440_34211', '', 'inherit', 'open', 'closed', '', 'dsc20050604_133440_34211', '', '', '2013-09-18 14:37:07', '2013-09-18 21:37:07', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/09/dsc20050604_133440_34211.jpg', 0, 'attachment', 'image/jpeg', 0),
(1830, 1, '2016-11-07 17:25:52', '2016-11-07 17:25:52', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" order="DESC " portfolio_category=""][goarch_experience content2="12" img="1828"][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-07 17:25:52', '2016-11-07 17:25:52', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/07/701-revision-v1/', 0, 'revision', '', 0),
(1931, 1, '2016-11-24 17:46:34', '2016-11-24 17:46:34', '', 'slide1', '', 'inherit', 'open', 'closed', '', 'slide1', '', '', '2016-11-24 17:46:34', '2016-11-24 17:46:34', '', 5, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/09/slide1.jpg', 0, 'attachment', 'image/jpeg', 0),
(1689, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Pages', '', 'publish', 'closed', 'closed', '', 'pages-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/pages-2/', 7, 'nav_menu_item', '', 0);
REPLACE INTO `xwlpv_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(1690, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Categories', '', 'publish', 'closed', 'closed', '', 'categories-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/categories-2/', 8, 'nav_menu_item', '', 0),
(1691, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', 'Posts in this category test markup tags and styles.', '', '', 'publish', 'closed', 'closed', '', '1691', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 9, 'nav_menu_item', '', 0),
(1693, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', 'Posts in this category test unpublished posts.', '', '', 'publish', 'closed', 'closed', '', '1693', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 10, 'nav_menu_item', '', 0),
(1694, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Depth', '', 'publish', 'closed', 'closed', '', 'depth-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/depth-2/', 28, 'nav_menu_item', '', 0),
(1695, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 01', '', 'publish', 'closed', 'closed', '', 'level-01-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-01-2/', 29, 'nav_menu_item', '', 0),
(1696, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 02', '', 'publish', 'closed', 'closed', '', 'level-02-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-02-2/', 30, 'nav_menu_item', '', 0),
(1697, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 03', '', 'publish', 'closed', 'closed', '', 'level-03-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-03-2/', 31, 'nav_menu_item', '', 0),
(1698, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 04', '', 'publish', 'closed', 'closed', '', 'level-04-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-04-2/', 32, 'nav_menu_item', '', 0),
(1699, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 05', '', 'publish', 'closed', 'closed', '', 'level-05-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-05-2/', 33, 'nav_menu_item', '', 0),
(1700, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 06', '', 'publish', 'closed', 'closed', '', 'level-06-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-06-2/', 34, 'nav_menu_item', '', 0),
(1701, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 07', '', 'publish', 'closed', 'closed', '', 'level-07-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-07-2/', 35, 'nav_menu_item', '', 0),
(1702, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 08', '', 'publish', 'closed', 'closed', '', 'level-08-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-08-2/', 36, 'nav_menu_item', '', 0),
(1703, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 09', '', 'publish', 'closed', 'closed', '', 'level-09-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-09-2/', 37, 'nav_menu_item', '', 0),
(1704, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Level 10', '', 'publish', 'closed', 'closed', '', 'level-10-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-10-2/', 38, 'nav_menu_item', '', 0),
(1705, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Advanced', '', 'publish', 'closed', 'closed', '', 'advanced-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/advanced-2/', 50, 'nav_menu_item', '', 0),
(1706, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', 'Custom Menu Description', 'Menu Description', '', 'publish', 'closed', 'closed', '', 'menu-description-2', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-description-2/', 64, 'nav_menu_item', '', 0),
(1707, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Menu Title Attribute', 'Custom Title Attribute', 'publish', 'closed', 'closed', '', 'menu-title-attribute-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-title-attribute-2/', 51, 'nav_menu_item', '', 0),
(1708, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Menu CSS Class', '', 'publish', 'closed', 'closed', '', 'menu-css-class-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-css-class-2/', 52, 'nav_menu_item', '', 0),
(1709, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'New Window / Tab', '', 'publish', 'closed', 'closed', '', 'new-window-tab-2', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/new-window-tab-2/', 53, 'nav_menu_item', '', 0),
(1710, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Home', '', 'publish', 'closed', 'closed', '', 'home-3', '', '', '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/home-3/', 1, 'nav_menu_item', '', 0),
(1711, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1711', '', '', '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 2, 'nav_menu_item', '', 0),
(1712, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1712', '', '', '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 3, 'nav_menu_item', '', 0),
(1713, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1713', '', '', '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 4, 'nav_menu_item', '', 0),
(1714, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1714', '', '', '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 5, 'nav_menu_item', '', 0),
(1715, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1715', '', '', '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 6, 'nav_menu_item', '', 0),
(1716, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1716', '', '', '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 7, 'nav_menu_item', '', 0),
(1717, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', '', 'Home', '', 'publish', 'closed', 'closed', '', 'home-4', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/home-4/', 7, 'nav_menu_item', '', 0),
(1718, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1718', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 4, 'nav_menu_item', '', 0),
(1724, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1724', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 16, 'nav_menu_item', '', 0),
(1725, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1725', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 17, 'nav_menu_item', '', 0),
(1726, 2, '2016-09-20 18:15:54', '2016-09-20 18:15:54', ' ', '', '', 'publish', 'closed', 'closed', '', '1726', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 18, 'nav_menu_item', '', 0),
(1846, 1, '2016-11-08 15:04:32', '2016-11-08 15:04:32', '[vc_row][vc_column][goarch_about_main_section][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 15:04:32', '2016-11-08 15:04:32', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1729, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Pages', '', 'publish', 'closed', 'closed', '', 'pages-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/pages-3/', 2, 'nav_menu_item', '', 0),
(1730, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Categories', '', 'publish', 'closed', 'closed', '', 'categories-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/categories-3/', 11, 'nav_menu_item', '', 0),
(1731, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', 'Posts in this category test markup tags and styles.', '', '', 'publish', 'closed', 'closed', '', '1731', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 12, 'nav_menu_item', '', 0),
(1733, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', 'Posts in this category test unpublished posts.', '', '', 'publish', 'closed', 'closed', '', '1733', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 13, 'nav_menu_item', '', 0),
(1734, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Depth', '', 'publish', 'closed', 'closed', '', 'depth-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/depth-3/', 17, 'nav_menu_item', '', 0),
(1735, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 01', '', 'publish', 'closed', 'closed', '', 'level-01-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-01-3/', 18, 'nav_menu_item', '', 0),
(1736, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 02', '', 'publish', 'closed', 'closed', '', 'level-02-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-02-3/', 19, 'nav_menu_item', '', 0),
(1737, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 03', '', 'publish', 'closed', 'closed', '', 'level-03-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-03-3/', 20, 'nav_menu_item', '', 0),
(1738, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 04', '', 'publish', 'closed', 'closed', '', 'level-04-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-04-3/', 21, 'nav_menu_item', '', 0),
(1739, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 05', '', 'publish', 'closed', 'closed', '', 'level-05-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-05-3/', 22, 'nav_menu_item', '', 0),
(1740, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 06', '', 'publish', 'closed', 'closed', '', 'level-06-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-06-3/', 23, 'nav_menu_item', '', 0),
(1741, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 07', '', 'publish', 'closed', 'closed', '', 'level-07-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-07-3/', 24, 'nav_menu_item', '', 0),
(1742, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 08', '', 'publish', 'closed', 'closed', '', 'level-08-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-08-3/', 25, 'nav_menu_item', '', 0),
(1743, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 09', '', 'publish', 'closed', 'closed', '', 'level-09-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-09-3/', 26, 'nav_menu_item', '', 0),
(1744, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Level 10', '', 'publish', 'closed', 'closed', '', 'level-10-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/level-10-3/', 27, 'nav_menu_item', '', 0),
(1745, 2, '2016-09-20 18:16:50', '2016-09-20 18:16:50', '', 'Advanced', '', 'publish', 'closed', 'closed', '', 'advanced-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/advanced-3/', 54, 'nav_menu_item', '', 0),
(1746, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', 'Custom Menu Description', 'Menu Description', '', 'publish', 'closed', 'closed', '', 'menu-description-3', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-description-3/', 62, 'nav_menu_item', '', 0),
(1747, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 'Menu Title Attribute', 'Custom Title Attribute', 'publish', 'closed', 'closed', '', 'menu-title-attribute-3', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-title-attribute-3/', 55, 'nav_menu_item', '', 0),
(1748, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 'Menu CSS Class', '', 'publish', 'closed', 'closed', '', 'menu-css-class-3', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/menu-css-class-3/', 56, 'nav_menu_item', '', 0),
(1749, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 'New Window / Tab', '', 'publish', 'closed', 'closed', '', 'new-window-tab-3', '', '', '2016-09-20 18:43:01', '2016-09-20 18:43:01', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/new-window-tab-3/', 57, 'nav_menu_item', '', 0),
(1750, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 'Home', '', 'publish', 'closed', 'closed', '', 'home-5', '', '', '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/home-5/', 1, 'nav_menu_item', '', 0),
(1751, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1751', '', '', '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 2, 'nav_menu_item', '', 0),
(1752, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1752', '', '', '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 3, 'nav_menu_item', '', 0),
(1753, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1753', '', '', '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 4, 'nav_menu_item', '', 0),
(1754, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1754', '', '', '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 5, 'nav_menu_item', '', 0),
(1755, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1755', '', '', '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 6, 'nav_menu_item', '', 0),
(1756, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1756', '', '', '2016-09-20 18:16:51', '2016-09-20 18:16:51', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 7, 'nav_menu_item', '', 0),
(1845, 1, '2016-11-08 15:03:13', '2016-11-08 15:03:13', '[vc_row][vc_column][goarch_about_section][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 15:03:13', '2016-11-08 15:03:13', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1993, 1, '2016-12-08 14:57:29', '2016-12-08 14:57:29', '', 'Home - Dark', '', 'publish', 'closed', 'closed', '', 'home-dark-3', '', '', '2016-12-09 15:35:55', '2016-12-09 15:35:55', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?p=1993', 3, 'nav_menu_item', '', 0),
(1760, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1760', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 5, 'nav_menu_item', '', 0),
(1761, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1761', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 9, 'nav_menu_item', '', 0),
(1762, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1762', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 10, 'nav_menu_item', '', 0),
(1763, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1763', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 11, 'nav_menu_item', '', 0),
(1764, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1764', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 19, 'nav_menu_item', '', 0),
(1765, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1765', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 20, 'nav_menu_item', '', 0),
(1766, 2, '2016-09-20 18:16:51', '2016-09-20 18:16:51', ' ', '', '', 'publish', 'closed', 'closed', '', '1766', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/', 21, 'nav_menu_item', '', 0),
(1848, 1, '2016-11-08 15:25:07', '2016-11-08 15:25:07', '[vc_row][vc_column][goarch_about_section][goarch_about_main_section][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 15:25:07', '2016-11-08 15:25:07', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1768, 5, '2013-12-04 11:08:29', '2013-12-04 18:08:29', '', '2014-slider-mobile-behavior', '', 'inherit', 'open', 'closed', '', '2014-slider-mobile-behavior', '', '', '2013-12-04 11:08:29', '2013-12-04 18:08:29', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2013/12/2014-slider-mobile-behavior-2.mov', 0, 'attachment', 'video/quicktime', 0),
(1769, 6, '2014-01-05 11:45:21', '2014-01-05 18:45:21', '', 'dsc20050315_145007_132', '', 'inherit', 'open', 'closed', '', 'dsc20050315_145007_132-2', '', '', '2014-01-05 11:45:21', '2014-01-05 18:45:21', '', 555, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2014/01/dsc20050315_145007_132.jpg', 0, 'attachment', 'image/jpeg', 0),
(1770, 6, '2014-01-05 11:45:36', '2014-01-05 18:45:36', '', 'spectacles', '', 'inherit', 'open', 'closed', '', 'spectacles-2', '', '', '2014-01-05 11:45:36', '2014-01-05 18:45:36', '', 501, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2014/01/spectacles.gif', 0, 'attachment', 'image/gif', 0),
(358, 3, '2010-10-05 00:27:25', '2010-10-05 07:27:25', 'All children, except one, grow up. They soon know that they will grow up, and the way Wendy knew was this. One day when she was two years old she was playing in a garden, and she plucked another flower and ran with it to her mother. I suppose she must have looked rather delightful, for Mrs. Darling put her hand to her heart and cried, "Oh, why can\'t you remain like this for ever!" This was all that passed between them on the subject, but henceforth Wendy knew that she must grow up. You always know after you are two. Two is the beginning of the end.\n\n<!--more-->\n\nMrs. Darling first heard of Peter when she was tidying up her children\'s minds. It is the nightly custom of every good mother after her children are asleep to rummage in their minds and put things straight for next morning, repacking into their proper places the many articles that have wandered during the day.\n\nIf you could keep awake (but of course you can\'t) you would see your own mother doing this, and you would find it very interesting to watch her. It is quite like tidying up drawers. You would see her on her knees, I expect, lingering humorously over some of your contents, wondering where on earth you had picked this thing up, making discoveries sweet and not so sweet, pressing this to her cheek as if it were as nice as a kitten, and hurriedly stowing that out of sight. When you wake in the morning, the naughtiness and evil passions with which you went to bed have been folded up small and placed at the bottom of your mind and on the top, beautifully aired, are spread out your prettier thoughts, ready for you to put on.\n\nI don\'t know whether you have ever seen a map of a person\'s mind. Doctors sometimes draw maps of other parts of you, and your own map can become intensely interesting, but catch them trying to draw a map of a child\'s mind, which is not only confused, but keeps going round all the time. There are zigzag lines on it, just like your temperature on a card, and these are probably roads in the island, for the Neverland is always more or less an island, with astonishing splashes of colour here and there, and coral reefs and rakish-looking craft in the offing, and savages and lonely lairs, and gnomes who are mostly tailors, and caves through which a river runs, and princes with six elder brothers, and a hut fast going to decay, and one very small old lady with a hooked nose. It would be an easy map if that were all, but there is also first day at school, religion, fathers, the round pond, needle-work, murders, hangings, verbs that take the dative, chocolate pudding day, getting into braces, say ninety-nine, three-pence for pulling out your tooth yourself, and so on, and either these are part of the island or they are another map showing through, and it is all rather confusing, especially as nothing will stand still.\n\nOf course the Neverlands vary a good deal. John\'s, for instance, had a lagoon with flamingoes flying over it at which John was shooting, while Michael, who was very small, had a flamingo with lagoons flying over it. John lived in a boat turned upside down on the sands, Michael in a wigwam, Wendy in a house of leaves deftly sewn together. John had no friends, Michael had friends at night, Wendy had a pet wolf forsaken by its parents, but on the whole the Neverlands have a family resemblance, and if they stood still in a row you could say of them that they have each other\'s nose, and so forth. On these magic shores children at play are for ever beaching their coracles [simple boat]. We too have been there; we can still hear the sound of the surf, though we shall land no more.\n\nOf all delectable islands the Neverland is the snuggest and most compact, not large and sprawly, you know, with tedious distances between one adventure and another, but nicely crammed. When you play at it by day with the chairs and table-cloth, it is not in the least alarming, but in the two minutes before you go to sleep it becomes very real. That is why there are night-lights.\n\nOccasionally in her travels through her children\'s minds Mrs. Darling found things she could not understand, and of these quite the most perplexing was the word Peter. She knew of no Peter, and yet he was here and there in John and Michael\'s minds, while Wendy\'s began to be scrawled all over with him. The name stood out in bolder letters than any of the other words, and as Mrs. Darling gazed she felt that it had an oddly cocky appearance.', 'Post Format: Standard', '', 'publish', 'closed', 'closed', '', 'post-format-standard', '', '', '2010-10-05 00:27:25', '2010-10-05 07:27:25', '', 0, 'http://wpthemetestdata.wordpress.com/?p=358', 0, 'post', '', 0),
(555, 3, '2010-09-10 07:24:14', '2010-09-10 14:24:14', '[gallery]\n\n<!--nextpage-->\n\nYou can use this page to test the Theme\'s handling of the[gallery]\n\nshortcode, including the <code>columns</code> parameter, from 1 to 9 columns. Themes are only required to support the default setting (3 columns), so this page is entirely optional.\n<h2>One Column</h2>\n[gallery columns="1"]\n<h2>Two Columns</h2>\n[gallery columns="2"]\n<h2>Three Columns</h2>\n[gallery columns="3"]\n<h2>Four Columns</h2>\n[gallery columns="4"]\n<h2>Five Columns</h2>\n[gallery columns="5"]\n<h2>Six Columns</h2>\n[gallery columns="6"]\n<h2>Seven Columns</h2>\n[gallery columns="7"]\n<h2>Eight Columns</h2>\n[gallery columns="8"]\n<h2>Nine Columns</h2>\n[gallery columns="9"]', 'Post Format: Gallery', '', 'publish', 'closed', 'closed', '', 'post-format-gallery', '', '', '2010-09-10 07:24:14', '2010-09-10 14:24:14', '', 0, 'http://wpthemetestdata.wordpress.com/?p=555', 0, 'post', '', 0),
(559, 3, '2010-05-09 07:51:54', '2010-05-09 14:51:54', '“I never tried to prove nothing, just wanted to give a good show. My life has always been my music, it\'s always come first, but the music ain\'t worth nothing if you can\'t lay it on the public. The main thing is to live for that audience, \'cause what you\'re there for is to please the people.”', 'Post Format: Aside', '', 'publish', 'closed', 'closed', '', 'post-format-aside', '', '', '2010-05-09 07:51:54', '2010-05-09 14:51:54', '', 0, 'http://wpthemetestdata.wordpress.com/?p=559', 0, 'post', '', 0),
(562, 3, '2010-01-08 07:59:31', '2010-01-08 14:59:31', 'Abbott: Strange as it may seem, they give ball players nowadays very peculiar names.\n\nCostello: Funny names?\n\nAbbott: Nicknames, nicknames. Now, on the St. Louis team we have Who\'s on first, What\'s on second, I Don\'t Know is on third--\n\nCostello: That\'s what I want to find out. I want you to tell me the names of the fellows on the St. Louis team.\n\nAbbott: I\'m telling you. Who\'s on first, What\'s on second, I Don\'t Know is on third--\n\nCostello: You know the fellows\' names?\n\nAbbott: Yes.\n\nCostello: Well, then who\'s playing first?\n\nAbbott: Yes.\n\nCostello: I mean the fellow\'s name on first base.\n\nAbbott: Who.\n\nCostello: The fellow playin\' first base.\n\nAbbott: Who.\n\nCostello: The guy on first base.\n\nAbbott: Who is on first.\n\nCostello: Well, what are you askin\' me for?\n\nAbbott: I\'m not asking you--I\'m telling you. Who is on first.\n\nCostello: I\'m asking you--who\'s on first?\n\nAbbott: That\'s the man\'s name.\n\nCostello: That\'s who\'s name?\n\nAbbott: Yes.\n\nCostello: When you pay off the first baseman every month, who gets the money?\n\nAbbott: Every dollar of it. And why not, the man\'s entitled to it.\n\nCostello: Who is?\n\nAbbott: Yes.\n\nCostello: So who gets it?\n\nAbbott: Why shouldn\'t he? Sometimes his wife comes down and collects it.\n\nCostello: Who\'s wife?\n\nAbbott: Yes. After all, the man earns it.\n\nCostello: Who does?\n\nAbbott: Absolutely.\n\nCostello: Well, all I\'m trying to find out is what\'s the guy\'s name on first base?\n\nAbbott: Oh, no, no. What is on second base.\n\nCostello: I\'m not asking you who\'s on second.\n\nAbbott: Who\'s on first!\n\nCostello: St. Louis has a good outfield?\n\nAbbott: Oh, absolutely.\n\nCostello: The left fielder\'s name?\n\nAbbott: Why.\n\nCostello: I don\'t know, I just thought I\'d ask.\n\nAbbott: Well, I just thought I\'d tell you.\n\nCostello: Then tell me who\'s playing left field?\n\nAbbott: Who\'s playing first.\n\nCostello: Stay out of the infield! The left fielder\'s name?\n\nAbbott: Why.\n\nCostello: Because.\n\nAbbott: Oh, he\'s center field.\n\nCostello: Wait a minute. You got a pitcher on this team?\n\nAbbott: Wouldn\'t this be a fine team without a pitcher?\n\nCostello: Tell me the pitcher\'s name.\n\nAbbott: Tomorrow.\n\nCostello: Now, when the guy at bat bunts the ball--me being a good catcher--I want to throw the guy out at first base, so I pick up the ball and throw it to who?\n\nAbbott: Now, that\'s he first thing you\'ve said right.\n\nCostello: I DON\'T EVEN KNOW WHAT I\'M TALKING ABOUT!\n\nAbbott: Don\'t get excited. Take it easy.\n\nCostello: I throw the ball to first base, whoever it is grabs the ball, so the guy runs to second. Who picks up the ball and throws it to what. What throws it to I don\'t know. I don\'t know throws it back to tomorrow--a triple play.\n\nAbbott: Yeah, it could be.\n\nCostello: Another guy gets up and it\'s a long ball to center.\n\nAbbott: Because.\n\nCostello: Why? I don\'t know. And I don\'t care.\n\nAbbott: What was that?\n\nCostello: I said, I DON\'T CARE!\n\nAbbott: Oh, that\'s our shortstop!', 'Post Format: Chat', '', 'publish', 'closed', 'closed', '', 'post-format-chat', '', '', '2010-01-08 07:59:31', '2010-01-08 14:59:31', '', 0, 'http://wpthemetestdata.wordpress.com/?p=562', 0, 'post', '', 0),
(565, 3, '2010-03-07 08:06:53', '2010-03-07 15:06:53', '<a href="http://make.wordpress.org/themes" title="The WordPress Theme Review Team Website">The WordPress Theme Review Team Website</a>', 'Post Format: Link', '', 'publish', 'closed', 'closed', '', 'post-format-link', '', '', '2010-03-07 08:06:53', '2010-03-07 15:06:53', '', 0, 'http://wpthemetestdata.wordpress.com/?p=565', 0, 'post', '', 0),
(568, 3, '2010-08-06 08:09:39', '2010-08-06 15:09:39', '[caption id="attachment_612" align="aligncenter" width="640" caption="Chunk of resinous blackboy husk, Clarkson, Western Australia. This burns like a spinifex log."]<a href="http://wpthemetestdata.files.wordpress.com/2012/06/dsc20040724_152504_532.jpg"><img src="http://wpthemetestdata.files.wordpress.com/2012/06/dsc20040724_152504_532.jpg" alt="chunk of resinous blackboy husk" title="dsc20040724_152504_532" width="640" height="480" class="size-full wp-image-612" /></a>[/caption]\n', 'Post Format: Image (Linked)', '', 'publish', 'closed', 'closed', '', 'post-format-image-linked', '', '', '2010-08-06 08:09:39', '2010-08-06 15:09:39', '', 0, 'http://wpthemetestdata.wordpress.com/?p=568', 0, 'post', '', 0),
(575, 3, '2010-02-05 08:13:15', '2010-02-05 15:13:15', '<blockquote>Only one thing is impossible for God: To find any sense in any copyright law on the planet.\n<cite><a href="http://www.brainyquote.com/quotes/quotes/m/marktwain163473.html">Mark Twain</a></cite></blockquote>', 'Post Format: Quote', '', 'publish', 'closed', 'closed', '', 'post-format-quote', '', '', '2010-02-05 08:13:15', '2010-02-05 15:13:15', '', 0, 'http://wpthemetestdata.wordpress.com/?p=575', 0, 'post', '', 0),
(579, 3, '2010-04-04 08:21:24', '2010-04-04 15:21:24', 'WordPress, how do I love thee? Let me count the ways (in 140 characters or less).', 'Post Format: Status', '', 'publish', 'closed', 'closed', '', 'post-format-status', '', '', '2010-04-04 08:21:24', '2010-04-04 15:21:24', '', 0, 'http://wpthemetestdata.wordpress.com/?p=579', 0, 'post', '', 0),
(582, 3, '2010-06-03 08:25:58', '2010-06-03 15:25:58', 'http://wordpress.tv/2009/03/16/anatomy-of-a-wordpress-theme-exploring-the-files-behind-your-theme/\n\nPosted as per the <a href="http://codex.wordpress.org/Embeds" target="_blank">instructions in the Codex</a>.', 'Post Format: Video (WordPress.tv)', '', 'publish', 'closed', 'closed', '', 'post-format-video-wordpresstv', '', '', '2010-06-03 08:25:58', '2010-06-03 15:25:58', '', 0, 'http://wpthemetestdata.wordpress.com/?p=582', 0, 'post', '', 0),
(587, 3, '2010-07-02 08:36:44', '2010-07-02 15:36:44', 'Link:\n\n<a href="http://wpthemetestdata.files.wordpress.com/2008/06/originaldixielandjazzbandwithalbernard-stlouisblues.mp3">St. Louis Blues</a>\n\nAudio shortcode:\n\n[audio http://wpthemetestdata.files.wordpress.com/2008/06/originaldixielandjazzbandwithalbernard-stlouisblues.mp3]', 'Post Format: Audio', '', 'publish', 'closed', 'closed', '', 'post-format-audio', '', '', '2010-07-02 08:36:44', '2010-07-02 15:36:44', '', 0, 'http://wpthemetestdata.wordpress.com/?p=587', 0, 'post', '', 0),
(733, 3, '2011-06-23 18:38:52', '2011-06-24 01:38:52', 'Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Aenean lacinia bibendum nulla sed consectetur. Etiam porta sem malesuada magna mollis euismod. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.', 'Page A', '', 'publish', 'open', 'closed', '', 'page-a', '', '', '2011-06-23 18:38:52', '2011-06-24 01:38:52', '', 0, 'http://wpthemetestdata.wordpress.com/?page_id=733', 10, 'page', '', 0),
(735, 3, '2011-06-23 18:39:14', '2011-06-24 01:39:14', '(lorem ipsum)', 'Page B', '', 'publish', 'open', 'closed', '', 'page-b', '', '', '2011-06-23 18:39:14', '2011-06-24 01:39:14', '', 0, 'http://wpthemetestdata.wordpress.com/?page_id=735', 11, 'page', '', 0),
(742, 3, '2011-06-23 19:03:33', '2011-06-24 02:03:33', '(lorem ipsum)', 'Level 2a', '', 'publish', 'open', 'closed', '', 'level-2a', '', '', '2011-06-23 19:03:33', '2011-06-24 02:03:33', '', 174, 'http://wpthemetestdata.wordpress.com/?page_id=742', 0, 'page', '', 0),
(744, 3, '2011-06-23 19:04:03', '2011-06-24 02:04:03', '(lorem ipsum)', 'Level 2b', '', 'publish', 'open', 'closed', '', 'level-2b', '', '', '2011-06-23 19:04:03', '2011-06-24 02:04:03', '', 174, 'http://wpthemetestdata.wordpress.com/?page_id=744', 0, 'page', '', 0),
(746, 3, '2011-06-23 19:04:24', '2011-06-24 02:04:24', '(lorem ipsum)', 'Level 3a', '', 'publish', 'open', 'closed', '', 'level-3a', '', '', '2011-06-23 19:04:24', '2011-06-24 02:04:24', '', 173, 'http://wpthemetestdata.wordpress.com/?page_id=746', 0, 'page', '', 0),
(748, 3, '2011-06-23 19:04:46', '2011-06-24 02:04:46', '(lorem ipsum)', 'Level 3b', '', 'publish', 'open', 'closed', '', 'level-3b', '', '', '2011-06-23 19:04:46', '2011-06-24 02:04:46', '', 173, 'http://wpthemetestdata.wordpress.com/?page_id=748', 0, 'page', '', 0),
(993, 3, '2012-03-15 14:38:08', '2012-03-15 21:38:08', 'This is the post content. It should be displayed in place of the user-defined excerpt in single-page views.', 'Template: Excerpt (Defined)', 'This is a user-defined post excerpt. It should be displayed in place of the post content in archive-index pages.', 'publish', 'closed', 'closed', '', 'template-excerpt-defined', '', '', '2012-03-15 14:38:08', '2012-03-15 21:38:08', '', 0, 'http://wptest.io/demo/?p=993', 0, 'post', '', 0),
(996, 3, '2012-03-15 14:41:11', '2012-03-15 21:41:11', 'This content is before the <a title="The More Tag" href="http://en.support.wordpress.com/splitting-content/more-tag/" target="_blank">more tag</a>.\n\nRight after this sentence should be a "continue reading" button of some sort.\n\n<!--more-->\n\nAnd this content is after the more tag.', 'Template: More Tag', '', 'publish', 'closed', 'closed', '', 'template-more-tag', '', '', '2012-03-15 14:41:11', '2012-03-15 21:41:11', '', 0, 'http://wptest.io/demo/?p=996', 0, 'post', '', 0),
(1000, 3, '2009-05-15 14:48:32', '2009-05-15 21:48:32', 'Nested and mixed lists are an interesting beast. It\'s a corner case to make sure that\n<ul>\n	<li><span style="line-height:1.714285714;font-size:1rem;">Lists within lists do not break the ordered list numbering order</span></li>\n	<li><span style="line-height:1.714285714;font-size:1rem;">Your list styles go deep enough.</span></li>\n</ul>\n<h3>Ordered - Unordered - Ordered</h3>\n<ol>\n	<li>ordered item</li>\n	<li>ordered item\n<ul>\n	<li><strong>unordered</strong></li>\n	<li><strong>unordered</strong>\n<ol>\n	<li>ordered item</li>\n	<li>ordered item</li>\n</ol>\n</li>\n</ul>\n</li>\n	<li>ordered item</li>\n	<li>ordered item</li>\n</ol>\n<h3>Ordered - Unordered - Unordered</h3>\n<ol>\n	<li>ordered item</li>\n	<li>ordered item\n<ul>\n	<li><strong>unordered</strong></li>\n	<li><strong>unordered</strong>\n<ul>\n	<li>unordered item</li>\n	<li>unordered item</li>\n</ul>\n</li>\n</ul>\n</li>\n	<li>ordered item</li>\n	<li>ordered item</li>\n</ol>\n<h3>Unordered - Ordered - Unordered</h3>\n<ul>\n	<li>unordered item</li>\n	<li>unordered item\n<ol>\n	<li>ordered</li>\n	<li>ordered\n<ul>\n	<li>unordered item</li>\n	<li>unordered item</li>\n</ul>\n</li>\n</ol>\n</li>\n	<li>unordered item</li>\n	<li>unordered item</li>\n</ul>\n<h3>Unordered - Unordered - Ordered</h3>\n<ul>\n	<li>unordered item</li>\n	<li>unordered item\n<ul>\n	<li>unordered</li>\n	<li>unordered\n<ol>\n	<li><strong>ordered item</strong></li>\n	<li><strong>ordered item</strong></li>\n</ol>\n</li>\n</ul>\n</li>\n	<li>unordered item</li>\n	<li>unordered item</li>\n</ul>', 'Edge Case: Nested And Mixed Lists', '', 'publish', 'closed', 'closed', '', 'edge-case-nested-and-mixed-lists', '', '', '2009-05-15 14:48:32', '2009-05-15 21:48:32', '', 0, 'http://wptest.io/demo/?p=1000', 0, 'post', '', 0),
(1005, 3, '2010-06-02 03:00:34', '2010-06-02 10:00:34', '[wpvideo tFnqC9XQ w=680]\n\n<a title="VideoPress Plugin for WordPress" href="http://videopress.com/" target="_blank">VideoPress</a>, especially as a video post format, usually provides some unique styling issues.\n\nYou will need to install <a title="Jetpack for WordPress" href="http://jetpack.me/" target="_blank">Jetpack</a> or <a title="Slim Jetpack" href="http://wordpress.org/extend/plugins/slimjetpack/" target="_blank">Slim Jetpack</a> plugin to turn the shortcode into a viewable video.', 'Post Format: Video (VideoPress)', '', 'publish', 'closed', 'closed', '', 'post-format-video-videopress', '', '', '2010-06-02 03:00:34', '2010-06-02 10:00:34', '', 0, 'http://wptest.io/demo/?p=1005', 0, 'post', '', 0),
(1011, 3, '2012-03-15 15:15:12', '2012-03-15 22:15:12', 'This post should display a <a title="Featured Images" href="http://en.support.wordpress.com/featured-images/#setting-a-featured-image" target="_blank">featured image</a>, if the theme <a title="Post Thumbnails" href="http://codex.wordpress.org/Post_Thumbnails" target="_blank">supports it</a>.\n\nNon-square images can provide some unique styling issues.\n\nThis post tests a horizontal featured image.', 'Template: Featured Image (Horizontal)', '', 'publish', 'closed', 'closed', '', 'template-featured-image-horizontal', '', '', '2012-03-15 15:15:12', '2012-03-15 22:15:12', '', 0, 'http://wptest.io/demo/?p=1011', 0, 'post', '', 0),
(1016, 3, '2012-03-15 15:36:32', '2012-03-15 22:36:32', 'This post should display a <a title="Featured Images" href="http://en.support.wordpress.com/featured-images/#setting-a-featured-image" target="_blank">featured image</a>, if the theme <a title="Post Thumbnails" href="http://codex.wordpress.org/Post_Thumbnails" target="_blank">supports it</a>.\n\nNon-square images can provide some unique styling issues.\n\nThis post tests a vertical featured image.', 'Template: Featured Image (Vertical)', '', 'publish', 'closed', 'closed', '', 'template-featured-image-vertical', '', '', '2012-03-15 15:36:32', '2012-03-15 22:36:32', '', 0, 'http://wptest.io/demo/?p=1016', 0, 'post', '', 0),
(1031, 3, '2010-09-09 17:23:27', '2010-09-10 00:23:27', 'This is a test for Jetpack\'s Tiled Gallery.\n\nInstall <a title="Jetpack for WordPress" href="http://wordpress.org/plugins/jetpack/" target="_blank">Jetpack</a> to test.\n\n[gallery type="rectangular" columns="4" ids="755,757,758,760,766,763" orderby="rand"]\n\nThis is some text after the Tiled Gallery just to make sure that everything spaces nicely.', 'Post Format: Gallery (Tiled)', '', 'publish', 'closed', 'closed', '', 'post-format-gallery-tiled', '', '', '2010-09-09 17:23:27', '2010-09-10 00:23:27', '', 0, 'http://wptest.io/demo/?p=1031', 0, 'post', '', 0),
(1133, 3, '2013-03-15 18:19:23', '2013-03-15 23:19:23', 'Welcome to image alignment! The best way to demonstrate the ebb and flow of the various image positioning options is to nestle them snuggly among an ocean of words. Grab a paddle and let\'s get started.\n\nOn the topic of alignment, it should be noted that users can choose from the options of <em>None</em>, <em>Left</em>, <em>Right, </em>and <em>Center</em>. In addition, they also get the options of <em>Thumbnail</em>, <em>Medium</em>, <em>Large</em> &amp; <em>Fullsize</em>.\n<p style="text-align:center;"><img class="size-full wp-image-906 aligncenter" title="Image Alignment 580x300" alt="Image Alignment 580x300" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-580x300.jpg" width="580" height="300" /></p>\nThe image above happens to be <em><strong>centered</strong></em>.\n\n<strong><img class="size-full wp-image-904 alignleft" title="Image Alignment 150x150" alt="Image Alignment 150x150" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-150x150.jpg" width="150" height="150" /></strong>The rest of this paragraph is filler for the sake of seeing the text wrap around the 150x150 image, which is <em><strong>left aligned</strong></em>. <strong></strong>\n\nAs you can see the should be some space above, below, and to the right of the image. The text should not be creeping on the image. Creeping is just not right. Images need breathing room too. Let them speak like you words. Let them do their jobs without any hassle from the text. In about one more sentence here, we\'ll see that the text moves from the right of the image down below the image in seamless transition. Again, letting the do it\'s thang. Mission accomplished!\n\nAnd now for a <em><strong>massively large image</strong></em>. It also has <em><strong>no alignment</strong></em>.\n\n<img class="alignnone  wp-image-907" title="Image Alignment 1200x400" alt="Image Alignment 1200x400" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-1200x4002.jpg" width="1200" height="400" />\n\nThe image above, though 1200px wide, should not overflow the content area. It should remain contained with no visible disruption to the flow of content.\n\n<img class="size-full wp-image-905 alignright" title="Image Alignment 300x200" alt="Image Alignment 300x200" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-300x200.jpg" width="300" height="200" />\n\nAnd now we\'re going to shift things to the <em><strong>right align</strong></em>. Again, there should be plenty of room above, below, and to the left of the image. Just look at him there... Hey guy! Way to rock that right side. I don\'t care what the left aligned image says, you look great. Don\'t let anyone else tell you differently.\n\nIn just a bit here, you should see the text start to wrap below the right aligned image and settle in nicely. There should still be plenty of room and everything should be sitting pretty. Yeah... Just like that. It never felt so good to be right.\n\nAnd just when you thought we were done, we\'re going to do them all over again with captions!\n\n[caption id="attachment_906" align="aligncenter" width="580"]<img class="size-full wp-image-906  " title="Image Alignment 580x300" alt="Image Alignment 580x300" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-580x300.jpg" width="580" height="300" /> Look at 580x300 getting some <a title="Image Settings" href="http://en.support.wordpress.com/images/image-settings/">caption</a> love.[/caption]\n\nThe image above happens to be <em><strong>centered</strong></em>. The caption also has a link in it, just to see if it does anything funky.\n\n[caption id="attachment_904" align="alignleft" width="150"]<img class="size-full wp-image-904  " title="Image Alignment 150x150" alt="Image Alignment 150x150" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-150x150.jpg" width="150" height="150" /> Itty-bitty caption.[/caption]\n\n<strong></strong>The rest of this paragraph is filler for the sake of seeing the text wrap around the 150x150 image, which is <em><strong>left aligned</strong></em>. <strong></strong>\n\nAs you can see the should be some space above, below, and to the right of the image. The text should not be creeping on the image. Creeping is just not right. Images need breathing room too. Let them speak like you words. Let them do their jobs without any hassle from the text. In about one more sentence here, we\'ll see that the text moves from the right of the image down below the image in seamless transition. Again, letting the do it\'s thang. Mission accomplished!\n\nAnd now for a <em><strong>massively large image</strong></em>. It also has <em><strong>no alignment</strong></em>.\n\n[caption id="attachment_907" align="alignnone" width="1200"]<img class=" wp-image-907" title="Image Alignment 1200x400" alt="Image Alignment 1200x400" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-1200x4002.jpg" width="1200" height="400" /> Massive image comment for your eyeballs.[/caption]\n\nThe image above, though 1200px wide, should not overflow the content area. It should remain contained with no visible disruption to the flow of content.\n\n[caption id="attachment_905" align="alignright" width="300"]<img class="size-full wp-image-905 " title="Image Alignment 300x200" alt="Image Alignment 300x200" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-300x200.jpg" width="300" height="200" /> Feels good to be right all the time.[/caption]\n\nAnd now we\'re going to shift things to the <em><strong>right align</strong></em>. Again, there should be plenty of room above, below, and to the left of the image. Just look at him there... Hey guy! Way to rock that right side. I don\'t care what the left aligned image says, you look great. Don\'t let anyone else tell you differently.\n\nIn just a bit here, you should see the text start to wrap below the right aligned image and settle in nicely. There should still be plenty of room and everything should be sitting pretty. Yeah... Just like that. It never felt so good to be right.\n\nAnd that\'s a wrap, yo! You survived the tumultuous waters of alignment. Image alignment achievement unlocked!', 'Page Image Alignment', '', 'publish', 'open', 'open', '', 'page-image-alignment', '', '', '2013-03-15 18:19:23', '2013-03-15 23:19:23', '', 9, 'http://wptest.io/demo/?page_id=1080', 0, 'page', '', 0);
REPLACE INTO `xwlpv_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(1134, 3, '2013-03-15 18:20:05', '2013-03-15 23:20:05', '<strong>Headings</strong>\n<h1>Header one</h1>\n<h2>Header two</h2>\n<h3>Header three</h3>\n<h4>Header four</h4>\n<h5>Header five</h5>\n<h6>Header six</h6>\n<h2>Blockquotes</h2>\nSingle line blockquote:\n<blockquote>Stay hungry. Stay foolish.</blockquote>\nMulti line blockquote with a cite reference:\n<blockquote>People think focus means saying yes to the thing you\'ve got to focus on. But that\'s not what it means at all. It means saying no to the hundred other good ideas that there are. You have to pick carefully. I\'m actually as proud of the things we haven\'t done as the things I have done. Innovation is saying no to 1,000 things. <cite>Steve Jobs - Apple Worldwide Developers\' Conference, 1997</cite></blockquote>\n<h2>Tables</h2>\n<table>\n<tbody>\n<tr>\n<th>Employee</th>\n<th class="views">Salary</th>\n<th></th>\n</tr>\n<tr class="odd">\n<td><a href="http://example.com/">Jane</a></td>\n<td>$1</td>\n<td>Because that\'s all Steve Job\' needed for a salary.</td>\n</tr>\n<tr class="even">\n<td><a href="http://example.com">John</a></td>\n<td>$100K</td>\n<td>For all the blogging he does.</td>\n</tr>\n<tr class="odd">\n<td><a href="http://example.com/">Jane</a></td>\n<td>$100M</td>\n<td>Pictures are worth a thousand words, right? So Tom x 1,000.</td>\n</tr>\n<tr class="even">\n<td><a href="http://example.com/">Jane</a></td>\n<td>$100B</td>\n<td>With hair like that?! Enough said...</td>\n</tr>\n</tbody>\n</table>\n<h2>Definition Lists</h2>\n<dl><dt>Definition List Title</dt><dd>Definition list division.</dd><dt>Startup</dt><dd>A startup company or startup is a company or temporary organization designed to search for a repeatable and scalable business model.</dd><dt>#dowork</dt><dd>Coined by Rob Dyrdek and his personal body guard Christopher "Big Black" Boykins, "Do Work" works as a self motivator, to motivating your friends.</dd><dt>Do It Live</dt><dd>I\'ll let Bill O\'Reilly will <a title="We\'ll Do It Live" href="https://www.youtube.com/watch?v=O_HyZ5aW76c">explain</a> this one.</dd></dl>\n<h2>Unordered Lists (Nested)</h2>\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n<h2>Ordered List (Nested)</h2>\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n<h2>HTML Tags</h2>\nThese supported tags come from the WordPress.com code <a title="Code" href="http://en.support.wordpress.com/code/">FAQ</a>.\n\n<strong>Address Tag</strong>\n\n<address>1 Infinite Loop\nCupertino, CA 95014\nUnited States</address><strong>Anchor Tag (aka. Link)</strong>\n\nThis is an example of a <a title="Apple" href="http://apple.com">link</a>.\n\n<strong>Abbreviation Tag</strong>\n\nThe abbreviation <abbr title="Seriously">srsly</abbr> stands for "seriously".\n\n<strong>Acronym Tag</strong>\n\nThe acronym <acronym title="For The Win">ftw</acronym> stands for "for the win".\n\n<strong>Big Tag</strong>\n\nThese tests are a <big>big</big> deal, but this tag is no longer supported in HTML5.\n\n<strong>Cite Tag</strong>\n\n"Code is poetry." --<cite>Automattic</cite>\n\n<strong>Code Tag</strong>\n\nYou will learn later on in these tests that <code>word-wrap: break-word;</code> will be your best friend.\n\n<strong>Delete Tag</strong>\n\nThis tag will let you <del>strikeout text</del>, but this tag is no longer supported in HTML5 (use the <code>&lt;strike&gt;</code> instead).\n\n<strong>Emphasize Tag</strong>\n\nThe emphasize tag should <em>italicize</em> text.\n\n<strong>Insert Tag</strong>\n\nThis tag should denote <ins>inserted</ins> text.\n\n<strong>Keyboard Tag</strong>\n\nThis scarcely known tag emulates <kbd>keyboard text</kbd>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Preformatted Tag</strong>\n\nThis tag styles large blocks of code.\n<pre>.post-title {\n	margin: 0 0 5px;\n	font-weight: bold;\n	font-size: 38px;\n	line-height: 1.2;\n}</pre>\n<strong>Quote Tag</strong>\n\n<q>Developers, developers, developers...</q> --Steve Ballmer\n\n<strong>Strong Tag</strong>\n\nThis tag shows <strong>bold<strong> text.</strong></strong>\n\n<strong>Subscript Tag</strong>\n\nGetting our science styling on with H<sub>2</sub>O, which should push the "2" down.\n\n<strong>Superscript Tag</strong>\n\nStill sticking with science and Isaac Newton\'s E = MC<sup>2</sup>, which should lift the 2 up.\n\n<strong>Teletype Tag</strong>\n\nThis rarely used tag emulates <tt>teletype text</tt>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Variable Tag</strong>\n\nThis allows you to denote <var>variables</var>.', 'Page Markup And Formatting', '', 'publish', 'open', 'open', '', 'page-markup-and-formatting', '', '', '2013-03-15 18:20:05', '2013-03-15 23:20:05', '', 9, 'http://wptest.io/demo/?page_id=1083', 0, 'page', '', 0),
(1148, 3, '2012-01-03 10:11:37', '2012-01-03 17:11:37', 'This post tests comments in the following ways.\n<ul>\n	<li>Threaded comments up to 10 levels deep</li>\n	<li>Paginated comments (set <em><strong>Settings &gt; Discussion &gt; Break comments into pages</strong></em> to <em><strong>5</strong></em> top level comments per page)</li>\n	<li>Comment markup / formatting</li>\n	<li>Comment images</li>\n	<li>Comment videos</li>\n	<li>Author comments</li>\n	<li>Gravatars and default fallbacks</li>\n</ul>', 'Template: Comments', '', 'publish', 'open', 'closed', '', 'template-comments', '', '', '2012-01-03 10:11:37', '2012-01-03 17:11:37', '', 0, 'http://wpthemetestdata.wordpress.com/2007/09/04/comment-test/', 0, 'post', '', 19),
(1149, 3, '2012-01-01 10:17:18', '2012-01-01 17:17:18', 'This post has many pingpacks and trackbacks.\n\nThere are a few ways to list them.\n<ol>\n	<li>Above the comments</li>\n	<li>Below the comments</li>\n	<li>Included within the normal flow of comments</li>\n</ol>', 'Template: Pingbacks And Trackbacks', '', 'publish', 'closed', 'closed', '', 'template-pingbacks-an-trackbacks', '', '', '2012-01-01 10:17:18', '2012-01-01 17:17:18', '', 0, 'http://wpthemetestdata.wordpress.com/2007/09/04/many-trackbacks/', 0, 'post', '', 5),
(1150, 3, '2012-01-02 10:21:15', '2012-01-02 17:21:15', 'This post has its comments, pingbacks, and trackbacks disabled.\n\nThere should be no comment reply form, but <em>should</em> display pingbacks and trackbacks.', 'Template: Comments Disabled', '', 'publish', 'closed', 'closed', '', 'template-comments-disabled', '', '', '2012-01-02 10:21:15', '2012-01-02 17:21:15', '', 0, 'http://wpthemetestdata.wordpress.com/2007/09/04/no-comments/', 0, 'post', '', 0),
(1151, 3, '2009-06-01 01:00:34', '2009-06-01 08:00:34', 'This post has many tags.', 'Edge Case: Many Tags', '', 'publish', 'closed', 'closed', '', 'edge-case-many-tags', '', '', '2009-06-01 01:00:34', '2009-06-01 08:00:34', '', 0, 'http://wpthemetestdata.wordpress.com/2007/11/24/many-tags/', 0, 'post', '', 0),
(1152, 3, '2009-07-02 02:00:03', '2009-07-02 09:00:03', 'This post has many categories.', 'Edge Case: Many Categories', '', 'publish', 'closed', 'closed', '', 'edge-case-many-categories', '', '', '2009-07-02 02:00:03', '2009-07-02 09:00:03', '', 0, 'http://wpthemetestdata.wordpress.com/2007/11/24/many-categories/', 0, 'post', '', 0),
(1153, 3, '2020-01-01 12:00:18', '2020-01-01 19:00:18', 'This post is scheduled to be published in the future.\r\n\r\nIt should not be displayed by the theme.', 'Scheduled', '', 'future', 'closed', 'closed', '', 'scheduled', '', '', '2016-11-29 10:14:30', '2016-11-29 10:14:30', '', 0, 'http://wpthemetestdata.wordpress.com/?p=418', 0, 'post', '', 0),
(1158, 3, '2010-08-08 05:00:39', '2010-08-08 12:00:39', '<dl id="attachment_612" class="wp-caption aligncenter" style="width:650px;"><dt class="wp-caption-dt"></dt></dl>&nbsp;\n\n<a href="http://wpthemetestdata.files.wordpress.com/2008/06/100_5540.jpg"><img class="alignnone wp-image-755 size-large" src="http://wpthemetestdata.files.wordpress.com/2008/06/100_5540.jpg?w=604" alt="" width="604" height="453" /></a>', 'Post Format: Image', '', 'publish', 'closed', 'closed', '', 'post-format-image', '', '', '2010-08-08 05:00:39', '2010-08-08 12:00:39', '', 0, 'http://wpthemetestdata.wordpress.com/?p=568', 0, 'post', '', 0),
(1161, 3, '2010-06-02 02:00:58', '2010-06-02 09:00:58', 'http://www.youtube.com/watch?v=SQEQr7c0-dw\n\nLearn more about <a title="WordPress Embeds" href="http://codex.wordpress.org/Embeds" target="_blank">WordPress Embeds</a>.', 'Post Format: Video (YouTube)', '', 'publish', 'closed', 'closed', '', 'post-format-video-youtube', '', '', '2010-06-02 02:00:58', '2010-06-02 09:00:58', '', 0, 'http://wpthemetestdata.wordpress.com/?p=582', 0, 'post', '', 0),
(1163, 3, '2010-08-07 06:00:19', '2010-08-07 13:00:19', '[caption id="attachment_754" align="alignnone" width="604"]<a href="http://wpthemetestdata.files.wordpress.com/2008/06/100_5478.jpg"><img class="wp-image-754 size-large" src="http://wpthemetestdata.files.wordpress.com/2008/06/100_5478.jpg?w=604" alt="Bell on Wharf" width="604" height="453" /></a> Bell on wharf in San Francisco[/caption]', 'Post Format: Image (Caption)', '', 'publish', 'closed', 'closed', '', 'post-format-image-caption', '', '', '2010-08-07 06:00:19', '2010-08-07 13:00:19', '', 0, 'http://wpthemetestdata.wordpress.com/?p=674', 0, 'post', '', 0),
(1164, 3, '2013-04-09 11:20:39', '2013-04-09 18:20:39', 'This post is drafted and not published yet.\n\nIt should not be displayed by the theme.', 'Draft', '', 'draft', 'closed', 'closed', '', '', '', '', '2013-04-09 11:20:39', '2013-04-09 18:20:39', '', 0, 'http://wptest.io/demo/?p=922', 0, 'post', '', 0),
(1168, 3, '2012-01-04 09:38:05', '2012-01-04 16:38:05', 'This content, comments, pingbacks, and trackbacks should not be visible until the password is entered.', 'Template: Password Protected (the password is "enter")', '', 'publish', 'closed', 'closed', 'enter', 'template-password-protected', '', '', '2012-01-04 09:38:05', '2012-01-04 16:38:05', '', 0, 'http://wpthemetestdata.wordpress.com/2007/09/04/test-with-secret-password/', 0, 'post', '', 1),
(1169, 3, '2009-09-05 09:00:23', '2009-09-05 16:00:23', 'This post has no title, but it still must link to the single post view somehow.\n\nThis is typically done by placing the permalink on the post date.', '', '', 'publish', 'closed', 'closed', '', 'edge-case-no-title', '', '', '2009-09-05 09:00:23', '2009-09-05 16:00:23', '', 0, 'http://wpthemetestdata.wordpress.com/2007/09/04/14/', 0, 'post', '', 0),
(1170, 3, '2009-08-06 09:39:56', '2009-08-06 16:39:56', '', 'Edge Case: No Content', '', 'publish', 'closed', 'closed', '', 'edge-case-no-content', '', '', '2009-08-06 09:39:56', '2009-08-06 16:39:56', '', 0, 'http://wpthemetestdata.wordpress.com/2007/09/04/this-post-has-no-body/', 0, 'post', '', 1),
(1171, 3, '2012-01-08 10:00:20', '2012-01-08 17:00:20', 'Post Page 1\n\n<!--nextpage-->\n\nPost Page 2\n\n<!--nextpage-->\n\nPost Page 3', 'Template: Paginated', '', 'publish', 'closed', 'closed', '', 'template-paginated', '', '', '2012-01-08 10:00:20', '2012-01-08 17:00:20', '', 0, 'http://noeltest.wordpress.com/?p=188', 0, 'post', '', 0),
(1173, 3, '2013-01-05 10:00:49', '2013-01-05 17:00:49', 'Verify that:\n<ul>\n	<li><span style="line-height:1.714285714;font-size:1rem;">The post title renders the word "with" in </span><em style="line-height:1.714285714;font-size:1rem;">italics</em><span style="line-height:1.714285714;font-size:1rem;"> and the word "markup" in </span><strong style="line-height:1.714285714;font-size:1rem;">bold</strong><span style="line-height:1.714285714;font-size:1rem;">.</span></li>\n	<li><span style="line-height:1.714285714;font-size:1rem;">The post title markup should be removed from the browser window / tab.</span></li>\n</ul>', 'Markup: Title With Markup', '', 'publish', 'closed', 'closed', '', 'markup-title-with-markup', '', '', '2013-01-05 10:00:49', '2013-01-05 17:00:49', '', 0, 'http://wptest.io/demo/?p=861', 0, 'post', '', 0),
(1174, 3, '2013-01-05 11:00:20', '2013-01-05 18:00:20', 'Putting special characters in the title should have no adverse effect on the layout or functionality.\n\nSpecial characters in the post title have been known to cause issues with JavaScript when it is minified, especially in the admin when editing the post itself (ie. issues with metaboxes, media upload, etc.).\n<h2>Latin Character Tests</h2>\nThis is a test to see if the fonts used in this theme support basic Latin characters.\n<table>\n<tbody>\n<tr>\n<td>!</td>\n<td>"</td>\n<td>#</td>\n<td>$</td>\n<td>%</td>\n<td>&amp;</td>\n<td>\'</td>\n<td>(</td>\n<td>)</td>\n<td>*</td>\n</tr>\n<tr>\n<td>+</td>\n<td>,</td>\n<td>-</td>\n<td>.</td>\n<td>/</td>\n<td>0</td>\n<td>1</td>\n<td>2</td>\n<td>3</td>\n<td>4</td>\n</tr>\n<tr>\n<td>5</td>\n<td>6</td>\n<td>7</td>\n<td>8</td>\n<td>9</td>\n<td>:</td>\n<td>;</td>\n<td>&gt;</td>\n<td>=</td>\n<td>&lt;</td>\n</tr>\n<tr>\n<td>?</td>\n<td>@</td>\n<td>A</td>\n<td>B</td>\n<td>C</td>\n<td>D</td>\n<td>E</td>\n<td>F</td>\n<td>G</td>\n<td>H</td>\n</tr>\n<tr>\n<td>I</td>\n<td>J</td>\n<td>K</td>\n<td>L</td>\n<td>M</td>\n<td>N</td>\n<td>O</td>\n<td>P</td>\n<td>Q</td>\n<td>R</td>\n</tr>\n<tr>\n<td>S</td>\n<td>T</td>\n<td>U</td>\n<td>V</td>\n<td>W</td>\n<td>X</td>\n<td>Y</td>\n<td>Z</td>\n<td>[</td>\n<td>\\</td>\n</tr>\n<tr>\n<td>]</td>\n<td>^</td>\n<td>_</td>\n<td>`</td>\n<td>a</td>\n<td>b</td>\n<td>c</td>\n<td>d</td>\n<td>e</td>\n<td>f</td>\n</tr>\n<tr>\n<td>g</td>\n<td>h</td>\n<td>i</td>\n<td>j</td>\n<td>k</td>\n<td>l</td>\n<td>m</td>\n<td>n</td>\n<td>o</td>\n<td>p</td>\n</tr>\n<tr>\n<td>q</td>\n<td>r</td>\n<td>s</td>\n<td>t</td>\n<td>u</td>\n<td>v</td>\n<td>w</td>\n<td>x</td>\n<td>y</td>\n<td>z</td>\n</tr>\n<tr>\n<td>{</td>\n<td>|</td>\n<td>}</td>\n<td>~</td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n<td></td>\n</tr>\n</tbody>\n</table>', 'Markup: Title With Special Characters', '', 'publish', 'closed', 'closed', '', 'title-with-special-characters', '', '', '2013-01-05 11:00:20', '2013-01-05 18:00:20', '', 0, 'http://wptest.io/demo/?p=867', 0, 'post', '', 0),
(1175, 3, '2009-10-05 12:00:59', '2009-10-05 19:00:59', '<h2>Title should not overflow the content area</h2>\n\nA few things to check for:\n<ul>\n	<li>Non-breaking text in the title, content, and comments should have no adverse effects on layout or functionality.</li>\n	<li>Check the browser window / tab title.</li>\n	<li>If you are a plugin or widget developer, check that this text does not break anything.</li>\n</ul>\n\nThe following CSS properties will help you support non-breaking text.\n\n<pre>-ms-word-wrap: break-word;\nword-wrap: break-word;</pre>\n&nbsp;', 'Antidisestablishmentarianism', '', 'publish', 'closed', 'closed', '', 'title-should-not-overflow-the-content-area', '', '', '2009-10-05 12:00:59', '2009-10-05 19:00:59', '', 0, 'http://wptest.io/demo/?p=877', 0, 'post', '', 0),
(1176, 3, '2013-01-09 09:00:39', '2013-01-09 16:00:39', '<h3>Default</h3>\nThis is a paragraph. It should not have any alignment of any kind. It should just flow like you would normally expect. Nothing fancy. Just straight up text, free flowing, with love. Completely neutral and not picking a side or sitting on the fence. It just is. It just freaking is. It likes where it is. It does not feel compelled to pick a side. Leave him be. It will just be better that way. Trust me.\n<h3>Left Align</h3>\n<p style="text-align:left;">This is a paragraph. It is left aligned. Because of this, it is a bit more liberal in it\'s views. It\'s favorite color is green. Left align tends to be more eco-friendly, but it provides no concrete evidence that it really is. Even though it likes share the wealth evenly, it leaves the equal distribution up to justified alignment.</p>\n\n<h3>Center Align</h3>\n<p style="text-align:center;">This is a paragraph. It is center aligned. Center is, but nature, a fence sitter. A flip flopper. It has a difficult time making up its mind. It wants to pick a side. Really, it does. It has the best intentions, but it tends to complicate matters more than help. The best you can do is try to win it over and hope for the best. I hear center align does take bribes.</p>\n\n<h3>Right Align</h3>\n<p style="text-align:right;">This is a paragraph. It is right aligned. It is a bit more conservative in it\'s views. It\'s prefers to not be told what to do or how to do it. Right align totally owns a slew of guns and loves to head to the range for some practice. Which is cool and all. I mean, it\'s a pretty good shot from at least four or five football fields away. Dead on. So boss.</p>\n\n<h3>Justify Align</h3>\n<p style="text-align:justify;">This is a paragraph. It is justify aligned. It gets really mad when people associate it with Justin Timberlake. Typically, justified is pretty straight laced. It likes everything to be in it\'s place and not all cattywampus like the rest of the aligns. I am not saying that makes it better than the rest of the aligns, but it does tend to put off more of an elitist attitude.</p>', 'Markup: Text Alignment', '', 'publish', 'closed', 'closed', '', 'markup-text-alignment', '', '', '2013-01-09 09:00:39', '2013-01-09 16:00:39', '', 0, 'http://wptest.io/demo/?p=895', 0, 'post', '', 0),
(1177, 3, '2013-01-10 20:15:40', '2013-01-11 03:15:40', 'Welcome to image alignment! The best way to demonstrate the ebb and flow of the various image positioning options is to nestle them snuggly among an ocean of words. Grab a paddle and let\'s get started.\n\nOn the topic of alignment, it should be noted that users can choose from the options of <em>None</em>, <em>Left</em>, <em>Right, </em>and <em>Center</em>. In addition, they also get the options of <em>Thumbnail</em>, <em>Medium</em>, <em>Large</em> &amp; <em>Fullsize</em>.\n<p style="text-align:center;"><img class="size-full wp-image-906 aligncenter" title="Image Alignment 580x300" alt="Image Alignment 580x300" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-580x300.jpg" width="580" height="300" /></p>\nThe image above happens to be <em><strong>centered</strong></em>.\n\n<strong><img class="size-full wp-image-904 alignleft" title="Image Alignment 150x150" alt="Image Alignment 150x150" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-150x150.jpg" width="150" height="150" /></strong>The rest of this paragraph is filler for the sake of seeing the text wrap around the 150x150 image, which is <em><strong>left aligned</strong></em>. <strong></strong>\n\nAs you can see the should be some space above, below, and to the right of the image. The text should not be creeping on the image. Creeping is just not right. Images need breathing room too. Let them speak like you words. Let them do their jobs without any hassle from the text. In about one more sentence here, we\'ll see that the text moves from the right of the image down below the image in seamless transition. Again, letting the do it\'s thang. Mission accomplished!\n\nAnd now for a <em><strong>massively large image</strong></em>. It also has <em><strong>no alignment</strong></em>.\n\n<img class="alignnone  wp-image-907" title="Image Alignment 1200x400" alt="Image Alignment 1200x400" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-1200x4002.jpg" width="1200" height="400" />\n\nThe image above, though 1200px wide, should not overflow the content area. It should remain contained with no visible disruption to the flow of content.\n\n<img class="size-full wp-image-905 alignright" title="Image Alignment 300x200" alt="Image Alignment 300x200" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-300x200.jpg" width="300" height="200" />\n\nAnd now we\'re going to shift things to the <em><strong>right align</strong></em>. Again, there should be plenty of room above, below, and to the left of the image. Just look at him there... Hey guy! Way to rock that right side. I don\'t care what the left aligned image says, you look great. Don\'t let anyone else tell you differently.\n\nIn just a bit here, you should see the text start to wrap below the right aligned image and settle in nicely. There should still be plenty of room and everything should be sitting pretty. Yeah... Just like that. It never felt so good to be right.\n\nAnd just when you thought we were done, we\'re going to do them all over again with captions!\n\n[caption id="attachment_906" align="aligncenter" width="580"]<img class="size-full wp-image-906  " title="Image Alignment 580x300" alt="Image Alignment 580x300" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-580x300.jpg" width="580" height="300" /> Look at 580x300 getting some <a title="Image Settings" href="http://en.support.wordpress.com/images/image-settings/">caption</a> love.[/caption]\n\nThe image above happens to be <em><strong>centered</strong></em>. The caption also has a link in it, just to see if it does anything funky.\n\n[caption id="attachment_904" align="alignleft" width="150"]<img class="size-full wp-image-904  " title="Image Alignment 150x150" alt="Image Alignment 150x150" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-150x150.jpg" width="150" height="150" /> Itty-bitty caption.[/caption]\n\n<strong></strong>The rest of this paragraph is filler for the sake of seeing the text wrap around the 150x150 image, which is <em><strong>left aligned</strong></em>. <strong></strong>\n\nAs you can see the should be some space above, below, and to the right of the image. The text should not be creeping on the image. Creeping is just not right. Images need breathing room too. Let them speak like you words. Let them do their jobs without any hassle from the text. In about one more sentence here, we\'ll see that the text moves from the right of the image down below the image in seamless transition. Again, letting the do it\'s thang. Mission accomplished!\n\nAnd now for a <em><strong>massively large image</strong></em>. It also has <em><strong>no alignment</strong></em>.\n\n[caption id="attachment_907" align="alignnone" width="1200"]<img class=" wp-image-907" title="Image Alignment 1200x400" alt="Image Alignment 1200x400" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-1200x4002.jpg" width="1200" height="400" /> Massive image comment for your eyeballs.[/caption]\n\nThe image above, though 1200px wide, should not overflow the content area. It should remain contained with no visible disruption to the flow of content.\n\n[caption id="attachment_905" align="alignright" width="300"]<img class="size-full wp-image-905 " title="Image Alignment 300x200" alt="Image Alignment 300x200" src="http://wpthemetestdata.files.wordpress.com/2013/03/image-alignment-300x200.jpg" width="300" height="200" /> Feels good to be right all the time.[/caption]\n\nAnd now we\'re going to shift things to the <em><strong>right align</strong></em>. Again, there should be plenty of room above, below, and to the left of the image. Just look at him there... Hey guy! Way to rock that right side. I don\'t care what the left aligned image says, you look great. Don\'t let anyone else tell you differently.\n\nIn just a bit here, you should see the text start to wrap below the right aligned image and settle in nicely. There should still be plenty of room and everything should be sitting pretty. Yeah... Just like that. It never felt so good to be right.\n\nAnd that\'s a wrap, yo! You survived the tumultuous waters of alignment. Image alignment achievement unlocked!', 'Markup: Image Alignment', '', 'publish', 'closed', 'closed', '', 'markup-image-alignment', '', '', '2013-01-10 20:15:40', '2013-01-11 03:15:40', '', 0, 'http://wptest.io/demo/?p=903', 0, 'post', '', 0),
(1178, 3, '2013-01-11 20:22:19', '2013-01-12 03:22:19', '<h2>Headings</h2>\n<h1>Header one</h1>\n<h2>Header two</h2>\n<h3>Header three</h3>\n<h4>Header four</h4>\n<h5>Header five</h5>\n<h6>Header six</h6>\n<h2>Blockquotes</h2>\nSingle line blockquote:\n<blockquote>Stay hungry. Stay foolish.</blockquote>\nMulti line blockquote with a cite reference:\n<blockquote>People think focus means saying yes to the thing you\'ve got to focus on. But that\'s not what it means at all. It means saying no to the hundred other good ideas that there are. You have to pick carefully. I\'m actually as proud of the things we haven\'t done as the things I have done. Innovation is saying no to 1,000 things. </blockquote>\n<cite>Steve Jobs</cite> - Apple Worldwide Developers\' Conference, 1997\n<h2>Tables</h2>\n<table>\n<thead>\n<tr>\n<th>Employee</th>\n<th>Salary</th>\n<th></th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<th><a href="http://example.org/">John Doe</a></th>\n<td>$1</td>\n<td>Because that\'s all Steve Jobs needed for a salary.</td>\n</tr>\n<tr>\n<th><a href="http://example.org/">Jane Doe</a></th>\n<td>$100K</td>\n<td>For all the blogging she does.</td>\n</tr>\n<tr>\n<th><a href="http://example.org/">Fred Bloggs</a></th>\n<td>$100M</td>\n<td>Pictures are worth a thousand words, right? So Jane x 1,000.</td>\n</tr>\n<tr>\n<th><a href="http://example.org/">Jane Bloggs</a></th>\n<td>$100B</td>\n<td>With hair like that?! Enough said...</td>\n</tr>\n</tbody>\n</table>\n<h2>Definition Lists</h2>\n<dl><dt>Definition List Title</dt><dd>Definition list division.</dd><dt>Startup</dt><dd>A startup company or startup is a company or temporary organization designed to search for a repeatable and scalable business model.</dd><dt>#dowork</dt><dd>Coined by Rob Dyrdek and his personal body guard Christopher "Big Black" Boykins, "Do Work" works as a self motivator, to motivating your friends.</dd><dt>Do It Live</dt><dd>I\'ll let Bill O\'Reilly will <a title="We\'ll Do It Live" href="https://www.youtube.com/watch?v=O_HyZ5aW76c">explain</a> this one.</dd></dl>\n<h2>Unordered Lists (Nested)</h2>\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one\n<ul>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ul>\n<h2>Ordered List (Nested)</h2>\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one\n<ol>\n	<li>List item one</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n</li>\n	<li>List item two</li>\n	<li>List item three</li>\n	<li>List item four</li>\n</ol>\n<h2>HTML Tags</h2>\nThese supported tags come from the WordPress.com code <a title="Code" href="http://en.support.wordpress.com/code/">FAQ</a>.\n\n<strong>Address Tag</strong>\n\n<address>1 Infinite Loop\nCupertino, CA 95014\nUnited States</address><strong>Anchor Tag (aka. Link)</strong>\n\nThis is an example of a <a title="Apple" href="http://apple.com">link</a>.\n\n<strong>Abbreviation Tag</strong>\n\nThe abbreviation <abbr title="Seriously">srsly</abbr> stands for "seriously".\n\n<strong>Acronym Tag (<em>deprecated in HTML5</em>)</strong>\n\nThe acronym <acronym title="For The Win">ftw</acronym> stands for "for the win".\n\n<strong>Big Tag <strong>(<em>deprecated in HTML5</em>)</strong></strong>\n\nThese tests are a <big>big</big> deal, but this tag is no longer supported in HTML5.\n\n<strong>Cite Tag</strong>\n\n"Code is poetry." --<cite>Automattic</cite>\n\n<strong>Code Tag</strong>\n\nYou will learn later on in these tests that <code>word-wrap: break-word;</code> will be your best friend.\n\n<strong>Delete Tag</strong>\n\nThis tag will let you <del>strikeout text</del>, but this tag is no longer supported in HTML5 (use the <code>&lt;strike&gt;</code> instead).\n\n<strong>Emphasize Tag</strong>\n\nThe emphasize tag should <em>italicize</em> text.\n\n<strong>Insert Tag</strong>\n\nThis tag should denote <ins>inserted</ins> text.\n\n<strong>Keyboard Tag</strong>\n\nThis scarcely known tag emulates <kbd>keyboard text</kbd>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Preformatted Tag</strong>\n\nThis tag styles large blocks of code.\n<pre>.post-title {\n	margin: 0 0 5px;\n	font-weight: bold;\n	font-size: 38px;\n	line-height: 1.2;\n	and here\'s a line of some really, really, really, really long text, just to see how the PRE tag handles it and to find out how it overflows;\n}</pre>\n<strong>Quote Tag</strong>\n\n<q>Developers, developers, developers...</q> --Steve Ballmer\n\n<strong>Strike Tag <strong>(<em>deprecated in HTML5</em>)</strong></strong>\n\nThis tag shows <span style="text-decoration:line-through;">strike-through text</span>\n\n<strong>Strong Tag</strong>\n\nThis tag shows <strong>bold<strong> text.</strong></strong>\n\n<strong>Subscript Tag</strong>\n\nGetting our science styling on with H<sub>2</sub>O, which should push the "2" down.\n\n<strong>Superscript Tag</strong>\n\nStill sticking with science and Isaac Newton\'s E = MC<sup>2</sup>, which should lift the 2 up.\n\n<strong>Teletype Tag <strong>(<em>deprecated in HTML5</em>)</strong></strong>\n\nThis rarely used tag emulates <tt>teletype text</tt>, which is usually styled like the <code>&lt;code&gt;</code> tag.\n\n<strong>Variable Tag</strong>\n\nThis allows you to denote <var>variables</var>.', 'Markup: HTML Tags and Formatting', '', 'publish', 'closed', 'closed', '', 'markup-html-tags-and-formatting', '', '', '2013-01-11 20:22:19', '2013-01-12 03:22:19', '', 0, 'http://wptest.io/demo/?p=919', 0, 'post', '', 0),
(1179, 3, '2011-03-15 15:47:16', '2011-03-15 22:47:16', 'https://twitter.com/nacin/status/319508408669708289\n\nThis post tests WordPress\' <a title="Twitter Embeds" href="http://en.support.wordpress.com/twitter/twitter-embeds/" target="_blank">Twitter Embeds</a> feature.', 'Media: Twitter Embeds', '', 'publish', 'closed', 'closed', '', 'media-twitter-embeds', '', '', '2011-03-15 15:47:16', '2011-03-15 22:47:16', '', 0, 'http://wptest.io/demo/?p=1027', 0, 'post', '', 0),
(1241, 3, '2012-01-07 07:07:21', '2012-01-07 14:07:21', 'This is a sticky post.\n\nThere are a few things to verify:\n<ul>\n	<li>The sticky post should be distinctly recognizable in some way in comparison to normal posts. You can style the <code>.sticky</code> class if you are using the <a title="WordPress Codex post_class() Function" href="http://codex.wordpress.org/Function_Reference/post_class" target="_blank">post_class()</a> function to generate your post classes, which is a best practice.</li>\n	<li>They should show at the very top of the blog index page, even though they could be several posts back chronologically.</li>\n	<li>They should still show up again in their chronologically correct postion in time, but without the sticky indicator.</li>\n	<li>If you have a plugin or widget that lists popular posts or comments, make sure that this sticky post is not always at the top of those lists unless it really is popular.</li>\n</ul>', 'Template: Sticky', '', 'publish', 'closed', 'closed', '', 'template-sticky', '', '', '2012-01-07 07:07:21', '2012-01-07 14:07:21', '', 0, 'http://wptest.io/demo/?p=1241', 0, 'post', '', 0),
(1446, 3, '2012-03-14 09:49:22', '2012-03-14 16:49:22', 'This is the post content. It should be displayed in place of the auto-generated excerpt in single-page views. Archive-index pages should display an auto-generated excerpt of this content. Depending on Theme-defined filters, the length of the auto-generated excerpt will vary from Theme-to-Theme. The default length for auto-generated excerpts is 55 words, so to test the excerpt auto-generation, this post must have more than 55 words.\n\nBe sure to test the formatting of the auto-generated excerpt, to ensure that it doesn\'t create any layout problems. Also, ensure that any filters applied to the excerpt, such as &lt;code&gt;excerpt_length&lt;/code&gt; and &lt;code&gt;excerpt_more&lt;/code&gt;, display properly.', 'Template: Excerpt (Generated)', '', 'publish', 'closed', 'closed', '', 'template-excerpt-generated', '', '', '2012-03-14 09:49:22', '2012-03-14 16:49:22', '', 0, 'http://wpthemetestdata.wordpress.com/?p=1446', 0, 'post', '', 0),
(1771, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1771', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1771/', 4, 'nav_menu_item', '', 0),
(1772, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1772', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1772/', 6, 'nav_menu_item', '', 0),
(1773, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1773', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1773/', 3, 'nav_menu_item', '', 0),
(1774, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1774', '', '', '2016-09-20 18:43:00', '2016-09-20 18:43:00', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1774/', 5, 'nav_menu_item', '', 0),
(1775, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1775', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1775/', 6, 'nav_menu_item', '', 0),
(1776, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1776', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 9, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1776/', 8, 'nav_menu_item', '', 0),
(1777, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1777', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 173, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1777/', 22, 'nav_menu_item', '', 0),
(1778, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1778', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 173, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1778/', 23, 'nav_menu_item', '', 0),
(1779, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1779', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 174, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1779/', 24, 'nav_menu_item', '', 0),
(1780, 2, '2016-09-20 18:16:55', '2016-09-20 18:16:55', ' ', '', '', 'publish', 'closed', 'closed', '', '1780', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 174, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/09/20/1780/', 25, 'nav_menu_item', '', 0),
(1843, 1, '2016-11-08 14:11:05', '2016-11-08 14:11:05', '', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 14:11:05', '2016-11-08 14:11:05', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1842, 1, '2016-11-08 14:11:05', '2016-11-08 14:11:05', '[vc_row][vc_column][goarch_page_heading_section class=" bg-about" items="%5B%7B%7D%5D" css=".vc_custom_1481618532323{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/about.jpg?id=1964) !important;}"][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22style%22%3A%22true%22%2C%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%2028.3%25%22%2C%22p_left%22%3A%2248.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2217.7%25%20%22%2C%22p_left%22%3A%2252.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2224.4%25%20%20%22%2C%22p_left%22%3A%2262.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Peking%22%2C%22p_top%22%3A%2242.4%25%20%20%22%2C%22p_left%22%3A%2282.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'publish', 'closed', 'closed', '', 'about-us', '', '', '2016-12-13 08:42:32', '2016-12-13 08:42:32', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?page_id=1842', 0, 'page', '', 0),
(1788, 1, '2016-11-04 13:14:08', '2016-11-04 13:14:08', '', '1-760x514', '', 'inherit', 'open', 'closed', '', '1-760x514', '', '', '2016-11-04 13:14:08', '2016-11-04 13:14:08', '', 1787, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/1-760x514.jpg', 0, 'attachment', 'image/jpeg', 0),
(1789, 1, '2016-11-04 13:14:24', '2016-11-04 13:14:24', 'When you enter into any new area of science, you almost always find yourself with a baffling new language of technical terms to learn before you can converse with the experts. This is certainly true in astronomy both in terms of terms that refer to the cosmos and terms that describe the tools of the trade, the most prevalent being the telescope. So to get us off of first base, let’s define some of the key terms that pertain to telescopes to help you be able to talk to them more intelligently.\r\n\r\nThe first area of specialization in telescopes has to do with the types of telescopes people use. The three designs of telescopes that most people use are the Refractor, the Reflector and the Schmidt Cassegrain telescope. The refractor telescope uses a convex lens to focus the light on the eyepiece. The reflector telescope has a concave lens which means it bends in. It uses mirrors to focus the image that you eventually see. The Schmidt Cassegrain telescope uses an involved system of mirrors to capture the image you want to see. A binocular telescope uses a set of telescopes mounted and synchronized so your view of the sky is 3-D.\r\n\r\nBeyond the basic types, other terms refer to parts of the telescope or to the science behind how telescopes work. Collimation is a term for how well tuned the telescope is to give you a good clear image of what you are looking at. You want your telescope to have good collimation so you are not getting a false image of the celestial body.\r\n\r\nAperture is a fancy word for how big the lens of your telescope is. But it’s an important word because the aperture of the lens is the key to how powerful your telescope is. Magnification has nothing to do with it, its all in the aperture.', 'Advice for stirring your online community and fostering engagement  Sticky note agile personas', '', 'inherit', 'closed', 'closed', '', '1787-revision-v1', '', '', '2016-11-04 13:14:24', '2016-11-04 13:14:24', '', 1787, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/04/1787-revision-v1/', 0, 'revision', '', 0),
(1924, 1, '2016-11-11 17:11:36', '2016-11-11 17:11:36', '[vc_row][vc_column][goarch_page_heading_section heading="CONTACTS" class=" main-contacts bg-contacts" items="%5B%7B%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%2028.3%25%22%2C%22p_left%22%3A%2248.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2217.7%25%20%22%2C%22p_left%22%3A%2252.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2224.4%25%20%20%22%2C%22p_left%22%3A%2262.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Peking%22%2C%22p_top%22%3A%2242.4%25%20%20%22%2C%22p_left%22%3A%2282.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][goarch_map lat="45.036558" lng="38.9957687" zoom="16" map_items="%5B%7B%22icon%22%3A%22fa%20fa-map-marker%22%2C%22content%22%3A%22USA%2C%20New%20York%3Cbr%3E%20648%20Ivah%20Street%20Apt.%20375%22%7D%2C%7B%22icon%22%3A%22fa%20fa-map-marker%22%2C%22content%22%3A%22USA%2C%20New%20York%3Cbr%3E%20648%20Ivah%20Street%20Apt.%20375%22%7D%2C%7B%22icon%22%3A%22fa%20fa-map-marker%22%2C%22content%22%3A%22USA%2C%20New%20York%3Cbr%3E%20648%20Ivah%20Street%20Apt.%20375%22%7D%5D" address="%5B%7B%22class%22%3A%22phone%20contact-row%22%2C%22fa%22%3A%22fa%20fa-phone%22%2C%22title%22%3A%22Phone%22%2C%22contacts%22%3A%22%255B%257B%2522d%2522%253A%2522%252B0%2520543%2520554%252044-25%2522%252C%2522class2%2522%253A%2522%2520phone-row%2522%257D%252C%257B%2522d%2522%253A%2522%252B0%2520543%2520554%252044-25%2522%252C%2522class2%2522%253A%2522%2520phone-row%2522%257D%252C%257B%2522d%2522%253A%2522%252B0%2520543%2520554%252044-25%2522%252C%2522class2%2522%253A%2522%2520phone-row%2522%257D%255D%22%7D%2C%7B%22class%22%3A%22phone%20contact-row%22%2C%22fa%22%3A%22fa%20fa-envelope-o%22%2C%22title%22%3A%22Email%22%2C%22contacts%22%3A%22%255B%257B%2522d%2522%253A%2522goarch%2540domain.com%2522%252C%2522class2%2522%253A%2522%2520contact-content%2522%257D%255D%22%7D%2C%7B%22class%22%3A%22phone%20contact-row%22%2C%22fa%22%3A%22fa%20fa-map-marker%22%2C%22title%22%3A%22ADDRESS%22%2C%22contacts%22%3A%22%255B%257B%2522d%2522%253A%2522USA%252C%2520New%2520York%252C%253Cbr%253E648%2520Ivah%2520Street%2520Apt.%2520375%2522%252C%2522class2%2522%253A%2522%2520contact-content%2522%257D%255D%22%7D%5D"][/vc_column][/vc_row]', 'CONTACTS', '', 'inherit', 'closed', 'closed', '', '1916-revision-v1', '', '', '2016-11-11 17:11:36', '2016-11-11 17:11:36', '', 1916, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/11/1916-revision-v1/', 0, 'revision', '', 0);
REPLACE INTO `xwlpv_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(1791, 1, '2016-11-04 13:16:14', '2016-11-04 13:16:14', 'When you enter into any new area of science, you almost always find yourself with a baffling new language of technical terms to learn before you can converse with the experts. This is certainly true in astronomy both in terms of terms that refer to the cosmos and terms that describe the tools of the trade, the most prevalent being the telescope. So to get us off of first base, let’s define some of the key terms that pertain to telescopes to help you be able to talk to them more intelligently.\r\n\r\nThe first area of specialization in telescopes has to do with the types of telescopes people use. The three designs of telescopes that most people use are the Refractor, the Reflector and the Schmidt Cassegrain telescope. The refractor telescope uses a convex lens to focus the light on the eyepiece. The reflector telescope has a concave lens which means it bends in. It uses mirrors to focus the image that you eventually see. The Schmidt Cassegrain telescope uses an involved system of mirrors to capture the image you want to see. A binocular telescope uses a set of telescopes mounted and synchronized so your view of the sky is 3-D.\r\n\r\nBeyond the basic types, other terms refer to parts of the telescope or to the science behind how telescopes work. Collimation is a term for how well tuned the telescope is to give you a good clear image of what you are looking at. You want your telescope to have good collimation so you are not getting a false image of the celestial body.\r\n\r\nAperture is a fancy word for how big the lens of your telescope is. But it’s an important word because the aperture of the lens is the key to how powerful your telescope is. Magnification has nothing to do with it, its all in the aperture.', 'Advice for stirring your online community and fostering engagement', '', 'publish', 'open', 'open', '', 'advice-for-stirring-your-online-community-and-fostering-engagement', '', '', '2016-11-04 13:16:14', '2016-11-04 13:16:14', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?p=1791', 0, 'post', '', 0),
(1792, 1, '2016-11-04 13:16:06', '2016-11-04 13:16:06', '', '3-760x514', '', 'inherit', 'open', 'closed', '', '3-760x514', '', '', '2016-11-04 13:16:06', '2016-11-04 13:16:06', '', 1791, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/3-760x514.jpg', 0, 'attachment', 'image/jpeg', 0),
(1793, 1, '2016-11-04 13:16:14', '2016-11-04 13:16:14', 'When you enter into any new area of science, you almost always find yourself with a baffling new language of technical terms to learn before you can converse with the experts. This is certainly true in astronomy both in terms of terms that refer to the cosmos and terms that describe the tools of the trade, the most prevalent being the telescope. So to get us off of first base, let’s define some of the key terms that pertain to telescopes to help you be able to talk to them more intelligently.\r\n\r\nThe first area of specialization in telescopes has to do with the types of telescopes people use. The three designs of telescopes that most people use are the Refractor, the Reflector and the Schmidt Cassegrain telescope. The refractor telescope uses a convex lens to focus the light on the eyepiece. The reflector telescope has a concave lens which means it bends in. It uses mirrors to focus the image that you eventually see. The Schmidt Cassegrain telescope uses an involved system of mirrors to capture the image you want to see. A binocular telescope uses a set of telescopes mounted and synchronized so your view of the sky is 3-D.\r\n\r\nBeyond the basic types, other terms refer to parts of the telescope or to the science behind how telescopes work. Collimation is a term for how well tuned the telescope is to give you a good clear image of what you are looking at. You want your telescope to have good collimation so you are not getting a false image of the celestial body.\r\n\r\nAperture is a fancy word for how big the lens of your telescope is. But it’s an important word because the aperture of the lens is the key to how powerful your telescope is. Magnification has nothing to do with it, its all in the aperture.', 'Advice for stirring your online community and fostering engagement', '', 'inherit', 'closed', 'closed', '', '1791-revision-v1', '', '', '2016-11-04 13:16:14', '2016-11-04 13:16:14', '', 1791, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/04/1791-revision-v1/', 0, 'revision', '', 0),
(1800, 1, '2016-11-05 15:42:09', '2016-11-05 15:42:09', '', 'icon-interiors', '', 'inherit', 'open', 'closed', '', 'icon-interiors', '', '', '2016-11-05 15:42:09', '2016-11-05 15:42:09', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/05/icon-interiors.png', 0, 'attachment', 'image/png', 0),
(1801, 1, '2016-11-05 15:42:11', '2016-11-05 15:42:11', '', 'icon-planing', '', 'inherit', 'open', 'closed', '', 'icon-planing', '', '', '2016-11-05 15:42:11', '2016-11-05 15:42:11', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/05/icon-planing.png', 0, 'attachment', 'image/png', 0),
(1804, 1, '2016-11-05 15:54:26', '2016-11-05 15:54:26', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="11111111" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-05 15:54:26', '2016-11-05 15:54:26', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/05/701-revision-v1/', 0, 'revision', '', 0),
(1803, 1, '2016-11-05 15:43:57', '2016-11-05 15:43:57', '[vc_row][vc_column][goarch_main_slider][goarch_about img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%2C%22i_title_p%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%2C%22i_title_p%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%2C%22i_title_p%22%3A%22%20ARCHITECTURE%20%22%7D%5D"][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-05 15:43:57', '2016-11-05 15:43:57', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/05/701-revision-v1/', 0, 'revision', '', 0),
(1805, 1, '2016-11-05 16:14:35', '2016-11-05 16:14:35', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-05 16:14:35', '2016-11-05 16:14:35', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/05/701-revision-v1/', 0, 'revision', '', 0),
(1806, 1, '2016-11-06 08:29:55', '2016-11-06 08:29:55', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Residential care project in Paris', '', 'publish', 'closed', 'closed', '', 'residential-care-project-in-paris', '', '', '2016-12-14 18:40:49', '2016-12-14 18:40:49', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1806', 0, 'projects', '', 0),
(1959, 1, '2016-11-29 11:30:05', '2016-11-29 11:30:05', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Concert hall  in New york', '', 'publish', 'closed', 'closed', '', 'concert-hall-in-new-york-2', '', '', '2016-12-14 18:39:31', '2016-12-14 18:39:31', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1959', 0, 'projects', '', 0),
(1960, 1, '2016-11-29 11:29:57', '2016-11-29 11:29:57', '', '11', '', 'inherit', 'open', 'closed', '', '11', '', '', '2016-11-29 11:29:57', '2016-11-29 11:29:57', '', 1959, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/11.jpg', 0, 'attachment', 'image/jpeg', 0),
(1961, 1, '2016-11-29 12:29:22', '2016-11-29 12:29:22', '[vc_row][vc_column][goarch_main_slider alias_slider="home"][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" portfolio_category="" post_id=" 1806 , 1959,1820 ,1821 , 1879, 1823, 1824,1878" order="ASC"][goarch_experience content2="12" img="1828"][goarch_clients heading="Our" b_text="Work together " img="1835" items="%5B%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%5D" b_url="#"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-29 12:29:22', '2016-11-29 12:29:22', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/29/701-revision-v1/', 0, 'revision', '', 0),
(1808, 1, '2016-11-06 08:42:34', '2016-11-06 08:42:34', '', '1-480x880', '', 'inherit', 'open', 'closed', '', '1-480x880', '', '', '2016-11-06 08:42:34', '2016-11-06 08:42:34', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/1-480x880.jpg', 0, 'attachment', 'image/jpeg', 0),
(1809, 1, '2016-11-06 08:42:41', '2016-11-06 08:42:41', '', '1-780x668', '', 'inherit', 'open', 'closed', '', '1-780x668', '', '', '2016-11-06 08:42:41', '2016-11-06 08:42:41', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/1-780x668.jpg', 0, 'attachment', 'image/jpeg', 0),
(1810, 1, '2016-11-06 08:42:49', '2016-11-06 08:42:49', '', '2-480x880', '', 'inherit', 'open', 'closed', '', '2-480x880', '', '', '2016-11-06 08:42:49', '2016-11-06 08:42:49', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/2-480x880.jpg', 0, 'attachment', 'image/jpeg', 0),
(1811, 1, '2016-11-06 08:43:00', '2016-11-06 08:43:00', '', '2-780x668', '', 'inherit', 'open', 'closed', '', '2-780x668', '', '', '2016-11-06 08:43:00', '2016-11-06 08:43:00', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/2-780x668.jpg', 0, 'attachment', 'image/jpeg', 0),
(1812, 1, '2016-11-06 08:43:08', '2016-11-06 08:43:08', '', '3-480x880', '', 'inherit', 'open', 'closed', '', '3-480x880', '', '', '2016-11-06 08:43:08', '2016-11-06 08:43:08', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/3-480x880.jpg', 0, 'attachment', 'image/jpeg', 0),
(1813, 1, '2016-11-06 08:43:17', '2016-11-06 08:43:17', '', '3-780x668', '', 'inherit', 'open', 'closed', '', '3-780x668', '', '', '2016-11-06 08:43:17', '2016-11-06 08:43:17', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/3-780x668.jpg', 0, 'attachment', 'image/jpeg', 0),
(1814, 1, '2016-11-06 08:43:25', '2016-11-06 08:43:25', '', '4-480x880', '', 'inherit', 'open', 'closed', '', '4-480x880', '', '', '2016-11-06 08:43:25', '2016-11-06 08:43:25', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/4-480x880.jpg', 0, 'attachment', 'image/jpeg', 0),
(1815, 1, '2016-11-06 08:43:30', '2016-11-06 08:43:30', '', '5-480x880', '', 'inherit', 'open', 'closed', '', '5-480x880', '', '', '2016-11-06 08:43:30', '2016-11-06 08:43:30', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/5-480x880.jpg', 0, 'attachment', 'image/jpeg', 0),
(1816, 1, '2016-11-06 08:43:37', '2016-11-06 08:43:37', '', '6-480x880', '', 'inherit', 'open', 'closed', '', '6-480x880', '', '', '2016-11-06 08:43:37', '2016-11-06 08:43:37', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/6-480x880.jpg', 0, 'attachment', 'image/jpeg', 0),
(1817, 1, '2016-11-06 08:43:44', '2016-11-06 08:43:44', '', '7-480x880', '', 'inherit', 'open', 'closed', '', '7-480x880', '', '', '2016-11-06 08:43:44', '2016-11-06 08:43:44', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/7-480x880.jpg', 0, 'attachment', 'image/jpeg', 0),
(1818, 1, '2016-11-06 08:43:52', '2016-11-06 08:43:52', '', '8-480x880', '', 'inherit', 'open', 'closed', '', '8-480x880', '', '', '2016-11-06 08:43:52', '2016-11-06 08:43:52', '', 1806, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/8-480x880.jpg', 0, 'attachment', 'image/jpeg', 0),
(1819, 1, '2016-11-06 08:59:42', '2016-11-06 08:59:42', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Concert hall in New york', '', 'publish', 'closed', 'closed', '', 'concert-hall-in-new-york', '', '', '2016-12-14 18:40:44', '2016-12-14 18:40:44', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1819', 0, 'projects', '', 0),
(1820, 1, '2016-11-06 09:00:27', '2016-11-06 09:00:27', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Modern hotel in London', '', 'publish', 'closed', 'closed', '', 'modern-hotel-in-london', '', '', '2016-12-14 18:40:36', '2016-12-14 18:40:36', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1820', 0, 'projects', '', 0),
(1821, 1, '2016-11-06 09:13:41', '2016-11-06 09:13:41', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Modern hotel in London', '', 'publish', 'closed', 'closed', '', 'modern-hotel-in-london-2', '', '', '2016-12-14 18:40:28', '2016-12-14 18:40:28', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1821', 0, 'projects', '', 0),
(1822, 1, '2016-11-06 09:15:46', '2016-11-06 09:15:46', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Residential care project in Paris', '', 'publish', 'closed', 'closed', '', 'residential-care-project-in-paris-2', '', '', '2016-12-14 18:40:21', '2016-12-14 18:40:21', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1822', 0, 'projects', '', 0),
(1823, 1, '2016-11-06 09:19:52', '2016-11-06 09:19:52', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Residential care project in Paris', '', 'publish', 'closed', 'closed', '', 'residential-care-project-in-paris-3', '', '', '2016-12-14 18:40:16', '2016-12-14 18:40:16', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1823', 0, 'projects', '', 0),
(1824, 1, '2016-11-06 09:20:53', '2016-11-06 09:20:53', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Residential care project in Paris', '', 'publish', 'closed', 'closed', '', 'residential-care-project-in-paris-4', '', '', '2016-12-14 18:40:09', '2016-12-14 18:40:09', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1824', 0, 'projects', '', 0),
(1825, 1, '2016-11-06 09:29:31', '2016-11-06 09:29:31', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Residential care project in Paris', '', 'publish', 'closed', 'closed', '', 'residential-care-project-in-paris-5', '', '', '2016-12-14 18:39:55', '2016-12-14 18:39:55', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1825', 0, 'projects', '', 0),
(1827, 1, '2016-11-07 07:22:35', '2016-11-07 07:22:35', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" order="DESC " portfolio_category=""][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-07 07:22:35', '2016-11-07 07:22:35', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/07/701-revision-v1/', 0, 'revision', '', 0),
(1828, 1, '2016-11-07 08:58:27', '2016-11-07 08:58:27', '', '502x526', '', 'inherit', 'open', 'closed', '', '502x526', '', '', '2016-11-07 08:58:27', '2016-11-07 08:58:27', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/05/502X526.jpg', 0, 'attachment', 'image/jpeg', 0),
(1829, 1, '2016-11-07 12:00:32', '2016-11-07 12:00:32', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" order="DESC " portfolio_category=""][goarch_experience img="1828"]12 [/goarch_experience][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-07 12:00:32', '2016-11-07 12:00:32', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/07/701-revision-v1/', 0, 'revision', '', 0),
(1831, 1, '2016-11-07 17:29:12', '2016-11-07 17:29:12', '', '2', '', 'inherit', 'open', 'closed', '', '2', '', '', '2016-11-07 17:29:12', '2016-11-07 17:29:12', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/05/2.png', 0, 'attachment', 'image/png', 0),
(1836, 1, '2016-11-07 17:38:29', '2016-11-07 17:38:29', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" order="DESC " portfolio_category=""][goarch_experience content2="12" img="1828"][goarch_clients img="1835" items="%5B%7B%7D%5D"][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-07 17:38:29', '2016-11-07 17:38:29', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/07/701-revision-v1/', 0, 'revision', '', 0),
(1835, 1, '2016-11-07 17:29:19', '2016-11-07 17:29:19', '', '1', '', 'inherit', 'open', 'closed', '', '1', '', '', '2016-11-07 17:29:19', '2016-11-07 17:29:19', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2011/05/1.png', 0, 'attachment', 'image/png', 0),
(1853, 1, '2016-11-08 19:31:11', '2016-11-08 19:31:11', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" Error_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 19:31:11', '2016-11-08 19:31:11', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1837, 1, '2016-11-08 08:31:10', '2016-11-08 08:31:10', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" order="DESC " portfolio_category=""][goarch_experience content2="12" img="1828"][goarch_clients heading="Our" b_text="Work together " img="1835" items="%5B%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%5D" b_url="#"][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-08 08:31:10', '2016-11-08 08:31:10', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/701-revision-v1/', 0, 'revision', '', 0),
(1838, 1, '2016-11-08 08:52:38', '2016-11-08 08:52:38', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" order="DESC " portfolio_category=""][goarch_experience content2="12" img="1828"][goarch_clients heading="Our" b_text="Work together " img="1835" items="%5B%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%5D" b_url="#"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info=""][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-08 08:52:38', '2016-11-08 08:52:38', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/701-revision-v1/', 0, 'revision', '', 0),
(1839, 1, '2016-11-08 09:00:13', '2016-11-08 09:00:13', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" order="DESC " portfolio_category=""][goarch_experience content2="12" img="1828"][goarch_clients heading="Our" b_text="Work together " img="1835" items="%5B%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%5D" b_url="#"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info=""] +7 (212) 654-33-35\r\n+7 (212) 287-85-22\r\ninfo@goarch.com\r\nUSA, New York, 57 Quigley Bridge[/goarch_contact_section][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-08 09:00:13', '2016-11-08 09:00:13', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/701-revision-v1/', 0, 'revision', '', 0),
(1840, 1, '2016-11-08 09:04:45', '2016-11-08 09:04:45', '[vc_row][vc_column][goarch_main_slider][goarch_about spec="our\r\nspecialization" img="1798" items="%5B%7B%22images%22%3A%221799%22%2C%22i_title%22%3A%22%20ARCHITECTURE%20%22%7D%2C%7B%22images%22%3A%221800%22%2C%22i_title%22%3A%22INTERIORS%22%7D%2C%7B%22images%22%3A%221801%22%2C%22i_title%22%3A%22PLANING%22%7D%5D"][goarch_project posts="" order="DESC " portfolio_category=""][goarch_experience content2="12" img="1828"][goarch_clients heading="Our" b_text="Work together " img="1835" items="%5B%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221835%22%2C%22c_url%22%3A%22%23%22%7D%2C%7B%22src%22%3A%221831%22%2C%22c_url%22%3A%22%23%22%7D%5D" b_url="#"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'Home - Dark', '', 'inherit', 'closed', 'closed', '', '701-revision-v1', '', '', '2016-11-08 09:04:45', '2016-11-08 09:04:45', '', 701, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/701-revision-v1/', 0, 'revision', '', 0),
(1991, 1, '2016-12-08 14:41:11', '2016-12-08 14:41:11', '', 'Home - Dark2', '', 'publish', 'closed', 'closed', '', 'home-dark-2', '', '', '2016-12-08 14:55:06', '2016-12-08 14:55:06', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?p=1991', 2, 'nav_menu_item', '', 0);
REPLACE INTO `xwlpv_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(1850, 1, '2016-11-08 17:39:31', '2016-11-08 17:39:31', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services Error_message="We\'re sorry, but something went wrong" items="%5B%7B%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Cn%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Cn%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Cn%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 17:39:31', '2016-11-08 17:39:31', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1851, 1, '2016-11-08 17:56:12', '2016-11-08 17:56:12', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services Error_message="We\'re sorry, but something went wrong" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Cn%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Cn%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Cn%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 17:56:12', '2016-11-08 17:56:12', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1852, 1, '2016-11-08 18:13:40', '2016-11-08 18:13:40', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" Error_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 18:13:40', '2016-11-08 18:13:40', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1854, 1, '2016-11-08 19:33:09', '2016-11-08 19:33:09', '', 'map', '', 'inherit', 'open', 'closed', '', 'map', '', '', '2016-11-08 19:33:09', '2016-11-08 19:33:09', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/map.png', 0, 'attachment', 'image/png', 0),
(1855, 1, '2016-11-08 19:43:22', '2016-11-08 19:43:22', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%2212.6%25%22%2C%22p_left%22%3A%2242%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2225.7%25%22%2C%22p_left%22%3A%2239.1%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-08 19:43:22', '2016-11-08 19:43:22', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/08/1842-revision-v1/', 0, 'revision', '', 0),
(1856, 1, '2016-11-09 07:30:36', '2016-11-09 07:30:36', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%20478.3%25%22%2C%22p_left%22%3A%2230.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2250.7%25%20%22%2C%22p_left%22%3A%2220.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2264.4%25%20%20%22%2C%22p_left%22%3A%2222.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-09 07:30:36', '2016-11-09 07:30:36', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1842-revision-v1/', 0, 'revision', '', 0),
(1857, 1, '2016-11-09 07:40:59', '2016-11-09 07:40:59', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%2037.3%25%22%2C%22p_left%22%3A%2238.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2224.7%25%20%22%2C%22p_left%22%3A%2250.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2264.4%25%20%20%22%2C%22p_left%22%3A%2272.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-09 07:40:59', '2016-11-09 07:40:59', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1842-revision-v1/', 0, 'revision', '', 0),
(1858, 1, '2016-11-09 07:59:57', '2016-11-09 07:59:57', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%20478.3%25%22%2C%22p_left%22%3A%2230.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2250.7%25%20%22%2C%22p_left%22%3A%2227.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2264.4%25%20%20%22%2C%22p_left%22%3A%2222.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Peking%22%2C%22p_top%22%3A%2282.4%25%20%20%22%2C%22p_left%22%3A%2232.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-09 07:59:57', '2016-11-09 07:59:57', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1842-revision-v1/', 0, 'revision', '', 0),
(1983, 1, '2016-12-05 11:46:38', '2016-12-05 11:46:38', '', 'favicon', '', 'inherit', 'open', 'closed', '', 'favicon', '', '', '2016-12-05 11:46:38', '2016-12-05 11:46:38', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/12/favicon.png', 0, 'attachment', 'image/png', 0),
(1859, 1, '2016-11-09 08:16:33', '2016-11-09 08:16:33', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%2048.3%25%22%2C%22p_left%22%3A%2230.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2230.7%25%20%22%2C%22p_left%22%3A%2247.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2224.4%25%20%20%22%2C%22p_left%22%3A%2262.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Peking%22%2C%22p_top%22%3A%2242.4%25%20%20%22%2C%22p_left%22%3A%2282.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-09 08:16:33', '2016-11-09 08:16:33', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1842-revision-v1/', 0, 'revision', '', 0),
(1861, 1, '2016-11-09 08:36:56', '2016-11-09 08:36:56', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%2028.3%25%22%2C%22p_left%22%3A%2248.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2217.7%25%20%22%2C%22p_left%22%3A%2252.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2224.4%25%20%20%22%2C%22p_left%22%3A%2262.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Peking%22%2C%22p_top%22%3A%2242.4%25%20%20%22%2C%22p_left%22%3A%2282.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-09 08:36:56', '2016-11-09 08:36:56', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1842-revision-v1/', 0, 'revision', '', 0),
(1860, 1, '2016-11-09 08:30:04', '2016-11-09 08:30:04', '[vc_row][vc_column][goarch_about_main_section][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%2038.3%25%22%2C%22p_left%22%3A%2246.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2222.7%25%20%22%2C%22p_left%22%3A%2249.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2224.4%25%20%20%22%2C%22p_left%22%3A%2262.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Peking%22%2C%22p_top%22%3A%2242.4%25%20%20%22%2C%22p_left%22%3A%2282.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Canberra%22%2C%22p_top%22%3A%2281.4%25%20%20%22%2C%22p_left%22%3A%2288.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-09 08:30:04', '2016-11-09 08:30:04', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1842-revision-v1/', 0, 'revision', '', 0),
(1862, 1, '2016-11-09 09:52:23', '2016-11-09 09:52:23', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECTS" css=".vc_custom_1478698102010{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/projects.jpg?id=1871) !important;}"][goarch_project_block posts="8" title="" t_p=""][/vc_column][/vc_row]', 'PROJECTS', '', 'publish', 'closed', 'closed', '', 'projects', '', '', '2016-11-10 09:06:33', '2016-11-10 09:06:33', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?page_id=1862', 0, 'page', '', 0),
(1864, 1, '2016-11-09 09:46:10', '2016-11-09 09:46:10', '[vc_row][vc_column][goarch_page_heading_section][goarch_about_section][goarch_services success_message="" error_message="We\'re sorry, but something went wrong" items="%5B%7B%22img%22%3A%221799%22%2C%22t%22%3A%22ARCHITECTURE%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.3s%22%2C%22img%22%3A%221800%22%2C%22t%22%3A%22interiors%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%2C%7B%22delay%22%3A%220.6s%22%2C%22img%22%3A%221801%22%2C%22t%22%3A%22PLANING%22%2C%22content%22%3A%22For%20each%20project%20we%20establish%20relationships%20with%20partners%20who%20we%20know%20will%20help%20us%20create%20added%20value%20for%20your%20project.%20As%20well%20as%20bringing%20together%20the%20public%20and%20private%20sectors%2C%20we%20make%20sector-overarching%20links%20to%20gather%20knowledge%20and%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctto%20learn%20from%20each%20other.%20The%20way%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ctwe%20undertake%20projects%20is%20based%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Ct%5Cton%20permanently%20applying.%22%7D%5D"][goarch_objects src="1854" items="%5B%7B%22t%22%3A%22New%20York%22%2C%22p_top%22%3A%22%2039.1%25%22%2C%22p_left%22%3A%2225.7%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Chicago%22%2C%22p_top%22%3A%2242%25%22%2C%22p_left%22%3A%2212.6%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Brazil%22%2C%22p_top%22%3A%22%2080.6%25%22%2C%22p_left%22%3A%22%2032.2%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Madrid%22%2C%22p_top%22%3A%22%2028.3%25%22%2C%22p_left%22%3A%2248.5%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Oslo%20%22%2C%22p_top%22%3A%2217.7%25%20%22%2C%22p_left%22%3A%2252.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Moscow%20%22%2C%22p_top%22%3A%2224.4%25%20%20%22%2C%22p_left%22%3A%2262.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%2C%7B%22t%22%3A%22Peking%22%2C%22p_top%22%3A%2242.4%25%20%20%22%2C%22p_left%22%3A%2282.4%25%22%2C%22content%22%3A%22%2B0%20595-510-1352%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20flatley.don%40weissnat.me%3Cbr%3E%5Cn%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20713%20Dibbert%20Bridge%22%7D%5D"][goarch_contact_section error_message="We\'re sorry, but something went wrong" c_info="" items="%5B%7B%22content%22%3A%22%20%20%2B7%20(212)%20654-33-35%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22%20%2B7%20(212)%20287-85-22%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22info%40goarch.com%3Cbr%3E%22%7D%2C%7B%22content%22%3A%22USA%2C%20New%20York%2C%2057%20Quigley%20Bridge%22%7D%5D"][/vc_column][/vc_row]', 'About us', '', 'inherit', 'closed', 'closed', '', '1842-revision-v1', '', '', '2016-11-09 09:46:10', '2016-11-09 09:46:10', '', 1842, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1842-revision-v1/', 0, 'revision', '', 0),
(1865, 1, '2016-11-09 09:52:23', '2016-11-09 09:52:23', '', 'PROJECTS', '', 'inherit', 'closed', 'closed', '', '1862-revision-v1', '', '', '2016-11-09 09:52:23', '2016-11-09 09:52:23', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1862-revision-v1/', 0, 'revision', '', 0),
(1867, 1, '2016-11-09 09:57:17', '2016-11-09 09:57:17', '', 'project', '', 'inherit', 'open', 'closed', '', 'project', '', '', '2016-11-09 09:57:17', '2016-11-09 09:57:17', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg', 0, 'attachment', 'image/jpeg', 0),
(1868, 1, '2016-11-09 09:58:15', '2016-11-09 09:58:15', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECTS" css=".vc_custom_1478685487219{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}"][/vc_column][/vc_row]', 'PROJECTS', '', 'inherit', 'closed', 'closed', '', '1862-revision-v1', '', '', '2016-11-09 09:58:15', '2016-11-09 09:58:15', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1862-revision-v1/', 0, 'revision', '', 0),
(1869, 1, '2016-11-09 13:20:22', '2016-11-09 13:20:22', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECTS" css=".vc_custom_1478685487219{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}"][goarch_project posts="8"][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'PROJECTS', '', 'inherit', 'closed', 'closed', '', '1862-revision-v1', '', '', '2016-11-09 13:20:22', '2016-11-09 13:20:22', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1862-revision-v1/', 0, 'revision', '', 0),
(1871, 1, '2016-11-09 13:27:30', '2016-11-09 13:27:30', '', 'projects', '', 'inherit', 'open', 'closed', '', 'projects-2', '', '', '2016-11-09 13:27:30', '2016-11-09 13:27:30', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/projects.jpg', 0, 'attachment', 'image/jpeg', 0),
(1873, 1, '2016-11-09 16:33:33', '2016-11-09 16:33:33', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECTS" css=".vc_custom_1478698102010{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/projects.jpg?id=1871) !important;}"][goarch_project_block title="" t_p=""][/vc_column][/vc_row]', 'PROJECTS', '', 'inherit', 'closed', 'closed', '', '1862-revision-v1', '', '', '2016-11-09 16:33:33', '2016-11-09 16:33:33', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1862-revision-v1/', 0, 'revision', '', 0),
(1872, 1, '2016-11-09 13:28:25', '2016-11-09 13:28:25', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECTS" css=".vc_custom_1478698102010{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/projects.jpg?id=1871) !important;}"][goarch_project_block title="" t_p=""][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'PROJECTS', '', 'inherit', 'closed', 'closed', '', '1862-revision-v1', '', '', '2016-11-09 13:28:25', '2016-11-09 13:28:25', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/09/1862-revision-v1/', 0, 'revision', '', 0),
(1876, 1, '2016-11-10 09:21:23', '2016-11-10 09:21:23', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECTS" css=".vc_custom_1478698102010{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/projects.jpg?id=1871) !important;}"][goarch_project_block posts="8" title="" t_p=""][/vc_column][/vc_row]', 'PROJECTS', '', 'inherit', 'closed', 'closed', '', '1862-autosave-v1', '', '', '2016-11-10 09:21:23', '2016-11-10 09:21:23', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/10/1862-autosave-v1/', 0, 'revision', '', 0),
(1877, 1, '2016-11-10 09:01:18', '2016-11-10 09:01:18', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECTS" css=".vc_custom_1478698102010{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/projects.jpg?id=1871) !important;}"][goarch_project_block posts="8" title="" t_p=""][/vc_column][/vc_row]', 'PROJECTS', '', 'inherit', 'closed', 'closed', '', '1862-revision-v1', '', '', '2016-11-10 09:01:18', '2016-11-10 09:01:18', '', 1862, 'http://murren.ru/templates/WP/go-arch/go-arch-light/2016/11/10/1862-revision-v1/', 0, 'revision', '', 0);
REPLACE INTO `xwlpv_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(1878, 1, '2016-11-10 09:48:26', '2016-11-10 09:48:26', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221811%22%2C%22class2%22%3A%22fadeInRight%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%232%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%2C%7B%22images%22%3A%221813%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22Project%20description%3Cbr%3E%20is%20here%20%233%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files%2C%20machines%20and%20decorations.%20The%20operating%20system%20is%20the%20boss.%20With%20this%20image%20in%20mind%2C%20think%20of%20an%20office%20you%E2%80%99ve%20visited%20that%20was%20slow%20and%20inefficient.%20%22%7D%5D"][/vc_column][/vc_row]', 'Concert hall in New york', '', 'publish', 'closed', 'closed', '', 'concert-hall-in-new-york-3', '', '', '2016-12-14 18:39:49', '2016-12-14 18:39:49', '', 0, 'http://murren.ru/templates/WP/go-arch/go-arch-light/?post_type=projects&#038;p=1878', 0, 'projects', '', 0),
(1879, 1, '2016-11-10 09:49:28', '2016-11-10 09:49:28', '[vc_row][vc_column][goarch_page_heading_section heading="PROJECT IN PARIS " class=" main-project" css=".vc_custom_1478802314364{background-image: url(http://murren.ru/templates/WP/go-arch/go-arch-light/wp-content/uploads/2016/11/project.jpg?id=1867) !important;}" items="%5B%7B%22t_p%22%3A%22Client%22%2C%22t%22%3A%22%3A%20Modernize%20ltd.%22%7D%2C%7B%22t_p%22%3A%22SCALE%3A%22%2C%22t%22%3A%223500%20KM%22%2C%22square_metre%22%3A%222%22%7D%5D"][goarch_project_details_block items="%5B%7B%22images%22%3A%221890%22%2C%22class%22%3A%22col-md-offset-4%22%2C%22class2%22%3A%22fadeInLeft%22%2C%22content%22%3A%22%20Project%20description%3Cbr%3E%20is%20here%20%231%22%2C%22d%22%3A%22%20It%20is%20a%20good%20idea%20to%20think%20of%20your%20PC%20as%20an%20office.%20It%20stores%20files%2C%20programs%2C%20pictures.%20This%20can%20be%20compared%20to%20an%20actual%20office%E2%80%99s%20files